/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.ui.device;

import com.tridium.lonworks.datatypes.BDeviceEntry;
import com.tridium.lonworks.datatypes.BDeviceEntryTable;
import com.tridium.lonworks.datatypes.BServicePinData;
import com.tridium.lonworks.netmgmt.BLonNetmgmt;
import com.tridium.lonworks.ui.device.BLonDevMgrTable;
import com.tridium.lonworks.ui.device.DeviceLearn;
import com.tridium.lonworks.ui.device.LonDeviceController;
import com.tridium.lonworks.util.DeviceDef;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.job.BJobBar;
import java.util.Hashtable;
import javax.baja.driver.BDevice;
import javax.baja.driver.BIDeviceFolder;
import javax.baja.driver.ui.device.BDeviceManager;
import javax.baja.driver.ui.device.DeviceExtsColumn;
import javax.baja.driver.ui.device.DeviceModel;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.lonworks.BDynamicDevice;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BLonDeviceFolder;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.datatypes.BDeviceData;
import javax.baja.lonworks.datatypes.BImportParameters;
import javax.baja.lonworks.datatypes.BNeuronId;
import javax.baja.lonworks.datatypes.BProgramId;
import javax.baja.lonworks.datatypes.BSubnetNode;
import javax.baja.lonworks.enums.BLonNodeState;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.util.Array;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.IntHashMap;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;
import javax.baja.workbench.mgr.folder.FolderModel;
import javax.baja.workbench.view.BWbComponentView;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BLonDeviceManager
extends BDeviceManager {
    public static final Type TYPE;
    static final UiLexicon lexicon;
    boolean initialized;
    private boolean useNetAddress;
    MgrColumn colPath;
    MgrColumn colName;
    MgrColumn colStatus;
    MgrColumn colType;
    MgrColumn colDeviceExts;
    MgrColumn colState;
    MgrColumn colChannelId;
    MgrColumn colSubnet;
    MgrColumn colNode;
    MgrColumn colMfgId;
    MgrColumn colWorkDomain;
    MgrColumn colProgramId;
    MgrColumn colNeuronId;
    MgrColumn colEnabled;
    MgrColumn colFaultCause;
    MgrColumn colXmlFile;
    MgrColumn[] cols;
    private BLonNetwork lon;
    private BJobBar jobBar;
    static /* synthetic */ Class class$com$tridium$lonworks$ui$device$BLonDeviceManager;
    static /* synthetic */ Class class$javax$baja$lonworks$BLonDevice;
    static /* synthetic */ Class class$javax$baja$lonworks$BLonDeviceFolder;
    static /* synthetic */ Class class$com$tridium$lonworks$ui$device$BLonDeviceManager$LonTypeInfo;
    static /* synthetic */ Class class$javax$baja$registry$TypeInfo;
    static /* synthetic */ Class class$javax$baja$lonworks$BDynamicDevice;

    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new LonDeviceModel(this);
    }

    protected MgrLearn makeLearn() {
        return new DeviceLearn(this);
    }

    protected MgrController makeController() {
        return new LonDeviceController(this);
    }

    public void doLoadValue(BObject bObject, Context context) {
        this.lon = (BLonNetwork)((BIDeviceFolder)bObject).getNetwork();
        try {
            super.doLoadValue(bObject, context);
        }
        catch (Throwable throwable) {
            System.out.println(throwable);
        }
        if (!this.initialized) {
            this.initialized = true;
            this.jobBar = new BJobBar();
            this.attach((BWbComponentView.Attachable)this.jobBar);
            BBorderPane bBorderPane = new BBorderPane((BWidget)this.jobBar, BBorder.solid, BInsets.make((double)0.0, (double)5, (double)0.0, (double)5));
            bBorderPane.setFill(Theme.widget().getWindowBackground());
            bBorderPane = new BBorderPane((BWidget)bBorderPane, BBorder.inset, BInsets.DEFAULT);
            ((BEdgePane)this.getContent()).setTop((BWidget)bBorderPane);
        }
        this.registerFolder((BComponent)bObject);
        if (((FolderModel)this.getModel()).isAllDescendants()) {
            this.loadDescendants();
        }
        this.registerForComponentEvents(this.lon.netmgmt(), 1);
        this.updateDiscoveryRows(this.lon.netmgmt().getDeviceDiscoverTable());
    }

    void reloadValue() {
        BComponent bComponent = this.getCurrentValue().asComponent();
        this.registerFolder(bComponent);
        if (((FolderModel)this.getModel()).isAllDescendants()) {
            this.loadDescendants();
        }
        this.updateDiscoveryRows(this.lon.netmgmt().getDeviceDiscoverTable());
        this.repaint();
    }

    void loadDescendants() {
        BComponent bComponent = this.getCurrentValue().asComponent();
        BLonDeviceFolder[] bLonDeviceFolderArray = this.getFolders(bComponent);
        int n = 0;
        while (n < bLonDeviceFolderArray.length) {
            this.registerFolder((BComponent)bLonDeviceFolderArray[n]);
            ++n;
        }
    }

    private final void registerFolder(BComponent bComponent) {
        this.registerForComponentEvents(bComponent, 1);
        Class clazz = class$javax$baja$lonworks$BLonDevice;
        if (clazz == null) {
            clazz = class$javax$baja$lonworks$BLonDevice = BLonDeviceManager.class("[Ljavax.baja.lonworks.BLonDevice;", false);
        }
        BLonDevice[] bLonDeviceArray = (BLonDevice[])bComponent.getChildren(clazz);
        BComponent[] bComponentArray = new BComponent[bLonDeviceArray.length];
        int n = 0;
        int n2 = 0;
        while (n < bLonDeviceArray.length) {
            bComponentArray[n2++] = bLonDeviceArray[n].getDeviceData();
            ++n;
        }
        this.registerForComponentEvents(bComponentArray, 0);
    }

    private final BLonDeviceFolder[] getFolders(BComponent bComponent) {
        Class clazz = class$javax$baja$lonworks$BLonDeviceFolder;
        if (clazz == null) {
            clazz = class$javax$baja$lonworks$BLonDeviceFolder = BLonDeviceManager.class("[Ljavax.baja.lonworks.BLonDeviceFolder;", false);
        }
        Array array = new Array(clazz);
        this.scanForFolders(bComponent, array);
        return (BLonDeviceFolder[])array.trim();
    }

    private final void scanForFolders(BComponent bComponent, Array array) {
        SlotCursor slotCursor = bComponent.getProperties();
        while (slotCursor.next()) {
            Property property = slotCursor.property();
            if (!property.getType().is(BLonDeviceFolder.TYPE)) continue;
            BComponent bComponent2 = (BComponent)slotCursor.get();
            this.registerForComponentEvents(bComponent2, 0);
            array.add((Object)bComponent2);
            this.scanForFolders(bComponent2, array);
        }
    }

    protected BJobBar getJobBar() {
        return this.jobBar;
    }

    public void handleComponentEvent(BComponentEvent bComponentEvent) {
        int n = bComponentEvent.getId();
        BComponent bComponent = bComponentEvent.getSourceComponent();
        switch (n) {
            case 5: {
                if (bComponent == this.getNetwork()) {
                    if (bComponentEvent.getSlot() != BLonNetwork.deviceChange) break;
                    this.repaint();
                    break;
                }
                if (bComponent != this.getNetwork().netmgmt()) break;
                if (bComponentEvent.getSlot() == BLonNetmgmt.learnComplete) {
                    this.reloadValue();
                    break;
                }
                if (bComponentEvent.getSlot() == BLonNetmgmt.deviceDiscoveryUpdated) {
                    this.updateDiscoveryRows((BDeviceEntryTable)bComponentEvent.getValue());
                    break;
                }
                if (bComponentEvent.getSlot() != BLonNetmgmt.servicePinReceived) break;
                BNeuronId bNeuronId = ((BServicePinData)bComponentEvent.getValue()).getNeuronId();
                BMgrTable bMgrTable = this.getModel().getTable();
                int n2 = bMgrTable.getComponentModel().getRowCount();
                int n3 = 0;
                while (n3 < n2) {
                    BComponent bComponent2 = bMgrTable.getComponentAt(n3);
                    if (bComponent2.getType().is(BLonDevice.TYPE) && ((BLonDevice)bComponent2).getNeuronIdAddress().equals(bNeuronId)) {
                        bMgrTable.getSelection().select(n3, true);
                        break;
                    }
                    ++n3;
                }
                BDeviceEntry[] bDeviceEntryArray = (BDeviceEntry[])this.getLearn().getRoots();
                int n4 = 0;
                while (n4 < bDeviceEntryArray.length) {
                    if (bDeviceEntryArray[n4].getNeuronId().equals(bNeuronId)) {
                        this.getLearn().getTable().getSelection().select(n4, true);
                    }
                    ++n4;
                }
                break;
            }
            case 1: 
            case 2: {
                if (!bComponentEvent.getValue().getType().is(BLonDevice.TYPE) && !bComponentEvent.getValue().getType().is(BLonDeviceFolder.TYPE)) break;
                this.reloadValue();
                break;
            }
            case 0: {
                if (!bComponent.getType().is(BLonDevice.TYPE) && !bComponent.getType().is(BDeviceData.TYPE)) break;
                this.repaint();
                break;
            }
        }
        super.handleComponentEvent(bComponentEvent);
    }

    protected void updateDiscoveryRows(BDeviceEntryTable bDeviceEntryTable) {
        BDeviceEntry[] bDeviceEntryArray = bDeviceEntryTable.getDeviceEntries();
        this.getLearn().updateRoots((Object[])bDeviceEntryArray);
    }

    public BLonNetwork getNetwork() {
        if (this.lon == null) {
            Thread.dumpStack();
        }
        return this.lon;
    }

    public boolean isUseNetAddress() {
        return this.useNetAddress;
    }

    public void setUseNetAddress(boolean bl) {
        this.useNetAddress = bl;
    }

    public void validate(MgrEditRow mgrEditRow) {
        int n = ((BInteger)mgrEditRow.getCell(this.colSubnet)).getInt();
        int n2 = ((BInteger)mgrEditRow.getCell(this.colNode)).getInt();
        BSubnetNode bSubnetNode = BSubnetNode.make(n, n2);
        BLonDevice bLonDevice = (BLonDevice)mgrEditRow.getTarget();
        if (bLonDevice.getDeviceData().getSubnetNodeId().equals(bSubnetNode)) {
            return;
        }
        BOrd bOrd = this.lon.getLonNetmgmt().deviceForSubnetNodeId(bSubnetNode);
        if (bOrd != null && !bOrd.equals((Object)bLonDevice.getHandleOrd())) {
            if (bLonDevice.isMounted()) {
                throw new BajaRuntimeException("Address " + n + '/' + n2 + " already in use.");
            }
            mgrEditRow.setCell(this.colSubnet, (BValue)BInteger.make((int)0));
            mgrEditRow.setCell(this.colNode, (BValue)BInteger.make((int)0));
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.initialized = false;
        this.useNetAddress = true;
        this.colPath = new MgrColumn.Path(2);
        this.colName = new MgrColumn.Name();
        this.colStatus = new StatusColumn();
        this.colType = new MgrColumn.Type(1);
        this.colDeviceExts = new DeviceExtsColumn((BDevice)new BLonDevice());
        this.colState = new MgrColumn.PropPath(lexicon.getText("device.columnTitle.state"), new Property[]{BLonDevice.deviceData, BDeviceData.nodeState}, 5);
        this.colChannelId = new MgrColumn.PropPath(lexicon.getText("device.columnTitle.channelId"), new Property[]{BLonDevice.deviceData, BDeviceData.channelId}, 3);
        this.colSubnet = new SubnetColumn();
        this.colNode = new NodeColumn();
        this.colMfgId = new MfgIdColumn();
        this.colWorkDomain = new MgrColumn.PropPath(lexicon.getText("device.columnTitle.workDomain"), new Property[]{BLonDevice.deviceData, BDeviceData.workingDomain}, 7);
        this.colProgramId = new MgrColumn.PropPath(lexicon.getText("device.columnTitle.programId"), new Property[]{BLonDevice.deviceData, BDeviceData.programId}, 5);
        this.colNeuronId = new MgrColumn.PropPath(lexicon.getText("device.columnTitle.neuronId"), new Property[]{BLonDevice.deviceData, BDeviceData.neuronId}, 5);
        this.colEnabled = new MgrColumn.PropPath(lexicon.getText("device.columnTitle.enabled"), new Property[]{BLonDevice.enabled}, 5);
        this.colFaultCause = new MgrColumn.PropPath(lexicon.getText("device.columnTitle.faultCause"), new Property[]{BLonDevice.faultCause}, 4);
        this.colXmlFile = new XmlColumn();
        this.cols = new MgrColumn[]{this.colPath, this.colName, this.colStatus, this.colType, this.colDeviceExts, this.colState, this.colChannelId, this.colSubnet, this.colNode, this.colWorkDomain, this.colFaultCause, this.colMfgId, this.colProgramId, this.colNeuronId, this.colEnabled, this.colXmlFile};
    }

    public BLonDeviceManager() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$lonworks$ui$device$BLonDeviceManager;
        if (clazz == null) {
            clazz = class$com$tridium$lonworks$ui$device$BLonDeviceManager = BLonDeviceManager.class("[Lcom.tridium.lonworks.ui.device.BLonDeviceManager;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        Class clazz2 = class$com$tridium$lonworks$ui$device$BLonDeviceManager;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$lonworks$ui$device$BLonDeviceManager = BLonDeviceManager.class("[Lcom.tridium.lonworks.ui.device.BLonDeviceManager;", false);
        }
        lexicon = new UiLexicon(clazz2);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class LonDeviceModel
    extends DeviceModel {
        Hashtable hash;

        public MgrTypeInfo[] getNewTypes(BProgramId bProgramId) {
            Class clazz = class$com$tridium$lonworks$ui$device$BLonDeviceManager$LonTypeInfo;
            if (clazz == null) {
                clazz = class$com$tridium$lonworks$ui$device$BLonDeviceManager$LonTypeInfo = BLonDeviceManager.class("[Lcom.tridium.lonworks.ui.device.BLonDeviceManager$LonTypeInfo;", false);
            }
            Array array = new Array(clazz);
            DeviceDef deviceDef = new DeviceDef(bProgramId);
            int n = deviceDef.entryCount();
            if (n == 0) {
                array.add((Object)new LonTypeInfo(deviceDef, -1));
            } else {
                int n2 = 0;
                while (n2 < n) {
                    array.add((Object)new LonTypeInfo(deviceDef, n2));
                    ++n2;
                }
            }
            return (LonTypeInfo[])array.trim();
        }

        public MgrTypeInfo[] getNewTypes() {
            TypeInfo[] typeInfoArray = Sys.getRegistry().getConcreteTypes(BLonDevice.TYPE.getTypeInfo());
            Class clazz = class$javax$baja$registry$TypeInfo;
            if (clazz == null) {
                clazz = class$javax$baja$registry$TypeInfo = BLonDeviceManager.class("[Ljavax.baja.registry.TypeInfo;", false);
            }
            Array array = new Array(clazz, typeInfoArray.length - 2);
            int n = 0;
            while (n < typeInfoArray.length) {
                String string = typeInfoArray[n].getTypeClassName();
                if (string.startsWith("javax.baja.lonworks")) {
                    if (string.equals("javax.baja.lonworks.BDynamicDevice")) {
                        array.add((Object)typeInfoArray[n]);
                    }
                    typeInfoArray[n] = null;
                }
                ++n;
            }
            n = 0;
            while (n < typeInfoArray.length) {
                if (typeInfoArray[n] != null) {
                    array.add((Object)typeInfoArray[n]);
                }
                ++n;
            }
            return MgrTypeInfo.makeArray((TypeInfo[])((TypeInfo[])array.trim()));
        }

        protected MgrColumn[] makeColumns() {
            return BLonDeviceManager.this.cols;
        }

        public CommandArtifact addInstances(MgrEditRow[] mgrEditRowArray, Context context) throws Exception {
            MgrEditRow mgrEditRow;
            Class clazz = class$javax$baja$lonworks$BDynamicDevice;
            if (clazz == null) {
                clazz = class$javax$baja$lonworks$BDynamicDevice = BLonDeviceManager.class("[Ljavax.baja.lonworks.BDynamicDevice;", false);
            }
            Array array = new Array(clazz);
            IntHashMap intHashMap = new IntHashMap();
            int n = 0;
            while (n < mgrEditRowArray.length) {
                mgrEditRow = mgrEditRowArray[n];
                BLonDevice bLonDevice = (BLonDevice)mgrEditRow.getTarget();
                if (this.preProcess(mgrEditRow, mgrEditRow.getTargetParent(), mgrEditRow.getName(), bLonDevice, intHashMap, context)) {
                    array.add((Object)bLonDevice);
                }
                super.addInstances(new MgrEditRow[]{mgrEditRow}, context);
                ++n;
            }
            BDynamicDevice[] bDynamicDeviceArray = (BDynamicDevice[])array.trim();
            mgrEditRow = (BComponent)this.getManager().getCurrentValue();
            if (bDynamicDeviceArray.length > 0) {
                mgrEditRow.getComponentSpace().sync();
            }
            int n2 = 0;
            while (n2 < bDynamicDeviceArray.length) {
                BOrd bOrd = BLonDeviceManager.this.lon.getLonNetmgmt().deviceForNeuronId(bDynamicDeviceArray[n2].getNeuronIdAddress());
                BDynamicDevice bDynamicDevice = (BDynamicDevice)bOrd.resolve((BObject)mgrEditRow).get();
                bDynamicDevice.learnNv();
                ++n2;
            }
            return null;
        }

        private final boolean preProcess(MgrEditRow mgrEditRow, BComponent bComponent, String string, BLonDevice bLonDevice, IntHashMap intHashMap, Context context) throws Exception {
            BSubnetNode bSubnetNode;
            this.hash.remove(bLonDevice);
            Object object = mgrEditRow.getDiscovery();
            BLonNodeState bLonNodeState = BLonNodeState.unknown;
            BDeviceEntry bDeviceEntry = (BDeviceEntry)((Object)object);
            if (bDeviceEntry != null) {
                bLonNodeState = bDeviceEntry.getState();
            }
            BDeviceData bDeviceData = bLonDevice.getDeviceData();
            if (bDeviceEntry != null) {
                bDeviceData.setAuthenticate(bDeviceEntry.getAuthenticate());
            }
            if (intHashMap.put((bSubnetNode = bDeviceData.getSubnetNodeId()).hashCode(), (Object)bLonDevice) != null || BLonDeviceManager.this.lon.getLonNetmgmt().deviceForSubnetNodeId(bSubnetNode) != null) {
                bDeviceData.setSubnetNodeId(BSubnetNode.DEFAULT);
            }
            if (bDeviceData.getSubnetNodeId().equals(BSubnetNode.DEFAULT) && bLonNodeState.isConfigured()) {
                bLonNodeState = BLonNodeState.unknown;
            }
            bDeviceData.setNodeState(bLonNodeState);
            if (bLonDevice instanceof BDynamicDevice) {
                BDynamicDevice bDynamicDevice = (BDynamicDevice)bLonDevice;
                if (this.hasValidXml(bDynamicDevice)) {
                    BProgramId bProgramId = bDeviceData.getProgramId();
                    BImportParameters bImportParameters = new BImportParameters(false, BLonDeviceManager.this.lon.getLonNetmgmt().getUseLonObjects());
                    try {
                        bDynamicDevice.doImportXml(bImportParameters, BLonDeviceManager.this.getNetwork().log());
                    }
                    catch (UnresolvedException unresolvedException) {
                        bDynamicDevice.importXml(bImportParameters);
                    }
                    if (!bProgramId.isZero()) {
                        bDynamicDevice.getDeviceData().setProgramId(bProgramId);
                    }
                } else if (!((BNeuronId)mgrEditRow.getCell(BLonDeviceManager.this.colNeuronId)).isZero()) {
                    return true;
                }
            }
            return false;
        }

        private final boolean hasValidXml(BDynamicDevice bDynamicDevice) {
            try {
                if (bDynamicDevice.getXmlFile().get() != null) {
                    return true;
                }
            }
            catch (Throwable throwable) {}
            return false;
        }

        protected BMgrTable makeTable() {
            return new BLonDevMgrTable((MgrModel)this);
        }

        public BComponent newInstance(MgrTypeInfo mgrTypeInfo) throws Exception {
            BComponent bComponent = mgrTypeInfo.newInstance();
            this.hash.put(bComponent, mgrTypeInfo);
            return bComponent;
        }

        public MgrTypeInfo toType(BComponent bComponent) {
            MgrTypeInfo mgrTypeInfo = (MgrTypeInfo)this.hash.get(bComponent);
            if (mgrTypeInfo != null) {
                return mgrTypeInfo;
            }
            if (bComponent.getType() != BDynamicDevice.TYPE) {
                return MgrTypeInfo.make((BComponent)bComponent);
            }
            BProgramId bProgramId = ((BLonDevice)bComponent).getDeviceData().getProgramId();
            LonTypeInfo[] lonTypeInfoArray = (LonTypeInfo[])this.getNewTypes(bProgramId);
            int n = 0;
            while (n < lonTypeInfoArray.length) {
                if (lonTypeInfoArray[n].isType((BLonDevice)bComponent)) {
                    return lonTypeInfoArray[n];
                }
                ++n;
            }
            return lonTypeInfoArray[0];
        }

        private final /* synthetic */ void this() {
            this.hash = new Hashtable();
        }

        LonDeviceModel(BLonDeviceManager bLonDeviceManager2) {
            super((BDeviceManager)bLonDeviceManager2);
            this.this();
        }
    }

    static class StatusColumn
    extends MgrColumn {
        public Object get(Object object) {
            return ((BLonDevice)object).getStatus().flagsToString(null);
        }

        public StatusColumn() {
            super(lexicon.getText("device.columnTitle.status"), 2);
        }
    }

    static class SubnetColumn
    extends IntColumn {
        public Object get(Object object) {
            return BInteger.make((int)((BLonDevice)object).getDeviceData().getSubnetNodeId().getSubnetId());
        }

        public void save(MgrEditRow mgrEditRow, BValue bValue, Context context) {
            BLonDeviceManager bLonDeviceManager = (BLonDeviceManager)mgrEditRow.getManager();
            bLonDeviceManager.validate(mgrEditRow);
            int n = ((BInteger)mgrEditRow.getCell(bLonDeviceManager.colSubnet)).getInt();
            BDeviceData bDeviceData = ((BLonDevice)mgrEditRow.getTarget()).getDeviceData();
            BSubnetNode bSubnetNode = bDeviceData.getSubnetNodeId();
            bDeviceData.setSubnetNodeId(BSubnetNode.make(n, bSubnetNode.getNodeId()));
        }

        public SubnetColumn() {
            super(lexicon.getText("device.columnTitle.subnet"), 1);
        }
    }

    static class NodeColumn
    extends IntColumn {
        public Object get(Object object) {
            return BInteger.make((int)((BLonDevice)object).getDeviceData().getSubnetNodeId().getNodeId());
        }

        public BWbEditor toEditor(MgrEditRow[] mgrEditRowArray, int n, BWbEditor bWbEditor) {
            if (mgrEditRowArray.length > 1) {
                return null;
            }
            return super.toEditor(mgrEditRowArray, n, bWbEditor);
        }

        public void save(MgrEditRow mgrEditRow, BValue bValue, Context context) {
            BLonDeviceManager bLonDeviceManager = (BLonDeviceManager)mgrEditRow.getManager();
            bLonDeviceManager.validate(mgrEditRow);
            int n = ((BInteger)mgrEditRow.getCell(bLonDeviceManager.colNode)).getInt();
            BDeviceData bDeviceData = ((BLonDevice)mgrEditRow.getTarget()).getDeviceData();
            BSubnetNode bSubnetNode = bDeviceData.getSubnetNodeId();
            bDeviceData.setSubnetNodeId(BSubnetNode.make(bSubnetNode.getSubnetId(), n));
        }

        public NodeColumn() {
            super(lexicon.getText("device.columnTitle.node"), 1);
        }
    }

    static class MfgIdColumn
    extends IntColumn {
        public Object get(Object object) {
            return ((BLonDevice)object).getDeviceData().getProgramId().getMfgId().getConvertedName();
        }

        public MfgIdColumn() {
            super(lexicon.getText("device.columnTitle.mfgId"), 0);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class XmlColumn
    extends MgrColumn {
        public Object get(Object object) {
            if (!(object instanceof BDynamicDevice)) {
                return BOrd.DEFAULT;
            }
            return ((BDynamicDevice)object).getXmlFile();
        }

        public BValue load(MgrEditRow mgrEditRow) {
            return ((BValue)this.get(mgrEditRow.getTarget())).newCopy();
        }

        public void save(MgrEditRow mgrEditRow, BValue bValue, Context context) {
            if (!(mgrEditRow.getTarget() instanceof BDynamicDevice)) {
                return;
            }
            BDynamicDevice bDynamicDevice = (BDynamicDevice)mgrEditRow.getTarget();
            BLonDeviceManager bLonDeviceManager = (BLonDeviceManager)mgrEditRow.getManager();
            BOrd bOrd = (BOrd)mgrEditRow.getCell(bLonDeviceManager.colXmlFile);
            if (bDynamicDevice.getXmlFile() == null || !bDynamicDevice.getXmlFile().equals((Object)bOrd)) {
                BImportParameters bImportParameters = new BImportParameters(false, BLonDeviceManager.this.lon.getLonNetmgmt().getUseLonObjects());
                bDynamicDevice.setXmlFile(bOrd);
                try {
                    bDynamicDevice.doImportXml(bImportParameters, BLonDeviceManager.this.getNetwork().log());
                }
                catch (UnresolvedException unresolvedException) {
                    bDynamicDevice.importXml(bImportParameters);
                }
            }
        }

        public BWbEditor toEditor(MgrEditRow[] mgrEditRowArray, int n, BWbEditor bWbEditor) {
            if (mgrEditRowArray.length != 1) {
                return null;
            }
            if (!(mgrEditRowArray[0].getTarget() instanceof BDynamicDevice)) {
                return null;
            }
            BValue bValue = mgrEditRowArray[0].getCell(n);
            if (bWbEditor == null) {
                bWbEditor = BWbFieldEditor.makeFor((BObject)bValue);
            }
            bWbEditor.loadValue((BObject)bValue);
            return bWbEditor;
        }

        public void fromEditor(MgrEditRow[] mgrEditRowArray, int n, BWbEditor bWbEditor) throws Exception {
            XmlColumn.fromFieldEditor((MgrEditRow[])mgrEditRowArray, (int)n, (BWbEditor)bWbEditor, null);
        }

        public XmlColumn() {
            super(lexicon.getText("device.columnTitle.xmlFile"), 1);
        }
    }

    static abstract class IntColumn
    extends MgrColumn {
        public BValue load(MgrEditRow mgrEditRow) {
            return ((BValue)this.get(mgrEditRow.getTarget())).newCopy();
        }

        public BWbEditor toEditor(MgrEditRow[] mgrEditRowArray, int n, BWbEditor bWbEditor) {
            BValue bValue = mgrEditRowArray[0].getCell(n);
            if (bWbEditor == null) {
                bWbEditor = BWbFieldEditor.makeFor((BObject)bValue);
            }
            bWbEditor.loadValue((BObject)bValue);
            return bWbEditor;
        }

        public void fromEditor(MgrEditRow[] mgrEditRowArray, int n, BWbEditor bWbEditor) throws Exception {
            IntColumn.fromFieldEditor((MgrEditRow[])mgrEditRowArray, (int)n, (BWbEditor)bWbEditor, null);
        }

        public void save(MgrEditRow mgrEditRow, BValue bValue, Context context) {
        }

        public IntColumn(String string, int n) {
            super(string, n);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class LonTypeInfo
    extends MgrTypeInfo {
        TypeInfo ti;
        DeviceDef def;
        int ndx;

        public String getDisplayName() {
            Context context = BLonDeviceManager.this.getCurrentContext();
            Lexicon lexicon = Lexicon.make((String)this.def.getModule(this.ndx), (Context)context);
            String string = this.def.getName(this.ndx);
            string = lexicon.get(string + ".displayName", string);
            return SlotPath.unescape((String)string);
        }

        public BImage getIcon() {
            return BImage.make((BIcon)this.ti.getIcon(null));
        }

        public boolean isMatchable(BComponent bComponent) {
            return bComponent.getType().is(this.ti);
        }

        public BComponent newInstance() {
            BLonDevice bLonDevice = (BLonDevice)this.ti.getInstance();
            if (this.def.isXml(this.ndx)) {
                ((BDynamicDevice)bLonDevice).setXmlFile(this.def.getXmlOrd(this.ndx));
            }
            return bLonDevice;
        }

        public boolean isType(BLonDevice bLonDevice) {
            if (this.def.isClass(this.ndx) && this.def.getType(this.ndx).getClass() == bLonDevice.getClass()) {
                return true;
            }
            return bLonDevice instanceof BDynamicDevice && ((BDynamicDevice)bLonDevice).getXmlFile().equals((Object)this.def.getXmlOrd(this.ndx));
        }

        LonTypeInfo(DeviceDef deviceDef, int n) {
            this.ti = deviceDef.getTypeInfo(n);
            this.ndx = n;
            this.def = deviceDef;
        }
    }
}

