/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.resource;

import com.tridium.lonworks.resource.ResFileInputStream;
import com.tridium.lonworks.resource.TypeNode;
import java.io.IOException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TypeScalar
extends TypeNode {
    protected static final int LM_BIT = 128;
    protected static final int LN_BIT = 64;
    protected static final int LZ_BIT = 32;
    protected static final int UM_BIT = 16;
    protected static final int UZ_BIT = 8;
    protected static final int SA_BIT = 4;
    protected static final int SB_BIT = 2;
    protected static final int SC_BIT = 1;
    protected int rangeScaleControl;
    protected long minValid;
    protected long maxValid;
    public int scaleA;
    public int scaleB;
    public int scaleC;
    public boolean invalidPresent;
    public long invalid;

    public void parseRangeScale(ResFileInputStream resFileInputStream) throws IOException {
        this.rangeScaleControl = resFileInputStream.readUnsigned8();
        this.minValid = (this.rangeScaleControl & 0x80) != 0 ? this.getMinPossible() : ((this.rangeScaleControl & 0x40) != 0 ? (long)-1 : ((this.rangeScaleControl & 0x20) != 0 ? 0L : this.readRange(resFileInputStream)));
        this.maxValid = (this.rangeScaleControl & 0x10) != 0 ? this.getMaxPossible() : ((this.rangeScaleControl & 8) != 0 ? 0L : this.readRange(resFileInputStream));
        this.readScale(resFileInputStream);
        this.readInvalid(resFileInputStream);
    }

    protected long getMinPossible() {
        switch (this.nodeType) {
            case 1: 
            case 3: 
            case 7: {
                return -128L;
            }
            case 2: 
            case 4: {
                return 0L;
            }
            case 5: {
                return -32768L;
            }
            case 6: {
                return 0L;
            }
            case 13: {
                return Integer.MIN_VALUE;
            }
            case 15: {
                return 0L;
            }
        }
        throw new RuntimeException("Invalid NVT_TYPE " + this.nodeType);
    }

    protected long getMaxPossible() {
        switch (this.nodeType) {
            case 1: 
            case 3: 
            case 7: {
                return 127L;
            }
            case 2: 
            case 4: {
                return 255L;
            }
            case 5: {
                return 32767L;
            }
            case 6: {
                return 65535L;
            }
            case 13: {
                return Integer.MAX_VALUE;
            }
            case 15: {
                return 0xFFFFFFFFL;
            }
        }
        throw new RuntimeException("Invalid NVT_TYPE " + this.nodeType);
    }

    protected long readRange(ResFileInputStream resFileInputStream) throws IOException {
        switch (this.nodeType) {
            case 1: 
            case 3: 
            case 7: {
                return resFileInputStream.readSigned8();
            }
            case 2: 
            case 4: {
                return resFileInputStream.readUnsigned8();
            }
            case 5: {
                return resFileInputStream.readSigned16();
            }
            case 6: {
                return resFileInputStream.readUnsigned16();
            }
            case 13: {
                return resFileInputStream.readSigned32();
            }
            case 15: {
                return resFileInputStream.readUnsigned32();
            }
        }
        throw new RuntimeException("Invalid NVT_TYPE " + this.nodeType);
    }

    protected void readScale(ResFileInputStream resFileInputStream) throws IOException {
        if ((this.rangeScaleControl & 4) != 0) {
            this.scaleA = resFileInputStream.readSigned16();
        }
        if ((this.rangeScaleControl & 2) != 0) {
            this.scaleB = resFileInputStream.readSigned16();
        }
        if ((this.rangeScaleControl & 1) != 0) {
            this.scaleC = resFileInputStream.readSigned16();
        }
    }

    protected void readInvalid(ResFileInputStream resFileInputStream) throws IOException {
        if (resFileInputStream.majorFmtVer < 3) {
            return;
        }
        switch (this.nodeType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 13: {
                this.invalidPresent = resFileInputStream.readBool();
                if (!this.invalidPresent) break;
                this.invalid = resFileInputStream.readSigned32();
                break;
            }
            case 15: {
                this.invalidPresent = resFileInputStream.readBool();
                if (!this.invalidPresent) break;
                this.invalid = resFileInputStream.readUnsigned32();
                break;
            }
        }
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append("Scalar").append("\n");
        super.toString(stringBuffer);
        stringBuffer.append("rangeScaleControl  = ").append(Integer.toString(this.rangeScaleControl, 16)).append("\n");
        if (this.hasMinimum() || this.hasMaximum()) {
            stringBuffer.append("  range  = ").append(this.getMinimum()).append(" - ").append(this.getMaximum()).append("\n");
        }
        if (this.hasInvalid()) {
            stringBuffer.append("  invalid  = ").append(this.getInvalid()).append("\n");
        }
        if ((this.rangeScaleControl & 7) != 0) {
            stringBuffer.append("  scale A=").append(this.scaleA).append(" B=").append(this.scaleB).append(" C=").append(this.scaleC).append("\n");
        } else {
            stringBuffer.append("default scale->1").append("\n");
        }
    }

    public boolean hasMinimum() {
        boolean bl = false;
        if ((this.rangeScaleControl & 0x80) == 0) {
            bl = true;
        }
        return bl;
    }

    public Number getMinimum() {
        return new Long(this.minValid);
    }

    public boolean hasMaximum() {
        boolean bl = false;
        if ((this.rangeScaleControl & 0x10) == 0) {
            bl = true;
        }
        return bl;
    }

    public Number getMaximum() {
        return new Long(this.maxValid);
    }

    public boolean hasInvalid() {
        return this.invalidPresent;
    }

    public Number getInvalid() {
        return new Long(this.invalid);
    }

    private final /* synthetic */ void this() {
        this.scaleA = 1;
        this.scaleB = 0;
        this.scaleC = 0;
        this.invalidPresent = false;
    }

    public TypeScalar() {
        this.this();
    }

    public TypeScalar(ResFileInputStream resFileInputStream, int n) throws IOException {
        this.this();
        this.nodeType = n;
        this.parseRangeScale(resFileInputStream);
    }
}

