/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.resource;

import com.tridium.lonworks.resource.ResFileInputStream;
import com.tridium.lonworks.resource.TypeScalar;
import java.io.IOException;

public class TypeBitfield
extends TypeScalar {
    public boolean bitfSigned;
    public int bitfOffset;
    public int bitfSize;

    protected long getMinPossible() {
        if (this.bitfSigned) {
            return -1 << this.bitfSize - 1;
        }
        return 0L;
    }

    protected long getMaxPossible() {
        if (this.bitfSigned) {
            return 1 << this.bitfSize - 1;
        }
        return (1 << this.bitfSize) - 1;
    }

    protected long readRange(ResFileInputStream resFileInputStream) throws IOException {
        if (this.bitfSigned) {
            return resFileInputStream.readSigned8();
        }
        return resFileInputStream.readUnsigned8();
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append("TypeBitField").append("\n");
        super.toString(stringBuffer);
        stringBuffer.append("  bit - ");
        if (this.bitfSigned) {
            stringBuffer.append("signed  ");
        }
        stringBuffer.append(" Offset = ").append(this.bitfOffset);
        stringBuffer.append(" Size = ").append(this.bitfSize).append("\n");
    }

    public TypeBitfield(ResFileInputStream resFileInputStream) throws IOException {
        this.nodeType = 11;
        int n = resFileInputStream.readUnsigned8();
        boolean bl = false;
        if ((n & 0x80) != 0) {
            bl = true;
        }
        this.bitfSigned = bl;
        this.bitfOffset = (n & 0x70) >> 4;
        this.bitfSize = n & 0xF;
        this.parseRangeScale(resFileInputStream);
    }
}

