/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.resource;

import com.tridium.lonworks.CancelOperationException;
import com.tridium.lonworks.resource.Conversion;
import com.tridium.lonworks.resource.CpType;
import com.tridium.lonworks.resource.CrossReference;
import com.tridium.lonworks.resource.EnumSet;
import com.tridium.lonworks.resource.ResourceFileUtil;
import com.tridium.lonworks.resource.Type;
import com.tridium.lonworks.resource.TypeArray;
import com.tridium.lonworks.resource.TypeBitfield;
import com.tridium.lonworks.resource.TypeEnum;
import com.tridium.lonworks.resource.TypeFile;
import com.tridium.lonworks.resource.TypeNode;
import com.tridium.lonworks.resource.TypeReference;
import com.tridium.lonworks.resource.TypeScalar;
import com.tridium.lonworks.resource.TypeStruct;
import com.tridium.lonworks.util.NameUtil;
import com.tridium.lonworks.xml.XCpTypeDef;
import com.tridium.lonworks.xml.XElementQualifier;
import com.tridium.lonworks.xml.XEnumDef;
import com.tridium.lonworks.xml.XLonInterfaceFile;
import com.tridium.lonworks.xml.XTypeDef;
import com.tridium.lonworks.xml.XUnion;
import com.tridium.lonworks.xml.XUnionBranch;
import java.io.PrintStream;
import java.util.Hashtable;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ResourceToXLon {
    public static final String[] JAVA_RESERVED_WORDS = new String[]{"true", "false", "null", "abstract", "double", "int", "strictfp", "boolean", "else", "interface", "super", "break", "extends", "long", "switch", "byte", "final", "native", "synchronized", "case", "finally", "new", "this", "catch", "float", "package", "throw", "char", "for", "private", "throws", "class", "goto", "protected", "transient", "const", "if", "public", "try", "continue", "implements", "return", "void", "default", "import", "short", "volatile", "do", "instanceof", "static", "while"};
    private boolean forceOffset;
    private int nextBitOffset;
    private int byteOffset;
    private int maxByteOffset;
    private boolean fixNames;
    private CrossReference crossRef;
    private PrintStream out;
    private TypeFile typeFile;
    public boolean parseUnions;

    public synchronized XLonInterfaceFile convert(TypeFile typeFile, Conversion conversion) {
        this.typeFile = typeFile;
        XLonInterfaceFile xLonInterfaceFile = new XLonInterfaceFile();
        EnumSet[] enumSetArray = typeFile.enumSets;
        int n = 0;
        while (n < enumSetArray.length) {
            XEnumDef xEnumDef;
            if (!(conversion != null && conversion.isBooleanEnum(enumSetArray[n].enumTag) || (xEnumDef = this.createXEnum(enumSetArray[n])) == null || xEnumDef.getName().indexOf("~") >= 0)) {
                if (conversion != null) {
                    conversion.renameEnumDef(xEnumDef);
                }
                xLonInterfaceFile.addAttribute(xEnumDef.getName(), xEnumDef);
            }
            ++n;
        }
        Type[] typeArray = typeFile.nvTypes;
        int n2 = 0;
        while (n2 < typeArray.length) {
            XTypeDef xTypeDef = this.createXType(typeArray[n2], typeFile.scope);
            if (xTypeDef != null) {
                if (conversion != null) {
                    conversion.renameTypeDef(xTypeDef);
                }
                xLonInterfaceFile.addAttribute(xTypeDef.getName(), xTypeDef);
            }
            ++n2;
        }
        CpType[] cpTypeArray = typeFile.cpTypes;
        int n3 = 0;
        while (n3 < cpTypeArray.length) {
            XCpTypeDef xCpTypeDef = this.createXCpType(cpTypeArray[n3], typeFile.scope);
            if (xCpTypeDef != null) {
                if (conversion != null) {
                    conversion.renameTypeDef(xCpTypeDef);
                }
                xLonInterfaceFile.addAttribute(xCpTypeDef.getName(), xCpTypeDef);
            }
            ++n3;
        }
        return xLonInterfaceFile;
    }

    private final XEnumDef createXEnum(EnumSet enumSet) {
        if (enumSet == null) {
            return null;
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        XEnumDef xEnumDef = new XEnumDef();
        xEnumDef.setName(this.toClassName(enumSet.enumTag));
        EnumSet.EnumMember[] enumMemberArray = enumSet.members;
        int n = 0;
        while (n < enumMemberArray.length) {
            EnumSet.EnumMember enumMember = enumMemberArray[n];
            String string = this.toElementName(enumMember.eString);
            String string2 = Integer.toString(enumMember.eValue);
            if (hashtable.get(string) != null) {
                this.out.print("Duplicate enum tag in " + xEnumDef.getName() + ". Change tag from " + string);
                string = string.concat(string2);
                this.out.println(" to " + string);
            }
            hashtable.put(string, string);
            xEnumDef.addEnum(string, string2);
            ++n;
        }
        return xEnumDef;
    }

    private final XTypeDef createXType(Type type, int n) {
        if (type == null) {
            return null;
        }
        TypeNode typeNode = type.node;
        if (typeNode.name.indexOf("~") >= 0) {
            return null;
        }
        this.resetOffset();
        XTypeDef xTypeDef = new XTypeDef();
        String string = Integer.toString(n) + ',' + Integer.toString(type.index);
        xTypeDef.setTypeScope(string);
        String string2 = this.toClassName(typeNode.name);
        xTypeDef.setName(string2);
        try {
            this.processTypeNode(xTypeDef, typeNode, "", false, "");
        }
        catch (UnionException unionException) {
            this.out.println("WARNING: NV Type " + string2 + " for scope " + string + " has a union. Unions require a class file.");
            if (!this.parseUnions) {
                return null;
            }
        }
        catch (BajaRuntimeException bajaRuntimeException) {
            this.out.println("WARNING:" + bajaRuntimeException.getMessage());
            Throwable throwable = bajaRuntimeException.getCause();
            if (throwable != null) {
                this.out.println("\t" + throwable.getClass().getName() + ' ' + throwable.getMessage());
            }
            return null;
        }
        return xTypeDef;
    }

    private final XCpTypeDef createXCpType(CpType cpType, int n) {
        if (cpType == null) {
            return null;
        }
        TypeNode typeNode = cpType.node;
        if (typeNode.name.indexOf("~") >= 0) {
            return null;
        }
        this.resetOffset();
        XCpTypeDef xCpTypeDef = new XCpTypeDef();
        String string = Integer.toString(n) + ',' + Integer.toString(cpType.index);
        xCpTypeDef.setTypeScope(string);
        String string2 = "Cp" + this.toClassName(typeNode.name);
        xCpTypeDef.setName(string2);
        if (cpType.min != null) {
            xCpTypeDef.min = cpType.min;
        }
        if (cpType.max != null) {
            xCpTypeDef.max = cpType.max;
        }
        xCpTypeDef.init = cpType.init;
        xCpTypeDef.inherited = cpType.inherited;
        try {
            this.processTypeNode(xCpTypeDef, typeNode, "", false, "");
        }
        catch (UnionException unionException) {
            this.out.println("WARNING: Cp type " + string2 + " for scope " + string + " has a union. Unions require a class file.");
            if (!this.parseUnions) {
                return null;
            }
        }
        catch (BajaRuntimeException bajaRuntimeException) {
            this.out.println("WARNING:" + bajaRuntimeException.getMessage());
            Throwable throwable = bajaRuntimeException.getCause();
            if (throwable != null) {
                this.out.println("\t" + throwable.getClass().getName() + ' ' + throwable.getMessage());
            }
            return null;
        }
        return xCpTypeDef;
    }

    private final void processTypeNode(XTypeDef xTypeDef, TypeNode typeNode, String string, boolean bl, String string2) throws UnionException {
        this.processTypeNode(xTypeDef, typeNode, string, bl, string2, null, "");
    }

    private final void processTypeNode(XTypeDef xTypeDef, TypeNode typeNode, String string, boolean bl, String string2, String string3) throws UnionException {
        this.processTypeNode(xTypeDef, typeNode, string, bl, string2, string3, "");
    }

    private final void processTypeNode(XTypeDef xTypeDef, TypeNode typeNode, String string, boolean bl, String string2, String string3, String string4) throws UnionException {
        try {
            switch (typeNode.nodeType) {
                case 8: {
                    TypeArray typeArray = (TypeArray)typeNode;
                    string = this.buildPrefix(string, typeNode.name);
                    if (typeArray.element.nodeType == 2) {
                        XElementQualifier xElementQualifier = new XElementQualifier();
                        xElementQualifier.setName(this.toElementName(string + string2));
                        xElementQualifier.setElementType("st");
                        xElementQualifier.setLength(typeArray.numElements);
                        if (string3 != null) {
                            xElementQualifier.setUnionBranch(string3);
                        }
                        xTypeDef.addAttribute("", xElementQualifier);
                        break;
                    }
                    int n = 0;
                    while (n < typeArray.numElements) {
                        String string5;
                        if (Character.isDigit(string.charAt(string.length() - 1))) {
                            string = string + 'n';
                        }
                        if ((string5 = string2).length() == 0) {
                            string5 = Integer.toString(n);
                        } else if (Character.isDigit(string5.charAt(string5.length() - 1))) {
                            string5 = string5 + 'n' + Integer.toString(n);
                        } else {
                            string2 = string2 + Integer.toString(n);
                        }
                        this.processTypeNode(xTypeDef, typeArray.element, string, bl, string5, string3);
                        ++n;
                    }
                    break;
                }
                case 9: {
                    TypeNode[] typeNodeArray = ((TypeStruct)typeNode).fields;
                    if (bl) {
                        string = this.buildPrefix(string, typeNode.name);
                    }
                    int n = 0;
                    while (n < typeNodeArray.length) {
                        this.processTypeNode(xTypeDef, typeNodeArray[n], string, true, string2, string3);
                        ++n;
                    }
                    break;
                }
                case 10: {
                    if (!this.parseUnions) {
                        throw new UnionException();
                    }
                    this.out.println("Union in : " + xTypeDef.getName() + '.' + typeNode.name);
                    this.forceOffset = true;
                    int n = this.adjustOffset(0);
                    if (xTypeDef.union == null) {
                        xTypeDef.union = new XUnion("??");
                    }
                    TypeNode[] typeNodeArray = ((TypeStruct)typeNode).fields;
                    string = this.buildPrefix(string, typeNode.name);
                    int n2 = 0;
                    while (n2 < typeNodeArray.length) {
                        this.setOffset(n);
                        String string6 = (string3 != null ? string3 : "") + typeNodeArray[n2].name;
                        if (typeNodeArray[n2].nodeType != 10) {
                            XUnionBranch xUnionBranch = new XUnionBranch(string6, "??");
                            xTypeDef.union.addAttribute("", xUnionBranch);
                        }
                        this.processTypeNode(xTypeDef, typeNodeArray[n2], string, true, string2, string6, (string4.length() > 0 ? string4 + '_' : "") + xTypeDef.getName() + '_' + string);
                        ++n2;
                    }
                    this.setOffset(this.maxByteOffset);
                    bl = false;
                    break;
                }
                default: {
                    XElementQualifier xElementQualifier = typeNode.nodeType == 14 ? this.processReference(xTypeDef, (TypeReference)typeNode, string, string2) : this.processScalar((TypeScalar)typeNode, string, string2);
                    if (string3 != null) {
                        xElementQualifier.setUnionBranch(string3);
                    }
                    xTypeDef.addAttribute("", xElementQualifier);
                }
            }
        }
        catch (UnionException unionException) {
            throw unionException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException("Unable to process type for " + xTypeDef.getName(), (Throwable)exception);
        }
    }

    private final XElementQualifier processReference(XTypeDef xTypeDef, TypeReference typeReference, String string, String string2) throws UnionException {
        Object object;
        TypeNode typeNode = this.crossRef.findNvType((int)typeReference.scope, (int)typeReference.index).node;
        XElementQualifier xElementQualifier = new XElementQualifier();
        xElementQualifier.setName(this.toElementName(this.buildPrefix(string, typeReference.name) + string2));
        if (typeNode.nodeType == 7) {
            object = (TypeEnum)typeNode;
            EnumSet enumSet = this.crossRef.findEnum(((TypeEnum)object).enumScope, ((TypeEnum)object).enumIndex);
            if (enumSet.isBoolean) {
                xElementQualifier.setElementType("b8");
            } else {
                xElementQualifier.setElementType("e8");
                xElementQualifier.setEnumDef(this.toClassName(enumSet.enumTag));
            }
        } else {
            xElementQualifier.setElementType("ref");
            object = this.toClassName(typeNode.name);
            xElementQualifier.setTypeDef((String)object);
        }
        int n = this.adjustOffset(typeReference.typeSize);
        if (this.forceOffset) {
            xElementQualifier.setByteOffset(n);
        }
        return xElementQualifier;
    }

    private final XElementQualifier processScalar(TypeScalar typeScalar, String string, String string2) {
        float f;
        int n;
        XElementQualifier xElementQualifier = new XElementQualifier();
        xElementQualifier.setName(this.toElementName(this.buildPrefix(string, typeScalar.name) + string2));
        switch (typeScalar.nodeType) {
            case 1: {
                xElementQualifier.setElementType("s8");
                n = this.adjustOffset(1);
                break;
            }
            case 2: {
                xElementQualifier.setElementType("u8");
                n = this.adjustOffset(1);
                break;
            }
            case 3: {
                xElementQualifier.setElementType("s8");
                n = this.adjustOffset(1);
                break;
            }
            case 4: {
                xElementQualifier.setElementType("u8");
                n = this.adjustOffset(1);
                break;
            }
            case 5: {
                xElementQualifier.setElementType("s16");
                n = this.adjustOffset(2);
                break;
            }
            case 6: {
                xElementQualifier.setElementType("u16");
                n = this.adjustOffset(2);
                break;
            }
            case 7: {
                TypeEnum typeEnum = (TypeEnum)typeScalar;
                EnumSet enumSet = this.crossRef.findEnum(typeEnum.enumScope, typeEnum.enumIndex);
                if (enumSet == null) {
                    throw new RuntimeException("Could not find enumSet " + typeEnum.enumScope + '\\' + typeEnum.enumIndex + " in " + this.typeFile.fileName);
                }
                if (enumSet.isBoolean) {
                    xElementQualifier.setElementType("b8");
                } else {
                    xElementQualifier.setElementType("e8");
                    xElementQualifier.setEnumDef(this.toClassName(enumSet.enumTag));
                }
                int n2 = this.adjustOffset(1);
                return xElementQualifier;
            }
            case 11: {
                TypeBitfield typeBitfield = (TypeBitfield)typeScalar;
                if (!typeBitfield.bitfSigned) {
                    xElementQualifier.setElementType("ub");
                } else {
                    xElementQualifier.setElementType("sb");
                }
                if (typeBitfield.bitfOffset < this.nextBitOffset) {
                    this.incrementByteOffset();
                }
                this.nextBitOffset = typeBitfield.bitfOffset + typeBitfield.bitfSize;
                n = this.byteOffset;
                xElementQualifier.setByteOffset(n);
                xElementQualifier.setBitOffset(8 - typeBitfield.bitfOffset - typeBitfield.bitfSize);
                xElementQualifier.setLength(typeBitfield.bitfSize);
                break;
            }
            case 12: {
                xElementQualifier.setElementType("f32");
                n = this.adjustOffset(4);
                break;
            }
            case 13: {
                xElementQualifier.setElementType("s32");
                n = this.adjustOffset(4);
                break;
            }
            case 15: {
                xElementQualifier.setElementType("u32");
                n = this.adjustOffset(4);
                break;
            }
            case 16: {
                xElementQualifier.setElementType("f64");
                n = this.adjustOffset(8);
                break;
            }
            case 17: {
                xElementQualifier.setElementType("s64");
                n = this.adjustOffset(8);
                break;
            }
            case 18: {
                xElementQualifier.setElementType("u64");
                n = this.adjustOffset(8);
                break;
            }
            default: {
                throw new RuntimeException("Invalid NVT_TYPE : " + typeScalar.nodeType);
            }
        }
        if (this.forceOffset) {
            xElementQualifier.setByteOffset(n);
        }
        if ((f = (float)((double)typeScalar.scaleA * Math.pow(10.0, typeScalar.scaleB))) == 0.0f) {
            f = 1.0f;
        }
        if (f != 1.0f) {
            xElementQualifier.setResolution(f);
        }
        if (typeScalar.scaleC != 0) {
            xElementQualifier.setOffset(-((float)typeScalar.scaleC * f));
        }
        if (typeScalar.hasMinimum()) {
            xElementQualifier.setMinimum(this.applyResolution(typeScalar.getMinimum(), f));
        }
        if (typeScalar.hasMaximum()) {
            xElementQualifier.setMaximum(this.applyResolution(typeScalar.getMaximum(), f));
        }
        if (typeScalar.hasInvalid()) {
            xElementQualifier.setInvalid(typeScalar.getInvalid());
        }
        if (typeScalar.resUntIndex > 0) {
            String string3;
            try {
                string3 = this.crossRef.getResourceString(typeScalar.resUntScope, typeScalar.resUntIndex);
            }
            catch (CancelOperationException cancelOperationException) {
                throw cancelOperationException;
            }
            catch (Throwable throwable) {
                string3 = "";
            }
            if (string3.length() > 0) {
                xElementQualifier.setEngUnit(string3);
                try {
                    BUnit.getUnit((String)string3);
                }
                catch (Throwable throwable) {
                    this.out.println("Could not find eng units " + string3 + ' ' + typeScalar.resUntScope + '/' + typeScalar.resUntIndex);
                }
            }
        }
        return xElementQualifier;
    }

    private final Double applyResolution(Number number, float f) {
        if ((double)f == 1.0) {
            return new Double(number.doubleValue());
        }
        if (number instanceof Integer) {
            return new Double((float)number.intValue() * f);
        }
        if (number instanceof Long) {
            return new Double((float)number.longValue() * f);
        }
        return new Double((Double)number * (double)f);
    }

    private final String toClassName(String string) {
        if (!this.fixNames) {
            return string;
        }
        return NameUtil.toJavaName(string, true);
    }

    private final String toElementName(String string) {
        if (!this.fixNames) {
            return string;
        }
        String string2 = NameUtil.toJavaName(string, false);
        int n = 0;
        while (n < JAVA_RESERVED_WORDS.length) {
            if (string2.equals(JAVA_RESERVED_WORDS[n])) {
                string2 = string2.substring(0, 1).toUpperCase() + string2.substring(1);
            }
            ++n;
        }
        return string2;
    }

    private final String buildPrefix(String string, String string2) {
        if (string.length() == 0) {
            return this.toElementName(string2);
        }
        if (string2.length() == 0) {
            return this.toElementName(string);
        }
        return this.toElementName(string) + this.toClassName(string2);
    }

    private final void resetOffset() {
        this.nextBitOffset = 0;
        this.byteOffset = 0;
        this.forceOffset = false;
        this.maxByteOffset = 0;
    }

    private final int adjustOffset(int n) {
        if (this.nextBitOffset != 0) {
            ++this.byteOffset;
        }
        int n2 = this.byteOffset;
        this.nextBitOffset = 0;
        this.byteOffset += n;
        if (this.byteOffset > this.maxByteOffset) {
            this.maxByteOffset = this.byteOffset;
        }
        return n2;
    }

    private final void incrementByteOffset() {
        ++this.byteOffset;
        if (this.byteOffset > this.maxByteOffset) {
            this.maxByteOffset = this.byteOffset;
        }
    }

    private final void setOffset(int n) {
        this.nextBitOffset = 0;
        this.byteOffset = n;
    }

    public static void main(String[] stringArray) throws Exception {
        String string = stringArray[0];
        if (string == null) {
            System.out.println("must specify file to parse");
            return;
        }
        ResourceFileUtil.getResourceFile(string);
    }

    private final /* synthetic */ void this() {
        this.forceOffset = false;
        this.fixNames = true;
        this.parseUnions = true;
    }

    public ResourceToXLon(CrossReference crossReference, boolean bl, PrintStream printStream) {
        this.this();
        this.crossRef = crossReference;
        this.fixNames = bl;
        this.out = printStream;
    }

    static {
        UnitDatabase.getDefault();
    }

    static class UnionException
    extends Exception {
        public static final long serialVersionUID = 2L;

        UnionException() {
        }
    }
}

