/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.resource;

import com.tridium.lonworks.resource.Conversion;
import com.tridium.lonworks.resource.CpType;
import com.tridium.lonworks.resource.EnumSet;
import com.tridium.lonworks.resource.Fpt;
import com.tridium.lonworks.resource.FptFile;
import com.tridium.lonworks.resource.LanguageFile;
import com.tridium.lonworks.resource.ResourceFile;
import com.tridium.lonworks.resource.ResourceFileUtil;
import com.tridium.lonworks.resource.Type;
import com.tridium.lonworks.resource.TypeFile;
import com.tridium.lonworks.util.LonFileUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.util.Array;
import javax.baja.units.BUnit;
import javax.baja.util.ByteArrayUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CrossReference {
    Conversion.UnitPrompt unitPrompt;
    boolean[] marks;
    Resource resources;
    Resource standard;
    PrintStream out;
    static /* synthetic */ Class class$com$tridium$lonworks$resource$TypeFile;

    private final void addStandard() {
        String string = "standard";
        Resource resource = new Resource();
        resource.fileName = string;
        BIFile bIFile = (BIFile)BOrd.make((String)"module://lonworks/type/Standard.typ").get();
        try {
            resource.typFile = (TypeFile)ResourceFileUtil.getResourceFile(bIFile);
        }
        catch (IOException iOException) {
            this.out.println(iOException);
        }
        bIFile = (BIFile)BOrd.make((String)"module://lonworks/type/Standard.fpt").get();
        try {
            resource.fptFile = (FptFile)ResourceFileUtil.getResourceFile(bIFile);
        }
        catch (IOException iOException) {
            this.out.println("No \".fpt\" file for " + string);
        }
        bIFile = (BIFile)BOrd.make((String)"module://lonworks/type/Standard.enu").get();
        try {
            resource.lanFile = (LanguageFile)ResourceFileUtil.getResourceFile(bIFile);
        }
        catch (IOException iOException) {
            this.out.println("No \".enu\" file for " + string);
        }
        try {
            bIFile = (BIFile)BOrd.make((String)"file:!lib/lonStandardConversion.xml").get();
        }
        catch (UnresolvedException unresolvedException) {
            bIFile = (BIFile)BOrd.make((String)"module://lonworks/type/StandardConversion.xml").get();
        }
        resource.conversion = new Conversion(bIFile);
        this.standard = resource;
        resource.standard = true;
        this.addResource(resource);
    }

    private final void addResource(Resource resource) {
        if (this.resources == null || this.resources.typFile.scope <= resource.typFile.scope) {
            resource.next = this.resources;
            this.resources = resource;
            return;
        }
        Resource resource2 = this.resources;
        Resource resource3 = resource2.next;
        while (resource3 != null) {
            if (resource3.typFile.scope < resource.typFile.scope) {
                resource.next = resource3;
                resource2.next = resource;
                return;
            }
            resource2 = resource3;
            resource3 = resource2.next;
        }
        resource2.next = resource;
    }

    private final void verifyUniqueResourceId(TypeFile typeFile, String string) throws DuplicateResourceException {
        Resource resource = this.resources;
        while (resource != null) {
            if (resource.typFile.scope == typeFile.scope && this.compareArray(resource.typFile.refId, typeFile.refId, 8)) {
                throw new DuplicateResourceException("Duplicate resource sets: " + string + " & " + this.stripFilename(resource.fileName) + " for scope " + resource.typFile.scope + " and refId: " + ByteArrayUtil.toHexString((byte[])resource.typFile.refId));
            }
            resource = resource.next;
        }
    }

    private final boolean compareArray(byte[] byArray, byte[] byArray2, int n) {
        int n2;
        if (n == 0) {
            return true;
        }
        if (byArray[0] != 15) {
            if ((byArray[0] & 0xF) != (byArray2[0] & 0xF)) {
                return false;
            }
            n2 = byArray[0] >> 4 & 0xF;
            int n3 = byArray2[0] >> 4 & 0xF;
            if (n2 != 8 && n2 != 9 || n3 != 8 && n3 != 9) {
                return false;
            }
        }
        n2 = 1;
        while (n2 < n) {
            if (byArray[n2] != byArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void addResource(BDirectory bDirectory, String string, TypeFile typeFile) throws DuplicateResourceException {
        String string2 = this.stripFilename(string);
        Resource resource = new Resource();
        resource.fileName = string2;
        resource.typFile = typeFile;
        if (resource.typFile == null) {
            resource.typFile = (TypeFile)this.getResourceFile(bDirectory, string2, ".typ");
        }
        resource.fptFile = (FptFile)this.getResourceFile(bDirectory, string2, ".fpt");
        resource.lanFile = this.getLanguageFile(bDirectory, string2);
        this.verifyUniqueResourceId(resource.typFile, string2);
        BIFile bIFile = LonFileUtil.getOrMakeFile(bDirectory, string2 + "Conversion.xml");
        if (bIFile != null) {
            resource.conversion = new Conversion(bIFile);
        }
        resource.conversion.setUnitPrompt(this.unitPrompt);
        this.addResource(resource);
    }

    private final LanguageFile getLanguageFile(BDirectory bDirectory, String string) {
        BIFile[] bIFileArray = bDirectory.listFiles();
        LanguageFile languageFile = null;
        int n = 0;
        while (n < bIFileArray.length) {
            if (this.fileNameNoExt(bIFileArray[n].getFileName()).equals(string)) {
                ResourceFile resourceFile = null;
                try {
                    resourceFile = ResourceFileUtil.getResourceFile(bIFileArray[n]);
                }
                catch (Throwable throwable) {}
                if (resourceFile != null && resourceFile.fileType == 2) {
                    if (languageFile == null) {
                        languageFile = (LanguageFile)resourceFile;
                        this.out.println("Using language file: " + bIFileArray[n].getFileName());
                    } else {
                        this.out.println("Detected duplicate language file: " + bIFileArray[n].getFileName());
                    }
                }
            }
            ++n;
        }
        return null;
    }

    private final String fileNameNoExt(String string) {
        int n = string.indexOf(".");
        return n > 0 ? string.substring(0, n) : string;
    }

    private final String stripFilename(String string) {
        String string2 = string.lastIndexOf(46) > 0 ? string.substring(0, string.lastIndexOf(46)) : string;
        return string2;
    }

    private final ResourceFile getResourceFile(BDirectory bDirectory, String string, String string2) {
        try {
            BIFile bIFile = LonFileUtil.getFile(bDirectory, string + string2);
            if (bIFile != null) {
                return ResourceFileUtil.getResourceFile(bIFile);
            }
        }
        catch (Exception exception) {}
        this.out.println("Error opening " + string + string2);
        return null;
    }

    public Type findNvType(int n, int n2) {
        if (n2 <= 0) {
            throw new RuntimeException("Not a valid index (" + n2 + ')');
        }
        Resource resource = this.getResouce(n);
        TypeFile typeFile = resource.typFile;
        if (typeFile == null) {
            Thread.dumpStack();
        }
        if (typeFile == null) {
            throw new RuntimeException("No type file for scope " + n);
        }
        Type[] typeArray = typeFile.nvTypes;
        if (n2 > typeArray.length) {
            throw new RuntimeException("No nvType index (" + n2 + ") found in " + typeFile.fileName);
        }
        return typeArray[n2 - 1];
    }

    public CpType findCpType(int n, int n2) {
        Resource resource = this.getResouce(n);
        TypeFile typeFile = resource.typFile;
        if (typeFile == null) {
            Thread.dumpStack();
        }
        if (typeFile == null) {
            throw new RuntimeException("No type file for scope " + n);
        }
        CpType[] cpTypeArray = typeFile.cpTypes;
        if (n2 < 0 || n2 > cpTypeArray.length) {
            throw new RuntimeException("No cpType index (" + n2 + ") found in " + typeFile.fileName);
        }
        return cpTypeArray[n2 - 1];
    }

    public EnumSet findEnum(int n, int n2) {
        Resource resource = this.getResouce(n);
        TypeFile typeFile = resource.typFile;
        if (typeFile == null) {
            Thread.dumpStack();
        }
        if (typeFile == null) {
            throw new RuntimeException("No type file for scope " + n);
        }
        EnumSet[] enumSetArray = typeFile.enumSets;
        if (n2 > enumSetArray.length) {
            throw new RuntimeException("No enum index " + n2 + " found in " + typeFile.fileName);
        }
        EnumSet enumSet = enumSetArray[n2 - 1];
        if (resource.conversion != null && resource.conversion.isBooleanEnum(enumSet.enumTag)) {
            enumSet.isBoolean = true;
        }
        return enumSet;
    }

    public Type findNvTypeByObject(int n, int n2, boolean bl) {
        Resource resource = this.resources;
        while (resource != null) {
            if (resource.standard == bl) {
                resource = resource.next;
                continue;
            }
            FptFile fptFile = resource.fptFile;
            Fpt fpt = fptFile.getFptByKey(n);
            if (fpt != null) {
                Fpt.Nv nv = fpt.getMemberNv(n2);
                if (nv == null) {
                    throw new RuntimeException("No member " + n2 + " for object type " + n + " in file " + fptFile.fileName);
                }
                if (nv.nvTIndex <= 0) {
                    throw new RuntimeException("Member nv " + n2 + " for object type " + n + " in file " + fptFile.fileName + " has no type specified.");
                }
                Type type = this.findNvType(nv.nvTScope, nv.nvTIndex);
                if (type == null) {
                    throw new RuntimeException("Could not find nv type " + nv.nvTScope + ',' + nv.nvTIndex);
                }
                return type;
            }
            resource = resource.next;
        }
        throw new RuntimeException("Could not find object type " + n);
    }

    public String getCpName(int n, int n2, int n3) {
        Object object;
        Object object2;
        Resource resource = this.resources;
        while (resource != null) {
            if (resource.standard) {
                resource = resource.next;
                continue;
            }
            object2 = resource.fptFile;
            object = ((FptFile)object2).getFptByKey(n);
            if (object != null) {
                Fpt fpt;
                Fpt.Cp cp = ((Fpt)object).getMemberCp(n2, n3);
                if (cp == null && ((Fpt)object).inheritMark && this.standard != null && (fpt = this.standard.fptFile.getFptByKey(n)) != null) {
                    cp = fpt.getMemberCp(n2, n3);
                }
                if (cp == null) {
                    throw new RuntimeException("No member cp with scope/index " + n2 + '/' + n3 + " in " + ((Fpt)object).key + ' ' + ((FptFile)object2).fileName);
                }
                return cp.cpName;
            }
            resource = resource.next;
        }
        if (this.standard != null && (object2 = this.standard.fptFile.getFptByKey(n)) != null) {
            object = ((Fpt)object2).getMemberCp(n2, n3);
            if (object == null) {
                throw new RuntimeException("No member cp with scope/index " + n2 + '/' + n3 + " in " + ((Fpt)object2).key + ' ' + this.standard.fileName);
            }
            return ((Fpt.Cp)object).cpName;
        }
        throw new RuntimeException("Could not find object type " + n);
    }

    public String getResourceString(int n, int n2) {
        String string;
        block4: {
            Resource resource = this.getResouce(n);
            LanguageFile languageFile = resource.lanFile;
            if (languageFile == null) {
                throw new RuntimeException("No language file for scope " + n);
            }
            LanguageFile.LangRec[] langRecArray = languageFile.langRecs;
            if (n2 > langRecArray.length) {
                throw new RuntimeException("No index " + n + '/' + n2 + " found in " + languageFile.fileName);
            }
            string = langRecArray[n2 - 1].resStr;
            try {
                String string2 = string.toLowerCase();
                BUnit.getUnit((String)string2);
                string = string2;
            }
            catch (Throwable throwable) {
                Conversion conversion = resource.conversion;
                if (conversion == null) break block4;
                string = conversion.getConversionString(n, n2, string);
            }
        }
        return string;
    }

    public String getPrincipalNv(int n) {
        Resource resource = this.resources;
        while (resource != null) {
            if (resource.standard) {
                resource = resource.next;
                continue;
            }
            boolean bl = true;
            FptFile fptFile = resource.fptFile;
            Fpt fpt = fptFile.getFptByKey(n);
            if (fpt != null) {
                if (fpt.principalNV == 0 && fpt.inheritMark && this.standard != null) {
                    fpt = this.standard.fptFile.getFptByKey(n);
                    bl = false;
                }
                if (fpt.principalNV <= 0) {
                    throw new RuntimeException("No principalNV for objType " + n);
                }
                return (bl ? "#" : "|") + fpt.principalNV;
            }
            resource = resource.next;
        }
        if (this.standard != null) {
            Fpt fpt = this.standard.fptFile.getFptByKey(n);
            if (fpt.principalNV <= 0) {
                throw new RuntimeException("No principalNV for objType " + n);
            }
            return "|" + fpt.principalNV;
        }
        throw new RuntimeException("Could not find object type " + n);
    }

    public void setUnitPrompt(Conversion.UnitPrompt unitPrompt) {
        this.unitPrompt = unitPrompt;
        Resource resource = this.resources;
        while (resource != null) {
            if (resource.conversion != null) {
                resource.conversion.setUnitPrompt(unitPrompt);
            }
            resource = resource.next;
        }
    }

    public Conversion getConversion(String string) {
        String string2 = this.stripFilename(string);
        Resource resource = this.resources;
        while (resource != null && !resource.fileName.equals(string2)) {
            resource = resource.next;
        }
        if (resource == null) {
            return null;
        }
        return resource.conversion;
    }

    public TypeFile[] getTypeFiles(boolean bl) {
        Class clazz = class$com$tridium$lonworks$resource$TypeFile;
        if (clazz == null) {
            clazz = class$com$tridium$lonworks$resource$TypeFile = CrossReference.class("[Lcom.tridium.lonworks.resource.TypeFile;", false);
        }
        Array array = new Array(clazz);
        Resource resource = this.resources;
        while (resource != null) {
            if (!(resource.standard || bl && !this.marks[resource.typFile.scope])) {
                array.add((Object)resource.typFile);
            }
            resource = resource.next;
        }
        return (TypeFile[])array.trim();
    }

    public void flush() {
        Resource resource = this.resources;
        while (resource != null) {
            if (resource.conversion != null) {
                resource.conversion.flush();
            }
            resource = resource.next;
        }
    }

    Resource getResouce(int n) {
        Resource resource = this.resources;
        while (resource != null && resource.typFile != null && resource.typFile.scope != n) {
            resource = resource.next;
        }
        if (resource == null) {
            throw new RuntimeException("No resource file for scope " + n);
        }
        return resource;
    }

    public LanguageFile getLanguageFile(int n) {
        Resource resource = this.getResouce(n);
        LanguageFile languageFile = resource.lanFile;
        if (languageFile == null) {
            throw new RuntimeException("No language file for scope " + n);
        }
        return languageFile;
    }

    public void mark(int n) {
        if (n < 0 || n >= this.marks.length) {
            return;
        }
        this.marks[n] = true;
    }

    public void clearMarks() {
        this.marks = new boolean[7];
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.unitPrompt = null;
        this.marks = new boolean[7];
        this.resources = null;
        this.standard = null;
        this.out = System.out;
    }

    public CrossReference(boolean bl, String string) {
        this.this();
        String string2 = "standard";
        Resource resource = new Resource();
        resource.fileName = string2;
        try {
            BIFile bIFile = LonFileUtil.getFile(string + "/STANDARD.typ");
            resource.typFile = (TypeFile)ResourceFileUtil.getResourceFile(bIFile);
            bIFile = LonFileUtil.getFile(string + "/STANDARD.fpt");
            resource.fptFile = (FptFile)ResourceFileUtil.getResourceFile(bIFile);
            bIFile = LonFileUtil.getFile(string + "/STANDARD.enu");
            resource.lanFile = (LanguageFile)ResourceFileUtil.getResourceFile(bIFile);
            File file = new File(".");
            bIFile = LonFileUtil.getFile(file.getCanonicalPath() + "/StandardConversion.xml");
            resource.conversion = new Conversion(bIFile);
        }
        catch (Throwable throwable) {
            System.out.println(throwable);
        }
        this.standard = resource;
        resource.standard = true;
        resource.next = this.resources;
        this.resources = resource;
    }

    public CrossReference() {
        this.this();
        this.addStandard();
    }

    public CrossReference(PrintStream printStream) {
        this.this();
        this.out = printStream;
        this.addStandard();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class Resource {
        String fileName;
        TypeFile typFile;
        FptFile fptFile;
        LanguageFile lanFile;
        Conversion conversion;
        Resource next;
        boolean standard;

        private final /* synthetic */ void this() {
            this.typFile = null;
            this.fptFile = null;
            this.lanFile = null;
            this.conversion = null;
            this.next = null;
            this.standard = false;
        }

        Resource() {
            this.this();
        }
    }

    public static class DuplicateResourceException
    extends Exception {
        public static final long serialVersionUID = 1L;
        final String msg;

        public String toString() {
            return this.msg;
        }

        DuplicateResourceException(String string) {
            this.msg = string;
        }
    }
}

