/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.netmgmt;

import com.tridium.lonworks.enums.BLonLinkStatus;
import com.tridium.lonworks.netmgmt.NetMgmtConst;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.datatypes.BDeviceData;
import javax.baja.lonworks.datatypes.BIAddressEntry;
import javax.baja.lonworks.datatypes.BSubnetNode;
import javax.baja.lonworks.enums.BAddressType;
import javax.baja.naming.SlotPath;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TagPoint
implements NetMgmtConst {
    protected BLonDevice device;
    private int tagIndex;
    private BLonLinkStatus status;
    private String name;
    private boolean mtag;

    public BLonDevice getLonDevice() {
        return this.device;
    }

    public int getTagIndex() {
        return this.tagIndex;
    }

    public BLonLinkStatus getStatus() {
        return this.status;
    }

    public void setTagIndex(int n) {
        this.tagIndex = n;
    }

    public void setStatus(BLonLinkStatus bLonLinkStatus) {
        this.status = bLonLinkStatus;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean isNew() {
        boolean bl = false;
        if (this.status == BLonLinkStatus.newLink) {
            bl = true;
        }
        return bl;
    }

    public boolean isObsolete() {
        boolean bl = false;
        if (this.status == BLonLinkStatus.obsolete) {
            bl = true;
        }
        return bl;
    }

    public boolean isBound() {
        boolean bl = false;
        if (this.status == BLonLinkStatus.bound) {
            bl = true;
        }
        return bl;
    }

    public boolean isUnbound() {
        boolean bl = false;
        if (this.status == BLonLinkStatus.unbound) {
            bl = true;
        }
        return bl;
    }

    public boolean isActive() {
        boolean bl = false;
        if (this.status == BLonLinkStatus.bound || this.status == BLonLinkStatus.newLink) {
            bl = true;
        }
        return bl;
    }

    public boolean isLocal() {
        return this.device.isLocal();
    }

    public boolean isSameNode(BLonDevice bLonDevice) {
        boolean bl = false;
        if (this.device == bLonDevice) {
            bl = true;
        }
        return bl;
    }

    public boolean isError() {
        return this.status.isError();
    }

    public String getDeviceName() {
        return this.device.getDisplayName(null);
    }

    public String getTagName() {
        return SlotPath.unescape((String)this.name) + (this.tagIndex >= 0 ? " (" + this.tagIndex + ')' : "");
    }

    public boolean isMtag() {
        return this.mtag;
    }

    public boolean verifyGroup(int n) {
        BDeviceData bDeviceData = this.device.getDeviceData();
        int n2 = 0;
        while (n2 < bDeviceData.getAddressCount()) {
            BIAddressEntry bIAddressEntry = bDeviceData.getAddressEntry(n2);
            if (bIAddressEntry.getAddressType() == BAddressType.group && bIAddressEntry.getGroupOrSubnet() == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean equals(TagPoint tagPoint) {
        boolean bl = false;
        if (this.hashCode() == tagPoint.hashCode()) {
            bl = true;
        }
        return bl;
    }

    public String getSummaryString() {
        return this.getDeviceName() + ':' + this.name + (this.tagIndex != -1 ? "." + this.tagIndex : "");
    }

    public int hashCode() {
        return TagPoint.hashCode(this.device, this.tagIndex);
    }

    public static int hashCode(BLonDevice bLonDevice, int n) {
        BSubnetNode bSubnetNode = bLonDevice.getDeviceData().getSubnetNodeId();
        return (bSubnetNode.getSubnetId() << 11) + (bSubnetNode.getNodeId() << 4) + n;
    }

    public String toString() {
        return "Device " + this.getDeviceName() + ':' + this.name + " tagIndex = " + this.tagIndex + ' ' + (Object)((Object)this.status);
    }

    private final /* synthetic */ void this() {
        this.mtag = false;
    }

    public TagPoint(BLonDevice bLonDevice, int n, BLonLinkStatus bLonLinkStatus, String string) {
        this.this();
        this.device = bLonDevice;
        this.tagIndex = n;
        this.status = bLonLinkStatus;
        this.name = string;
        boolean bl = false;
        if (n >= 0) {
            bl = true;
        }
        this.mtag = bl;
    }

    public TagPoint(BLonDevice bLonDevice, int n, BLonLinkStatus bLonLinkStatus) {
        this(bLonDevice, n, bLonLinkStatus, "msgOut" + n);
    }
}

