/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.netmgmt;

import com.tridium.lonworks.datatypes.BLinkDescriptor;
import com.tridium.lonworks.enums.BLonLinkStatus;
import com.tridium.lonworks.netmgmt.ConnectionTable;
import com.tridium.lonworks.netmgmt.Group;
import com.tridium.lonworks.netmgmt.GroupMember;
import com.tridium.lonworks.netmgmt.GroupTable;
import com.tridium.lonworks.netmgmt.NetMgmtConst;
import com.tridium.lonworks.netmgmt.TagPoint;
import java.util.Vector;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.datatypes.BIAddressEntry;
import javax.baja.lonworks.datatypes.BSubnetNode;
import javax.baja.lonworks.enums.BAddressType;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TagConnection
implements NetMgmtConst {
    private int addressGroup;
    private BIAddressEntry entry;
    private boolean addressChange;
    private Vector inputs;
    private TagPoint output;

    public void setAddressChange(boolean bl) {
        this.addressChange = bl;
    }

    public void setAddressGroup(int n) {
        this.addressGroup = n;
    }

    public void setAddressEntry(BIAddressEntry bIAddressEntry) {
        this.entry = bIAddressEntry;
        if (bIAddressEntry.isGroupAddress()) {
            this.addressGroup = bIAddressEntry.getGroupOrSubnet();
        }
    }

    public int getAddressGroup() {
        return this.addressGroup;
    }

    public boolean isAddressChange() {
        return this.addressChange;
    }

    public BIAddressEntry getAddressEntry() {
        return this.entry;
    }

    public TagPoint getOutput() {
        return this.output;
    }

    public TagPoint[] getInputs() {
        Object[] objectArray = new TagPoint[this.inputs.size()];
        this.inputs.copyInto(objectArray);
        return objectArray;
    }

    public boolean hasInput() {
        boolean bl = false;
        if (this.inputs.size() > 0) {
            bl = true;
        }
        return bl;
    }

    public boolean containsDevice(BLonDevice bLonDevice) {
        boolean bl = false;
        if (this.findDevice(bLonDevice) != null) {
            bl = true;
        }
        return bl;
    }

    public TagPoint findDevice(BLonDevice bLonDevice) {
        if (this.output.isSameNode(bLonDevice)) {
            return this.output;
        }
        int n = this.inputs.size();
        int n2 = 0;
        while (n2 < n) {
            TagPoint tagPoint = (TagPoint)this.inputs.elementAt(n2);
            if (tagPoint.isSameNode(bLonDevice)) {
                return tagPoint;
            }
            ++n2;
        }
        return null;
    }

    public int getGroupNum() {
        if (this.entry == null || !this.entry.isGroupAddress()) {
            return -1;
        }
        return this.entry.getGroupOrSubnet();
    }

    public boolean isNew() {
        int n = this.inputs.size();
        int n2 = 0;
        while (n2 < n) {
            if (((TagPoint)this.inputs.elementAt(n2)).isNew()) {
                return true;
            }
            ++n2;
        }
        return this.output.isNew();
    }

    public void setError() {
        this.setStatus(BLonLinkStatus.error);
    }

    public void setStatus(BLonLinkStatus bLonLinkStatus) {
        int n = this.inputs.size();
        int n2 = 0;
        while (n2 < n) {
            ((TagPoint)this.inputs.elementAt(n2)).setStatus(bLonLinkStatus);
            ++n2;
        }
        this.output.setStatus(bLonLinkStatus);
    }

    public boolean isError() {
        if (this.output.isError()) {
            return true;
        }
        int n = this.inputs.size();
        int n2 = 0;
        while (n2 < n) {
            if (((TagPoint)this.inputs.elementAt(n2)).isError()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isBound() {
        if (!this.output.isBound()) {
            return false;
        }
        int n = this.inputs.size();
        int n2 = 0;
        while (n2 < n) {
            if (!((TagPoint)this.inputs.elementAt(n2)).isBound()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean isActive() {
        if (!this.output.isActive()) {
            return false;
        }
        int n = this.inputs.size();
        int n2 = 0;
        while (n2 < n) {
            if (((TagPoint)this.inputs.elementAt(n2)).isActive()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.inputs.size();
        stringBuffer.append(" TagConnection => ");
        stringBuffer.append("\n   Output = ").append(this.output);
        if (n == 0) {
            stringBuffer.append("  no inputs");
        }
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("\n   input #").append(n2).append(" ").append(this.inputs.elementAt(n2));
            ++n2;
        }
        return stringBuffer.toString();
    }

    public boolean addInput(TagPoint tagPoint) {
        int n = this.inputs.size();
        int n2 = 0;
        while (n2 < n) {
            if (((TagPoint)this.inputs.elementAt(n2)).equals(tagPoint)) {
                return true;
            }
            ++n2;
        }
        this.inputs.addElement(tagPoint);
        return true;
    }

    public void setMessageTagStatus(ConnectionTable connectionTable, GroupTable groupTable) {
        if (this.entry == null) {
            return;
        }
        if (this.output.isObsolete() && this.inputs.size() == 0) {
            return;
        }
        BLinkDescriptor bLinkDescriptor = connectionTable.lonworks.netmgmt().getLinkDescriptors().getDescriptor(2);
        boolean bl = bLinkDescriptor.entryMatches(this.entry) ^ true;
        BAddressType bAddressType = this.entry.getAddressType();
        int n = this.inputs.size();
        if (bAddressType == BAddressType.group) {
            GroupMember groupMember;
            TagPoint tagPoint = (TagPoint)this.inputs.elementAt(0);
            if (n == 1 && !tagPoint.isMtag()) {
                this.setStatus(BLonLinkStatus.newLink);
                return;
            }
            int n2 = this.entry.getGroupOrSubnet();
            Group group = groupTable.getGroup(n2);
            boolean bl2 = false;
            if (group == null) {
                this.setStatus(BLonLinkStatus.newLink);
                return;
            }
            if (group.getSize() != n + 1) {
                bl2 = true;
            }
            int n3 = 0;
            while (n3 < n) {
                tagPoint = (TagPoint)this.inputs.elementAt(n3);
                groupMember = group.findMember(connectionTable.getDeviceIndex(tagPoint.getLonDevice()));
                if (groupMember == null || tagPoint.isMtag() && groupMember.getAddressIndex() != tagPoint.getTagIndex()) {
                    bl2 = true;
                } else {
                    tagPoint.setTagIndex(groupMember.getAddressIndex());
                }
                ++n3;
            }
            if (bl2) {
                this.setStatus(BLonLinkStatus.newLink);
                return;
            }
            groupMember = group.findMember(connectionTable.getDeviceIndex(this.output.getLonDevice()));
            if (groupMember == null || !groupMember.isMessageTag() || groupMember.getAddressIndex() != this.output.getTagIndex()) {
                this.setStatus(BLonLinkStatus.newLink);
                return;
            }
            if (bl) {
                this.setStatus(BLonLinkStatus.dirtyDescriptor);
                return;
            }
            this.setStatus(BLonLinkStatus.bound);
        } else if (bAddressType == BAddressType.subnetNode) {
            TagPoint tagPoint;
            BSubnetNode bSubnetNode;
            BLonLinkStatus bLonLinkStatus = BLonLinkStatus.newLink;
            if (n == 1 && (bSubnetNode = (tagPoint = (TagPoint)this.inputs.elementAt(0)).getLonDevice().getSubnetNodeAddress()).getSubnetId() == this.entry.getGroupOrSubnet() && bSubnetNode.getNodeId() == this.entry.getMemberOrNode()) {
                bLonLinkStatus = bl ? BLonLinkStatus.dirtyDescriptor : BLonLinkStatus.bound;
            }
            this.setStatus(bLonLinkStatus);
        } else {
            System.out.println("\nERROR: in TagConnection.verifyEntry()");
            this.setStatus(BLonLinkStatus.error);
        }
    }

    public void setUpdatedStatus() {
        if (this.isError()) {
            return;
        }
        if (this.output.isNew()) {
            this.setStatus(BLonLinkStatus.bound);
        } else if (this.output.isObsolete()) {
            this.setStatus(BLonLinkStatus.unbound);
        }
    }

    public boolean hasNonMtagPoint() {
        int n = this.inputs.size();
        int n2 = 0;
        while (n2 < n) {
            if (!((TagPoint)this.inputs.elementAt(n2)).isMtag()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private final /* synthetic */ void this() {
        this.addressGroup = -1;
        this.entry = null;
        this.addressChange = true;
        this.inputs = new Vector(10);
    }

    public TagConnection(TagPoint tagPoint, boolean bl) {
        this.this();
        this.output = tagPoint;
    }
}

