/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.netmgmt;

import com.tridium.lonworks.Lon;
import com.tridium.lonworks.RouterManager;
import com.tridium.lonworks.datatypes.BLinkDescriptor;
import com.tridium.lonworks.enums.BLonLinkStatus;
import com.tridium.lonworks.netmgmt.BLonBindJob;
import com.tridium.lonworks.netmgmt.Connection;
import com.tridium.lonworks.netmgmt.ConnectionTable;
import com.tridium.lonworks.netmgmt.Group;
import com.tridium.lonworks.netmgmt.GroupBitSet;
import com.tridium.lonworks.netmgmt.GroupMember;
import com.tridium.lonworks.netmgmt.LonPoint;
import com.tridium.lonworks.netmgmt.NetMgmtConst;
import com.tridium.lonworks.netmgmt.TagConnection;
import com.tridium.lonworks.netmgmt.TagPoint;
import com.tridium.lonworks.util.NmUtil;
import java.util.BitSet;
import java.util.Vector;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.datatypes.BAddressEntry;
import javax.baja.lonworks.datatypes.BDeviceData;
import javax.baja.lonworks.datatypes.BIAddressEntry;
import javax.baja.lonworks.datatypes.BSubnetNode;
import javax.baja.lonworks.enums.BAddressType;
import javax.baja.lonworks.enums.BLonLinkType;
import javax.baja.sys.BajaRuntimeException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GroupTable
implements NetMgmtConst {
    private static int MAX_USE = 5000;
    private static int MAX_SIZE = 256;
    private Group[] table;
    private BLonDevice[] lonDevices;
    private boolean debug;
    private ConnectionTable connTable;
    BLonNetwork lonworks;
    BLonBindJob bindJob;

    public Group getGroup(int n) {
        if (n < 0 || n > this.table.length) {
            return null;
        }
        return this.table[n];
    }

    public boolean selectTurnAround(Connection connection, Vector vector) {
        int n;
        BAddressEntry bAddressEntry;
        LonPoint lonPoint = connection.getHub();
        BLonDevice bLonDevice = lonPoint.getLonDevice();
        int n2 = this.findAddressEntry(bLonDevice, bAddressEntry = BAddressEntry.make(BAddressType.turnaround, 0, 0, 1, n = NmUtil.linkTypeToDescriptor(connection.getLinkType()), bLonDevice.getWorkingDomain(), this.lonworks.netmgmt().getLinkDescriptors().getDescriptor(n)));
        if (n2 >= 0) {
            if (lonPoint.getAddressIndex() == n2) {
                if (!bAddressEntry.equals(lonPoint.getAddressEntry())) {
                    lonPoint.setAddressEntry(bAddressEntry);
                    connection.setAddressChange(true);
                } else {
                    connection.setAddressChange(false);
                }
                return true;
            }
        } else {
            int n3 = this.connTable.getDeviceIndex(bLonDevice);
            if (!(this.hasFreeAddressEntry(bLonDevice) || this.freeAddressEntry(n3, vector) || this.mergeGroups(n3, vector))) {
                return false;
            }
            n2 = this.addAddressEntry(bLonDevice, bAddressEntry);
        }
        if (n2 < 0) {
            return false;
        }
        lonPoint.setAddressIndex(n2);
        lonPoint.setStatus(BLonLinkStatus.newLink);
        connection.setAddressChange(true);
        return true;
    }

    public boolean selectSingle(Connection connection, LonPoint lonPoint, Vector vector) {
        LonPoint lonPoint2 = connection.getHub();
        if (lonPoint == null) {
            return false;
        }
        if (lonPoint2.isLocal()) {
            connection.setAddressChange(false);
            return true;
        }
        boolean bl = lonPoint2.requiresAddressEntry();
        LonPoint lonPoint3 = bl ? lonPoint2 : lonPoint;
        LonPoint lonPoint4 = bl ? lonPoint : lonPoint2;
        BLonDevice bLonDevice = lonPoint3.getLonDevice();
        BLonDevice bLonDevice2 = lonPoint4.getLonDevice();
        BDeviceData bDeviceData = bLonDevice2.getDeviceData();
        int n = NmUtil.linkTypeToDescriptor(connection.getLinkType());
        BAddressEntry bAddressEntry = BAddressEntry.makeSubnetNodeEntry(bDeviceData.getSubnetNodeId(), n, bLonDevice.getWorkingDomain(), this.lonworks.netmgmt().getLinkDescriptors().getDescriptor(n));
        int n2 = this.findAddressEntry(bLonDevice, bAddressEntry);
        if (n2 >= 0) {
            if (lonPoint3.getAddressIndex() == n2) {
                if (!bAddressEntry.equals(lonPoint3.getAddressEntry())) {
                    lonPoint3.setAddressEntry(bAddressEntry);
                    connection.setAddressChange(true);
                } else {
                    connection.setAddressChange(false);
                }
                return true;
            }
        } else {
            if (!this.hasFreeAddressEntry(bLonDevice) && !this.freeAddressEntry(this.connTable.getDeviceIndex(bLonDevice), true, vector)) {
                return false;
            }
            n2 = this.addAddressEntry(bLonDevice, bAddressEntry);
        }
        if (n2 < 0) {
            return false;
        }
        if (this.debug) {
            System.out.println(" in selectSingle() change adrNdx from " + lonPoint3.getAddressIndex() + " to " + n2);
        }
        lonPoint3.setAddressIndex(n2);
        if (lonPoint3.isBound()) {
            lonPoint3.setStatus(BLonLinkStatus.newLink);
        }
        connection.setAddressGroup(-1);
        connection.setAddressChange(true);
        return true;
    }

    public boolean selectGroup(Connection connection, Vector vector) {
        int n = connection.getAddressGroup();
        GroupBitSet groupBitSet = connection.getGroupBitSet(this.lonDevices);
        GroupBitSet groupBitSet2 = connection.getExcludeBitSet(this.lonDevices);
        if (n == -1 || this.table[n] == null || !this.table[n].getBitSet().contains(groupBitSet, groupBitSet2) || this.table[n].getLinkType() != connection.getLinkType()) {
            n = this.selectGroup(groupBitSet, groupBitSet2, connection.getLinkType(), false, n, vector);
        }
        if (this.debug) {
            System.out.println("\nselected groupNum " + n);
        }
        if (n <= 0) {
            return false;
        }
        if (connection.getAddressGroup() == n) {
            connection.setAddressChange(false);
        } else {
            connection.setAddressGroup(n);
            connection.setAddressChange(true);
        }
        this.verifyAddressIndex(connection, this.table[n]);
        return true;
    }

    public boolean reconfigTagGroup(TagConnection tagConnection, int n, Vector vector) {
        Object object;
        Group group = this.getGroup(n);
        if (this.debug) {
            System.out.println(" reconfigTagGroup for groupNum = " + n + "\n " + group);
        }
        GroupMember[] groupMemberArray = group.getMembers();
        this.findMemberAndRemove(groupMemberArray, tagConnection.getOutput().getLonDevice());
        TagPoint[] tagPointArray = tagConnection.getInputs();
        BIAddressEntry bIAddressEntry = tagConnection.getAddressEntry();
        int n2 = 0;
        while (n2 < tagPointArray.length) {
            object = tagPointArray[n2];
            BLonDevice bLonDevice = ((TagPoint)object).getLonDevice();
            GroupMember groupMember = this.findMemberAndRemove(groupMemberArray, bLonDevice);
            boolean bl = ((TagPoint)object).isMtag();
            if (bl && groupMember != null && ((TagPoint)object).getTagIndex() != groupMember.getAddressIndex()) {
                this.removeFromGroup(groupMember, group, vector);
                groupMember = null;
            }
            if (groupMember == null) {
                int n3 = ((TagPoint)object).getTagIndex();
                int n4 = this.connTable.getDeviceIndex(bLonDevice);
                if (n3 < 0) {
                    if (!(this.hasFreeAddressEntry(bLonDevice) || this.freeAddressEntry(n4, vector) || this.mergeGroups(n4, vector))) {
                        tagConnection.setStatus(BLonLinkStatus.dirtyGroup);
                        return false;
                    }
                    n3 = this.addAddressEntry(bLonDevice, bIAddressEntry);
                    ((TagPoint)object).setTagIndex(n3);
                }
                group.addMember(new GroupMember(n4, n3, bl));
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < groupMemberArray.length) {
            object = groupMemberArray[n2];
            if (object != null) {
                this.removeFromGroup((GroupMember)object, group, vector);
            }
            ++n2;
        }
        group.setStatus(1);
        return true;
    }

    private final void removeFromGroup(GroupMember groupMember, Group group, Vector vector) {
        int n = groupMember.getDeviceIndex();
        this.clearAddressEntry(this.lonDevices[n], groupMember.getAddressIndex(), vector);
        group.removeMember(n);
    }

    private final GroupMember findMemberAndRemove(GroupMember[] groupMemberArray, BLonDevice bLonDevice) {
        int n = this.findDeviceIndex(bLonDevice);
        int n2 = 0;
        while (n2 < groupMemberArray.length) {
            GroupMember groupMember = groupMemberArray[n2];
            if (groupMember != null && groupMember.getDeviceIndex() == n) {
                groupMemberArray[n2] = null;
                return groupMember;
            }
            ++n2;
        }
        return null;
    }

    public boolean selectTagGroup(TagConnection tagConnection, Vector vector) {
        int n;
        Object object;
        GroupBitSet groupBitSet;
        GroupBitSet groupBitSet2 = new GroupBitSet(this.lonDevices, tagConnection, false);
        int n2 = this.addGroup(groupBitSet2, BLonLinkType.reliable, 0);
        if (n2 <= 0 && (n2 = this.selectGroup(groupBitSet2, groupBitSet = GroupBitSet.getMirror(this.lonDevices.length, (GroupBitSet)(object = new GroupBitSet(this.lonDevices, tagConnection, true))), BLonLinkType.reliable, true, -1, vector)) > 0) {
            this.fixGroupForTagConn(tagConnection, n2, vector);
        }
        if (this.debug) {
            System.out.println("\nselected tag groupNum " + n2);
        }
        if (n2 <= 0) {
            return false;
        }
        object = this.table[n2];
        int n3 = ((Group)object).getSize();
        TagPoint tagPoint = tagConnection.getOutput();
        BLonDevice bLonDevice = tagPoint.getLonDevice();
        int n4 = ConnectionTable.getDeviceIndex(this.lonDevices, bLonDevice);
        this.table[n2].addMember(new GroupMember(n4, tagPoint.getTagIndex(), true));
        TagPoint[] tagPointArray = tagConnection.getInputs();
        int n5 = 0;
        while (n5 < tagPointArray.length) {
            n = tagPointArray[n5].getTagIndex();
            if (n >= 0) {
                int n6 = ConnectionTable.getDeviceIndex(this.lonDevices, tagPointArray[n5].getLonDevice());
                this.table[n2].addMember(new GroupMember(n6, n, true));
            }
            ++n5;
        }
        n5 = ((Group)object).getSize();
        n = NmUtil.linkTypeToDescriptor(((Group)object).getLinkType());
        BAddressEntry bAddressEntry = BAddressEntry.make(BAddressType.group, n5, n2, n3++, n, bLonDevice.getWorkingDomain(), this.lonworks.netmgmt().getLinkDescriptors().getDescriptor(n));
        this.addAddressEntry(bLonDevice, bAddressEntry, tagPoint.getTagIndex());
        int n7 = 0;
        while (n7 < tagPointArray.length) {
            int n8 = tagPointArray[n7].getTagIndex();
            if (n8 >= 0) {
                BLonDevice bLonDevice2 = tagPointArray[n7].getLonDevice();
                bAddressEntry = BAddressEntry.make(BAddressType.group, n5, n2, n3++, n, bLonDevice2.getWorkingDomain(), this.lonworks.netmgmt().getLinkDescriptors().getDescriptor(n));
                this.addAddressEntry(bLonDevice2, bAddressEntry, n8);
            }
            ++n7;
        }
        if (tagConnection.getAddressGroup() == n2) {
            tagConnection.setAddressChange(false);
        } else {
            tagConnection.setAddressGroup(n2);
            tagConnection.setAddressChange(true);
            this.updateAddressIndex(tagConnection, this.table[n2]);
        }
        return true;
    }

    private final void fixGroupForTagConn(TagConnection tagConnection, int n, Vector vector) {
        Group group = this.getGroup(n);
        this.fixMTagPoint(tagConnection.getOutput(), group, vector);
        TagPoint[] tagPointArray = tagConnection.getInputs();
        int n2 = 0;
        while (n2 < tagPointArray.length) {
            TagPoint tagPoint = tagPointArray[n2];
            if (tagPoint.isMtag()) {
                this.fixMTagPoint(tagPoint, group, vector);
            }
            ++n2;
        }
    }

    private final void fixMTagPoint(TagPoint tagPoint, Group group, Vector vector) {
        int n = this.findDeviceIndex(tagPoint.getLonDevice());
        GroupMember groupMember = group.findMember(n);
        if (groupMember == null) {
            return;
        }
        if (tagPoint.getTagIndex() != groupMember.getAddressIndex()) {
            this.clearAddressEntry(tagPoint.getLonDevice(), groupMember.getAddressIndex(), vector);
            group.removeMember(n);
            group.addMember(new GroupMember(n, tagPoint.getTagIndex(), true));
        }
    }

    public boolean moveTagPoint(TagPoint tagPoint, int n, Vector vector) {
        Group group = this.getGroup(n);
        if (group == null) {
            return false;
        }
        BLonDevice bLonDevice = tagPoint.getLonDevice();
        int n2 = this.findDeviceIndex(bLonDevice);
        if (!this.hasFreeAddressEntry(bLonDevice) && !this.freeAddressEntry(n2, false, vector)) {
            return false;
        }
        BIAddressEntry bIAddressEntry = bLonDevice.getDeviceData().getAddressEntry(tagPoint.getTagIndex());
        this.clearAddressEntry(tagPoint.getLonDevice(), tagPoint.getTagIndex(), vector);
        group.removeMember(n2);
        BAddressEntry bAddressEntry = BAddressEntry.make(bIAddressEntry);
        int n3 = this.addAddressEntry(bLonDevice, bAddressEntry);
        group.addMember(new GroupMember(n2, n3, false));
        return true;
    }

    public void processGroups(Vector vector) {
        int n = 1;
        while (n < 256) {
            Group group = this.table[n];
            if (group != null) {
                if (this.connTable.groupUse(n) == 0) {
                    this.removeGroup(n, vector);
                } else if (group.getStatus() != 2) {
                    if (this.debug) {
                        System.out.println("\nUpdate group " + group.getGroupNum() + ' ' + group);
                    }
                    group.updateGroup(this.lonDevices, vector, this.bindJob);
                }
            }
            ++n;
        }
    }

    public void updateGroupRouteFlags(RouterManager routerManager) {
        routerManager.initGroupRouteUpdate();
        int[] nArray = new int[this.lonDevices.length];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = this.lonDevices[n] != null ? this.lonDevices[n].getDeviceData().getChannelId() : -1;
            ++n;
        }
        n = 1;
        while (n < 256) {
            BitSet bitSet = new BitSet(routerManager.getAddressManager().getMaxChannelId() + 1);
            Group group = this.table[n];
            if (group != null) {
                GroupBitSet groupBitSet = group.getBitSet();
                int n2 = 0;
                while (n2 < groupBitSet.size()) {
                    if (groupBitSet.get(n2)) {
                        bitSet.set(nArray[n2]);
                    }
                    ++n2;
                }
                routerManager.setGroupRouteFlags(n, bitSet);
            }
            ++n;
        }
        routerManager.updateGroupRouteFlags();
    }

    /*
     * Unable to fully structure code
     */
    private final int selectGroup(GroupBitSet var1_1, GroupBitSet var2_2, BLonLinkType var3_3, boolean var4_4, int var5_5, Vector var6_6) {
        var9_7 = -1;
        var10_8 = this.lonDevices.length;
        var12_9 = null;
        if (this.debug) {
            System.out.println(" in selectGroup :  eLinkType = " + (Object)var3_3 + "\n    include: " + var1_1 + (var2_2 != null ? "\n    exclude: " + var2_2 : ""));
        }
        var7_10 = 1;
        while (var7_10 < 256) {
            var8_11 = this.table[var7_10];
            if (var8_11 != null) {
                if (var4_4) {
                    if (var8_11.getBitSet().contains(var1_1, var2_2) && !var8_11.hasMessageTag()) {
                        return var7_10;
                    }
                } else if (var8_11.getLinkType() == var3_3 && var8_11.getBitSet().contains(var1_1, var2_2) && (var9_7 < 0 || var8_11.getSize() < var10_8)) {
                    var9_7 = var7_10;
                    var10_8 = var8_11.getSize();
                }
            }
            ++var7_10;
        }
        if (var9_7 != -1) {
            return var9_7;
        }
        if (var5_5 == -1 || this.table[var5_5] == null || this.table[var5_5].getLinkType() != var3_3 || this.table[var5_5].hasMessageTag()) ** GOTO lbl42
        var13_12 = this.connTable.getExcludesForGroup(var5_5);
        var14_14 = this.missingMembers(var5_5, var1_1);
        if (this.debug) {
            System.out.println("attempt expand: new members= " + var14_14 + " grpExcludes= " + var13_12);
        }
        if (!var1_1.excludes(var13_12)) ** GOTO lbl42
        var15_16 = 0;
        while (var15_16 == 0 && (var11_17 = this.verifyEntries(var14_14)) >= 0) {
            if (this.freeAddressEntry(var11_17, var6_6)) continue;
            var15_16 = 1;
        }
        if (var15_16 != 0) ** GOTO lbl42
        if (this.debug) {
            System.out.println("Expand original group " + var5_5);
        }
        this.expandGroup(var5_5, var14_14);
        return var5_5;
lbl-1000:
        // 1 sources

        {
            if (this.freeAddressEntry(var11_17, var6_6)) continue;
            if (var12_9 == null) {
                var12_9 = new GroupBitSet(this.lonDevices.length);
            }
            var12_9.set(var11_17);
            var1_1.clear(var11_17);
lbl42:
            // 5 sources

            ** while ((var11_17 = this.verifyEntries((GroupBitSet)var1_1)) >= 0)
        }
lbl43:
        // 1 sources

        if (var12_9 == null) {
            return this.addGroup(var1_1, var3_3, var1_1.getGroupSize());
        }
        var9_7 = -1;
        var10_8 = this.lonDevices.length;
        var7_10 = 1;
        while (var7_10 < 256) {
            var8_11 = this.table[var7_10];
            if (var8_11 != null && !var8_11.hasMessageTag() && var8_11.getLinkType() == var3_3 && var8_11.getBitSet().contains(var12_9, var2_2) && var1_1.excludes(this.connTable.getExcludesForGroup(var7_10)) && (var9_7 < 0 || var8_11.getSize() < var10_8)) {
                var9_7 = var7_10;
                var10_8 = var8_11.getSize();
            }
            ++var7_10;
        }
        if (var9_7 > 0) {
            if (this.debug) {
                System.out.println("Expand group " + var9_7 + " to include " + var12_9);
            }
            this.expandGroup(var9_7, this.missingMembers(var9_7, var1_1));
            return var9_7;
        }
        var13_13 = false;
        var14_15 = this.lonDevices.length;
        var15_16 = 0;
        while (var15_16 < var14_15) {
            if (var12_9.get(var15_16)) {
                if (this.mergeGroups(var15_16, var6_6)) {
                    var12_9.clear(var15_16);
                    var1_1.set(var15_16);
                } else {
                    var13_13 = true;
                    break;
                }
            }
            ++var15_16;
        }
        if (!var13_13) {
            return this.addGroup(var1_1, var3_3, var1_1.getGroupSize());
        }
        return -1;
    }

    private final boolean freeAddressEntry(int n, Vector vector) {
        return this.freeAddressEntry(n, false, vector);
    }

    private final boolean freeAddressEntry(int n, boolean bl, Vector vector) {
        int n2;
        BLonDevice bLonDevice = this.lonDevices[n];
        BDeviceData bDeviceData = bLonDevice.getDeviceData();
        int n3 = bDeviceData.getAddressCount();
        UseCnt[] useCntArray = this.connTable.addressEntryUsage(bLonDevice);
        if (this.debug && useCntArray.length > 0) {
            System.out.print("\nin freeAddressEntry for " + bLonDevice.getDisplayName(null) + " - useCnt {" + useCntArray[0].cnt);
            n2 = 1;
            while (n2 < useCntArray.length) {
                System.out.print("," + (useCntArray[n2].mtag ? "m" : Integer.toString(useCntArray[n2].cnt)));
                ++n2;
            }
            System.out.println("}");
            n2 = 0;
            while (n2 < useCntArray.length) {
                if (useCntArray[n2].include != null) {
                    System.out.println("  include " + n2 + " :" + useCntArray[n2].include);
                }
                if (useCntArray[n2].exclude != null) {
                    System.out.println("  exclude " + n2 + " :" + useCntArray[n2].exclude);
                }
                ++n2;
            }
        }
        int n4 = n2 = bDeviceData.getMsgTagCount();
        while (n4 < n3) {
            if (useCntArray[n4].cnt == 0) {
                BIAddressEntry bIAddressEntry = bDeviceData.getAddressEntry(n4);
                switch (bIAddressEntry.getAddressType().getOrdinal()) {
                    case 0: {
                        return true;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        if (this.debug) {
                            System.out.println("\nfound unused address entry " + bIAddressEntry);
                        }
                        bDeviceData.setAddressEntry(n4, BAddressEntry.DEFAULT);
                        return true;
                    }
                    case 1: {
                        if (this.debug) {
                            System.out.println("\nfound unused group " + bIAddressEntry);
                        }
                        Group group = this.table[bIAddressEntry.getGroupOrSubnet()];
                        group.removeMember(n);
                        bDeviceData.setAddressEntry(n4, BAddressEntry.DEFAULT);
                        return true;
                    }
                }
            }
            ++n4;
        }
        if (bl) {
            return false;
        }
        n4 = 1;
        while (n4 <= 2) {
            if (this.mergeNodeInGroup(BLonLinkType.make(n4), bLonDevice, useCntArray)) {
                if (this.debug) {
                    System.out.println("\nfound s/n which can be merged into group.");
                }
                return true;
            }
            ++n4;
        }
        n4 = 1;
        while (n4 <= 2) {
            if (this.mergeNodesToGroup(BLonLinkType.make(n4), bLonDevice, useCntArray, vector)) {
                return true;
            }
            ++n4;
        }
        if (this.mergeGroups(n, vector)) {
            return true;
        }
        if (this.debug) {
            System.out.println("freeAddress failed");
        }
        return false;
    }

    private final boolean mergeGroups(int n, Vector vector) {
        BLonDevice bLonDevice = this.lonDevices[n];
        UseCnt[] useCntArray = this.connTable.addressEntryUsage(bLonDevice);
        BDeviceData bDeviceData = bLonDevice.getDeviceData();
        int[] nArray = this.getGroupSizeOrder(bDeviceData);
        int n2 = 1;
        while (n2 <= 2) {
            Object object;
            int n3;
            Object object2;
            int n4 = -1;
            int n5 = -1;
            boolean bl = false;
            int n6 = 0;
            while (n6 < nArray.length) {
                int n7 = nArray[n6];
                object2 = bDeviceData.getAddressEntry(n7);
                if (object2.getDescriptor() == n2) {
                    n3 = n6 + 1;
                    while (n3 < nArray.length) {
                        int n8 = nArray[n3];
                        object = bDeviceData.getAddressEntry(n8);
                        if (object.getDescriptor() == n2) {
                            Group group = this.table[object2.getGroupOrSubnet()];
                            Group group2 = this.table[object.getGroupOrSubnet()];
                            if (group.getBitSet().excludes(useCntArray[n8].exclude) && group2.getBitSet().excludes(useCntArray[n7].exclude) && !group.hasMessageTag() && !group2.hasMessageTag()) {
                                bl = true;
                                n4 = n7;
                                n5 = n8;
                                break;
                            }
                        }
                        ++n3;
                    }
                    if (bl) break;
                }
                ++n6;
            }
            if (bl && n4 != -1 && n5 != -1) {
                n6 = bDeviceData.getAddressEntry(n4).getGroupOrSubnet();
                Group group = this.table[n6];
                object2 = group.getBitSet();
                n3 = bDeviceData.getAddressEntry(n5).getGroupOrSubnet();
                Group group3 = this.table[n3];
                object = group3.getBitSet();
                int n9 = this.lonDevices.length;
                if (this.debug) {
                    System.out.println("\nattempt to merge groups " + n6 + " & " + n3);
                }
                if (this.debug) {
                    System.out.println("in " + bLonDevice.getDisplayName(null) + " entry " + n4 + ' ' + n5 + '\n');
                }
                int n10 = 0;
                while (n10 < n9) {
                    if (((GroupBitSet)object2).get(n10)) {
                        int n11;
                        int n12;
                        BLonDevice bLonDevice2 = this.lonDevices[n10];
                        if (((GroupBitSet)object).get(n10)) {
                            n12 = this.findGroupAddressEntry(bLonDevice2, n6);
                            n11 = this.findGroupAddressEntry(bLonDevice2, n3);
                            bLonDevice2.getDeviceData().setAddressEntry(n12, BAddressEntry.DEFAULT);
                            if (this.debug) {
                                System.out.println("\n" + bLonDevice2.getDisplayName(null) + " is member of both groups. Remove entry " + n12);
                            }
                            this.clearAddressEntry(bLonDevice2, n12, vector);
                        } else {
                            n11 = n12 = this.changeGroupAddressEntry(bLonDevice2, n6, n3);
                            group3.addMember(new GroupMember(n10, n11));
                            if (this.debug) {
                                System.out.println("\n" + bLonDevice2.getDisplayName(null) + " is only a member of group " + n6 + ". Changed group of entry " + n12);
                            }
                        }
                        this.connTable.changeEntry(bLonDevice2, n11, n12, n3);
                    }
                    ++n10;
                }
                if (group3.getStatus() == 2) {
                    group3.setStatus(1);
                }
                this.table[n6] = null;
                return true;
            }
            ++n2;
        }
        if (this.debug) {
            System.out.println("unable to find groups to merge in " + bLonDevice.getDisplayName(null));
        }
        return false;
    }

    private final int findGroupAddressEntry(BLonDevice bLonDevice, int n) {
        BDeviceData bDeviceData = bLonDevice.getDeviceData();
        int n2 = bDeviceData.getAddressCount();
        int n3 = 0;
        while (n3 < n2) {
            BIAddressEntry bIAddressEntry = bDeviceData.getAddressEntry(n3);
            if (bIAddressEntry.isGroupAddress() && bIAddressEntry.getGroupOrSubnet() == n) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    private final int changeGroupAddressEntry(BLonDevice bLonDevice, int n, int n2) {
        BDeviceData bDeviceData = bLonDevice.getDeviceData();
        int n3 = bDeviceData.getAddressCount();
        int n4 = 0;
        while (n4 < n3) {
            BIAddressEntry bIAddressEntry = bDeviceData.getAddressEntry(n4);
            if (bIAddressEntry.isGroupAddress() && bIAddressEntry.getGroupOrSubnet() == n) {
                BAddressEntry bAddressEntry = BAddressEntry.make(BAddressType.group, bIAddressEntry.getSize(), n2, 0, 0, bDeviceData.getWorkingDomain(), new BLinkDescriptor());
                bDeviceData.setAddressEntry(n4, bAddressEntry);
                return n4;
            }
            ++n4;
        }
        return -1;
    }

    private final boolean mergeNodesToGroup(BLonLinkType bLonLinkType, BLonDevice bLonDevice, UseCnt[] useCntArray, Vector vector) {
        Object object;
        BDeviceData bDeviceData = bLonDevice.getDeviceData();
        int n = bDeviceData.getAddressCount();
        int n2 = -1;
        int n3 = 0;
        int n4 = MAX_USE;
        int n5 = -1;
        int n6 = 0;
        int n7 = MAX_USE;
        int n8 = bDeviceData.getMsgTagCount();
        while (n8 < n) {
            BIAddressEntry bIAddressEntry = bDeviceData.getAddressEntry(n8);
            if (NmUtil.getLinkType(bIAddressEntry.getDescriptor()) == bLonLinkType && bIAddressEntry.isSubnetNodeAddress()) {
                object = BSubnetNode.make(bIAddressEntry.getGroupOrSubnet(), bIAddressEntry.getMemberOrNode());
                BLonDevice bLonDevice2 = this.lonworks.addressManager().getDeviceByAddress((BSubnetNode)object);
                if (this.hasFreeAddressEntry(bLonDevice2)) {
                    int n9 = this.findDeviceIndex(bLonDevice2);
                    if (n7 < n4) {
                        if (useCntArray[n8].cnt < n4) {
                            n3 = n9;
                            n2 = n8;
                            n4 = useCntArray[n8].cnt;
                        }
                    } else if (useCntArray[n8].cnt < n7) {
                        n6 = n9;
                        n7 = useCntArray[n8].cnt;
                        n5 = n8;
                    }
                }
            }
            ++n8;
        }
        if (n2 != -1 && n5 != -1) {
            BLonDevice[] bLonDeviceArray = new BLonDevice[]{bLonDevice};
            object = new GroupBitSet(this.lonDevices, bLonDeviceArray);
            bDeviceData.setAddressEntry(n2, BAddressEntry.DEFAULT);
            ((GroupBitSet)object).set(n3);
            ((GroupBitSet)object).set(n6);
            int n10 = this.addGroup((GroupBitSet)object, bLonLinkType, ((GroupBitSet)object).getGroupSize());
            if (n10 <= 0) {
                return false;
            }
            this.connTable.changeEntry(bLonDevice, n2, n5, n10);
            bDeviceData.setAddressEntry(n5, BAddressEntry.DEFAULT);
            if (this.debug) {
                System.out.println("\nmerge sn entries " + n2 + " and " + n5 + " into groupnum " + n10);
            }
            return true;
        }
        return false;
    }

    private final boolean mergeNodeInGroup(BLonLinkType bLonLinkType, BLonDevice bLonDevice, UseCnt[] useCntArray) {
        Object object;
        BDeviceData bDeviceData = bLonDevice.getDeviceData();
        int n = -1;
        int n2 = -1;
        int n3 = 0;
        int[] nArray = this.getUseOrder(useCntArray, bDeviceData.getMsgTagCount());
        int n4 = 0;
        while (n4 < nArray.length) {
            BIAddressEntry bIAddressEntry = bDeviceData.getAddressEntry(nArray[n4]);
            if (NmUtil.getLinkType(bIAddressEntry.getDescriptor()) == bLonLinkType && bIAddressEntry.isSubnetNodeAddress()) {
                object = BSubnetNode.make(bIAddressEntry.getGroupOrSubnet(), bIAddressEntry.getMemberOrNode());
                BLonDevice bLonDevice2 = this.lonworks.addressManager().getDeviceByAddress((BSubnetNode)object);
                int n5 = this.findDeviceIndex(bLonDevice2);
                int n6 = MAX_SIZE;
                n2 = -1;
                boolean bl = false;
                int n7 = 0;
                while (n7 < nArray.length) {
                    int n8 = nArray[n7];
                    BIAddressEntry bIAddressEntry2 = bDeviceData.getAddressEntry(n8);
                    if (!useCntArray[n8].mtag && NmUtil.getLinkType(bIAddressEntry2.getDescriptor()) == bLonLinkType && bIAddressEntry2.isGroupAddress() && !useCntArray[n8].excludes(n5)) {
                        Group group = this.table[bIAddressEntry2.getGroupOrSubnet()];
                        if (group.isMember(n5)) {
                            n2 = n8;
                            bl = true;
                            break;
                        }
                        if (group.getSize() < n6) {
                            n6 = group.getSize();
                            n2 = n8;
                        }
                    }
                    ++n7;
                }
                if (n2 != -1 && (bl || this.hasFreeAddressEntry(this.lonDevices[n5]))) {
                    n = nArray[n4];
                    n3 = n5;
                    break;
                }
            }
            ++n4;
        }
        if (n != -1 && n2 != -1) {
            BIAddressEntry bIAddressEntry = bDeviceData.getAddressEntry(n2);
            int n9 = bIAddressEntry.getGroupOrSubnet();
            object = this.table[n9];
            if (this.debug) {
                System.out.print("\nmerge sn entry " + n + " with grp entry " + n2);
            }
            if (this.debug) {
                System.out.println("  device " + this.lonDevices[n3].getDisplayName(null) + " group# " + n9);
            }
            if (!((Group)object).isMember(n3)) {
                int n10 = this.addAddressEntry(this.lonDevices[n3], bIAddressEntry);
                ((Group)object).addMember(new GroupMember(n3, n10));
                if (((Group)object).getStatus() == 2) {
                    ((Group)object).setStatus(1);
                }
            }
            this.connTable.changeEntry(bLonDevice, n2, n, n9);
            bDeviceData.setAddressEntry(n, BAddressEntry.DEFAULT);
            return true;
        }
        return false;
    }

    private final GroupBitSet missingMembers(int n, GroupBitSet groupBitSet) {
        GroupBitSet groupBitSet2 = new GroupBitSet(groupBitSet);
        groupBitSet2.and(this.table[n].getBitSet());
        groupBitSet2.xor(groupBitSet);
        return groupBitSet2;
    }

    private final void expandGroup(int n, GroupBitSet groupBitSet) {
        Group group = this.table[n];
        GroupBitSet groupBitSet2 = group.getBitSet();
        int n2 = group.getSize();
        int n3 = n2 + groupBitSet.getGroupSize();
        int n4 = 0;
        while (n4 < this.lonDevices.length) {
            if (groupBitSet.get(n4) && !groupBitSet2.get(n4)) {
                BLonDevice bLonDevice = this.lonDevices[n4];
                int n5 = NmUtil.linkTypeToDescriptor(group.getLinkType());
                int n6 = this.addAddressEntry(bLonDevice, BAddressEntry.make(BAddressType.group, n3, n, n2++, n5, bLonDevice.getWorkingDomain(), this.lonworks.netmgmt().getLinkDescriptors().getDescriptor(n5)));
                group.addMember(new GroupMember(n4, n6));
            }
            ++n4;
        }
        if (group.getStatus() == 2) {
            group.setStatus(1);
        }
        if (this.debug) {
            System.out.println("\nmerged devices " + groupBitSet + " with existing group. Results =>" + group);
        }
    }

    private final int verifyEntries(GroupBitSet groupBitSet) {
        int n = groupBitSet.size();
        int n2 = 0;
        while (n2 < n) {
            if (groupBitSet.get(n2) && !this.hasFreeAddressEntry(this.lonDevices[n2])) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private final int addGroup(GroupBitSet groupBitSet, BLonLinkType bLonLinkType, int n) {
        int n2 = 0;
        int n3 = groupBitSet.size();
        int n4 = 0;
        while (n4 < n3) {
            if (groupBitSet.get(n4) && !this.hasFreeAddressEntry(this.lonDevices[n4])) {
                if (this.debug) {
                    System.out.println("\nNo free addressEntry for " + this.lonDevices[n4].getDisplayName(null));
                }
                return -1;
            }
            ++n4;
        }
        int n5 = 1;
        while (n5 < 256) {
            if (this.table[n5] == null) break;
            ++n5;
        }
        if (n5 >= 256) {
            return -1;
        }
        Group group = new Group(n5, this.lonDevices.length, bLonLinkType, 0);
        n4 = 0;
        while (n4 < n3) {
            if (groupBitSet.get(n4)) {
                BLonDevice bLonDevice = this.lonDevices[n4];
                int n6 = NmUtil.linkTypeToDescriptor(bLonLinkType);
                BAddressEntry bAddressEntry = BAddressEntry.make(BAddressType.group, n, n5, n2++, n6, bLonDevice.getWorkingDomain(), this.lonworks.netmgmt().getLinkDescriptors().getDescriptor(n6));
                int n7 = this.addAddressEntry(bLonDevice, bAddressEntry);
                group.addMember(new GroupMember(n4, n7));
            }
            ++n4;
        }
        this.table[n5] = group;
        if (this.debug) {
            System.out.println("\nadded group" + this.table[n5]);
        }
        return n5;
    }

    private final void removeGroup(int n, Vector vector) {
        Group group = this.table[n];
        GroupMember[] groupMemberArray = group.getMembers();
        int n2 = groupMemberArray.length;
        if (this.debug) {
            System.out.println("\nRemove group " + n);
        }
        int n3 = 0;
        while (n3 < n2) {
            GroupMember groupMember = groupMemberArray[n3];
            BLonDevice bLonDevice = this.lonDevices[groupMember.getDeviceIndex()];
            int n4 = groupMember.getAddressIndex();
            this.clearAddressEntry(bLonDevice, n4, vector);
            ++n3;
        }
        this.table[n] = null;
    }

    public void clearAddressEntry(BLonDevice bLonDevice, int n, Vector vector) {
        bLonDevice.getDeviceData().setAddressEntry(n, BAddressEntry.DEFAULT);
        try {
            if (Lon.n()) {
                NmUtil.setOfflineInBind(bLonDevice, vector);
                NmUtil.updateAddressTable(bLonDevice, n);
                if (!NmUtil.verifyAddressEntry(bLonDevice, n)) {
                    this.bindJob.error("ERROR: unable to verify address entry " + n + " in " + bLonDevice.getDisplayName(null), null);
                }
            }
        }
        catch (Throwable throwable) {
            this.bindJob.error("ERROR: in GroupTable.removeGroup() - comm failure to " + bLonDevice.getDisplayName(null), throwable);
        }
    }

    private final int addAddressEntry(BLonDevice bLonDevice, BIAddressEntry bIAddressEntry) {
        return this.addAddressEntry(bLonDevice, bIAddressEntry, -1);
    }

    private final int addAddressEntry(BLonDevice bLonDevice, BIAddressEntry bIAddressEntry, int n) {
        BDeviceData bDeviceData = bLonDevice.getDeviceData();
        int n2 = bDeviceData.getAddressCount();
        if (n != -1) {
            bDeviceData.setAddressEntry(n, bIAddressEntry);
            return n;
        }
        int n3 = bDeviceData.getMsgTagCount();
        while (n3 < n2) {
            if (bDeviceData.getAddressEntry(n3).getAddressType() == BAddressType.none) {
                bDeviceData.setAddressEntry(n3, bIAddressEntry);
                if (this.debug) {
                    System.out.println("\naddAddressEntry in " + bLonDevice.getDisplayName(null) + " at index " + n3 + '\n' + bIAddressEntry);
                }
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    private final int findAddressEntry(BLonDevice bLonDevice, BIAddressEntry bIAddressEntry) {
        BDeviceData bDeviceData = bLonDevice.getDeviceData();
        int n = bDeviceData.getAddressCount();
        int n2 = 0;
        while (n2 < n) {
            if (bDeviceData.getAddressEntry(n2).isSameAddress(bIAddressEntry)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private final boolean hasFreeAddressEntry(BLonDevice bLonDevice) {
        BDeviceData bDeviceData = bLonDevice.getDeviceData();
        int n = bDeviceData.getAddressCount();
        int n2 = bDeviceData.getMsgTagCount();
        while (n2 < n) {
            BIAddressEntry bIAddressEntry = bDeviceData.getAddressEntry(n2);
            if (bIAddressEntry.getAddressType() == BAddressType.none) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public int findDeviceIndex(BLonDevice bLonDevice) {
        int n = 0;
        while (n < this.lonDevices.length) {
            if (this.lonDevices[n] == bLonDevice) {
                return n;
            }
            ++n;
        }
        throw new BajaRuntimeException("INTERNAL ERROR: Could not find lonDevice " + bLonDevice.getDisplayName(null) + " in list.");
    }

    public BLonDevice[] getDevicesForGroup(int n) {
        Group group = this.getGroup(n);
        if (group == null) {
            return null;
        }
        return group.getMemberDevices(this.lonDevices);
    }

    private final void verifyAddressIndex(Connection connection, Group group) {
        LonPoint lonPoint = connection.getHub();
        if (lonPoint.requiresAddressEntry()) {
            this.verifyAddressIndex(lonPoint, group);
        }
        LonPoint[] lonPointArray = connection.getTargets();
        int n = 0;
        while (n < lonPointArray.length) {
            lonPoint = lonPointArray[n];
            if (lonPoint.requiresAddressEntry()) {
                this.verifyAddressIndex(lonPoint, group);
            }
            ++n;
        }
    }

    private final void verifyAddressIndex(LonPoint lonPoint, Group group) {
        GroupMember groupMember = group.findMember(this.findDeviceIndex(lonPoint.getLonDevice()));
        if (groupMember == null) {
            lonPoint.setStatus(BLonLinkStatus.error);
            return;
        }
        int n = groupMember.getAddressIndex();
        if (n == lonPoint.getAddressIndex()) {
            return;
        }
        lonPoint.setAddressIndex(n);
        if (this.debug) {
            System.out.println(" change address index in " + lonPoint);
        }
        if (lonPoint.isBound()) {
            lonPoint.setStatus(BLonLinkStatus.newLink);
        }
    }

    public void updateAddressIndex(TagConnection tagConnection, Group group) {
        TagPoint[] tagPointArray = tagConnection.getInputs();
        int n = 0;
        while (n < tagPointArray.length) {
            TagPoint tagPoint = tagPointArray[n];
            GroupMember groupMember = group.findMember(this.findDeviceIndex(tagPoint.getLonDevice()));
            if (groupMember == null) {
                tagPoint.setStatus(BLonLinkStatus.error);
            } else {
                tagPoint.setTagIndex(groupMember.getAddressIndex());
                if (this.debug & (tagPoint.isNew() ^ true)) {
                    System.out.println(" change address index in " + tagPoint);
                }
                if (tagPoint.isBound()) {
                    tagPoint.setStatus(BLonLinkStatus.newLink);
                }
            }
            ++n;
        }
    }

    private final int[] getUseOrder(UseCnt[] useCntArray, int n) {
        int n2 = useCntArray.length - n;
        int[] nArray = new int[n2];
        int n3 = 0;
        while (n3 < n2) {
            nArray[n3] = n3;
            ++n3;
        }
        n3 = 0;
        while (n3 < n2 - 1) {
            if (useCntArray[nArray[n3]].cnt > useCntArray[nArray[n3 + 1]].cnt) {
                int n4 = nArray[n3];
                nArray[n3] = nArray[n3 + 1];
                nArray[n3 + 1] = n4;
                int n5 = 1;
                if (n3 != 0) {
                    n5 = n3 - 1;
                }
                n3 = n5;
                continue;
            }
            ++n3;
        }
        return nArray;
    }

    private final int[] getGroupSizeOrder(BDeviceData bDeviceData) {
        int n = bDeviceData.getMsgTagCount();
        int n2 = 0;
        int n3 = n;
        while (n3 < bDeviceData.getAddressCount()) {
            if (bDeviceData.getAddressEntry(n3).isGroupAddress()) {
                ++n2;
            }
            ++n3;
        }
        int[] nArray = new int[n2];
        n2 = 0;
        int n4 = n;
        while (n4 < bDeviceData.getAddressCount()) {
            if (bDeviceData.getAddressEntry(n4).isGroupAddress()) {
                nArray[n2++] = n4;
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < n2 - 1) {
            if (this.table[bDeviceData.getAddressEntry(nArray[n4]).getGroupOrSubnet()].getSize() > this.table[bDeviceData.getAddressEntry(nArray[n4 + 1]).getGroupOrSubnet()].getSize()) {
                int n5 = nArray[n4];
                nArray[n4] = nArray[n4 + 1];
                nArray[n4 + 1] = n5;
                int n6 = 1;
                if (n4 != 0) {
                    n6 = n4 - 1;
                }
                n4 = n6;
                continue;
            }
            ++n4;
        }
        return nArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nGroup Table\n===================================\n");
        int n = 0;
        while (n < this.table.length) {
            if (this.table[n] != null) {
                stringBuffer.append(this.table[n]);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public Group[] getGroupArray() {
        return this.table;
    }

    private final /* synthetic */ void this() {
        this.table = new Group[256];
    }

    public GroupTable(BLonNetwork bLonNetwork, BLonDevice[] bLonDeviceArray, boolean bl) {
        this(bLonNetwork, bLonDeviceArray, null, bl);
    }

    public GroupTable(BLonNetwork bLonNetwork, BLonDevice[] bLonDeviceArray, ConnectionTable connectionTable, boolean bl) {
        Object object;
        this.this();
        int n = bLonDeviceArray.length;
        this.lonDevices = bLonDeviceArray;
        this.connTable = connectionTable;
        this.lonworks = bLonNetwork;
        this.debug = bl;
        int n2 = 0;
        while (n2 < n) {
            BLonDevice bLonDevice = bLonDeviceArray[n2];
            if (bLonDevice != null) {
                object = bLonDevice.getDeviceData();
                int n3 = ((BDeviceData)((Object)object)).getMsgTagCount();
                int n4 = 0;
                while (n4 < ((BDeviceData)((Object)object)).getAddressCount()) {
                    BIAddressEntry bIAddressEntry = ((BDeviceData)((Object)object)).getAddressEntry(n4);
                    if (bIAddressEntry.isGroupAddress()) {
                        Group group = this.table[bIAddressEntry.getGroupOrSubnet()];
                        if (group == null) {
                            this.table[bIAddressEntry.getGroupOrSubnet()] = group = new Group(bIAddressEntry.getGroupOrSubnet(), bLonDeviceArray.length, NmUtil.getLinkType(bIAddressEntry.getDescriptor()), 2, bIAddressEntry.getSize());
                        }
                        if (group.getExpectedSize() != bIAddressEntry.getSize()) {
                            group.setStatus(1);
                        }
                        boolean bl2 = false;
                        if (n4 < n3) {
                            bl2 = true;
                        }
                        group.addMember(new GroupMember(n2, n4, bl2));
                        if (bIAddressEntry.getDomain() != ((BDeviceData)((Object)object)).getWorkingDomain()) {
                            group.setStatus(1);
                        }
                        if (group.getLinkType() == BLonLinkType.unknown && NmUtil.getLinkType(bIAddressEntry.getDescriptor()) != BLonLinkType.unknown) {
                            group.setLinkType(NmUtil.getLinkType(bIAddressEntry.getDescriptor()));
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        int n5 = 1;
        while (n5 < 256) {
            object = this.table[n5];
            if (object != null && ((Group)object).getExpectedSize() != ((Group)object).getSize() && ((Group)object).getLinkType() != BLonLinkType.standard) {
                ((Group)object).setStatus(1);
            }
            ++n5;
        }
        if (bl) {
            System.out.print("\nlonDevices = {" + bLonDeviceArray[0].getDisplayName(null));
            n5 = 1;
            while (n5 < bLonDeviceArray.length) {
                System.out.print("," + bLonDeviceArray[n5].getDisplayName(null));
                ++n5;
            }
            System.out.println("}");
            System.out.println(this.toString());
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class UseCnt {
        boolean mtag;
        int cnt;
        GroupBitSet exclude;
        GroupBitSet include;

        boolean excludes(int n) {
            if (this.exclude == null) {
                return false;
            }
            return this.exclude.get(n);
        }

        private final /* synthetic */ void this() {
            this.mtag = false;
            this.cnt = 0;
            this.exclude = null;
            this.include = null;
        }

        public UseCnt() {
            this.this();
        }
    }
}

