/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.netmgmt;

import com.tridium.lonworks.datatypes.BLinkEntry;
import com.tridium.lonworks.datatypes.BLinkEntryTable;
import com.tridium.lonworks.datatypes.BTagLinkEntry;
import com.tridium.lonworks.datatypes.BTagLinkEntryTable;
import com.tridium.lonworks.enums.BLonLinkStatus;
import com.tridium.lonworks.local.BPseudoNV;
import com.tridium.lonworks.netmgmt.Connection;
import com.tridium.lonworks.netmgmt.Group;
import com.tridium.lonworks.netmgmt.GroupBitSet;
import com.tridium.lonworks.netmgmt.GroupMember;
import com.tridium.lonworks.netmgmt.GroupTable;
import com.tridium.lonworks.netmgmt.LonPoint;
import com.tridium.lonworks.netmgmt.LonPointAlias;
import com.tridium.lonworks.netmgmt.LonPointProxy;
import com.tridium.lonworks.netmgmt.LonPointPseudo;
import com.tridium.lonworks.netmgmt.LonPointRemote;
import com.tridium.lonworks.netmgmt.NetMgmtConst;
import com.tridium.lonworks.netmgmt.TagConnection;
import com.tridium.lonworks.netmgmt.TagPoint;
import com.tridium.lonworks.util.NmUtil;
import java.util.Vector;
import javax.baja.control.BControlPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.lonworks.AddressManager;
import javax.baja.lonworks.BINetworkVariable;
import javax.baja.lonworks.BINvContainer;
import javax.baja.lonworks.BLocalLonDevice;
import javax.baja.lonworks.BLonComponent;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BLonLink;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.BMessageTag;
import javax.baja.lonworks.BNetworkVariable;
import javax.baja.lonworks.datatypes.BAliasConfigData;
import javax.baja.lonworks.datatypes.BAliasTable;
import javax.baja.lonworks.datatypes.BDeviceData;
import javax.baja.lonworks.datatypes.BIAddressEntry;
import javax.baja.lonworks.datatypes.BNvConfigData;
import javax.baja.lonworks.datatypes.BNvProps;
import javax.baja.lonworks.datatypes.BSubnetNode;
import javax.baja.lonworks.enums.BAddressType;
import javax.baja.lonworks.enums.BLonLinkType;
import javax.baja.lonworks.proxy.BLonProxyExt;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Knob;
import javax.baja.util.IntHashMap;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ConnectionTable
implements NetMgmtConst {
    public static int INITIAL_CONNECTIONS = 200;
    private Vector unresolved;
    private BLonDevice[] lonDevices;
    private BLocalLonDevice local;
    BLonNetwork lonworks;
    private boolean debug;
    private Connection[] table;
    private IntHashMap pointHash;
    private Vector tagTable;
    private IntHashMap tagHash;
    private IntHashMap proxyHash;
    private GroupTable groupTable;
    static /* synthetic */ Class class$com$tridium$lonworks$local$BPseudoNV;
    static /* synthetic */ Class class$javax$baja$lonworks$BINetworkVariable;

    public Connection[] getConnectionArray() {
        return this.table;
    }

    public GroupTable getGroupTable() {
        if (this.groupTable == null) {
            this.groupTable = new GroupTable(this.lonworks, this.lonDevices, this, this.debug);
        }
        return this.groupTable;
    }

    public TagConnection[] getMessageTagTable() {
        Object[] objectArray = new TagConnection[this.tagTable.size()];
        this.tagTable.copyInto(objectArray);
        return objectArray;
    }

    public Connection getConnection(int n) {
        if (this.table.length <= n) {
            return null;
        }
        return this.table[n];
    }

    private final void addBoundNv(BINvContainer bINvContainer) {
        if (this.debug) {
            System.out.println("\nAnalyze nvProps for " + bINvContainer.getDisplayName(null));
        }
        BComponent bComponent = (BComponent)bINvContainer;
        Class clazz = class$javax$baja$lonworks$BINetworkVariable;
        if (clazz == null) {
            clazz = class$javax$baja$lonworks$BINetworkVariable = ConnectionTable.class("[Ljavax.baja.lonworks.BINetworkVariable;", false);
        }
        BINetworkVariable[] bINetworkVariableArray = (BINetworkVariable[])bComponent.getChildren(clazz);
        int n = 0;
        while (n < bINetworkVariableArray.length) {
            BNetworkVariable bNetworkVariable;
            BNvConfigData bNvConfigData;
            if (bINetworkVariableArray[n] != null && bINetworkVariableArray[n].isNetworkVariable() && (bNvConfigData = (bNetworkVariable = (BNetworkVariable)bINetworkVariableArray[n]).getNvConfigData()).isBoundNv()) {
                LonPoint lonPoint = new LonPoint(bINvContainer, bNetworkVariable, BLonLinkStatus.obsolete);
                lonPoint.setAddressIndex(bNvConfigData.getAddrIndex());
                if (this.debug) {
                    System.out.println("\n found bound point " + lonPoint);
                }
                int n2 = bNvConfigData.getSelector();
                this.addPoint(lonPoint, n2);
            }
            ++n;
        }
    }

    private final void addProxyLinks(BLonDevice bLonDevice) {
        if (this.debug) {
            System.out.println("\nAnalyze proxyPoints for " + bLonDevice.getDisplayName(null));
        }
        BControlPoint[] bControlPointArray = bLonDevice.getLonProxies();
        int n = 0;
        while (n < bControlPointArray.length) {
            BControlPoint bControlPoint = bControlPointArray[n];
            BAbstractProxyExt bAbstractProxyExt = bControlPoint.getProxyExt();
            if (bAbstractProxyExt != null && bAbstractProxyExt instanceof BLonProxyExt) {
                BLonProxyExt bLonProxyExt = (BLonProxyExt)bAbstractProxyExt;
                BLonComponent bLonComponent = null;
                try {
                    bLonComponent = bLonProxyExt.getLonComponent();
                }
                catch (Throwable throwable) {}
                if (bLonComponent != null && bLonComponent.isNetworkVariable()) {
                    BNetworkVariable bNetworkVariable = (BNetworkVariable)bLonComponent;
                    BNvConfigData bNvConfigData = bNetworkVariable.getNvConfigData();
                    BNvProps bNvProps = bNetworkVariable.getNvProps();
                    if (!bNvConfigData.isInput() || bControlPoint.isWritablePoint()) {
                        BLonLinkStatus bLonLinkStatus = BLonLinkStatus.newLink;
                        if (bNvConfigData.isBoundNv() && (bNvConfigData.isInput() || bNvProps.getBoundToLocal())) {
                            bLonLinkStatus = BLonLinkStatus.bound;
                        }
                        LonPoint lonPoint = new LonPoint(bLonDevice, bNetworkVariable, bLonLinkStatus);
                        LonPointProxy lonPointProxy = new LonPointProxy(bLonDevice, bNetworkVariable, bLonLinkStatus, bControlPoint, this.local, (BLonProxyExt)bAbstractProxyExt);
                        int n2 = this.getSelector(lonPoint);
                        BLonLinkType bLonLinkType = bLonProxyExt.getLinkType();
                        boolean bl = bLonProxyExt.getPriority();
                        boolean bl2 = this.isSecondProxy(lonPointProxy);
                        if (n2 < 0) {
                            if (this.debug) {
                                System.out.println(" addProxyLink sel < 0");
                            }
                            if (bNvConfigData.isInput()) {
                                this.addConnection(lonPointProxy, lonPoint, bLonLinkType, bl);
                            } else {
                                this.addConnection(lonPoint, lonPointProxy, bLonLinkType, bl);
                            }
                        } else if (!bl2) {
                            if (this.debug) {
                                System.out.println(" addProxyLink to sel = " + n2 + '\n' + lonPointProxy);
                            }
                            this.table[n2].addLinkedProxy(lonPoint, lonPointProxy, bLonLinkType, bl);
                            this.hash(lonPointProxy, n2);
                        }
                    }
                }
            }
            ++n;
        }
    }

    private final void addLinks(BINvContainer bINvContainer) {
        BLink[] bLinkArray = bINvContainer.asComponent().getLinks();
        if (this.debug) {
            System.out.println("\nAnalyze " + bLinkArray.length + " links for " + bINvContainer.getDisplayName(null));
        }
        boolean bl = bINvContainer.getLonDevice().isConfigOnline();
        int n = 0;
        while (n < bLinkArray.length) {
            if (bLinkArray[n].getType().is(BLonLink.TYPE)) {
                BLonLink bLonLink = (BLonLink)bLinkArray[n];
                if (bLonLink.getMessageTag()) {
                    this.addTagLink(bINvContainer.getLonDevice(), bLonLink, bl ^ true);
                } else {
                    try {
                        if (bLonLink.getRemoteLink()) {
                            this.addRemoteLinkToSrc(bINvContainer, bLonLink, bl ^ true);
                        } else if (bLonLink.getPseudoLink()) {
                            this.addPseudoLinkToSrc(bINvContainer, bLonLink, bl ^ true);
                        } else {
                            this.addLink(bINvContainer, bLonLink, bl ^ true);
                        }
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        System.out.println("Error in addLinks: " + throwable);
                    }
                }
            }
            ++n;
        }
        Knob[] knobArray = bINvContainer.asComponent().getKnobs();
        int n2 = 0;
        while (n2 < knobArray.length) {
            BLink bLink = knobArray[n2].getLink();
            if (bLink.getType().is(BLonLink.TYPE) && ((BLonLink)bLink).getRemoteLink()) {
                this.addRemoteLinkToTgt(bINvContainer, (BLonLink)bLink, bl ^ true);
            }
            ++n2;
        }
    }

    private final void addLink(BINvContainer bINvContainer, BLonLink bLonLink, boolean bl) {
        LonPoint lonPoint = null;
        LonPoint lonPoint2 = null;
        Connection connection = null;
        BLonLinkType bLonLinkType = bLonLink.getLinkType();
        boolean bl2 = bLonLink.getPriority();
        int n = -1;
        if (this.debug) {
            System.out.println("\n addlink ->" + (Object)((Object)bLonLink));
        }
        BINvContainer bINvContainer2 = (BINvContainer)bLonLink.getSourceComponent();
        BNetworkVariable bNetworkVariable = (BNetworkVariable)bINvContainer2.asComponent().get(bLonLink.getSourceSlot().asProperty());
        BNetworkVariable bNetworkVariable2 = (BNetworkVariable)bINvContainer.asComponent().get(bLonLink.getTargetSlot().asProperty());
        LonPoint lonPoint3 = new LonPoint(bINvContainer2, bNetworkVariable);
        LonPoint lonPoint4 = new LonPoint(bINvContainer, bNetworkVariable2);
        if (this.debug) {
            System.out.println(" srcPnt =>" + lonPoint3 + "\n tgtPnt =>" + lonPoint4);
        }
        int n2 = this.getSelector(lonPoint3);
        int n3 = this.getSelector(lonPoint4);
        if (n2 < 0 && n3 < 0) {
            if (this.debug) {
                System.out.println(" addLink srcSel < 0 && tgtSel < 0");
            }
            n = this.addConnection(lonPoint3, lonPoint4, bLonLinkType, bl2);
            connection = this.table[n];
        } else if (n2 < 0) {
            n = n3;
            connection = this.table[n];
            if (this.debug) {
                System.out.println(" addLinkedPoint selector = " + n);
            }
            this.table[n].addLinkedPoint(lonPoint4, lonPoint3, bLonLinkType, bl2);
            this.hash(lonPoint3, n);
        } else if (n3 < 0) {
            n = n2;
            connection = this.table[n];
            if (this.debug) {
                System.out.println(" addLinkedPoint selector = " + n);
            }
            this.table[n].addLinkedPoint(lonPoint3, lonPoint4, bLonLinkType, bl2);
            this.hash(lonPoint4, n);
        } else if (n2 == n3) {
            n = n2;
            connection = this.table[n];
            this.verifySelector(n);
            if (this.debug) {
                System.out.println(" srcSel == tgtSel  selector = " + n);
            }
            this.table[n].addLink(lonPoint4, lonPoint3, bLonLinkType, bl2);
        } else {
            connection = this.table[n2].findAliasConnection(this.table[n3], lonPoint3);
            if (connection != null) {
                if (this.debug) {
                    System.out.println(" p1 in selector " + n2 + " has alias in " + n3);
                }
                lonPoint = connection.findAliasPoint(lonPoint3);
                lonPoint2 = connection.findPoint(lonPoint4);
                if (lonPoint2 == null) {
                    connection.addPoint(lonPoint4);
                }
                connection.setLinkType(bLonLinkType);
            } else {
                connection = this.table[n3].findAliasConnection(this.table[n2], lonPoint4);
                if (connection != null) {
                    if (this.debug) {
                        System.out.println(" p2 in selector " + n3 + " has alias in " + n2);
                    }
                    lonPoint = connection.findPoint(lonPoint3);
                    lonPoint2 = connection.findAliasPoint(lonPoint4);
                    if (lonPoint == null) {
                        connection.addPoint(lonPoint3);
                    }
                    connection.setLinkType(bLonLinkType);
                } else {
                    if (this.debug) {
                        System.out.println("\n******* unresolvedLink srcSel=" + n2 + " tgtSel=" + n3 + " ********");
                    }
                    this.unresolvedLink(lonPoint3, lonPoint4, bLonLinkType, bl2);
                    return;
                }
            }
        }
        if (lonPoint != null && lonPoint.getStatus() == BLonLinkStatus.obsolete) {
            lonPoint.setStatus(BLonLinkStatus.bound);
        }
        if (lonPoint2 != null && lonPoint2.getStatus() == BLonLinkStatus.obsolete) {
            lonPoint2.setStatus(BLonLinkStatus.bound);
        }
        if (connection != null && this.debug) {
            System.out.println(connection);
        }
    }

    private final void addRemoteLinkToTgt(BINvContainer bINvContainer, BLonLink bLonLink, boolean bl) {
        BINvContainer bINvContainer2 = (BINvContainer)bLonLink.getTargetComponent();
        BNetworkVariable bNetworkVariable = (BNetworkVariable)bINvContainer.asComponent().get(bLonLink.getSourceSlot().asProperty());
        BNetworkVariable bNetworkVariable2 = (BNetworkVariable)bINvContainer2.asComponent().get(bLonLink.getTargetSlot().asProperty());
        BLonLinkStatus bLonLinkStatus = bNetworkVariable.getNvConfigData().isBoundNv() ? BLonLinkStatus.bound : BLonLinkStatus.newLink;
        LonPoint lonPoint = new LonPoint(bINvContainer, bNetworkVariable, bLonLinkStatus);
        LonPointRemote lonPointRemote = new LonPointRemote(bINvContainer, bNetworkVariable, bLonLinkStatus, this.local, bINvContainer2, bNetworkVariable2);
        int n = this.getSelector(lonPoint);
        BLonLinkType bLonLinkType = bLonLink.getLinkType();
        boolean bl2 = bLonLink.getPriority();
        if (n < 0) {
            if (this.debug) {
                System.out.println(" add remote link");
            }
            this.addConnection(lonPoint, lonPointRemote, bLonLinkType, bl2);
        } else {
            if (this.debug) {
                System.out.println(" add remote Link to sel = " + n);
            }
            this.table[n].addLinkedProxy(lonPoint, lonPointRemote, bLonLinkType, bl2);
            this.hash(lonPointRemote, n);
        }
    }

    private final void addRemoteLinkToSrc(BINvContainer bINvContainer, BLonLink bLonLink, boolean bl) {
        BLonDevice bLonDevice = (BLonDevice)bLonLink.getSourceComponent();
        BNetworkVariable bNetworkVariable = (BNetworkVariable)bLonDevice.asComponent().get(bLonLink.getSourceSlot().asProperty());
        BNetworkVariable bNetworkVariable2 = (BNetworkVariable)bINvContainer.asComponent().get(bLonLink.getTargetSlot().asProperty());
        BLonLinkStatus bLonLinkStatus = bNetworkVariable2.getNvConfigData().isBoundNv() ? BLonLinkStatus.bound : BLonLinkStatus.newLink;
        LonPoint lonPoint = new LonPoint(bINvContainer, bNetworkVariable2, bLonLinkStatus);
        LonPointRemote lonPointRemote = new LonPointRemote(bINvContainer, bNetworkVariable2, bLonLinkStatus, this.local, bLonDevice, bNetworkVariable);
        int n = this.getSelector(lonPoint);
        BLonLinkType bLonLinkType = bLonLink.getLinkType();
        boolean bl2 = bLonLink.getPriority();
        if (n < 0) {
            if (this.debug) {
                System.out.println(" add remote link");
            }
            this.addConnection(lonPointRemote, lonPoint, bLonLinkType, bl2);
        } else {
            if (this.debug) {
                System.out.println(" add remote Link to sel = " + n);
            }
            this.table[n].addLinkedProxy(lonPoint, lonPointRemote, bLonLinkType, bl2);
            this.hash(lonPointRemote, n);
        }
    }

    private final void addPseudoNv(BPseudoNV bPseudoNV) {
        BNvConfigData bNvConfigData = bPseudoNV.getNvConfigData();
        if (bNvConfigData.isBoundNv()) {
            int n = bNvConfigData.getSelector();
            LonPointPseudo lonPointPseudo = new LonPointPseudo(null, null, BLonLinkStatus.obsolete, this.local, (BComponent)bPseudoNV.getParent(), bPseudoNV);
            lonPointPseudo.setAddressIndex(bNvConfigData.getAddrIndex());
            if (this.debug) {
                System.out.println("\n found bound pseudo " + lonPointPseudo);
            }
            this.addPoint((LonPoint)lonPointPseudo, n);
        }
    }

    private final void addPseudoLinkToSrc(BINvContainer bINvContainer, BLonLink bLonLink, boolean bl) {
        BComponent bComponent = bLonLink.getSourceComponent();
        BPseudoNV bPseudoNV = (BPseudoNV)bComponent.asComponent().get(bLonLink.getSourceSlot().asProperty());
        BNetworkVariable bNetworkVariable = (BNetworkVariable)bINvContainer.asComponent().get(bLonLink.getTargetSlot().asProperty());
        BLonLinkStatus bLonLinkStatus = bNetworkVariable.getNvConfigData().isBoundNv() ? BLonLinkStatus.bound : BLonLinkStatus.newLink;
        LonPoint lonPoint = new LonPoint(bINvContainer, bNetworkVariable, bLonLinkStatus);
        LonPointPseudo lonPointPseudo = new LonPointPseudo(bINvContainer, bNetworkVariable, BLonLinkStatus.newLink, this.local, bComponent, bPseudoNV);
        lonPointPseudo.setAddressIndex(bPseudoNV.getNvConfigData().getAddrIndex());
        int n = this.getSelector(lonPoint);
        int n2 = this.getSelector(lonPointPseudo);
        BLonLinkType bLonLinkType = bLonLink.getLinkType();
        boolean bl2 = bLonLink.getPriority();
        if (n < 0 && n2 < 0) {
            if (this.debug) {
                System.out.println(" add pseudo link");
            }
            this.addConnection(lonPointPseudo, lonPoint, bLonLinkType, bl2);
        } else if (n < 0) {
            if (this.debug) {
                System.out.println(" add linked pseudo Link to sel = " + n);
            }
            this.table[n2].addLinkedPoint(lonPointPseudo, lonPoint, bLonLinkType, bl2);
            this.hash(lonPoint, n2);
        } else if (n2 < 0) {
            if (this.debug) {
                System.out.println(" add pseudo Link to sel = " + n);
            }
            this.table[n].addLinkedPoint(lonPoint, lonPointPseudo, bLonLinkType, bl2);
            this.hash(lonPointPseudo, n);
        } else if (n == n2) {
            if (this.debug) {
                System.out.println(" add linked pseudo Link to sel = " + n);
            }
            this.table[n].addLink(lonPoint, lonPointPseudo, bLonLinkType, bl2);
        } else {
            if (this.debug) {
                System.out.println("\n******* unresolvedLink pseudo sel=" + n2 + " tgt sel=" + n + " ********");
            }
            this.unresolvedLink(lonPointPseudo, lonPoint, bLonLinkType, bl2);
            return;
        }
    }

    private final int addConnection(LonPoint lonPoint, LonPoint lonPoint2, BLonLinkType bLonLinkType, boolean bl) {
        int n = this.getNextSelector();
        if (n == -1) {
            return -1;
        }
        this.hash(lonPoint, n);
        this.hash(lonPoint2, n);
        if (this.debug) {
            System.out.println("  Addconnection selector = " + n + "\n   p1 =>" + lonPoint + "\n   p2 =>" + lonPoint2);
        }
        this.table[n] = new Connection(lonPoint, lonPoint2, n, bLonLinkType, bl, this.debug);
        return n;
    }

    private final int getNextSelector() {
        int n = 1;
        while (n < this.table.length) {
            if (this.table[n] == null) {
                return n;
            }
            ++n;
        }
        this.verifySelector(n);
        return n;
    }

    private final void verifySelector(int n) {
        if (n < this.table.length) {
            return;
        }
        if (n > 12287) {
            throw new BajaRuntimeException("Exceeded maximum selector.");
        }
        int n2 = n + INITIAL_CONNECTIONS;
        if (n2 > 12287) {
            n2 = 12287;
        }
        Connection[] connectionArray = new Connection[n2];
        System.arraycopy(this.table, 0, connectionArray, 0, this.table.length);
        this.table = connectionArray;
    }

    private final void addPoint(LonPoint lonPoint, int n) {
        this.verifySelector(n);
        if (this.table[n] == null) {
            if (this.debug) {
                System.out.println(" in addPoint - add new connection at selector " + n + ' ' + lonPoint);
            }
            this.table[n] = new Connection(lonPoint, n, this.debug);
        } else {
            if (this.debug) {
                System.out.println(" in addPoint - addpoint at selector " + n + ' ' + lonPoint);
            }
            this.table[n].addPoint(lonPoint);
        }
        this.hash(lonPoint, n);
    }

    private final void addPoint(LonPoint lonPoint, Connection connection) {
        if (this.debug) {
            System.out.println(" in addPoint - addpoint at selector " + connection.getSelector() + ' ' + lonPoint);
        }
        connection.addPoint(lonPoint);
        this.hash(lonPoint, connection.getSelector());
    }

    private final void unresolvedLink(LonPoint lonPoint, LonPoint lonPoint2, BLonLinkType bLonLinkType, boolean bl) {
        if (this.debug) {
            System.out.println(" add to unresolved:\n    p1: " + lonPoint + "\n    p2: " + lonPoint2);
        }
        UnresolvedLink unresolvedLink = new UnresolvedLink(lonPoint, lonPoint2, bLonLinkType, bl);
        this.unresolved.addElement(unresolvedLink);
    }

    private final void processUnresolved() {
        int n = 0;
        while (n < this.unresolved.size()) {
            UnresolvedLink unresolvedLink = (UnresolvedLink)this.unresolved.elementAt(n);
            int n2 = this.getSelector(unresolvedLink.srcPnt);
            int n3 = this.getSelector(unresolvedLink.tgtPnt);
            if (this.debug) {
                System.out.println("\nprocessUnresolved:\n  srcSel=" + n2 + " p1: " + unresolvedLink.srcPnt + "\n  tgtSel=" + n3 + " p2: " + unresolvedLink.tgtPnt);
            }
            if (n2 == n3) {
                this.table[n2].addLink(unresolvedLink.srcPnt, unresolvedLink.tgtPnt, unresolvedLink.linkType, unresolvedLink.priority);
                if (this.debug) {
                    System.out.println("\n  addLink: " + this.table[n2]);
                }
            } else if (n2 == -1 || this.table[n2].okayToRemove(unresolvedLink.srcPnt)) {
                this.removePointAll(unresolvedLink.srcPnt);
                this.table[n3].addLinkedPoint(unresolvedLink.tgtPnt, unresolvedLink.srcPnt, unresolvedLink.linkType, unresolvedLink.priority);
                this.moveHash(unresolvedLink.srcPnt, n3);
                if (this.debug) {
                    System.out.println("\n  addLinkedPoint: " + this.table[n3]);
                }
            } else if (n3 == -1 || this.table[n3].okayToRemove(unresolvedLink.tgtPnt)) {
                this.removePointAll(unresolvedLink.tgtPnt);
                this.table[n2].addLinkedPoint(unresolvedLink.srcPnt, unresolvedLink.tgtPnt, unresolvedLink.linkType, unresolvedLink.priority);
                this.moveHash(unresolvedLink.tgtPnt, n2);
                if (this.debug) {
                    System.out.println("\n  addLinkedPoint: " + this.table[n2]);
                }
            } else {
                boolean bl = unresolvedLink.srcPnt.isOutput();
                int n4 = bl ? n2 : n3;
                n3 = bl ? n3 : n2;
                LonPoint lonPoint = bl ? unresolvedLink.srcPnt : unresolvedLink.tgtPnt;
                LonPoint lonPoint2 = bl ? unresolvedLink.tgtPnt : unresolvedLink.srcPnt;
                Connection connection = this.table[n4].findConnection(lonPoint);
                Connection connection2 = this.table[n3].findConnection(lonPoint2);
                if (!this.table[n4].okToMerge(this.table[n3])) {
                    Connection connection3 = this.table[n3].findAliasConnection(lonPoint);
                    if (connection3 != null) {
                        connection3.addLinkedPoint(connection3.getHub(), lonPoint2, unresolvedLink.linkType, unresolvedLink.priority);
                    } else {
                        connection3 = this.createNewAliasConnection(connection, n3, false);
                        connection3.addPoint(lonPoint2);
                        connection3.setLinkType(unresolvedLink.linkType);
                        connection.addAliasConnection(connection3);
                    }
                    if (this.debug) {
                        System.out.println("\n  after processing: hubCon:" + this.table[n4]);
                    }
                    if (this.debug) {
                        System.out.println("tgtConn:" + this.table[n3]);
                    }
                } else if (this.table[n4].countPoints() >= this.table[n3].countPoints()) {
                    this.mergeConnections(this.table[n4], this.table[n3]);
                    connection.addLink(lonPoint, lonPoint2, unresolvedLink.linkType, unresolvedLink.priority);
                    if (this.debug) {
                        System.out.println("\n  after merge: " + this.table[n4]);
                    }
                } else {
                    this.mergeConnections(this.table[n3], this.table[n4]);
                    connection2.addLink(lonPoint2, lonPoint, unresolvedLink.linkType, unresolvedLink.priority);
                    if (this.debug) {
                        System.out.println("\n  after merge: " + this.table[n3]);
                    }
                }
            }
            ++n;
        }
    }

    private final void mergeConnections(Connection connection, Connection connection2) {
        if (this.debug) {
            System.out.println("\n  mergeConnections:\nc1:" + connection + "\nc2:" + connection2);
        }
        this.table[connection2.getSelector()] = null;
        int n = connection.getSelector();
        Connection connection3 = connection2;
        while (connection3 != null) {
            this.moveConnection(connection3, n);
            connection3 = connection3.getSecondary();
        }
        connection.mergeConnection(connection2);
    }

    private final void moveConnection(Connection connection, int n) {
        LonPoint lonPoint = connection.getHub();
        this.moveHash(lonPoint, n);
        LonPoint[] lonPointArray = connection.getTargets();
        int n2 = 0;
        while (n2 < lonPointArray.length) {
            this.moveHash(lonPointArray[n2], n);
            ++n2;
        }
        connection.setSelector(n);
    }

    private final void moveHash(LonPoint lonPoint, int n) {
        if (lonPoint == null) {
            return;
        }
        this.unhash(lonPoint);
        this.hash(lonPoint, n);
        if (lonPoint.getStatus() == BLonLinkStatus.bound) {
            lonPoint.setStatus(BLonLinkStatus.newLink);
        }
    }

    private final void removePointAll(LonPoint lonPoint) {
        int n = this.getSelector(lonPoint);
        if (n < 0) {
            return;
        }
        Connection connection = this.table[n];
        if (this.debug) {
            System.out.println(" remove from selector = " + connection.getSelector() + " point:" + lonPoint);
        }
        while (connection != null) {
            connection.removePoint(lonPoint);
            connection = connection.getSecondary();
        }
        this.unhash(lonPoint);
    }

    private final void removePoint(LonPoint lonPoint, Connection connection) {
        lonPoint.setStatus(BLonLinkStatus.newLink);
        if (this.debug) {
            System.out.println("\n remove from selector = " + connection.getSelector() + " point:" + lonPoint);
        }
        connection.removePoint(lonPoint);
        this.unhash(lonPoint);
    }

    private final void addAliasNv(BLonDevice bLonDevice) {
        BAliasTable bAliasTable = bLonDevice.getDeviceData().getAliasTable();
        BAliasConfigData[] bAliasConfigDataArray = bAliasTable.getAliasArray();
        if (this.debug && bAliasTable.getAliasCount() > 0) {
            System.out.println("\nAnalyze aliases for " + bLonDevice.getDisplayName(null));
        }
        int n = 0;
        while (n < bAliasConfigDataArray.length) {
            BAliasConfigData bAliasConfigData = bAliasConfigDataArray[n];
            if (bAliasConfigData != null) {
                if (bAliasConfigData.isBoundNv()) {
                    int n2 = bAliasConfigData.getPrimary();
                    BNetworkVariable bNetworkVariable = bLonDevice.getNetworkVariable(n2);
                    if (bNetworkVariable == null) {
                        System.out.println("Error: " + bLonDevice.getDisplayName(null) + " alias " + n + " has invalid primNv " + n2);
                    } else {
                        LonPointAlias lonPointAlias = new LonPointAlias((BINvContainer)bNetworkVariable.getParent(), bNetworkVariable, BLonLinkStatus.obsolete, n);
                        lonPointAlias.setAddressIndex(bAliasConfigData.getAddrIndex());
                        if (this.debug) {
                            System.out.println("\n found bound alias point" + lonPointAlias);
                        }
                        int n3 = bAliasConfigData.getSelector();
                        this.verifySelector(n3);
                        this.addPoint((LonPoint)lonPointAlias, n3);
                        int n4 = lonPointAlias.primaryHashCode();
                        int n5 = this.getSelector(n4);
                        if (n5 >= 0) {
                            this.verifySelector(n5);
                            Connection connection = this.table[this.getSelector(n4)];
                            Connection connection2 = this.table[n3].findConnection(lonPointAlias);
                            connection = connection.findAliasPrimary(n4);
                            if (connection != null && connection2 != null) {
                                connection.addAliasConnection(connection2);
                            }
                            bAliasConfigData.setBound();
                        }
                    }
                } else {
                    bAliasConfigData.setFree();
                }
            }
            ++n;
        }
    }

    private final void processAliasConnections() {
        Connection connection;
        Connection connection2;
        if (this.debug) {
            System.out.println("\n\nDo alias connection check.");
        }
        if (this.debug) {
            System.out.println("\nCreate new connections.");
        }
        int n = 0;
        while (n < this.table.length) {
            connection2 = this.table[n];
            if (connection2 != null) {
                this.discoverNewAlias(connection2);
            }
            ++n;
        }
        if (this.debug) {
            System.out.println("\n\nCompress and free.");
        }
        n = 0;
        while (n < this.table.length) {
            connection = connection2 = this.table[n];
            while (connection != null) {
                if (connection.hasAliasConnection()) {
                    this.compressAliases(connection);
                }
                if (connection.hasAliasConnection()) {
                    this.checkForObsoletePrimary(connection);
                }
                connection = connection.getSecondary();
            }
            ++n;
        }
        if (this.debug) {
            System.out.println("\n\nMake obsolete aliases available.");
        }
        n = 0;
        while (n < this.table.length) {
            connection = connection2 = this.table[n];
            while (connection != null) {
                if (connection.isAliasConnection()) {
                    this.freeObsoleteAliases(connection);
                }
                connection = connection.getSecondary();
            }
            ++n;
        }
        if (this.debug) {
            System.out.println("\n\nCheck for unresolved aliases.");
        }
        n = 0;
        while (n < this.table.length) {
            connection = connection2 = this.table[n];
            while (connection != null) {
                if (connection.isAliasConnection()) {
                    this.checkInvalidAliasIndex(connection);
                }
                connection = connection.getSecondary();
            }
            ++n;
        }
    }

    private final void freeObsoleteAliases(Connection connection) {
        LonPointAlias lonPointAlias = (LonPointAlias)connection.getHub();
        if (lonPointAlias == null || !lonPointAlias.isObsolete()) {
            return;
        }
        BLonDevice bLonDevice = lonPointAlias.getLonDevice();
        BAliasConfigData[] bAliasConfigDataArray = bLonDevice.getDeviceData().getAliasTable().getAliasArray();
        if (this.debug) {
            System.out.println("Clear alias ndx=" + lonPointAlias.getAliasIndex() + '|' + bAliasConfigDataArray[lonPointAlias.getAliasIndex()].toString());
        }
        bAliasConfigDataArray[lonPointAlias.getAliasIndex()].makeAvailable();
    }

    private final void compressAliases(Connection connection) {
        Connection[] connectionArray = connection.getAliasConnections();
        if (connectionArray != null) {
            Connection connection2 = connection;
            int n = 0;
            while (n < connectionArray.length) {
                LonPoint[] lonPointArray;
                int n2 = connectionArray.length - 1;
                while (n2 >= n) {
                    lonPointArray = connection2.getAliasPointsToCompress(connectionArray[n2]);
                    if (lonPointArray != null) {
                        if (this.debug) {
                            System.out.println(" compress " + lonPointArray.length + " pnts from alias " + n2 + " to " + (n == 0 ? "primary" : Integer.toString(n - 1)));
                        }
                        this.movePoints(lonPointArray, connectionArray[n2], connection2);
                    }
                    --n2;
                }
                lonPointArray = connection2.getSameDevicePoints();
                if (lonPointArray != null) {
                    if (this.debug) {
                        System.out.println(" move " + lonPointArray.length + " points up to next alias ");
                    }
                    this.movePoints(lonPointArray, connection2, connectionArray[n]);
                }
                connection2 = connectionArray[n];
                ++n;
            }
            n = connectionArray.length - 1;
            while (n >= 0) {
                LonPointAlias lonPointAlias;
                if (connectionArray[n].getActiveTargetCount() == 0 && (lonPointAlias = (LonPointAlias)connectionArray[n].getHub()) != null) {
                    if (this.debug) {
                        System.out.println("detected alias to remove " + lonPointAlias);
                    }
                    if (lonPointAlias.isNew()) {
                        this.removeOriginalAliasPoint(lonPointAlias);
                    } else {
                        lonPointAlias.setStatus(BLonLinkStatus.obsolete);
                    }
                }
                --n;
            }
        }
    }

    private final void movePoints(LonPoint[] lonPointArray, Connection connection, Connection connection2) {
        int n = 0;
        while (n < lonPointArray.length) {
            LonPoint lonPoint = lonPointArray[n];
            if (this.debug) {
                System.out.println("  move point to sel = " + connection2.getSelector() + ":\n   " + lonPoint);
            }
            this.removePoint(lonPoint, connection);
            this.addPoint(lonPoint, connection2);
            connection2.setLinkType(connection.getLinkType());
            ++n;
        }
        this.updateHubStatus(connection2, connection.getLinkType());
    }

    private final void checkInvalidAliasIndex(Connection connection) {
        LonPointAlias lonPointAlias = (LonPointAlias)connection.getHub();
        if (lonPointAlias.getAliasIndex() >= 0) {
            return;
        }
        int n = this.reserveAvailableAlias(lonPointAlias.getLonDevice());
        if (n >= 0) {
            this.unhash(lonPointAlias);
            lonPointAlias.setAliasIndex(n);
            this.removeOriginalAliasPoint(lonPointAlias);
            this.hash(lonPointAlias, connection.getSelector());
        } else {
            connection.setStatus(BLonLinkStatus.aliasError);
        }
    }

    private final void checkForObsoletePrimary(Connection connection) {
        if (connection.isActive() || connection.isError()) {
            return;
        }
        Connection connection2 = connection.getActiveAliasConnection();
        if (connection2 == null) {
            return;
        }
        if (this.debug) {
            System.out.println("Remove alias from " + connection2.getSelector() + " because of obsolete primary in " + connection.getSelector());
        }
        LonPoint lonPoint = connection.getHub();
        LonPoint lonPoint2 = connection2.getHub();
        this.unhash(lonPoint);
        this.unhash(lonPoint2);
        lonPoint.setStatus(BLonLinkStatus.newLink);
        lonPoint2.setStatus(BLonLinkStatus.obsolete);
        this.hash(lonPoint, connection2.getSelector());
        this.hash(lonPoint2, connection.getSelector());
        connection2.setHub(lonPoint);
        connection.setHub(lonPoint2);
        connection.removeAliasConnection(connection2);
        Connection[] connectionArray = connection.getAliasConnections();
        if (connectionArray == null) {
            return;
        }
        int n = 0;
        while (n < connectionArray.length) {
            connection.removeAliasConnection(connectionArray[n]);
            connection2.addAliasConnection(connectionArray[n]);
            ++n;
        }
    }

    private final void discoverNewAlias(Connection connection) {
        Vector vector = connection.getAllSameDevicePoints();
        boolean bl = false;
        if (connection.getSecondary() != null) {
            bl = true;
        }
        boolean bl2 = bl;
        while (vector.size() > 1) {
            LonPoint lonPoint = (LonPoint)vector.elementAt(0);
            int n = 1;
            while (n < vector.size()) {
                LonPoint lonPoint2 = (LonPoint)vector.elementAt(n);
                if (lonPoint2.overlappCnt < lonPoint.overlappCnt || lonPoint2.overlappCnt == lonPoint.overlappCnt && lonPoint.isBound() && !lonPoint2.isBound()) {
                    lonPoint = lonPoint2;
                }
                ++n;
            }
            vector.removeElement(lonPoint);
            int n2 = this.getNextSelector();
            boolean bl3 = true;
            Connection connection2 = connection.findConnection(lonPoint, true);
            while (connection2 != null) {
                Connection connection3 = connection2.findAliasConnectionForPoint(lonPoint, n2, bl3 ^ true);
                if (connection3 != null) {
                    n2 = connection3.getSelector();
                    if (this.debug) {
                        System.out.println("found alias connection for point " + n2);
                    }
                    this.removePoint(lonPoint, connection2);
                    this.addPoint(lonPoint, connection3);
                    this.updateHubStatus(connection3, connection2.getLinkType());
                } else if (bl2 && !connection2.hasAnyOverlappingTargets(lonPoint)) {
                    int n3 = connection.getSelector();
                    if (connection2 == connection) {
                        this.table[n3] = connection = connection2.removeAllSecondaries();
                    } else {
                        connection.removeSecondary(connection2);
                    }
                    this.moveConnection(connection2, n2);
                    if (this.debug) {
                        System.out.println("moveConnection with no other overlapps from " + n3 + " to " + n2 + '\n' + connection2);
                    }
                    this.table[n2] = connection2;
                } else {
                    connection3 = this.createNewAliasConnection(connection2, n2, bl3);
                    this.removePoint(lonPoint, connection2);
                    this.addPoint(lonPoint, connection3);
                    this.updateHubStatus(connection3, connection2.getLinkType());
                    connection2.addAliasConnection(connection3);
                    if (this.debug) {
                        System.out.println(" create new alias " + connection3.toString(false));
                    }
                }
                connection2 = connection == null ? null : connection.findConnection(lonPoint, true);
                bl3 = false;
            }
            if (connection == null || vector.size() > 1) continue;
            vector = connection.getAllSameDevicePoints();
        }
    }

    private final void updateHubStatus(Connection connection, BLonLinkType bLonLinkType) {
        LonPoint lonPoint;
        if (connection.getActiveTargetCount() > 0 && (lonPoint = connection.getHub()) != null && lonPoint.isObsolete()) {
            lonPoint.setStatus(BLonLinkStatus.bound);
            if (connection.getLinkType() == BLonLinkType.unknown) {
                connection.setLinkType(bLonLinkType);
            }
        }
    }

    private final Connection createNewAliasConnection(Connection connection, int n, boolean bl) {
        LonPoint lonPoint = connection.getHub();
        BLonDevice bLonDevice = lonPoint.getLonDevice();
        int n2 = this.reserveAvailableAlias(bLonDevice);
        LonPointAlias lonPointAlias = new LonPointAlias(lonPoint.getNvContainer(), lonPoint.getNetworkVariable(), BLonLinkStatus.newLink, n2);
        this.hash(lonPointAlias, n);
        Connection connection2 = new Connection(lonPointAlias, n, this.debug);
        connection2.setLinkType(connection.getLinkType());
        if (bl) {
            this.table[n] = connection2;
        } else {
            this.table[n].addSecondary(connection2);
        }
        return connection2;
    }

    private final int reserveAvailableAlias(BLonDevice bLonDevice) {
        BAliasConfigData[] bAliasConfigDataArray = bLonDevice.getDeviceData().getAliasTable().getAliasArray();
        int n = 0;
        while (n < bAliasConfigDataArray.length) {
            if (bAliasConfigDataArray[n].isAvailable()) {
                bAliasConfigDataArray[n].reserve();
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Connection findConnectionForHash(int n) {
        int n2 = this.getSelector(n);
        if (n2 < 0 || n2 > this.table.length) {
            return null;
        }
        Connection connection = this.table[n2];
        while (connection != null) {
            LonPoint lonPoint = connection.getHub();
            if (lonPoint != null && lonPoint.hashCode() == n) break;
            connection = connection.getSecondary();
        }
        return connection;
    }

    private final void removeOriginalAliasPoint(LonPointAlias lonPointAlias) {
        int n = this.getSelector(lonPointAlias);
        if (n != -1) {
            LonPoint lonPoint;
            Connection connection = this.table[n].findConnection(lonPointAlias);
            if (connection == null) {
                return;
            }
            if (this.debug) {
                System.out.println("Removing alias pnt from selector " + n + '\n' + lonPointAlias);
            }
            if ((lonPoint = connection.findPoint(lonPointAlias)).isObsolete() || lonPoint.isNew()) {
                this.unhash(lonPoint);
                connection.removePoint(lonPoint);
            }
        }
    }

    public GroupTable.UseCnt[] addressEntryUsage(BLonDevice bLonDevice) {
        Object object;
        NetMgmtConst netMgmtConst;
        GroupTable.UseCnt[] useCntArray = new GroupTable.UseCnt[bLonDevice.getDeviceData().getAddressCount()];
        int n = 0;
        while (n < useCntArray.length) {
            useCntArray[n] = new GroupTable.UseCnt();
            ++n;
        }
        n = this.getDeviceIndex(bLonDevice);
        int n2 = 0;
        while (n2 < this.table.length) {
            netMgmtConst = this.table[n2];
            while (netMgmtConst != null) {
                object = ((Connection)netMgmtConst).findAppDevice(bLonDevice);
                int n3 = 0;
                while (n3 < ((LonPoint[])object).length) {
                    block16: {
                        Object object2;
                        int n4;
                        block15: {
                            GroupMember groupMember;
                            LonPoint lonPoint = object[n3];
                            n4 = lonPoint.getAddressIndex();
                            if (n4 != -1) break block15;
                            int n5 = ((Connection)netMgmtConst).getAddressGroup();
                            if (n5 < 0 || (object2 = this.getGroupTable().getGroupArray()[n5]) == null || (groupMember = ((Group)object2).findMember(n)) == null) break block16;
                            n4 = groupMember.getAddressIndex();
                        }
                        if (n4 < useCntArray.length) {
                            ++useCntArray[n4].cnt;
                            GroupBitSet groupBitSet = ((Connection)netMgmtConst).getExcludeBitSet(this.lonDevices);
                            if (groupBitSet != null) {
                                if (useCntArray[n4].exclude == null) {
                                    useCntArray[n4].exclude = new GroupBitSet(groupBitSet);
                                } else {
                                    useCntArray[n4].exclude.or(groupBitSet);
                                }
                            }
                            object2 = ((Connection)netMgmtConst).getGroupBitSet(this.lonDevices);
                            if (useCntArray[n4].include == null) {
                                useCntArray[n4].include = new GroupBitSet((GroupBitSet)object2);
                            } else {
                                useCntArray[n4].include.or((GroupBitSet)object2);
                            }
                        }
                    }
                    ++n3;
                }
                netMgmtConst = ((Connection)netMgmtConst).getSecondary();
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < this.tagTable.size()) {
            netMgmtConst = (TagConnection)this.tagTable.elementAt(n2);
            if (((TagConnection)netMgmtConst).getAddressGroup() >= 0 && (object = ((TagConnection)netMgmtConst).findDevice(bLonDevice)) != null && ((TagPoint)object).getTagIndex() >= 0 && ((TagPoint)object).getTagIndex() < useCntArray.length) {
                ++useCntArray[((TagPoint)object).getTagIndex()].cnt;
                useCntArray[((TagPoint)object).getTagIndex()].mtag = true;
            }
            ++n2;
        }
        return useCntArray;
    }

    GroupBitSet getExcludesForGroup(int n) {
        GroupBitSet groupBitSet = null;
        int n2 = 0;
        while (n2 < this.table.length) {
            Connection connection = this.table[n2];
            while (connection != null) {
                GroupBitSet groupBitSet2;
                if (connection.getAddressGroup() == n && (groupBitSet2 = connection.getExcludeBitSet(this.lonDevices)) != null) {
                    if (groupBitSet == null) {
                        groupBitSet = new GroupBitSet(groupBitSet2);
                    } else {
                        groupBitSet.or(groupBitSet2);
                    }
                }
                connection = connection.getSecondary();
            }
            ++n2;
        }
        return groupBitSet;
    }

    public void changeEntry(BLonDevice bLonDevice, int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < this.table.length) {
            Connection connection = this.table[n4];
            while (connection != null) {
                LonPoint[] lonPointArray = connection.findAppDevice(bLonDevice);
                int n5 = 0;
                while (n5 < lonPointArray.length) {
                    LonPoint lonPoint = lonPointArray[n5];
                    if (lonPoint != null && lonPoint.getAddressIndex() == n2 && (lonPoint.isBound() || lonPoint.isNew())) {
                        if (this.debug) {
                            System.out.println(" changing address entry " + lonPoint + " to group " + n3);
                        }
                        lonPoint.setAddressIndex(n);
                        lonPoint.setStatus(BLonLinkStatus.newLink);
                        connection.setAddressGroup(n3);
                    }
                    ++n5;
                }
                connection = connection.getSecondary();
            }
            ++n4;
        }
    }

    public void reviewOverlapps() {
        if (this.debug) {
            System.out.println("\n\nReview overlapping connections.");
        }
        int n = 0;
        while (n < this.table.length) {
            Connection connection = this.table[n];
            if (connection != null) {
                Connection connection2 = connection;
                while (connection2 != null) {
                    connection2.removeObsoleteOverlappPnts();
                    connection2 = connection2.getSecondary();
                }
                connection2 = connection.removeNoOverlappSecondary();
                while (connection2 != null) {
                    if (connection == connection2) {
                        if (this.debug) {
                            System.out.println("\nRemove root in sel " + n);
                        }
                        this.table[connection.getSelector()] = connection.getSecondary();
                        connection = connection.getSecondary();
                        connection2.finalRemove();
                        connection2.removeAllSecondaries();
                        if (connection == null) {
                            break;
                        }
                    } else if (connection2.getHub() == null && connection2.getSecondary() == null) {
                        connection2.finalRemove();
                    } else {
                        int n2 = this.getNextSelector();
                        if (this.debug) {
                            System.out.println("\nMove connection from sel " + n + " to " + n2);
                        }
                        connection2.newSelector(n2);
                        this.table[n2] = connection2;
                    }
                    connection2 = connection.removeNoOverlappSecondary();
                }
            }
            ++n;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void verifyConnection() {
        if (this.debug) {
            System.out.println("\n\nDo connection verifications.");
        }
        var1_1 = 0;
        while (var1_1 < this.table.length) {
            block5: {
                var2_2 = this.table[var1_1];
                if (var2_2 == null) break block5;
                if (var2_2.removeEmpty()) {
                    this.table[var1_1] = var2_2.getSecondary();
                    var2_2 = this.table[var1_1];
                }
                if (var2_2 != null) ** GOTO lbl16
                break block5;
lbl-1000:
                // 1 sources

                {
                    if (var2_2.isActive()) {
                        var2_2.verifyConnection();
                        this.verifyAddress(var2_2);
                    }
                    var2_2 = var2_2.getSecondary();
lbl16:
                    // 2 sources

                    ** while (var2_2 != null)
                }
            }
            ++var1_1;
        }
    }

    private final void verifyAddress(Connection connection) {
        GroupBitSet groupBitSet;
        LonPoint lonPoint = connection.getHub();
        if (lonPoint == null) {
            return;
        }
        BIAddressEntry bIAddressEntry = lonPoint.getAddressEntry();
        if (bIAddressEntry == null) {
            return;
        }
        if (bIAddressEntry.getDomain() != lonPoint.getLonDevice().getWorkingDomain()) {
            lonPoint.setStatus(BLonLinkStatus.newLink);
            if (this.debug) {
                System.out.println("address entry domain mismatch ");
            }
            return;
        }
        if (lonPoint.getStatus() == BLonLinkStatus.descriptorError) {
            if (bIAddressEntry.isGroupAddress()) {
                this.groupTable.getGroup(bIAddressEntry.getGroupOrSubnet()).setStatus(1);
            }
            lonPoint.setStatus(BLonLinkStatus.newLink);
            if (this.debug) {
                System.out.println("descriptor mismatch: force update of " + bIAddressEntry);
            }
            return;
        }
        if (lonPoint.requiresAddressEntry() && bIAddressEntry.isSubnetNodeAddress()) {
            LonPoint lonPoint2 = connection.getActiveTargetNotTurnaround();
            if (lonPoint2 == null) {
                return;
            }
            BSubnetNode bSubnetNode = lonPoint2.getLonDevice().getDeviceData().getSubnetNodeId();
            if (!bSubnetNode.equals(bIAddressEntry.getSubnetNodeAddress())) {
                lonPoint.setStatus(BLonLinkStatus.newLink);
                if (this.debug) {
                    System.out.println("verifyAddress failed: hub entry " + bIAddressEntry + " tgt actual " + bSubnetNode + "\n for " + connection.toString(false));
                }
            }
            return;
        }
        GroupBitSet groupBitSet2 = connection.getGroupBitSet(this.lonDevices);
        if (!groupBitSet2.excludes(groupBitSet = connection.getExcludeBitSet(this.lonDevices))) {
            lonPoint.setStatus(BLonLinkStatus.groupExcludeError);
            if (this.debug) {
                System.out.println("group exclude error \n must contain:" + groupBitSet2 + "\n must exclude:" + groupBitSet + "\n for " + connection.toString(false));
            }
            return;
        }
        int n = connection.getAddressGroup();
        if (n == -1) {
            return;
        }
        Group group = this.getGroupTable().getGroup(n);
        if (!group.getBitSet().contains(groupBitSet2, groupBitSet)) {
            lonPoint.setStatus(BLonLinkStatus.newLink);
            if (this.debug) {
                System.out.println("verifyAddress failed for " + n + "\ngroup set=" + group.getBitSet() + "\n must contain:" + groupBitSet2 + "\n must exclude:" + groupBitSet + "\n for " + connection.toString(false));
            }
        }
    }

    public BLinkEntryTable getLonLinkTable() {
        BLinkEntryTable bLinkEntryTable = new BLinkEntryTable();
        int n = 0;
        int n2 = 0;
        while (n2 < this.table.length) {
            Connection connection = this.table[n2];
            while (connection != null) {
                BLonLinkStatus bLonLinkStatus;
                String string;
                String string2;
                LonPoint lonPoint = connection.getHub();
                if (lonPoint == null) {
                    string2 = "none";
                    string = "none";
                    bLonLinkStatus = BLonLinkStatus.error;
                } else {
                    string2 = lonPoint.getDeviceName();
                    string = lonPoint.getNvName();
                    bLonLinkStatus = lonPoint.getStatus();
                }
                LonPoint[] lonPointArray = connection.getTargets();
                String string3 = connection.getLinkType().getTag() + (connection.getPriority() ? " Priority" : "");
                if (lonPointArray.length == 0) {
                    bLinkEntryTable.addEntry(new BLinkEntry(n2, bLonLinkStatus, string2, string, "none", "none", string3), n++);
                }
                int n3 = 0;
                while (n3 < lonPointArray.length) {
                    LonPoint lonPoint2 = lonPointArray[n3];
                    bLonLinkStatus = this.getLinkStatus(lonPoint, lonPoint2, connection);
                    while (lonPoint2 != null) {
                        bLinkEntryTable.addEntry(new BLinkEntry(n2, bLonLinkStatus, string2, string, lonPoint2.getDeviceName(), lonPoint2.getNvName(), string3), n++);
                        LonPoint lonPoint3 = lonPoint2 = lonPoint2.isProxy() ? ((LonPointProxy)lonPoint2).sec : null;
                    }
                    ++n3;
                }
                connection = connection.getSecondary();
            }
            ++n2;
        }
        if (this.debug) {
            System.out.println("\n dump network variable link table");
            BLinkEntry[] bLinkEntryArray = bLinkEntryTable.getLinkEntries();
            int n4 = 0;
            while (n4 < bLinkEntryArray.length) {
                System.out.println(bLinkEntryArray[n4].toString());
                ++n4;
            }
        }
        return bLinkEntryTable;
    }

    public BTagLinkEntryTable getLonMessageTagTable() {
        Vector<BTagLinkEntry> vector = new Vector<BTagLinkEntry>(50);
        TagConnection[] tagConnectionArray = this.getMessageTagTable();
        int n = 0;
        while (n < tagConnectionArray.length) {
            TagPoint tagPoint = tagConnectionArray[n].getOutput();
            TagPoint[] tagPointArray = tagConnectionArray[n].getInputs();
            if (tagPointArray.length == 0) {
                vector.addElement(new BTagLinkEntry(tagPoint.getStatus(), tagPoint.getDeviceName(), tagPoint.getTagName(), "n/a", "n/a"));
            } else {
                int n2 = 0;
                while (n2 < tagPointArray.length) {
                    vector.addElement(new BTagLinkEntry(tagPoint.getStatus(), tagPoint.getDeviceName(), tagPoint.getTagName(), tagPointArray[n2].getDeviceName(), tagPointArray[n2].getTagName()));
                    ++n2;
                }
            }
            ++n;
        }
        BTagLinkEntry[] bTagLinkEntryArray = new BTagLinkEntry[vector.size()];
        vector.copyInto((Object[])bTagLinkEntryArray);
        if (this.debug) {
            System.out.println("\n dump message tag link table");
            int n3 = 0;
            while (n3 < bTagLinkEntryArray.length) {
                System.out.println("" + n3 + ' ' + bTagLinkEntryArray[n3].toString());
                ++n3;
            }
        }
        return new BTagLinkEntryTable(bTagLinkEntryArray);
    }

    private final BLonLinkStatus getLinkStatus(LonPoint lonPoint, LonPoint lonPoint2, Connection connection) {
        if (connection.isPollOnly()) {
            return BLonLinkStatus.pollOnly;
        }
        BLonLinkStatus bLonLinkStatus = lonPoint != null && (lonPoint.isNew() && lonPoint2 != null && lonPoint2.isBound() || lonPoint.isError() || lonPoint2 == null) ? lonPoint.getStatus() : lonPoint2.getStatus();
        int n = connection.getAddressGroup();
        Group[] groupArray = this.getGroupTable().getGroupArray();
        if (bLonLinkStatus == BLonLinkStatus.bound && n >= 0 && (groupArray[n] == null || groupArray[n].getStatus() != 2)) {
            bLonLinkStatus = BLonLinkStatus.dirtyGroup;
        }
        return bLonLinkStatus;
    }

    public int groupUse(int n) {
        return this.groupUse(n, false);
    }

    public int groupUse(int n, boolean bl) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.table.length) {
            Connection connection = this.table[n3];
            while (connection != null) {
                if (connection.getAddressGroup() == n && (!bl || connection.isActive())) {
                    ++n2;
                }
                connection = connection.getSecondary();
            }
            ++n3;
        }
        TagConnection[] tagConnectionArray = this.getMessageTagTable();
        int n4 = 0;
        while (n4 < tagConnectionArray.length) {
            if (tagConnectionArray[n4].getAddressGroup() == n && (!bl || tagConnectionArray[n4].isActive())) {
                ++n2;
            }
            ++n4;
        }
        return n2;
    }

    public int getSelector(LonPoint lonPoint) {
        return this.getSelector(lonPoint.hashCode());
    }

    public int getSelector(int n) {
        Object object = this.pointHash.get(n);
        return object == null ? -1 : (Integer)object;
    }

    public void hash(LonPoint lonPoint, int n) {
        this.pointHash.put(lonPoint.hashCode(), (Object)new Integer(n));
    }

    public void unhash(LonPoint lonPoint) {
        int n = lonPoint.hashCode();
        this.pointHash.remove(n);
    }

    private final boolean isSecondProxy(LonPointProxy lonPointProxy) {
        int n = lonPointProxy.hashCode();
        LonPointProxy lonPointProxy2 = (LonPointProxy)this.proxyHash.get(n);
        if (lonPointProxy2 != null) {
            lonPointProxy.sec = lonPointProxy2.sec;
            lonPointProxy2.sec = lonPointProxy;
            return true;
        }
        this.proxyHash.put(n, (Object)lonPointProxy);
        return false;
    }

    private final void addTagLink(BLonDevice bLonDevice, BLonLink bLonLink, boolean bl) {
        TagPoint tagPoint;
        if (this.debug) {
            System.out.println("\n addTaglink ->" + (Object)((Object)bLonLink));
        }
        BLonDevice bLonDevice2 = (BLonDevice)bLonLink.getSourceComponent();
        BMessageTag bMessageTag = (BMessageTag)bLonDevice2.get(bLonLink.getSourceSlot().asProperty());
        BMessageTag bMessageTag2 = (BMessageTag)bLonDevice.get(bLonLink.getTargetSlot().asProperty());
        TagConnection tagConnection = (TagConnection)this.tagHash.get(TagPoint.hashCode(bLonDevice2, bMessageTag.getIndex()));
        if (tagConnection == null) {
            tagPoint = new TagPoint(bLonDevice2, bMessageTag.getIndex(), BLonLinkStatus.newLink, bMessageTag.getName());
            tagConnection = this.addTagConnection(tagPoint);
            if (this.debug) {
                System.out.println("\n  added new tagConnection");
            }
        } else {
            tagPoint = tagConnection.getOutput();
            tagPoint.setName(bMessageTag.getName());
        }
        tagPoint = new TagPoint(bLonDevice, bMessageTag2.getIndex(), BLonLinkStatus.newLink, bMessageTag2.getName());
        tagConnection.addInput(tagPoint);
        int n = TagPoint.hashCode(bLonDevice, bMessageTag2.getIndex());
        TagConnection tagConnection2 = (TagConnection)this.tagHash.get(n);
        if (tagConnection2 != null) {
            this.tagHash.remove(n);
            this.tagTable.removeElement(tagConnection2);
            tagPoint.setStatus(BLonLinkStatus.bound);
            if (this.debug) {
                System.out.println("\n  mtag moved to new conn - remove tagConnection" + tagConnection2);
            }
        }
        if (this.debug) {
            System.out.println("\n  add input tag point " + tagPoint + '\n' + tagConnection);
        }
    }

    private final void addMessageTags(BLonDevice bLonDevice) {
        int n = bLonDevice.getDeviceData().getMsgTagCount();
        if (n <= 0) {
            return;
        }
        BDeviceData bDeviceData = bLonDevice.getDeviceData();
        int n2 = 0;
        while (n2 < n) {
            BIAddressEntry bIAddressEntry = bDeviceData.getAddressEntry(n2);
            if (bIAddressEntry.getAddressType() != BAddressType.none) {
                TagPoint tagPoint = new TagPoint(bLonDevice, n2, BLonLinkStatus.obsolete);
                TagConnection tagConnection = this.addTagConnection(tagPoint);
                tagConnection.setAddressEntry(bIAddressEntry);
                if (this.debug) {
                    System.out.println("\n  added new tagConnection \n    " + tagConnection);
                }
            }
            ++n2;
        }
    }

    private final void setMessageTagStatus() {
        TagConnection[] tagConnectionArray = this.getMessageTagTable();
        int n = 0;
        while (n < tagConnectionArray.length) {
            tagConnectionArray[n].setMessageTagStatus(this, this.getGroupTable());
            ++n;
        }
    }

    private final TagConnection addTagConnection(TagPoint tagPoint) {
        TagConnection tagConnection = new TagConnection(tagPoint, this.debug);
        this.tagTable.addElement(tagConnection);
        this.tagHash.put(tagPoint.hashCode(), (Object)tagConnection);
        return tagConnection;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nConnection Table\n=============================================== \n");
        int n = 0;
        while (n < this.table.length) {
            if (this.table[n] != null) {
                stringBuffer.append(n).append(" ").append(this.table[n]).append("\n");
            }
            ++n;
        }
        n = 0;
        while (n < this.tagTable.size()) {
            stringBuffer.append(n).append(" ").append(this.tagTable.elementAt(n)).append("\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    public BLonDevice getDevice(int n) {
        return this.lonDevices[n];
    }

    public int getDeviceIndex(BLonDevice bLonDevice) {
        return ConnectionTable.getDeviceIndex(this.lonDevices, bLonDevice);
    }

    public static int getDeviceIndex(BLonDevice[] bLonDeviceArray, BLonDevice bLonDevice) {
        int n = 0;
        while (n < bLonDeviceArray.length) {
            if (bLonDeviceArray[n] == bLonDevice) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.unresolved = new Vector();
        this.table = new Connection[INITIAL_CONNECTIONS];
        this.pointHash = new IntHashMap(INITIAL_CONNECTIONS * 2);
        this.tagTable = new Vector(10);
        this.tagHash = new IntHashMap(32);
        this.proxyHash = new IntHashMap(500);
    }

    public ConnectionTable(BLonNetwork bLonNetwork) {
        this(bLonNetwork, false, bLonNetwork.getLonNetmgmt().getDebug());
    }

    public ConnectionTable(BLonNetwork bLonNetwork, boolean bl, boolean bl2) {
        Class clazz;
        BLonDevice bLonDevice;
        this.this();
        this.lonworks = bLonNetwork;
        AddressManager addressManager = bLonNetwork.addressManager();
        this.lonDevices = addressManager.getDeviceList(true);
        this.local = bLonNetwork.getLocalLonDevice();
        this.debug = bl2;
        if (bl2) {
            System.out.println("Create connection table.");
        }
        int n = 0;
        while (n < this.lonDevices.length) {
            bLonDevice = this.lonDevices[n];
            if (bLonDevice != null) {
                BINvContainer[] bINvContainerArray = bLonDevice.getNvContainers();
                int n2 = 0;
                while (n2 < bINvContainerArray.length) {
                    this.addBoundNv(bINvContainerArray[n2]);
                    ++n2;
                }
                this.addAliasNv(bLonDevice);
                this.addMessageTags(bLonDevice);
            }
            ++n;
        }
        if (bl2) {
            System.out.println(this.toString());
        }
        if (bl2) {
            System.out.println("\nadd proxy and pseudo points\n");
        }
        n = 0;
        while (n < this.lonDevices.length) {
            bLonDevice = this.lonDevices[n];
            if (bLonDevice != null) {
                this.addProxyLinks(bLonDevice);
            }
            ++n;
        }
        if (bl2) {
            System.out.println(this.toString());
        }
        if ((clazz = class$com$tridium$lonworks$local$BPseudoNV) == null) {
            clazz = class$com$tridium$lonworks$local$BPseudoNV = ConnectionTable.class("[Lcom.tridium.lonworks.local.BPseudoNV;", false);
        }
        BPseudoNV[] bPseudoNVArray = (BPseudoNV[])NmUtil.getDecendantsByClass((BComponent)bLonNetwork, clazz);
        int n3 = 0;
        while (n3 < bPseudoNVArray.length) {
            this.addPseudoNv(bPseudoNVArray[n3]);
            ++n3;
        }
        if (bl2) {
            System.out.println(this.toString());
        }
        GroupTable groupTable = this.getGroupTable();
        if (bl2) {
            System.out.println("\nparse overlapping targets\n");
        }
        int n4 = 0;
        while (n4 < this.table.length) {
            if (this.table[n4] != null) {
                this.table[n4].parseTargets(groupTable);
            }
            ++n4;
        }
        if (bl2) {
            System.out.println(this.toString());
        }
        n4 = 0;
        while (n4 < this.lonDevices.length) {
            BLonDevice bLonDevice2 = this.lonDevices[n4];
            if (bLonDevice2 != null) {
                BINvContainer[] bINvContainerArray = bLonDevice2.getNvContainers();
                int n5 = 0;
                while (n5 < bINvContainerArray.length) {
                    this.addLinks(bINvContainerArray[n5]);
                    ++n5;
                }
            }
            ++n4;
        }
        if (bl2) {
            System.out.println(this.toString());
        }
        this.processUnresolved();
        if (bl2) {
            System.out.println(this.toString());
        }
        if (!bl) {
            this.reviewOverlapps();
        }
        if (bl2) {
            System.out.println(this.toString());
        }
        if (!bl) {
            this.processAliasConnections();
        }
        if (bl2) {
            System.out.println(this.toString());
        }
        this.setMessageTagStatus();
        if (bl2) {
            System.out.println(this.toString());
        }
        this.verifyConnection();
        if (bl2) {
            System.out.println(this.toString());
        }
    }

    private static class UnresolvedLink {
        LonPoint srcPnt;
        LonPoint tgtPnt;
        BLonLinkType linkType;
        boolean priority;

        UnresolvedLink(LonPoint lonPoint, LonPoint lonPoint2, BLonLinkType bLonLinkType, boolean bl) {
            this.srcPnt = lonPoint;
            this.tgtPnt = lonPoint2;
            this.linkType = bLonLinkType;
            this.priority = bl;
        }
    }
}

