/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.netmgmt;

import com.tridium.lonworks.datatypes.BSetServiceTypeParameter;
import com.tridium.lonworks.netmgmt.BLonNetmgmt;
import com.tridium.lonworks.netmgmt.BLonNetmgmtJob;
import com.tridium.lonworks.netmgmt.Connection;
import com.tridium.lonworks.netmgmt.ConnectionTable;
import com.tridium.lonworks.netmgmt.LonPoint;
import com.tridium.lonworks.netmgmt.LonPointProxy;
import com.tridium.lonworks.netmgmt.NetMgmtConst;
import com.tridium.lonworks.util.NmUtil;
import java.util.StringTokenizer;
import javax.baja.lonworks.BLonLink;
import javax.baja.lonworks.BNetworkVariable;
import javax.baja.lonworks.datatypes.BNvConfigData;
import javax.baja.lonworks.datatypes.BNvProps;
import javax.baja.lonworks.enums.BLonLinkType;
import javax.baja.lonworks.proxy.BLonProxyExt;
import javax.baja.sys.BComponent;
import javax.baja.sys.Knob;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BLonSetServiceTypeJob
extends BLonNetmgmtJob
implements NetMgmtConst {
    public static final Type TYPE;
    private ConnectionTable connTable;
    private BSetServiceTypeParameter param;
    static /* synthetic */ Class class$com$tridium$lonworks$netmgmt$BLonSetServiceTypeJob;

    public Type getType() {
        return TYPE;
    }

    public void run() {
        String string = this.param.getSelector();
        BLonLinkType bLonLinkType = this.param.getLinkType();
        boolean bl = this.param.getPriority();
        this.log().start("SetServiceType for selector " + string + ' ' + (Object)((Object)bLonLinkType) + (bl ? "/priority" : ""));
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",. ");
            while (stringTokenizer.hasMoreTokens()) {
                int n = Integer.decode(stringTokenizer.nextToken());
                Connection connection = this.connTable.getConnection(n);
                while (connection != null) {
                    if ((connection.getLinkType() != bLonLinkType || connection.getPriority() != bl) && this.isChangeLegal(connection.getHub(), bLonLinkType, bl)) {
                        this.changeLinkType(connection, bLonLinkType, bl);
                    }
                    connection = connection.getSecondary();
                }
            }
        }
        catch (Throwable throwable) {
            this.fatal("Unexpected exception in BLonSetServiceTypeJob.", throwable);
        }
        this.netMgmt.doRefreshLinkTable();
        this.end();
    }

    private final boolean isChangeLegal(LonPoint lonPoint, BLonLinkType bLonLinkType, boolean bl) {
        if (bLonLinkType == BLonLinkType.pollOnly) {
            return true;
        }
        BNvProps bNvProps = lonPoint.getNvProps();
        BNvConfigData bNvConfigData = lonPoint.getNvConfigData();
        if (!bNvProps.getServiceConf() && bNvConfigData.getServiceType() != NmUtil.linkTypeToServiceType(bLonLinkType)) {
            this.fatal("Service type not configurable in " + lonPoint.getSummaryString());
            return false;
        }
        if (!bNvProps.getAuthConf()) {
            boolean bl2 = bNvConfigData.getAuthenticated();
            boolean bl3 = false;
            if (bLonLinkType == BLonLinkType.authenticated) {
                bl3 = true;
            }
            if (bl2 != bl3) {
                this.fatal("Authenticate not configurable in " + lonPoint.getSummaryString());
                return false;
            }
        }
        if (!bNvProps.getPriorityConf() && bNvConfigData.getPriority() != bl) {
            this.fatal("Priority not configurable in " + lonPoint.getSummaryString());
            return false;
        }
        return true;
    }

    private final void changeLinkType(Connection connection, BLonLinkType bLonLinkType, boolean bl) {
        try {
            LonPoint lonPoint = connection.getHub();
            if (lonPoint == null) {
                return;
            }
            if (lonPoint.isProxy()) {
                BLonProxyExt bLonProxyExt = ((LonPointProxy)lonPoint).getProxyExtension();
                bLonProxyExt.setLinkType(bLonLinkType);
                bLonProxyExt.setPriority(bl);
            } else {
                BNetworkVariable bNetworkVariable = lonPoint.getNetworkVariable();
                Knob[] knobArray = ((BComponent)bNetworkVariable.getParent()).getKnobs((Slot)bNetworkVariable.getPropertyInParent());
                int n = 0;
                while (n < knobArray.length) {
                    BLonLink bLonLink = (BLonLink)knobArray[n].getLink();
                    this.updateLink(bLonLink, bLonLinkType, bl);
                    ++n;
                }
                LonPoint[] lonPointArray = connection.getTargets();
                int n2 = 0;
                while (n2 < lonPointArray.length) {
                    if (lonPointArray[n2].isProxy()) {
                        LonPointProxy lonPointProxy = (LonPointProxy)lonPointArray[n2];
                        while (lonPointProxy != null) {
                            BLonProxyExt bLonProxyExt = lonPointProxy.getProxyExtension();
                            bLonProxyExt.setLinkType(bLonLinkType);
                            bLonProxyExt.setPriority(bl);
                            lonPointProxy = lonPointProxy.sec;
                        }
                    }
                    ++n2;
                }
            }
        }
        catch (Throwable throwable) {
            this.fatal("Unable to change link type for selector " + connection.getSelector());
        }
    }

    private final void updateLink(BLonLink bLonLink, BLonLinkType bLonLinkType, boolean bl) {
        BNetworkVariable bNetworkVariable;
        BNetworkVariable bNetworkVariable2 = null;
        BComponent bComponent = null;
        Property property = null;
        boolean bl2 = false;
        if (!bLonLink.getMessageTag() && (bNetworkVariable = bLonLink.getDestinationNv()).getPropertyInParent().isFrozen()) {
            bNetworkVariable2 = bNetworkVariable;
            bComponent = (BComponent)bNetworkVariable.getParent();
            property = bNetworkVariable.getPropertyInParent();
            bl2 = true;
        }
        bLonLink.setLinkType(bLonLinkType);
        bLonLink.setPriority(bl);
        if (bl2) {
            bNetworkVariable = (BNetworkVariable)bComponent.get(property);
            bNetworkVariable.setNvProps((BNvProps)bNetworkVariable2.getNvProps().newCopy(true));
            bNetworkVariable.setNvConfigData((BNvConfigData)bNetworkVariable2.getNvConfigData().newCopy(true));
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BLonSetServiceTypeJob() {
    }

    public BLonSetServiceTypeJob(BLonNetmgmt bLonNetmgmt, BSetServiceTypeParameter bSetServiceTypeParameter) {
        super(bLonNetmgmt);
        this.connTable = new ConnectionTable(bLonNetmgmt.lonNetwork());
        this.param = bSetServiceTypeParameter;
    }

    static {
        Class clazz = class$com$tridium$lonworks$netmgmt$BLonSetServiceTypeJob;
        if (clazz == null) {
            clazz = class$com$tridium$lonworks$netmgmt$BLonSetServiceTypeJob = BLonSetServiceTypeJob.class("[Lcom.tridium.lonworks.netmgmt.BLonSetServiceTypeJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

