/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.netmgmt;

import com.tridium.lonworks.BLonRouter;
import com.tridium.lonworks.datatypes.BAppDownloadParameter;
import com.tridium.lonworks.datatypes.BCommissionParameter;
import com.tridium.lonworks.datatypes.BDescriptorTable;
import com.tridium.lonworks.datatypes.BDeviceEntry;
import com.tridium.lonworks.datatypes.BDeviceEntryTable;
import com.tridium.lonworks.datatypes.BDiscoverParameter;
import com.tridium.lonworks.datatypes.BLearnParameter;
import com.tridium.lonworks.datatypes.BLinkEntryTable;
import com.tridium.lonworks.datatypes.BMatchParameter;
import com.tridium.lonworks.datatypes.BRouterEntry;
import com.tridium.lonworks.datatypes.BRouterEntryTable;
import com.tridium.lonworks.datatypes.BServicePinData;
import com.tridium.lonworks.datatypes.BSetServiceTypeParameter;
import com.tridium.lonworks.datatypes.BTagLinkEntry;
import com.tridium.lonworks.datatypes.BTagLinkEntryTable;
import com.tridium.lonworks.datatypes.BUtilitiesCommand;
import com.tridium.lonworks.netmessages.ServicePin;
import com.tridium.lonworks.netmgmt.BLonAppDownloadJob;
import com.tridium.lonworks.netmgmt.BLonBindJob;
import com.tridium.lonworks.netmgmt.BLonCommissionJob;
import com.tridium.lonworks.netmgmt.BLonCommissionRouterJob;
import com.tridium.lonworks.netmgmt.BLonDiscoverJob;
import com.tridium.lonworks.netmgmt.BLonLearnJob;
import com.tridium.lonworks.netmgmt.BLonLearnLinksJob;
import com.tridium.lonworks.netmgmt.BLonReplaceJob;
import com.tridium.lonworks.netmgmt.BLonSetServiceTypeJob;
import com.tridium.lonworks.netmgmt.BLonUpdateRoutersJob;
import com.tridium.lonworks.netmgmt.ConnectionTable;
import com.tridium.lonworks.netmgmt.LonUtilRequest;
import com.tridium.lonworks.netmgmt.ProcessServicePin;
import com.tridium.lonworks.util.NmUtil;
import com.tridium.lonworks.util.RouterUtil;
import com.tridium.sys.station.Station;
import java.io.PrintWriter;
import javax.baja.log.Log;
import javax.baja.lonworks.AddressManager;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.datatypes.BAuthenticationKey;
import javax.baja.lonworks.datatypes.BDeviceData;
import javax.baja.lonworks.datatypes.BDomainId;
import javax.baja.lonworks.datatypes.BNeuronId;
import javax.baja.lonworks.datatypes.BSubnetNode;
import javax.baja.naming.BOrd;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BLonNetmgmt
extends BComponent {
    public static final Property deviceDiscoverTable = BLonNetmgmt.newProperty((int)6, (BValue)new BDeviceEntryTable(), null);
    public static final Property routerDiscoverTable = BLonNetmgmt.newProperty((int)6, (BValue)new BRouterEntryTable(), null);
    public static final Property domainId = BLonNetmgmt.newProperty((int)0, (BValue)BDomainId.DEFAULT, null);
    public static final Property authenticate = BLonNetmgmt.newProperty((int)0, (boolean)false, null);
    public static final Property authenticationKey = BLonNetmgmt.newProperty((int)0, (BValue)BAuthenticationKey.DEFAULT, null);
    public static final Property linkDescriptors = BLonNetmgmt.newProperty((int)0, (BValue)new BDescriptorTable(), null);
    public static final Property nonGroupTimer = BLonNetmgmt.newProperty((int)0, (int)4, null);
    public static final Property channelPriorities = BLonNetmgmt.newProperty((int)0, (int)0, null);
    public static final Property debug = BLonNetmgmt.newProperty((int)0, (boolean)false, null);
    public static final Property verifyNvDir = BLonNetmgmt.newProperty((int)0, (boolean)false, null);
    public static final Property servicePinWait = BLonNetmgmt.newProperty((int)0, (int)300, (BFacets)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"second")));
    public static final Property enabled = BLonNetmgmt.newProperty((int)7, (boolean)true, null);
    public static final Property tempBridge = BLonNetmgmt.newProperty((int)5, (boolean)false, null);
    public static final Property useLonObjects = BLonNetmgmt.newProperty((int)0, (boolean)false, null);
    public static final Property alwaysInZeroLengthDomain = BLonNetmgmt.newProperty((int)0, (boolean)false, null);
    public static final Action discover = BLonNetmgmt.newAction((int)4, null);
    public static final Action discoverSelect = BLonNetmgmt.newAction((int)4, (BValue)new BDiscoverParameter(), null);
    public static final Action learn = BLonNetmgmt.newAction((int)4, (BValue)new BLearnParameter(), null);
    public static final Action match = BLonNetmgmt.newAction((int)4, (BValue)new BMatchParameter(), null);
    public static final Action commissionDevice = BLonNetmgmt.newAction((int)4, (BValue)new BCommissionParameter(), null);
    public static final Action replaceDevice = BLonNetmgmt.newAction((int)4, (BValue)new BCommissionParameter(), null);
    public static final Action commissionRouter = BLonNetmgmt.newAction((int)4, (BValue)new BCommissionParameter(), null);
    public static final Action replaceRouter = BLonNetmgmt.newAction((int)4, (BValue)new BCommissionParameter(), null);
    public static final Action setServiceType = BLonNetmgmt.newAction((int)4, (BValue)new BSetServiceTypeParameter(), null);
    public static final Action bind = BLonNetmgmt.newAction((int)4, null);
    public static final Action bindLinkEntry = BLonNetmgmt.newAction((int)4, (BValue)BString.DEFAULT, null);
    public static final Action bindTagLinkEntry = BLonNetmgmt.newAction((int)4, (BValue)new BTagLinkEntry(), null);
    public static final Action bindDevice = BLonNetmgmt.newAction((int)4, (BValue)new BLonDevice(), null);
    public static final Action refreshLinkTable = BLonNetmgmt.newAction((int)4, null);
    public static final Action tempBridgeOn = BLonNetmgmt.newAction((int)0, null);
    public static final Action tempBridgeOff = BLonNetmgmt.newAction((int)0, null);
    public static final Action appDownLoad = BLonNetmgmt.newAction((int)4, (BValue)new BAppDownloadParameter(), null);
    public static final Action deviceForSubnetNodeId = BLonNetmgmt.newAction((int)4, (BValue)BSubnetNode.DEFAULT, null);
    public static final Action deviceForNeuronId = BLonNetmgmt.newAction((int)4, (BValue)BNeuronId.DEFAULT, null);
    public static final Action updateRouters = BLonNetmgmt.newAction((int)0, null);
    public static final Action cancelServicePin = BLonNetmgmt.newAction((int)0, null);
    public static final Topic deviceDiscoveryUpdated = BLonNetmgmt.newTopic((int)0, null);
    public static final Topic routerDiscoveryUpdated = BLonNetmgmt.newTopic((int)0, null);
    public static final Topic devicesUpdated = BLonNetmgmt.newTopic((int)0, null);
    public static final Topic routersUpdated = BLonNetmgmt.newTopic((int)0, null);
    public static final Topic linksUpdated = BLonNetmgmt.newTopic((int)0, null);
    public static final Topic tagLinksUpdated = BLonNetmgmt.newTopic((int)0, null);
    public static final Topic servicePinReceived = BLonNetmgmt.newTopic((int)0, null);
    public static final Topic learnComplete = BLonNetmgmt.newTopic((int)0, null);
    public static final Type TYPE;
    private static final BIcon icon;
    static /* synthetic */ Class class$com$tridium$lonworks$netmgmt$BLonNetmgmt;

    public BDeviceEntryTable getDeviceDiscoverTable() {
        return (BDeviceEntryTable)this.get(deviceDiscoverTable);
    }

    public void setDeviceDiscoverTable(BDeviceEntryTable bDeviceEntryTable) {
        this.set(deviceDiscoverTable, (BValue)bDeviceEntryTable, null);
    }

    public BRouterEntryTable getRouterDiscoverTable() {
        return (BRouterEntryTable)this.get(routerDiscoverTable);
    }

    public void setRouterDiscoverTable(BRouterEntryTable bRouterEntryTable) {
        this.set(routerDiscoverTable, (BValue)bRouterEntryTable, null);
    }

    public BDomainId getDomainId() {
        return (BDomainId)this.get(domainId);
    }

    public void setDomainId(BDomainId bDomainId) {
        this.set(domainId, (BValue)bDomainId, null);
    }

    public boolean getAuthenticate() {
        return this.getBoolean(authenticate);
    }

    public void setAuthenticate(boolean bl) {
        this.setBoolean(authenticate, bl, null);
    }

    public BAuthenticationKey getAuthenticationKey() {
        return (BAuthenticationKey)this.get(authenticationKey);
    }

    public void setAuthenticationKey(BAuthenticationKey bAuthenticationKey) {
        this.set(authenticationKey, (BValue)bAuthenticationKey, null);
    }

    public BDescriptorTable getLinkDescriptors() {
        return (BDescriptorTable)this.get(linkDescriptors);
    }

    public void setLinkDescriptors(BDescriptorTable bDescriptorTable) {
        this.set(linkDescriptors, (BValue)bDescriptorTable, null);
    }

    public int getNonGroupTimer() {
        return this.getInt(nonGroupTimer);
    }

    public void setNonGroupTimer(int n) {
        this.setInt(nonGroupTimer, n, null);
    }

    public int getChannelPriorities() {
        return this.getInt(channelPriorities);
    }

    public void setChannelPriorities(int n) {
        this.setInt(channelPriorities, n, null);
    }

    public boolean getDebug() {
        return this.getBoolean(debug);
    }

    public void setDebug(boolean bl) {
        this.setBoolean(debug, bl, null);
    }

    public boolean getVerifyNvDir() {
        return this.getBoolean(verifyNvDir);
    }

    public void setVerifyNvDir(boolean bl) {
        this.setBoolean(verifyNvDir, bl, null);
    }

    public int getServicePinWait() {
        return this.getInt(servicePinWait);
    }

    public void setServicePinWait(int n) {
        this.setInt(servicePinWait, n, null);
    }

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean bl) {
        this.setBoolean(enabled, bl, null);
    }

    public boolean getTempBridge() {
        return this.getBoolean(tempBridge);
    }

    public void setTempBridge(boolean bl) {
        this.setBoolean(tempBridge, bl, null);
    }

    public boolean getUseLonObjects() {
        return this.getBoolean(useLonObjects);
    }

    public void setUseLonObjects(boolean bl) {
        this.setBoolean(useLonObjects, bl, null);
    }

    public boolean getAlwaysInZeroLengthDomain() {
        return this.getBoolean(alwaysInZeroLengthDomain);
    }

    public void setAlwaysInZeroLengthDomain(boolean bl) {
        this.setBoolean(alwaysInZeroLengthDomain, bl, null);
    }

    public BOrd discover() {
        return (BOrd)this.invoke(discover, null, null);
    }

    public BOrd discoverSelect(BDiscoverParameter bDiscoverParameter) {
        return (BOrd)this.invoke(discoverSelect, (BValue)bDiscoverParameter, null);
    }

    public BOrd learn(BLearnParameter bLearnParameter) {
        return (BOrd)this.invoke(learn, (BValue)bLearnParameter, null);
    }

    public BBoolean match(BMatchParameter bMatchParameter) {
        return (BBoolean)this.invoke(match, (BValue)bMatchParameter, null);
    }

    public BOrd commissionDevice(BCommissionParameter bCommissionParameter) {
        return (BOrd)this.invoke(commissionDevice, (BValue)bCommissionParameter, null);
    }

    public BOrd replaceDevice(BCommissionParameter bCommissionParameter) {
        return (BOrd)this.invoke(replaceDevice, (BValue)bCommissionParameter, null);
    }

    public BOrd commissionRouter(BCommissionParameter bCommissionParameter) {
        return (BOrd)this.invoke(commissionRouter, (BValue)bCommissionParameter, null);
    }

    public BOrd replaceRouter(BCommissionParameter bCommissionParameter) {
        return (BOrd)this.invoke(replaceRouter, (BValue)bCommissionParameter, null);
    }

    public BOrd setServiceType(BSetServiceTypeParameter bSetServiceTypeParameter) {
        return (BOrd)this.invoke(setServiceType, (BValue)bSetServiceTypeParameter, null);
    }

    public BOrd bind() {
        return (BOrd)this.invoke(bind, null, null);
    }

    public BOrd bindLinkEntry(BString bString) {
        return (BOrd)this.invoke(bindLinkEntry, (BValue)bString, null);
    }

    public BOrd bindTagLinkEntry(BTagLinkEntry bTagLinkEntry) {
        return (BOrd)this.invoke(bindTagLinkEntry, (BValue)bTagLinkEntry, null);
    }

    public BOrd bindDevice(BLonDevice bLonDevice) {
        return (BOrd)this.invoke(bindDevice, (BValue)bLonDevice, null);
    }

    public void refreshLinkTable() {
        this.invoke(refreshLinkTable, null, null);
    }

    public void tempBridgeOn() {
        this.invoke(tempBridgeOn, null, null);
    }

    public void tempBridgeOff() {
        this.invoke(tempBridgeOff, null, null);
    }

    public BOrd appDownLoad(BAppDownloadParameter bAppDownloadParameter) {
        return (BOrd)this.invoke(appDownLoad, (BValue)bAppDownloadParameter, null);
    }

    public BOrd deviceForSubnetNodeId(BSubnetNode bSubnetNode) {
        return (BOrd)this.invoke(deviceForSubnetNodeId, (BValue)bSubnetNode, null);
    }

    public BOrd deviceForNeuronId(BNeuronId bNeuronId) {
        return (BOrd)this.invoke(deviceForNeuronId, (BValue)bNeuronId, null);
    }

    public BOrd updateRouters() {
        return (BOrd)this.invoke(updateRouters, null, null);
    }

    public void cancelServicePin() {
        this.invoke(cancelServicePin, null, null);
    }

    public void fireDeviceDiscoveryUpdated(BDeviceEntryTable bDeviceEntryTable) {
        this.fire(deviceDiscoveryUpdated, (BValue)bDeviceEntryTable, null);
    }

    public void fireRouterDiscoveryUpdated(BRouterEntryTable bRouterEntryTable) {
        this.fire(routerDiscoveryUpdated, (BValue)bRouterEntryTable, null);
    }

    public void fireDevicesUpdated(BDeviceEntryTable bDeviceEntryTable) {
        this.fire(devicesUpdated, (BValue)bDeviceEntryTable, null);
    }

    public void fireRoutersUpdated(BRouterEntryTable bRouterEntryTable) {
        this.fire(routersUpdated, (BValue)bRouterEntryTable, null);
    }

    public void fireLinksUpdated(BLinkEntryTable bLinkEntryTable) {
        this.fire(linksUpdated, (BValue)bLinkEntryTable, null);
    }

    public void fireTagLinksUpdated(BTagLinkEntryTable bTagLinkEntryTable) {
        this.fire(tagLinksUpdated, (BValue)bTagLinkEntryTable, null);
    }

    public void fireServicePinReceived(BServicePinData bServicePinData) {
        this.fire(servicePinReceived, (BValue)bServicePinData, null);
    }

    public void fireLearnComplete(BValue bValue) {
        this.fire(learnComplete, bValue, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent bComponent) {
        if (!(bComponent instanceof BLonNetwork)) {
            return false;
        }
        SlotCursor slotCursor = bComponent.getProperties();
        Class clazz = class$com$tridium$lonworks$netmgmt$BLonNetmgmt;
        if (clazz == null) {
            clazz = class$com$tridium$lonworks$netmgmt$BLonNetmgmt = BLonNetmgmt.class("[Lcom.tridium.lonworks.netmgmt.BLonNetmgmt;", false);
        }
        return !slotCursor.next(clazz);
    }

    public BLonNetwork lonNetwork() {
        return (BLonNetwork)this.getParent();
    }

    public Log log() {
        return this.lonNetwork().log();
    }

    public final void started() {
        boolean bl = Boolean.getBoolean("lonworks.disableNetmgmt");
        this.setEnabled(bl ^ true);
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning() || context == BLonNetwork.lonNoWrite) {
            return;
        }
        if (property == domainId || property == authenticationKey) {
            try {
                NmUtil.updateDomainTable(this.lonNetwork().getLocalLonDevice(), this.getDomainId(), this.getAuthenticationKey(), false);
            }
            catch (LonException lonException) {
                this.log().error("Unable to update local domain table ", (Throwable)((Object)lonException));
            }
        }
    }

    public void doRefreshLinkTable() {
        BComponentSpace bComponentSpace = this.getComponentSpace();
        if (bComponentSpace == null || bComponentSpace != Station.space) {
            return;
        }
        Runnable runnable = new Runnable(){

            public final void run() {
                BLonNetmgmt.this.asyncRefreshLinkTable();
            }
        };
        this.lonNetwork().postAsync(runnable);
    }

    private final void asyncRefreshLinkTable() {
        try {
            ConnectionTable connectionTable = new ConnectionTable(this.lonNetwork());
            this.updateLinkTable(connectionTable);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public BOrd doBind() {
        return new BLonBindJob(this, null, null, this.getDebug()).submit(null);
    }

    public BOrd doBindDevice(BLonDevice bLonDevice) {
        return new BLonBindJob(this, bLonDevice, this.getDebug()).submit(null);
    }

    public BOrd doBindLinkEntry(BString bString) {
        return new BLonBindJob(this, bString, null, this.getDebug()).submit(null);
    }

    public BOrd doBindTagLinkEntry(BTagLinkEntry bTagLinkEntry) {
        return new BLonBindJob(this, null, bTagLinkEntry, this.getDebug()).submit(null);
    }

    void updateLinkTable(ConnectionTable connectionTable) {
        BLinkEntryTable bLinkEntryTable = connectionTable.getLonLinkTable();
        this.fireLinksUpdated(bLinkEntryTable);
        BTagLinkEntryTable bTagLinkEntryTable = connectionTable.getLonMessageTagTable();
        this.fireTagLinksUpdated(bTagLinkEntryTable);
    }

    public void deviceAdded(BLonDevice bLonDevice) {
        BDeviceEntry bDeviceEntry = this.getDeviceDiscoverTable().findEntry(bLonDevice.getDeviceData().getNeuronId());
        if (bDeviceEntry != null) {
            this.getDeviceDiscoverTable().removeEntry(bDeviceEntry);
        }
        this.fireDeviceDiscoveryUpdated(this.getDeviceDiscoverTable());
    }

    public void routerAdded(BLonRouter bLonRouter) {
        BRouterEntry bRouterEntry = this.getRouterDiscoverTable().findEntry(bLonRouter.getNearDeviceData().getNeuronId());
        if (bRouterEntry != null) {
            this.getRouterDiscoverTable().removeEntry(bRouterEntry);
        }
        this.fireRouterDiscoveryUpdated(this.getRouterDiscoverTable());
    }

    public void receiveServicePin(ServicePin servicePin) {
        this.lonNetwork().postAsync(new ProcessServicePin(this, servicePin));
        this.fireServicePinReceived(new BServicePinData(servicePin.getNeuronId(), servicePin.getIdString()));
    }

    public BOrd doDiscover() {
        return new BLonDiscoverJob(this).submit(null);
    }

    public BOrd doDiscoverSelect(BDiscoverParameter bDiscoverParameter) {
        return new BLonDiscoverJob(this, bDiscoverParameter).submit(null);
    }

    public BOrd doLearn(BLearnParameter bLearnParameter) {
        if (bLearnParameter.isSelectedDevices()) {
            return new BLonLearnLinksJob(this, bLearnParameter).submit(null);
        }
        return new BLonLearnJob(this, bLearnParameter).submit(null);
    }

    public void doCancelServicePin() {
        this.lonNetwork().netMessageReceiver().cancelServicePin();
    }

    public BOrd doCommissionDevice(BCommissionParameter bCommissionParameter) {
        return new BLonCommissionJob(this, bCommissionParameter).submit(null);
    }

    public BOrd doCommissionRouter(BCommissionParameter bCommissionParameter) {
        return new BLonCommissionRouterJob(this, bCommissionParameter).submit(null);
    }

    public BOrd doReplaceDevice(BCommissionParameter bCommissionParameter) {
        return new BLonReplaceJob(this, bCommissionParameter).submit(null);
    }

    public BOrd doReplaceRouter(BCommissionParameter bCommissionParameter) {
        return new BLonCommissionRouterJob(this, bCommissionParameter).submit(null);
    }

    public void doTempBridgeOn() {
        Runnable runnable = new Runnable(){

            public final void run() {
                BLonNetmgmt.this.setTempBridge(true);
                RouterUtil.setTemporaryBridge(BLonNetmgmt.this.lonNetwork());
            }
        };
        this.lonNetwork().postAsync(runnable);
    }

    public void doTempBridgeOff() {
        Runnable runnable = new Runnable(){

            public final void run() {
                BLonNetmgmt.this.setTempBridge(false);
                RouterUtil.clearTemporaryBridge(BLonNetmgmt.this.lonNetwork());
            }
        };
        this.lonNetwork().postAsync(runnable);
    }

    public BOrd doAppDownLoad(BAppDownloadParameter bAppDownloadParameter) {
        return new BLonAppDownloadJob(this, bAppDownloadParameter).submit(null);
    }

    public BOrd doSetServiceType(BSetServiceTypeParameter bSetServiceTypeParameter) {
        return new BLonSetServiceTypeJob(this, bSetServiceTypeParameter).submit(null);
    }

    public BBoolean doMatch(BMatchParameter bMatchParameter) {
        BLonDevice bLonDevice = this.lonNetwork().addressManager().getDeviceByAddress(bMatchParameter.getDbDevSubnetNode());
        BDeviceEntry bDeviceEntry = bMatchParameter.getDeviceEntry();
        if (bLonDevice == null || bDeviceEntry == null) {
            return BBoolean.TRUE;
        }
        BDeviceData bDeviceData = bLonDevice.getDeviceData();
        BSubnetNode bSubnetNode = BSubnetNode.make(bDeviceEntry.getSubnet(), bDeviceEntry.getNode());
        BLonDevice bLonDevice2 = this.lonNetwork().addressManager().getDeviceByAddress(bSubnetNode);
        if (bLonDevice2 != null && bLonDevice2 != bLonDevice) {
            return BBoolean.FALSE;
        }
        bDeviceData.set(BDeviceData.neuronId, (BValue)bDeviceEntry.getNeuronId(), AddressManager.noDeviceChange);
        bDeviceData.set(BDeviceData.subnetNodeId, (BValue)bSubnetNode, AddressManager.noDeviceChange);
        bDeviceData.set(BDeviceData.nodeState, (BValue)bDeviceEntry.getState(), AddressManager.noDeviceChange);
        bDeviceData.set(BDeviceData.programId, (BValue)bDeviceEntry.getProgramId(), AddressManager.noDeviceChange);
        bDeviceData.setInt(BDeviceData.channelId, bDeviceEntry.getChannelId(), AddressManager.noDeviceChange);
        String string = bDeviceEntry.getDevName();
        if (!string.equals(bLonDevice.getName())) {
            bLonDevice.getParent().asComponent().rename(bLonDevice.getPropertyInParent(), string);
        }
        return BBoolean.TRUE;
    }

    public BOrd doDeviceForSubnetNodeId(BSubnetNode bSubnetNode) {
        if (this.lonNetwork().addressManager() == null) {
            return null;
        }
        BLonDevice bLonDevice = this.lonNetwork().addressManager().getDeviceByAddress(bSubnetNode);
        if (bLonDevice != null) {
            return bLonDevice.getHandleOrd();
        }
        BLonRouter bLonRouter = this.lonNetwork().addressManager().getRouterByAddress(bSubnetNode);
        if (bLonRouter != null) {
            return bLonRouter.getHandleOrd();
        }
        return null;
    }

    public BOrd doDeviceForNeuronId(BNeuronId bNeuronId) {
        if (this.lonNetwork().addressManager() == null) {
            return null;
        }
        BLonDevice bLonDevice = this.lonNetwork().addressManager().getDeviceByAddress(bNeuronId);
        if (bLonDevice != null) {
            return bLonDevice.getHandleOrd();
        }
        BLonRouter bLonRouter = this.lonNetwork().addressManager().getRouterByAddress(bNeuronId);
        if (bLonRouter != null) {
            return bLonRouter.getHandleOrd();
        }
        return null;
    }

    public void executeUtilitiesCommand(BUtilitiesCommand bUtilitiesCommand, PrintWriter printWriter) {
        LonUtilRequest lonUtilRequest = new LonUtilRequest(bUtilitiesCommand, this, printWriter);
        lonUtilRequest.run();
        printWriter.flush();
    }

    public BOrd doUpdateRouters() {
        return new BLonUpdateRoutersJob(this).submit(null);
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$lonworks$netmgmt$BLonNetmgmt;
        if (clazz == null) {
            clazz = class$com$tridium$lonworks$netmgmt$BLonNetmgmt = BLonNetmgmt.class("[Lcom.tridium.lonworks.netmgmt.BLonNetmgmt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"match.png");
    }
}

