/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.netmgmt;

import com.tridium.lonworks.datatypes.BLearnParameter;
import com.tridium.lonworks.enums.BLonLinkStatus;
import com.tridium.lonworks.netmessages.ExEnumerateAddressResponse;
import com.tridium.lonworks.netmessages.ExEnumerateAliasResponse;
import com.tridium.lonworks.netmessages.QueryAddrResponse;
import com.tridium.lonworks.netmessages.QueryAliasResponse;
import com.tridium.lonworks.netmgmt.BLonNetmgmt;
import com.tridium.lonworks.netmgmt.BLonNetmgmtJob;
import com.tridium.lonworks.netmgmt.Connection;
import com.tridium.lonworks.netmgmt.ConnectionTable;
import com.tridium.lonworks.netmgmt.Group;
import com.tridium.lonworks.netmgmt.GroupMember;
import com.tridium.lonworks.netmgmt.LonPoint;
import com.tridium.lonworks.netmgmt.NetMgmtConst;
import com.tridium.lonworks.util.Neuron;
import com.tridium.lonworks.util.NmUtil;
import javax.baja.job.JobCancelException;
import javax.baja.lonworks.AddressManager;
import javax.baja.lonworks.BINetworkVariable;
import javax.baja.lonworks.BINvContainer;
import javax.baja.lonworks.BLocalLonDevice;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BLonLink;
import javax.baja.lonworks.BMessageTag;
import javax.baja.lonworks.BNetworkVariable;
import javax.baja.lonworks.FailedResponseException;
import javax.baja.lonworks.LonComm;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.datatypes.BAddressEntry;
import javax.baja.lonworks.datatypes.BAliasConfigData;
import javax.baja.lonworks.datatypes.BAliasTable;
import javax.baja.lonworks.datatypes.BDeviceData;
import javax.baja.lonworks.datatypes.BIAddressEntry;
import javax.baja.lonworks.datatypes.BNvConfigData;
import javax.baja.lonworks.datatypes.BProgramId;
import javax.baja.lonworks.datatypes.BSubnetNode;
import javax.baja.lonworks.datatypes.LonAddress;
import javax.baja.lonworks.enums.BAddressType;
import javax.baja.lonworks.enums.BLonLinkType;
import javax.baja.lonworks.enums.BLonNvDirection;
import javax.baja.lonworks.enums.BLonReceiveTimer;
import javax.baja.lonworks.enums.BLonRepeatTimer;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Knob;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IntHashMap;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BLonLearnLinksJob
extends BLonNetmgmtJob
implements NetMgmtConst {
    public static final Type TYPE;
    private static final BIcon icon;
    private LonComm loncomm;
    private boolean debug;
    private boolean uploadDevData;
    private BLonDevice[] devList;
    private ConnectionTable connTable;
    private IntHashMap linkType;
    static /* synthetic */ Class class$com$tridium$lonworks$netmgmt$BLonLearnLinksJob;

    public Type getType() {
        return TYPE;
    }

    public void run() {
        try {
            this.doLearnLinks();
        }
        catch (JobCancelException jobCancelException) {
            this.canceled();
        }
        catch (Throwable throwable) {
            this.fatal("LearnLinks failed ", throwable);
        }
        this.end();
    }

    public void doLearnLinks() {
        this.log().start("Learn links");
        if (this.devList.length == 0) {
            return;
        }
        int n = this.devList.length;
        this.percentFactor = (double)n / 0.8;
        int n2 = 0;
        while (n2 < n) {
            this.percentOffset = (int)(100.0 / this.percentFactor) * n2;
            if (!this.upload(this.devList[n2])) {
                this.devList[n2] = null;
            }
            ++n2;
        }
        this.connTable = new ConnectionTable(this.lon, true, false);
        this.percentOffset = 80;
        this.percentFactor = (double)n / 0.2;
        n2 = 0;
        while (n2 < n) {
            if (this.devList[n2] != null) {
                this.processLinks(this.devList[n2]);
                this.processMessageTags(this.devList[n2]);
                this.myProgress(n2 / n);
            }
            ++n2;
        }
    }

    private final boolean upload(BLonDevice bLonDevice) {
        if (bLonDevice.isLocal()) {
            return false;
        }
        this.log().start("Upload device data for " + bLonDevice.getDisplayName(null));
        BDeviceData bDeviceData = bLonDevice.getDeviceData();
        try {
            if (this.uploadDevData) {
                BProgramId bProgramId;
                BProgramId bProgramId2 = Neuron.getProgramId(bLonDevice);
                if (!bProgramId2.equals((Object)(bProgramId = bDeviceData.getProgramId()))) {
                    this.fatal("Program id does not match");
                    return false;
                }
                this.myProgress(2);
                if (!NmUtil.verifyDomainTable(bLonDevice, this.netMgmt)) {
                    this.fatal("Domain table error for " + bLonDevice.getDisplayName(null));
                    return false;
                }
                bDeviceData.setProgramId(Neuron.getProgramId(bLonDevice));
                bDeviceData.set(BDeviceData.nodeState, (BValue)NmUtil.getDeviceState(bLonDevice), AddressManager.noDeviceChange);
                bDeviceData.setChannelId(Neuron.getChannelId(bLonDevice));
                Neuron.uploadDeviceData(bLonDevice);
                this.myProgress(5);
            }
            this.readNvConfig(bLonDevice);
            this.myProgress(85);
            this.readAliasTable(bLonDevice);
            this.readAddressTable(bLonDevice);
            this.myProgress(95);
            bDeviceData.setLocation(Neuron.getLocation(bLonDevice));
            bDeviceData.setPrioritySlot(Neuron.getNodePriority(bLonDevice));
        }
        catch (Throwable throwable) {
            this.fatal("Upload device data failed for " + bLonDevice.getDisplayName(null) + '\n' + throwable.toString());
            throwable.printStackTrace();
            return false;
        }
        this.pass("Success");
        return true;
    }

    private final void readNvConfig(BLonDevice bLonDevice) throws LonException {
        this.linkType.clear();
        BDeviceData bDeviceData = bLonDevice.getDeviceData();
        BINetworkVariable[] bINetworkVariableArray = bLonDevice.getNetworkVariables();
        int n = 0;
        while (n < bINetworkVariableArray.length) {
            if (n == bINetworkVariableArray.length / 2) {
                this.myProgress(45);
            }
            if (bINetworkVariableArray[n] != null && !bINetworkVariableArray[n].isNetworkConfig()) {
                BNvConfigData bNvConfigData = NmUtil.queryNvConfigData(bLonDevice, n);
                BNetworkVariable bNetworkVariable = (BNetworkVariable)bINetworkVariableArray[n];
                BNvConfigData bNvConfigData2 = bNetworkVariable.getNvConfigData();
                if (bNvConfigData.getDirection() != bNvConfigData2.getDirection()) {
                    String string = "BINetworkVariable direction mismatch for " + bNetworkVariable.getDisplayName(null) + '(' + n + ')';
                    if (this.netMgmt.getVerifyNvDir()) {
                        throw new LonException(string);
                    }
                    this.warning(string);
                }
                bNvConfigData2.copyFrom((BComplex)bNvConfigData);
                int n2 = bNvConfigData.getAddrIndex();
                if (n2 < bDeviceData.getAddressCount() && n2 >= 0 && bNvConfigData2.isBoundNv() && this.requiresAddressEntry(bNetworkVariable)) {
                    this.linkType.put(n2, (Object)NmUtil.getLinkType(bNvConfigData));
                }
            }
            ++n;
        }
    }

    private final boolean requiresAddressEntry(BNetworkVariable bNetworkVariable) {
        boolean bl;
        BLonNvDirection bLonNvDirection = bNetworkVariable.getNvConfigData().getDirection();
        if (bNetworkVariable.getNvProps().getPolled()) {
            bl = false;
            if (bLonNvDirection == BLonNvDirection.input) {
                bl = true;
            }
        } else {
            bl = false;
            if (bLonNvDirection == BLonNvDirection.output) {
                bl = true;
            }
        }
        return bl;
    }

    private final void readAliasTable(BLonDevice bLonDevice) throws LonException {
        BDeviceData bDeviceData = bLonDevice.getDeviceData();
        BAliasTable bAliasTable = bDeviceData.getAliasTable();
        int n = bAliasTable.getAliasCount();
        if (n == 0) {
            return;
        }
        int n2 = bAliasTable.getAliasOffset();
        LonAddress lonAddress = NmUtil.getSendAddress(bLonDevice);
        boolean bl = bLonDevice.authenticate();
        int n3 = 0;
        while (n3 < n) {
            QueryAliasResponse queryAliasResponse;
            block5: {
                try {
                    queryAliasResponse = NmUtil.queryAliasConfigData(this.loncomm, lonAddress, n3, n2, bl, bLonDevice.isExtended());
                    if (!queryAliasResponse.isExtended()) break block5;
                    n3 = ((ExEnumerateAliasResponse)queryAliasResponse).getAliasIndex();
                }
                catch (FailedResponseException failedResponseException) {
                    break;
                }
            }
            BAliasConfigData bAliasConfigData = queryAliasResponse.getAliasConfigData();
            bAliasTable.setAliasEntry(n3, bAliasConfigData);
            int n4 = bAliasConfigData.getAddrIndex();
            if (n4 < bDeviceData.getAddressCount() && n4 >= 0 && bAliasConfigData.isBoundNv()) {
                this.linkType.put(n4, (Object)NmUtil.getLinkType(bAliasConfigData));
            }
            ++n3;
        }
    }

    private final void readAddressTable(BLonDevice bLonDevice) throws LonException {
        BDeviceData bDeviceData = bLonDevice.getDeviceData();
        int n = bDeviceData.getAddressCount();
        int n2 = bDeviceData.getWorkingDomain();
        LonAddress lonAddress = NmUtil.getSendAddress(bLonDevice);
        boolean bl = false;
        boolean bl2 = bLonDevice.isExtended();
        int n3 = 0;
        while (n3 < n) {
            QueryAddrResponse queryAddrResponse;
            block7: {
                try {
                    queryAddrResponse = NmUtil.getAddressTableEntry(this.loncomm, lonAddress, n3, bLonDevice.authenticate(), bl2);
                    if (!bl2) break block7;
                    n3 = ((ExEnumerateAddressResponse)queryAddrResponse).getAddressIndex();
                }
                catch (FailedResponseException failedResponseException) {
                    break;
                }
            }
            if (queryAddrResponse.getAddressType() == BAddressType.none) {
                bDeviceData.setAddressEntry(n3, BAddressEntry.DEFAULT);
            } else {
                if (n2 != queryAddrResponse.getDomainIndex()) {
                    bl = true;
                }
                int n4 = NmUtil.linkTypeToDescriptor((BLonLinkType)((Object)this.linkType.get(n3)));
                bDeviceData.setAddressEntry(n3, BAddressEntry.make(queryAddrResponse.getAddressType(), queryAddrResponse.getSize(), queryAddrResponse.getGroupOrSubnet(), queryAddrResponse.getMemberOrNode(), n4, queryAddrResponse.getDomainIndex(), BLonRepeatTimer.make(queryAddrResponse.repeatTimer), queryAddrResponse.retryCount, BLonReceiveTimer.make(queryAddrResponse.receiveTimer), BLonRepeatTimer.make(queryAddrResponse.xmitTimer)));
            }
            ++n3;
        }
        if (bl) {
            this.warning("Mismatch between working domain and address table domain index in " + bLonDevice.getDisplayName(null));
        }
    }

    private final void processLinks(BLonDevice bLonDevice) {
        BINvContainer[] bINvContainerArray = bLonDevice.getNvContainers();
        int n = 0;
        while (n < bINvContainerArray.length) {
            this.doProcessLinks(bINvContainerArray[n]);
            ++n;
        }
    }

    private final void doProcessLinks(BINvContainer bINvContainer) {
        BComponent bComponent = bINvContainer.asComponent();
        String string = "Learn links for " + bComponent.getDisplayName(null);
        this.log().message(string);
        try {
            BLink[] bLinkArray = bComponent.getLinks();
            int n = 0;
            while (n < bLinkArray.length) {
                if (!(bLinkArray[n] instanceof BLonLink)) {
                    bLinkArray[n] = null;
                }
                ++n;
            }
            Connection[] connectionArray = this.connTable.getConnectionArray();
            int n2 = 0;
            while (n2 < connectionArray.length) {
                Connection connection = connectionArray[n2];
                while (connection != null) {
                    LonPoint lonPoint = connection.getHub();
                    if (lonPoint != null) {
                        boolean bl = lonPoint.isSameNode(bINvContainer);
                        LonPoint[] lonPointArray = connection.getTargets();
                        BLonLinkType bLonLinkType = this.getLinkType(connection);
                        int n3 = 0;
                        while (n3 < lonPointArray.length) {
                            Object object;
                            Object object2;
                            boolean bl2;
                            LonPoint lonPoint2 = lonPointArray[n3];
                            if (bl && !lonPoint2.isProxy() || lonPoint2.isSameNode(bINvContainer) && !lonPoint2.isOutput()) {
                                BComponent bComponent2;
                                if (this.debug) {
                                    System.out.println("process link from : " + lonPoint + "\n   to:" + lonPoint2);
                                }
                                bl2 = lonPoint2.requiresAddressEntry() ? lonPoint2.isPriority() : lonPoint.isPriority();
                                object2 = lonPoint.getNvContainer().asComponent().getOrdInSession();
                                object = lonPoint.getNetworkVariable().getPropertyInParent();
                                Property property = lonPoint2.getNetworkVariable().getPropertyInParent();
                                BComponent bComponent3 = bComponent2 = bl ? lonPoint2.getNvContainer().asComponent() : bComponent;
                                if (lonPoint2.isObsolete()) {
                                    BLonLink bLonLink = new BLonLink(lonPoint.getNvContainer().asComponent().getHandleOrd(), object.getName(), property.getName(), true);
                                    bLonLink.setLinkType(bLonLinkType);
                                    bLonLink.setPriority(bl2);
                                    bComponent2.add(null, (BValue)bLonLink);
                                    bLonLink.activate();
                                    if (this.debug) {
                                        System.out.println(" Add new link: " + (Object)((Object)bLonLink) + '\n');
                                    }
                                    lonPoint2.setStatus(BLonLinkStatus.bound);
                                } else {
                                    boolean bl3 = false;
                                    BLonLink bLonLink = null;
                                    int n4 = 0;
                                    while (n4 < bLinkArray.length) {
                                        if (bLinkArray[n4] != null && (bLonLink = (BLonLink)bLinkArray[n4]).getSourceOrd().equals(object2) && bLonLink.getSourceSlotName().equals(object.getName()) && bLonLink.getTargetSlotName().equals(property.getName())) {
                                            bLinkArray[n4] = null;
                                            bl3 = true;
                                            break;
                                        }
                                        ++n4;
                                    }
                                    if (bl3) {
                                        if (lonPoint2.isNew()) {
                                            if (this.debug) {
                                                System.out.println(" Remove link: " + (Object)((Object)bLonLink));
                                            }
                                            bLonLink.deactivate();
                                            bComponent2.remove(bLonLink.getPropertyInParent());
                                        } else {
                                            bLonLink.setLinkType(bLonLinkType);
                                            bLonLink.setPriority(bl2);
                                        }
                                        if (this.debug) {
                                            System.out.println();
                                        }
                                    }
                                }
                            } else if (lonPoint2.isProxy() && lonPoint.isBound()) {
                                bl2 = this.isAddressedToLocal(lonPoint.getAddressEntry());
                                object2 = lonPoint.getNetworkVariable();
                                object = ((BNetworkVariable)object2).getNvProps();
                                if (object.getBoundToLocal() != bl2) {
                                    if (this.debug) {
                                        System.out.println(" Set boundToLocal to " + bl2);
                                    }
                                    object.setBoundToLocal(bl2);
                                    ((BNetworkVariable)object2).bound();
                                }
                            }
                            ++n3;
                        }
                    }
                    connection = connection.getSecondary();
                }
                ++n2;
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof JobCancelException) {
                throw (JobCancelException)throwable;
            }
            this.fatal("Learn links failed for " + bComponent.getDisplayName(null), throwable);
        }
    }

    private final boolean isAddressedToLocal(BIAddressEntry bIAddressEntry) {
        if (bIAddressEntry == null) {
            return false;
        }
        BLocalLonDevice bLocalLonDevice = this.loncomm.lonNetwork().getLocalLonDevice();
        if (bIAddressEntry.isSubnetNodeAddress()) {
            return bIAddressEntry.getSubnetNodeAddress().equals(bLocalLonDevice.getSubnetNodeAddress());
        }
        if (bIAddressEntry.isGroupAddress()) {
            int n = bIAddressEntry.getGroupOrSubnet();
            BDeviceData bDeviceData = bLocalLonDevice.getDeviceData();
            int n2 = bDeviceData.getAddressCount();
            int n3 = 0;
            while (n3 < n2) {
                BIAddressEntry bIAddressEntry2 = bDeviceData.getAddressEntry(n3);
                if (bIAddressEntry2.isGroupAddress() && bIAddressEntry2.getGroupOrSubnet() == n) {
                    return true;
                }
                ++n3;
            }
        }
        return false;
    }

    private final void processMessageTags(BLonDevice bLonDevice) {
        BDeviceData bDeviceData = bLonDevice.getDeviceData();
        int n = bDeviceData.getMsgTagCount();
        if (n == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            BIAddressEntry bIAddressEntry = bDeviceData.getAddressEntry(n2);
            BMessageTag bMessageTag = bLonDevice.getMessageTag(n2);
            if (bMessageTag != null) {
                Property property = bMessageTag.getPropertyInParent();
                switch (bIAddressEntry.getAddressType().getOrdinal()) {
                    case 1: {
                        BLink[] bLinkArray;
                        Object object2;
                        int n3 = bIAddressEntry.getGroupOrSubnet();
                        Group group = this.connTable.getGroupTable().getGroup(n3);
                        GroupMember[] groupMemberArray = group.getMembers();
                        int n4 = -1;
                        int n5 = -1;
                        int n6 = 0;
                        while (n6 < groupMemberArray.length) {
                            GroupMember groupMember = groupMemberArray[n6];
                            groupMember.dev = this.connTable.getDevice(groupMember.getDeviceIndex());
                            object2 = groupMember.dev;
                            groupMember.mtag = groupMember.isMessageTag() ? ((BLonDevice)object2).getMessageTag(groupMember.getAddressIndex()) : ((BLonDevice)object2).getMessageIn();
                            groupMember.prop = groupMember.mtag.getPropertyInParent();
                            if (groupMember.dev == bLonDevice) {
                                n5 = n6;
                            }
                            if ((bLinkArray = groupMember.dev.getKnobs((Slot)groupMember.prop)).length > 0) {
                                if (n4 == -1) {
                                    n4 = n6;
                                    int n7 = 0;
                                    while (n7 < bLinkArray.length) {
                                        BLink bLink = bLinkArray[n7];
                                        if (!this.linkTgtInGroup((Knob)bLink, group)) {
                                            this.deleteLink(bLink.getLink());
                                        }
                                        ++n7;
                                    }
                                } else {
                                    this.deleteLinks((Knob[])bLinkArray);
                                }
                            }
                            ++n6;
                        }
                        if (n5 == -1) {
                            throw new BajaRuntimeException("Internal error : not member of my group.");
                        }
                        if (n4 == -1) {
                            n4 = n5;
                        }
                        GroupMember groupMember = groupMemberArray[n4];
                        int n8 = 0;
                        while (n8 < groupMemberArray.length) {
                            if (n8 != n4) {
                                object2 = groupMemberArray[n8];
                                bLinkArray = ((GroupMember)object2).dev.getLinks((Slot)((GroupMember)object2).prop);
                                if (bLinkArray.length <= 0) {
                                    BLonLink bLonLink = new BLonLink(groupMember.dev.getHandleOrd(), groupMember.prop.getName(), ((GroupMember)object2).prop.getName(), true);
                                    bLonLink.setMessageTag(true);
                                    ((GroupMember)object2).dev.add(null, (BValue)bLonLink);
                                    bLonLink.activate();
                                    if (this.debug) {
                                        System.out.println(" Add new link: " + (Object)((Object)bLonLink) + '\n');
                                    }
                                }
                            }
                            ++n8;
                        }
                        break;
                    }
                    case 2: {
                        Object object;
                        BSubnetNode bSubnetNode = bIAddressEntry.getSubnetNodeAddress();
                        Object object2 = this.lon.addressManager().getDeviceByAddress(bSubnetNode);
                        BLink[] bLinkArray = ((BLonDevice)object2).getMessageIn().getPropertyInParent();
                        Knob[] knobArray = bLonDevice.getKnobs((Slot)property);
                        boolean bl = false;
                        if (knobArray.length > 0) {
                            object = knobArray[n2];
                            if (object.getTargetComponent() == object2 && object.getTargetSlot() == bLinkArray) {
                                bl = true;
                            } else {
                                this.deleteLink(object.getLink());
                            }
                        }
                        if (bl) {
                            return;
                        }
                        object = new BLonLink(bLonDevice.getHandleOrd(), property.getName(), bLinkArray.getName(), true);
                        ((BLonLink)((Object)object)).setMessageTag(true);
                        object2.add(null, (BValue)object);
                        object.activate();
                        if (!this.debug) break;
                        System.out.println(" Add new link: " + object + '\n');
                        break;
                    }
                    case 0: {
                        this.deleteLinks(bLonDevice.getKnobs((Slot)property));
                        BLink[] bLinkArray = bLonDevice.getLinks((Slot)property);
                        int n9 = 0;
                        while (n9 < bLinkArray.length) {
                            this.deleteLink(bLinkArray[n9]);
                            ++n9;
                        }
                        break;
                    }
                }
            }
            ++n2;
        }
    }

    private final void deleteLinks(Knob[] knobArray) {
        int n = 0;
        while (n < knobArray.length) {
            this.deleteLink(knobArray[n].getLink());
            ++n;
        }
    }

    private final void deleteLink(BLink bLink) {
        if (this.debug) {
            System.out.println(" Remove link: " + bLink);
        }
        bLink.deactivate();
        bLink.getTargetComponent().remove(bLink.getPropertyInParent());
    }

    private final boolean linkTgtInGroup(Knob knob, Group group) {
        BLonDevice bLonDevice = (BLonDevice)knob.getTargetComponent();
        Slot slot = knob.getTargetSlot();
        if (!slot.asProperty().getType().is(BMessageTag.TYPE)) {
            return false;
        }
        BMessageTag bMessageTag = (BMessageTag)bLonDevice.get(slot.asProperty());
        int n = this.connTable.getGroupTable().findDeviceIndex(bLonDevice);
        GroupMember groupMember = group.findMember(n);
        if (groupMember == null) {
            return false;
        }
        if (bMessageTag.getIndex() >= 0) {
            boolean bl = false;
            if (bMessageTag.getIndex() == groupMember.getAddressIndex()) {
                bl = true;
            }
            return bl;
        }
        boolean bl = false;
        if (groupMember.getAddressIndex() >= bLonDevice.getDeviceData().getMsgTagCount()) {
            bl = true;
        }
        return bl;
    }

    private final BLonLinkType getLinkType(Connection connection) {
        LonPoint lonPoint = connection.getAddressPnt(false);
        if (lonPoint == null) {
            return BLonLinkType.unknown;
        }
        BIAddressEntry bIAddressEntry = lonPoint.getAddressEntry();
        if (bIAddressEntry == null) {
            return BLonLinkType.unknown;
        }
        return NmUtil.getLinkType(bIAddressEntry.getDescriptor());
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.linkType = new IntHashMap();
    }

    public BLonLearnLinksJob() {
        this.this();
    }

    public BLonLearnLinksJob(BLonNetmgmt bLonNetmgmt, BLearnParameter bLearnParameter) {
        super(bLonNetmgmt);
        this.this();
        this.loncomm = this.lon.lonComm();
        this.debug = bLonNetmgmt.getDebug();
        this.uploadDevData = true;
        this.devList = bLearnParameter.getDeviceList(this.lon);
    }

    public BLonLearnLinksJob(BLonNetmgmt bLonNetmgmt, BLonDevice[] bLonDeviceArray, boolean bl) {
        super(bLonNetmgmt);
        this.this();
        this.devList = bLonDeviceArray;
        this.loncomm = this.lon.lonComm();
        this.debug = bLonNetmgmt.getDebug();
        this.uploadDevData = bl;
    }

    static {
        Class clazz = class$com$tridium$lonworks$netmgmt$BLonLearnLinksJob;
        if (clazz == null) {
            clazz = class$com$tridium$lonworks$netmgmt$BLonLearnLinksJob = BLonLearnLinksJob.class("[Lcom.tridium.lonworks.netmgmt.BLonLearnLinksJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((BIcon)BIcon.std((String)"apple.png"), (BIcon)BIcon.std((String)"badges/clock.png"));
    }
}

