/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.netmgmt;

import com.tridium.lonworks.NAddressManager;
import com.tridium.lonworks.datatypes.BCommissionParameter;
import com.tridium.lonworks.device.DeviceFacets;
import com.tridium.lonworks.enums.BServicePinState;
import com.tridium.lonworks.netmessages.ServicePin;
import com.tridium.lonworks.netmgmt.BLonNetmgmt;
import com.tridium.lonworks.netmgmt.BLonServicePinJob;
import com.tridium.lonworks.netmgmt.NetMgmtConst;
import com.tridium.lonworks.util.Neuron;
import com.tridium.lonworks.util.NmUtil;
import com.tridium.lonworks.util.RouterUtil;
import com.tridium.lonworks.util.selfdoc.SelfDoc;
import javax.baja.job.JobCancelException;
import javax.baja.lonworks.AddressManager;
import javax.baja.lonworks.BINetworkVariable;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.FailedResponseException;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.datatypes.BAliasTable;
import javax.baja.lonworks.datatypes.BDeviceData;
import javax.baja.lonworks.datatypes.BNeuronId;
import javax.baja.lonworks.datatypes.BNvConfigData;
import javax.baja.lonworks.datatypes.BProgramId;
import javax.baja.lonworks.datatypes.BSubnetNode;
import javax.baja.lonworks.enums.BLonConfigSourceEnum;
import javax.baja.lonworks.enums.BLonNodeState;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BLonCommissionJob
extends BLonServicePinJob
implements NetMgmtConst {
    public static final Type TYPE;
    private static final BIcon icon;
    private BLonDevice lonDevice;
    private BSubnetNode[] sns;
    private boolean servicePin;
    private boolean devArray;
    private int aliasCnt;
    private int nvCount;
    static /* synthetic */ Class class$com$tridium$lonworks$netmgmt$BLonCommissionJob;

    public Type getType() {
        return TYPE;
    }

    public static void commission(BLonNetmgmt bLonNetmgmt, BLonDevice bLonDevice) {
        BLonCommissionJob bLonCommissionJob = new BLonCommissionJob(bLonNetmgmt, bLonDevice);
        bLonCommissionJob.run();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block11: {
            boolean bl = this.netMgmt.getTempBridge();
            try {
                try {
                    if (!bl) {
                        RouterUtil.setTemporaryBridge(this.lon);
                    }
                    if (this.devArray) {
                        this.percentFactor = this.sns.length;
                        int n = 0;
                        while (n < this.sns.length) {
                            this.lonDevice = this.lon.addressManager().getDeviceByAddress(this.sns[n]);
                            this.percentOffset = (int)(100.0 / this.percentFactor) * n;
                            this.doCommission();
                            ++n;
                        }
                    } else {
                        this.doCommission();
                    }
                }
                catch (JobCancelException jobCancelException) {
                    this.canceled();
                }
                catch (Throwable throwable) {
                    this.fatal("Fatal error ", throwable);
                }
            }
            catch (Throwable throwable) {
                Object var3_6 = null;
                if (!bl) {
                    RouterUtil.clearTemporaryBridge(this.lon);
                }
                throw throwable;
            }
            {
                Object var3_7 = null;
                if (bl) break block11;
            }
            RouterUtil.clearTemporaryBridge(this.lon);
        }
        this.end();
    }

    private final void doCommission() {
        boolean bl = this.lonDevice.isLocal();
        BDeviceData bDeviceData = this.lonDevice.getDeviceData();
        NAddressManager nAddressManager = (NAddressManager)this.lon.addressManager();
        this.log().start("Commissioning " + this.lonDevice.getDisplayName(null));
        try {
            Object object;
            BProgramId bProgramId;
            this.lonDevice.beginCommission();
            if (nAddressManager.isRouted()) {
                nAddressManager.routerManager().verifySubnets();
            }
            BNeuronId bNeuronId = null;
            this.myProgress(2);
            if (bl) {
                bDeviceData.setNeuronId(Neuron.getNeuronId(this.lonDevice));
                bProgramId = Neuron.getProgramId(this.lonDevice);
            } else {
                this.lonDevice.clearFiles();
                if (this.servicePin) {
                    this.setServicePinState(BServicePinState.waiting);
                    object = this.receiveServicePin();
                    if (object == null) {
                        return;
                    }
                    this.setServicePinState(BServicePinState.received);
                    bNeuronId = ((ServicePin)object).getNeuronId();
                    bProgramId = ((ServicePin)object).getIdString();
                    this.validateNeuronId(bNeuronId, (BComponent)this.lonDevice);
                } else {
                    Neuron.verifyAuthenticate(this.lonDevice);
                    bProgramId = Neuron.getProgramId(this.lonDevice);
                }
            }
            object = bDeviceData.getProgramId();
            if (this.lonDevice.programIdChanges() || ((BProgramId)((Object)object)).isZero()) {
                bDeviceData.setProgramId(bProgramId);
            } else if (!bProgramId.equals(object)) {
                this.fatal("Program id does not match");
                return;
            }
            if (bNeuronId != null) {
                bDeviceData.setNeuronId(bNeuronId);
            }
            if (!bl) {
                if (this.servicePin) {
                    Neuron.verifyAuthenticate(this.lonDevice);
                }
                if (!this.lonDevice.isExtended() && NmUtil.isExtended(this.lonDevice)) {
                    this.fatal("Device requires extended netmgmt support. Import updated *.lnml or execute learnNv.");
                    return;
                }
                NmUtil.setDeviceState(this.lonDevice, BLonNodeState.configOffline);
                bDeviceData.set(BDeviceData.nodeState, (BValue)BLonNodeState.configOffline, AddressManager.noDeviceChange);
                DeviceFacets.delayToHardOffline(this.lonDevice);
                NmUtil.setDeviceState(this.lonDevice, BLonNodeState.hardOffline);
                NmUtil.wait(10);
                NmUtil.setDeviceState(this.lonDevice, BLonNodeState.unconfigured);
            }
            this.myProgress(10);
            Neuron.uploadDeviceData(this.lonDevice);
            NmUtil.updateDomainTable(this.netMgmt, this.lonDevice);
            this.myProgress(25);
            NmUtil.clearAddressTable(this.lonDevice);
            if (!bl) {
                this.getCounts();
                this.verifyAndUnbindNv();
                this.clearAliasTable();
            }
            this.myProgress(60);
            Neuron.updateConfigData(this.netMgmt, this.lonDevice);
            if (!bl) {
                NmUtil.setConfigSrc(this.lonDevice, BLonConfigSourceEnum.cfgExternal);
                NmUtil.clearStatus(this.lonDevice);
                DeviceFacets.delayToReset(this.lonDevice);
                NmUtil.resetNode(this.lonDevice);
                if (this.lonDevice.getDeviceData().getHosted()) {
                    NmUtil.wait(3000);
                }
                this.myProgress(80);
                NmUtil.setDeviceState(this.lonDevice, BLonNodeState.configOnline);
                if (!DeviceFacets.disableToggleMode(this.lonDevice)) {
                    NmUtil.setDeviceState(this.lonDevice, BLonNodeState.configOffline);
                    NmUtil.setDeviceState(this.lonDevice, BLonNodeState.configOnline);
                }
            }
            bDeviceData.set(BDeviceData.nodeState, (BValue)BLonNodeState.configOnline, AddressManager.noDeviceChange);
            this.lonDevice.pingOk();
            this.lonDevice.postCommission();
            this.pass("Commission success");
        }
        catch (LonException lonException) {
            this.fatal("Commission failed for " + this.lonDevice.getDisplayName(null), (Throwable)((Object)lonException));
        }
    }

    private final void verifyAndUnbindNv() throws LonException {
        BINetworkVariable[] bINetworkVariableArray = this.lonDevice.getNetworkVariables();
        if (this.lonDevice.isExtended()) {
            NmUtil.extNvInitialize(this.lonDevice, 0, (char)-1);
            int n = 0;
            while (n < bINetworkVariableArray.length) {
                if (bINetworkVariableArray[n] != null) {
                    bINetworkVariableArray[n].setUnbound();
                }
                ++n;
            }
            return;
        }
        int n = 0;
        while (n < this.nvCount) {
            BNvConfigData bNvConfigData;
            BINetworkVariable bINetworkVariable;
            BNvConfigData bNvConfigData2;
            boolean bl = false;
            try {
                bNvConfigData2 = NmUtil.queryNvConfigData(this.lonDevice, n);
            }
            catch (LonException lonException) {
                return;
            }
            BINetworkVariable bINetworkVariable2 = bINetworkVariable = n < bINetworkVariableArray.length ? bINetworkVariableArray[n] : null;
            if (bINetworkVariable != null) {
                BNvConfigData bNvConfigData3 = bINetworkVariable.getNvConfigData();
                if (bNvConfigData2.getDirection() != bNvConfigData3.getDirection()) {
                    String string = "BINetworkVariable direction mismatch for " + ((BComponent)bINetworkVariable).getDisplayName(null) + '(' + n + ')';
                    if (this.netMgmt.getVerifyNvDir()) {
                        throw new LonException(string);
                    }
                    this.log().message(string);
                }
                bINetworkVariableArray[n].setUnbound();
                if (!bNvConfigData3.equivalent((Object)bNvConfigData2)) {
                    bl = true;
                }
                bNvConfigData = bNvConfigData3;
            } else {
                bNvConfigData = (BNvConfigData)bNvConfigData2.newCopy(true);
                bNvConfigData.setUnbound(n);
                if (!bNvConfigData2.equivalent((Object)bNvConfigData)) {
                    bl = true;
                }
            }
            if (bl) {
                NmUtil.updateNvConfig(this.lonDevice, n, bNvConfigData);
            }
            ++n;
        }
    }

    private final void clearAliasTable() throws LonException {
        if (this.lonDevice.isExtended()) {
            NmUtil.extAliasInitialize(this.lonDevice, 0, (char)-1);
            return;
        }
        BAliasTable bAliasTable = this.lonDevice.getDeviceData().getAliasTable();
        bAliasTable.setAliasCount(this.aliasCnt);
        if (this.aliasCnt == 0) {
            return;
        }
        bAliasTable.setAliasOffset(this.nvCount);
        bAliasTable.clearTable();
        try {
            NmUtil.updateAliasTable(this.lonDevice);
        }
        catch (FailedResponseException failedResponseException) {
            System.out.println((Object)failedResponseException);
        }
    }

    private final void getCounts() throws LonException {
        if (!this.lonDevice.getDeviceData().getHosted()) {
            this.nvCount = Neuron.getNvCount(this.lonDevice);
            this.aliasCnt = Neuron.getAliasCount(this.lonDevice);
        } else if (!this.lonDevice.isExtended()) {
            SelfDoc selfDoc = new SelfDoc(this.lonDevice.lonComm(), NmUtil.getSendAddress(this.lonDevice), this.lonDevice.authenticate(), true, this.lonDevice.isExtended());
            this.aliasCnt = selfDoc.getAliasCnt();
            this.nvCount = selfDoc.getAliasOffset();
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.sns = null;
        this.servicePin = false;
        this.devArray = false;
    }

    public BLonCommissionJob() {
        this.this();
    }

    public BLonCommissionJob(BLonNetmgmt bLonNetmgmt, BCommissionParameter bCommissionParameter) {
        super(bLonNetmgmt);
        this.this();
        this.servicePin = bCommissionParameter.getServicePin();
        this.sns = bCommissionParameter.getSubnetNodes();
        this.devArray = true;
        BNeuronId bNeuronId = bCommissionParameter.getNeuronId();
        if (bNeuronId != null && !bNeuronId.equals(BNeuronId.DEFAULT)) {
            this.lonDevice = this.lon.addressManager().getDeviceByAddress(this.sns[0]);
            this.lonDevice.getDeviceData().setNeuronId(bNeuronId);
        }
    }

    private BLonCommissionJob(BLonNetmgmt bLonNetmgmt, BLonDevice bLonDevice) {
        super(bLonNetmgmt);
        this.this();
        this.lonDevice = bLonDevice;
        this.servicePin = false;
        this.devArray = false;
    }

    static {
        Class clazz = class$com$tridium$lonworks$netmgmt$BLonCommissionJob;
        if (clazz == null) {
            clazz = class$com$tridium$lonworks$netmgmt$BLonCommissionJob = BLonCommissionJob.class("[Lcom.tridium.lonworks.netmgmt.BLonCommissionJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"build.png");
    }
}

