/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.netmessages;

import com.tridium.lonworks.netmessages.NetMessages;
import com.tridium.lonworks.netmessages.NoDataResponse;
import javax.baja.lonworks.FailedResponseException;
import javax.baja.lonworks.InvalidResponseException;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.LonMessage;
import javax.baja.lonworks.datatypes.BNvConfigData;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class UpdateNvConfigRequest
extends LonMessage
implements NetMessages {
    private int nvIndex;
    private BNvConfigData configData;
    private int primary;

    public int getNvIndex() {
        return this.nvIndex;
    }

    public void setNvIndex(int n) {
        this.nvIndex = n;
    }

    public BNvConfigData getConfigData() {
        return this.configData;
    }

    public void setConfigData(BNvConfigData bNvConfigData) {
        this.configData = bNvConfigData;
    }

    public int getPrimary() {
        return this.primary;
    }

    public void toOutputStream(LonOutputStream lonOutputStream) {
        lonOutputStream.writeUnsigned8(this.code);
        if (this.nvIndex > 254) {
            lonOutputStream.write(255);
            lonOutputStream.writeUnsigned16(this.nvIndex);
        } else {
            lonOutputStream.write(this.nvIndex);
        }
        this.configData.writeNetworkBytes(lonOutputStream);
    }

    public void fromInputStream(LonInputStream lonInputStream) throws LonException {
        int n = lonInputStream.readUnsigned8();
        if (n != 107) {
            throw new InvalidResponseException(n);
        }
        this.nvIndex = lonInputStream.read();
        if (this.nvIndex == 255) {
            this.nvIndex = lonInputStream.readUnsigned16();
        }
        this.configData = new BNvConfigData();
        this.configData.fromInputStream(lonInputStream);
        if (lonInputStream.available() <= 0) {
            return;
        }
        this.primary = lonInputStream.readUnsigned8();
        if (this.primary == 255) {
            this.primary = lonInputStream.readUnsigned16();
        }
    }

    public LonMessage toResponse(LonInputStream lonInputStream) throws LonException {
        int n = lonInputStream.readUnsigned8();
        if (n == 11) {
            throw new FailedResponseException();
        }
        if (n != 43) {
            throw new InvalidResponseException(n);
        }
        return new NoDataResponse(43);
    }

    private final /* synthetic */ void this() {
        this.configData = null;
        this.primary = -1;
    }

    public UpdateNvConfigRequest() {
        this.this();
        this.code = 107;
    }

    public UpdateNvConfigRequest(int n, BNvConfigData bNvConfigData) {
        this.this();
        this.code = 107;
        this.nvIndex = n;
        this.configData = bNvConfigData;
    }
}

