/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.netmessages;

import com.tridium.lonworks.netmessages.NetMessages;
import com.tridium.lonworks.util.LonByteArrayUtil;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.LonMessage;
import javax.baja.lonworks.enums.BLonNvDirection;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class UnprocessedNV
extends LonMessage
implements NetMessages {
    private static final int DIRECTION_BIT_MASK = 64;
    private static final int UPPER_SEL_MASK = 16128;
    private static final int LOWER_SEL_MASK = 255;
    private static final int HDR_SIZE = 2;
    private static final int DIRECTION_INDEX = 0;
    private static final int UPPER_SEL_INDEX = 0;
    private static final int LOWER_SEL_INDEX = 1;
    private static final int DATA_INDEX = 2;
    public static final int MAX_NETVAR_DATA = 31;
    private int length;
    private byte[] msgData;

    public BLonNvDirection getDirection() {
        if ((this.msgData[0] & 0x40) == 0) {
            return BLonNvDirection.input;
        }
        return BLonNvDirection.output;
    }

    public void setDirection(BLonNvDirection bLonNvDirection) {
        if (bLonNvDirection == BLonNvDirection.input) {
            this.msgData[0] = (byte)(this.msgData[0] & 0xFFFFFFBF);
        } else if (bLonNvDirection == BLonNvDirection.output) {
            this.msgData[0] = (byte)(this.msgData[0] | 0x40);
        }
    }

    public int getNvSelector() {
        int n = this.msgData[0] << 8 & 0x3F00;
        return n |= this.msgData[1] & 0xFF;
    }

    public void setNvSelector(int n) {
        this.msgData[0] = (byte)(this.msgData[0] | (byte)((n & 0x3F00) >> 8));
        this.msgData[1] = (byte)(n & 0xFF);
    }

    public byte[] getData() {
        byte[] byArray = new byte[this.length - 2];
        System.arraycopy(this.msgData, 2, byArray, 0, this.length - 2);
        return byArray;
    }

    public void setData(byte[] byArray) {
        System.arraycopy(byArray, 0, this.msgData, 2, byArray.length);
    }

    public String toString() {
        return LonByteArrayUtil.toString(this.msgData, this.length);
    }

    public void toOutputStream(LonOutputStream lonOutputStream) {
        lonOutputStream.write(this.msgData, 0, this.length);
    }

    public void fromInputStream(LonInputStream lonInputStream) {
        this.msgData = lonInputStream.readByteArray();
        this.length = this.msgData.length;
    }

    private final /* synthetic */ void this() {
        this.length = 0;
        this.msgData = new byte[228];
    }

    public UnprocessedNV() {
        this.this();
    }

    public UnprocessedNV(BLonNvDirection bLonNvDirection, int n, byte[] byArray) throws LonException {
        this.this();
        if (byArray.length > 226) {
            throw new IllegalArgumentException("Invalid nvData length " + byArray.length + " exceeds max 228");
        }
        this.msgData[0] = (byte)(this.msgData[0] | 0x80);
        if (bLonNvDirection == BLonNvDirection.input) {
            this.msgData[0] = (byte)(this.msgData[0] & 0xFFFFFFBF);
        } else if (bLonNvDirection == BLonNvDirection.output) {
            this.msgData[0] = (byte)(this.msgData[0] | 0x40);
        }
        this.msgData[0] = (byte)(this.msgData[0] | (byte)((n & 0x3F00) >> 8));
        this.msgData[1] = (byte)(n & 0xFF);
        System.arraycopy(byArray, 0, this.msgData, 2, byArray.length);
        this.length = byArray.length + 2;
    }
}

