/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.netmessages;

import com.tridium.lonworks.netmessages.NetMessages;
import com.tridium.lonworks.netmessages.QuerySNVTResponse;
import javax.baja.lonworks.FailedResponseException;
import javax.baja.lonworks.InvalidResponseException;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.LonMessage;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;

public class QuerySNVTRequest
extends LonMessage
implements NetMessages {
    public static final int QUERY_SNVT_REQUEST_LEN = 3;
    private int offset;
    private int count;

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int n) {
        this.offset = n;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int n) {
        this.count = n;
    }

    public void toOutputStream(LonOutputStream lonOutputStream) {
        lonOutputStream.writeUnsigned8(this.code);
        lonOutputStream.writeUnsigned16(this.offset);
        lonOutputStream.write(this.count);
    }

    public void fromInputStream(LonInputStream lonInputStream) throws LonException {
        int n = lonInputStream.readUnsigned8();
        if (n != 114) {
            throw new InvalidResponseException(n);
        }
        this.offset = lonInputStream.readUnsigned16();
        this.count = lonInputStream.read();
    }

    public LonMessage toResponse(LonInputStream lonInputStream) throws LonException {
        int n = lonInputStream.readUnsigned8();
        if (n == 18) {
            throw new FailedResponseException();
        }
        if (n != 50) {
            throw new InvalidResponseException(n);
        }
        lonInputStream.reset();
        return new QuerySNVTResponse(lonInputStream);
    }

    public QuerySNVTRequest() {
        this.code = 114;
    }

    public QuerySNVTRequest(int n, int n2) {
        this.code = 114;
        this.offset = n;
        this.count = n2;
    }
}

