/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.netmessages;

import com.tridium.lonworks.netmessages.NetMessages;
import com.tridium.lonworks.util.LonByteArrayUtil;
import javax.baja.lonworks.InvalidResponseException;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.LonMessage;
import javax.baja.lonworks.datatypes.BNeuronId;
import javax.baja.lonworks.datatypes.BProgramId;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class QueryIdResponse
extends LonMessage
implements NetMessages {
    public static final int QUERY_ID_SUCCESS_LEN = 14;
    private byte[] neuronId;
    private byte[] idString;

    public BNeuronId getNeuronId() {
        return BNeuronId.make(this.neuronId);
    }

    public void setNeuronId(byte[] byArray) throws LonException {
        if (byArray.length != 6) {
            throw new IllegalArgumentException("Invalid neuronId length.");
        }
        System.arraycopy(byArray, 0, this.neuronId, 0, 6);
    }

    public BProgramId getIdString() {
        return BProgramId.make(this.idString);
    }

    public void setIdString(byte[] byArray) throws LonException {
        if (byArray.length != 8) {
            throw new IllegalArgumentException("Invalid idString length");
        }
        System.arraycopy(byArray, 0, this.idString, 0, 8);
    }

    public void toOutputStream(LonOutputStream lonOutputStream) {
        lonOutputStream.writeUnsigned8(this.code);
        lonOutputStream.write(this.neuronId, 0, 6);
        lonOutputStream.write(this.idString, 0, 8);
    }

    public void fromInputStream(LonInputStream lonInputStream) throws LonException {
        int n = lonInputStream.readUnsigned8();
        if (n != 33) {
            throw new InvalidResponseException(n);
        }
        lonInputStream.read(this.neuronId, 0, 6);
        lonInputStream.read(this.idString, 0, 8);
    }

    public String toString() {
        return "\nneuronId " + LonByteArrayUtil.toString(this.neuronId, ':') + "\nidString " + LonByteArrayUtil.toString(this.idString, ':');
    }

    private final /* synthetic */ void this() {
        this.neuronId = new byte[6];
        this.idString = new byte[8];
    }

    public QueryIdResponse() {
        this.this();
        this.code = 33;
    }

    public QueryIdResponse(byte[] byArray, byte[] byArray2) throws LonException {
        this.this();
        this.code = 33;
        this.setNeuronId(byArray);
        this.setIdString(byArray2);
    }

    public QueryIdResponse(LonInputStream lonInputStream) throws LonException {
        this.this();
        this.code = 33;
        this.fromInputStream(lonInputStream);
    }
}

