/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.netmessages;

import com.tridium.lonworks.netmessages.NetMessages;
import javax.baja.lonworks.InvalidResponseException;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.LonMessage;
import javax.baja.lonworks.enums.BAddressType;
import javax.baja.lonworks.enums.BLonGroupRestrictionEnum;
import javax.baja.lonworks.enums.BLonReceiveTimer;
import javax.baja.lonworks.enums.BLonRepeatTimer;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class QueryAddrResponse
extends LonMessage
implements NetMessages {
    public int addrType;
    public int domainIndex;
    public int memberOrNode;
    public int repeatTimer;
    public int retryCount;
    public int receiveTimer;
    public int xmitTimer;
    public int groupOrSubnet;
    public BLonGroupRestrictionEnum restriction;

    public int getDomainIndex() {
        return this.domainIndex;
    }

    public int getMemberOrNode() {
        return this.memberOrNode;
    }

    public int getNodeId() {
        return this.memberOrNode;
    }

    public BLonRepeatTimer getRepeatTimer() {
        return BLonRepeatTimer.make(this.repeatTimer);
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public BLonReceiveTimer getReceiveTimer() {
        return BLonReceiveTimer.make(this.receiveTimer);
    }

    public BLonRepeatTimer getXmitTimer() {
        return BLonRepeatTimer.make(this.xmitTimer);
    }

    public int getGroupOrSubnet() {
        return this.groupOrSubnet;
    }

    public int getSubnetId() {
        return this.groupOrSubnet;
    }

    public BLonGroupRestrictionEnum getRestriction() {
        return this.restriction;
    }

    public boolean isExtended() {
        return false;
    }

    public BAddressType getAddressType() {
        if ((this.addrType & 0x80) != 0) {
            return BAddressType.group;
        }
        if (this.addrType == 1) {
            return BAddressType.subnetNode;
        }
        if (this.addrType == 3) {
            return BAddressType.broadcast;
        }
        if (this.addrType == 0 && this.memberOrNode == 1) {
            return BAddressType.turnaround;
        }
        return BAddressType.none;
    }

    public int getSize() {
        if ((this.addrType & 0x80) != 0) {
            return this.addrType & 0xFFFFFF7F;
        }
        return -1;
    }

    public void toOutputStream(LonOutputStream lonOutputStream) {
        lonOutputStream.writeUnsigned8(this.code);
        lonOutputStream.write(this.addrType);
        int n = this.domainIndex << 7 | this.memberOrNode;
        lonOutputStream.write(n);
        n = this.repeatTimer << 4 | this.retryCount;
        lonOutputStream.write(n);
        n = this.receiveTimer << 4 | this.xmitTimer;
        lonOutputStream.write(n);
        lonOutputStream.write(this.groupOrSubnet);
    }

    public void fromInputStream(LonInputStream lonInputStream) throws LonException {
        int n = lonInputStream.readUnsigned8();
        if (n != 39) {
            throw new InvalidResponseException(n);
        }
        this.addrType = lonInputStream.readUnsigned8();
        int n2 = lonInputStream.readUnsigned8();
        this.memberOrNode = n2 & 0x7F;
        this.domainIndex = (n2 & 0x80) >> 7;
        n2 = lonInputStream.readUnsigned8();
        this.retryCount = n2 & 0xF;
        this.repeatTimer = (n2 & 0xF0) >> 4;
        n2 = lonInputStream.readUnsigned8();
        this.xmitTimer = n2 & 0xF;
        this.receiveTimer = (n2 & 0xF0) >> 4;
        this.groupOrSubnet = lonInputStream.readUnsigned8();
    }

    private final /* synthetic */ void this() {
        this.restriction = BLonGroupRestrictionEnum.grpNormal;
    }

    public QueryAddrResponse() {
        this.this();
    }

    public QueryAddrResponse(LonInputStream lonInputStream) throws LonException {
        this.this();
        this.code = 39;
        this.fromInputStream(lonInputStream);
    }
}

