/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.netmessages;

import com.tridium.lonworks.netmessages.FileXferResponse;
import com.tridium.lonworks.netmessages.NetMessages;
import com.tridium.lonworks.util.LonByteArrayUtil;
import javax.baja.lonworks.InvalidResponseException;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.LonMessage;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;

public class FileXferData
extends LonMessage
implements NetMessages {
    private int window;
    private int packet;
    private byte[] data;

    public int getWindow() {
        return this.window;
    }

    public int getPacket() {
        return this.packet;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setWindow(int n) {
        this.window = n;
    }

    public void setPacket(int n) {
        this.packet = n;
    }

    public void setData(byte[] byArray) {
        this.data = byArray;
    }

    public void toOutputStream(LonOutputStream lonOutputStream) {
        lonOutputStream.writeUnsigned8(this.code);
        byte by = (byte)(this.window << 4 | this.packet & 0xF);
        lonOutputStream.write(by);
        lonOutputStream.writeByteArray(this.data);
    }

    public void fromInputStream(LonInputStream lonInputStream) throws LonException {
        int n = lonInputStream.readUnsigned8();
        if (n != 62) {
            throw new InvalidResponseException(n);
        }
        try {
            int n2 = lonInputStream.read();
            this.window = n2 >> 4 & 0xF;
            this.packet = n2 & 0xF;
            int n3 = lonInputStream.available();
            this.data = new byte[n3];
            lonInputStream.read(this.data, 0, n3);
        }
        catch (Throwable throwable) {}
    }

    public LonMessage toResponse(LonInputStream lonInputStream) throws LonException {
        int n = lonInputStream.readUnsigned8();
        if (n > 6) {
            throw new InvalidResponseException(n);
        }
        return new FileXferResponse(n);
    }

    public String toString() {
        return "window=" + this.window + " packet=" + this.packet + "  data=" + LonByteArrayUtil.toString(this.data);
    }

    public FileXferData() {
        this.code = 62;
    }

    public FileXferData(int n, int n2, byte[] byArray) {
        this.code = 62;
        this.window = n;
        this.packet = n2;
        this.data = byArray;
    }
}

