/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.netmessages;

import com.tridium.lonworks.netmessages.NetMessages;
import com.tridium.lonworks.netmessages.NoDataResponse;
import javax.baja.lonworks.FailedResponseException;
import javax.baja.lonworks.InvalidResponseException;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.LonMessage;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;

public class ChecksumRecalcRequest
extends LonMessage
implements NetMessages {
    public int checksum;

    public int getChecksum() {
        return this.checksum;
    }

    public void setChecksum(int n) {
        this.checksum = n;
    }

    public void toOutputStream(LonOutputStream lonOutputStream) {
        lonOutputStream.writeUnsigned8(this.code);
        lonOutputStream.writeUnsigned8(this.checksum);
    }

    public void fromInputStream(LonInputStream lonInputStream) throws LonException {
        int n = lonInputStream.readUnsigned8();
        if (n != 111) {
            throw new InvalidResponseException(n);
        }
        this.setChecksum(lonInputStream.readUnsigned8());
    }

    public LonMessage toResponse(LonInputStream lonInputStream) throws LonException {
        int n = lonInputStream.readUnsigned8();
        if (n == 15) {
            throw new FailedResponseException();
        }
        if (n != 47) {
            throw new InvalidResponseException(n);
        }
        return new NoDataResponse(47);
    }

    public ChecksumRecalcRequest(int n) {
        this.code = 111;
        this.checksum = n;
    }
}

