/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.loncomm;

import com.tridium.lonworks.loncomm.LinkedQueue;
import com.tridium.lonworks.loncomm.ListenerSupport;
import com.tridium.lonworks.loncomm.LonLinkListenerRegistry;
import com.tridium.lonworks.loncomm.NAppBuffer;
import com.tridium.lonworks.loncomm.NLonComm;
import com.tridium.lonworks.netmessages.QueryStatusRequest;
import com.tridium.lonworks.util.NmUtil;
import com.tridium.platLon.BLonPlatformService;
import com.tridium.platLon.BLonPlatformServiceWin32;
import com.tridium.sys.station.Station;
import java.util.Hashtable;
import javax.baja.log.Log;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.LonComm;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.datatypes.BLocal;
import javax.baja.lonworks.enums.BLonServiceType;
import javax.baja.lonworks.io.AppBuffer;
import javax.baja.lonworks.io.LonLinkLayer;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class NLonLinkLayer
implements LonLinkLayer,
ListenerSupport {
    private static Hashtable devNameHash = new Hashtable();
    private String lonPort;
    private AppBufferReceive appBuffRcv;
    private LonReceiveDriver rcvDriver;
    private LonTransmitDriver xmitDriver;
    private Thread rcvThread;
    private Thread appThread;
    private Thread xmitThread;
    private BLonPlatformService driver;
    private int ldvHandle;
    private BLonNetwork lonworks;
    private NLonComm lonComm;
    private boolean done;
    private LonLinkListenerRegistry lstnrs;

    public final void verifySettings() throws Exception {
        this.init();
    }

    /*
     * Unable to fully structure code
     */
    private final void init() throws Exception {
        block6: {
            var1_1 = this.lonworks.getLonCommConfig().getDeviceName();
            NLonLinkLayer.verifyUnique(var1_1, this);
            if (var1_1.equals(this.lonPort)) {
                return;
            }
            var2_2 = this.lonworks.getComponentSpace();
            this.driver = var2_2 != null && var2_2 == Station.space ? (BLonPlatformService)Sys.getService((Type)BLonPlatformService.TYPE) : new BLonPlatformServiceWin32();
            if (this.driver == null) {
                throw new LonException("No LonPlatformService available");
            }
            try {
                this.ldvHandle = this.driver.driverInit(var1_1);
                this.lonPort = var1_1;
                break block6;
            }
            catch (Exception var3_3) {
                var4_4 = Sys.getServices((Type)BLonNetwork.TYPE);
                var5_5 = 0;
                ** while (var5_5 < var4_4.length)
            }
lbl-1000:
            // 1 sources

            {
                var6_6 = (BLonNetwork)var4_4[var5_5];
                if (var6_6 != this.lonworks && var6_6.getLonCommConfig().getDeviceName().equals(var1_1)) {
                    this.lonworks.log().error("Unable to initialize driver because lon port in use by " + var6_6.getDisplayName(null) + ". Change loncomm deviceName and restart station");
                    break;
                }
                ++var5_5;
                continue;
            }
lbl23:
            // 2 sources

            throw new LonException("Unable to initialize local lon port {" + var1_1 + '}', var3_3);
        }
    }

    private static final void verifyUnique(String string, NLonLinkLayer nLonLinkLayer) throws Exception {
        NLonLinkLayer nLonLinkLayer2 = (NLonLinkLayer)devNameHash.get(string);
        if (nLonLinkLayer2 != null && (!nLonLinkLayer2.lonworks.isMounted() || nLonLinkLayer2.lonworks.isDisabled())) {
            devNameHash.remove(string);
            nLonLinkLayer2 = null;
        }
        if (nLonLinkLayer2 != null && nLonLinkLayer2 != nLonLinkLayer) {
            throw new LonException("deviceName must be unique");
        }
        String string2 = nLonLinkLayer.lonPort;
        if (!string.equals(string2) && string2.length() > 0) {
            devNameHash.remove(string2);
        }
        if (nLonLinkLayer2 == null) {
            devNameHash.put(string, nLonLinkLayer);
        }
    }

    public final void start() throws Exception {
        this.init();
        this.done = false;
        this.appBuffRcv = new AppBufferReceive();
        this.appThread = new Thread((Runnable)this.appBuffRcv, this.lonComm.lonNetwork().getLogName() + ".AppBufferRcv");
        this.appThread.start();
        this.appThread.setPriority(5);
        this.rcvDriver = new LonReceiveDriver();
        this.rcvThread = new Thread((Runnable)this.rcvDriver, this.lonComm.lonNetwork().getLogName() + ".RcvDriver");
        this.rcvThread.start();
        this.rcvThread.setPriority(7);
        this.xmitDriver = new LonTransmitDriver();
        this.xmitThread = new Thread((Runnable)this.xmitDriver, this.lonComm.lonNetwork().getLogName() + ".XmitDriver");
        this.xmitThread.start();
        this.xmitThread.setPriority(5);
    }

    public final void stop() {
        this.done = true;
        if (this.rcvThread != null) {
            this.rcvThread.interrupt();
        }
        if (this.appThread != null) {
            this.appThread.interrupt();
        }
        if (this.xmitThread != null) {
            this.xmitThread.interrupt();
        }
        try {
            NAppBuffer nAppBuffer = NAppBuffer.makeAppBuffer();
            nAppBuffer.setServiceType(BLonServiceType.request);
            nAppBuffer.setDestAddress(BLocal.local);
            nAppBuffer.setMessage(new QueryStatusRequest());
            this.driver.write(this.ldvHandle, nAppBuffer.getWriteBuffer(), nAppBuffer.getWriteBufferLen());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public final void sendLonMessage(AppBuffer appBuffer) {
        if (this.done) {
            return;
        }
        this.xmitDriver.sendToDriver((NAppBuffer)appBuffer);
    }

    private final Log log() {
        return this.lonworks.log();
    }

    public final LonLinkListenerRegistry getLonLinkListenerRegistry() {
        return this.lstnrs;
    }

    private final /* synthetic */ void this() {
        this.lonPort = "";
        this.rcvThread = null;
        this.appThread = null;
        this.xmitThread = null;
        this.done = true;
        this.lstnrs = null;
    }

    public NLonLinkLayer(LonComm lonComm, BLonNetwork bLonNetwork) {
        this.this();
        this.lonworks = bLonNetwork;
        this.lonComm = (NLonComm)lonComm;
        this.lstnrs = new LonLinkListenerRegistry(bLonNetwork);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class AppBufferReceive
    implements Runnable {
        LinkedQueue rcvQueue;

        public void run() {
            while (!NLonLinkLayer.this.done) {
                try {
                    NAppBuffer nAppBuffer = (NAppBuffer)this.rcvQueue.dequeue();
                    if (nAppBuffer == null) continue;
                    NLonLinkLayer.this.lonComm.receiveLonMessage(nAppBuffer);
                }
                catch (ThreadDeath threadDeath) {
                    NLonLinkLayer.this.done = true;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    NLonLinkLayer.this.lonworks.log().error("Exception caught in AppBufferReceive. " + throwable);
                }
            }
        }

        private final void rcvAppBuffer(NAppBuffer nAppBuffer) {
            this.rcvQueue.enqueue(nAppBuffer);
        }

        private final /* synthetic */ void this() {
            this.rcvQueue = new LinkedQueue();
        }

        private AppBufferReceive() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class LonReceiveDriver
    implements Runnable {
        public void run() {
            NAppBuffer nAppBuffer = NAppBuffer.makeAppBuffer();
            while (!NLonLinkLayer.this.done) {
                try {
                    byte[] byArray = nAppBuffer.getReadBuffer();
                    if (NLonLinkLayer.this.driver.read(NLonLinkLayer.this.ldvHandle, byArray)) {
                        byte by;
                        NLonLinkLayer.this.lstnrs.listenerReceive(nAppBuffer);
                        if (NLonLinkLayer.this.log().isTraceOn() || NLonLinkLayer.this.lonComm.getLinkDebug()) {
                            NLonLinkLayer.this.lstnrs.writeLinkDebug("Link recv: ", byArray, (byArray[1] & 0xFF) + 2);
                        }
                        if ((by = byArray[1]) > 5 && byArray[4] != by - 14) {
                            byArray[4] = (byte)(by - 14);
                        }
                        if (nAppBuffer.isResponse()) {
                            NLonLinkLayer.this.lonComm.handleResponseMessage(nAppBuffer);
                        } else {
                            NLonLinkLayer.this.appBuffRcv.rcvAppBuffer(nAppBuffer);
                        }
                        nAppBuffer = NAppBuffer.makeAppBuffer();
                        continue;
                    }
                    NmUtil.wait(20);
                }
                catch (ThreadDeath threadDeath) {
                    NLonLinkLayer.this.done = true;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    NLonLinkLayer.this.lonworks.log().error("NLonLinkLayer.LonReceiveDriver error", throwable);
                }
            }
        }

        private LonReceiveDriver() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class LonTransmitDriver
    implements Runnable {
        LinkedQueue sendQueue;

        public void run() {
            while (!NLonLinkLayer.this.done) {
                NAppBuffer nAppBuffer = (NAppBuffer)this.sendQueue.dequeue();
                if (nAppBuffer == null) continue;
                try {
                    if (NLonLinkLayer.this.log().isTraceOn() || NLonLinkLayer.this.lonComm.getLinkDebug()) {
                        byte[] byArray = nAppBuffer.getWriteBuffer();
                        NLonLinkLayer.this.lstnrs.writeLinkDebug("Link send: ", byArray, (byArray[1] & 0xFF) + 2);
                    }
                    NLonLinkLayer.this.lstnrs.listenerSend(nAppBuffer);
                    NLonLinkLayer.this.driver.write(NLonLinkLayer.this.ldvHandle, nAppBuffer.getWriteBuffer(), nAppBuffer.getWriteBufferLen());
                }
                catch (ThreadDeath threadDeath) {
                    NLonLinkLayer.this.done = true;
                }
                catch (Throwable throwable) {
                    try {
                        NLonLinkLayer.this.lonComm.handleFailedTransmit(nAppBuffer, new LonException("Failed transmit to lonDriver.", throwable));
                    }
                    catch (Throwable throwable2) {
                        throwable2.printStackTrace();
                        NLonLinkLayer.this.lonworks.log().error("Unable to handle failed transmit in NLonLinkLayer ", throwable2);
                    }
                }
                if (!nAppBuffer.isNoTransaction()) continue;
                nAppBuffer.releaseAppBuffer();
            }
        }

        private final void sendToDriver(NAppBuffer nAppBuffer) {
            this.sendQueue.enqueue(nAppBuffer);
        }

        private final /* synthetic */ void this() {
            this.sendQueue = new LinkedQueue();
        }

        private LonTransmitDriver() {
            this.this();
        }
    }
}

