/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.loncomm;

import com.tridium.lonworks.enums.BLonCompletionCode;
import com.tridium.lonworks.loncomm.LonTransaction;
import com.tridium.lonworks.loncomm.LonTransactionManager;
import com.tridium.lonworks.loncomm.NAppBuffer;
import com.tridium.lonworks.util.NmUtil;
import java.util.Vector;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.InvalidResponseException;
import javax.baja.lonworks.LonComm;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.LonListener;
import javax.baja.lonworks.LonMessage;
import javax.baja.lonworks.datatypes.BSubnetNode;
import javax.baja.lonworks.datatypes.LonAddress;
import javax.baja.lonworks.enums.BLonServiceType;
import javax.baja.lonworks.io.LonLinkLayer;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.util.IntHashMap;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NLonComm
implements LonComm {
    protected BLonNetwork lonworks;
    LonLinkLayer linkLayer;
    private LonTransactionManager transactionManager;
    private boolean serviceStarted;
    private int workingDomain;
    private IntHashMap listners;
    private LonListener nvListner;
    static /* synthetic */ Class class$com$tridium$lonworks$netmessages$UnprocessedNV;

    public void start() throws Exception {
        this.updateWorkingDomain();
        this.linkLayer.start();
        this.serviceStarted = true;
        this.transactionManager.start();
    }

    public void stop() {
        if (!this.serviceStarted) {
            return;
        }
        this.serviceStarted = false;
        this.linkLayer.stop();
        this.transactionManager.stop();
    }

    public void verifySettings() throws Exception {
        this.linkLayer.verifySettings();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LonMessage sendRequest(LonAddress lonAddress, LonMessage lonMessage) throws LonException {
        NAppBuffer nAppBuffer = NAppBuffer.makeAppBuffer();
        nAppBuffer.setServiceType(BLonServiceType.request);
        nAppBuffer.setAuthenticate(lonMessage.isAuthenticate());
        nAppBuffer.setDomainIndex(this.workingDomain);
        nAppBuffer.setDestAddress(lonAddress);
        nAppBuffer.setMessage(lonMessage);
        LonException lonException = null;
        NAppBuffer nAppBuffer2 = null;
        LonMessage lonMessage2 = null;
        boolean bl = true;
        boolean bl2 = false;
        try {
            while (bl || bl2) {
                bl = false;
                nAppBuffer2 = this.doLonCommSendRequest(nAppBuffer, -1);
                if (nAppBuffer2 == null) {
                    lonException = new LonException("Message failed to send.");
                    continue;
                }
                if (nAppBuffer2.exception != null) {
                    lonException = new LonException("SendRequest failed", (Throwable)((Object)nAppBuffer2.exception));
                    continue;
                }
                try {
                    lonMessage2 = nAppBuffer2.makeResponse(lonMessage);
                    bl2 = false;
                }
                catch (InvalidResponseException invalidResponseException) {
                    if (bl2 ^= true) {
                        nAppBuffer2.releaseAppBuffer();
                        continue;
                    }
                    lonException = invalidResponseException;
                }
            }
        }
        catch (LonException lonException2) {
            lonException = lonException2;
        }
        nAppBuffer.releaseAppBuffer();
        if (nAppBuffer2 != null) {
            nAppBuffer2.releaseAppBuffer();
        }
        if (lonException != null) {
            throw lonException;
        }
        return lonMessage2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NAppBuffer doLonCommSendRequest(NAppBuffer nAppBuffer, int n) throws LonException {
        if (!this.serviceStarted) {
            this.lonCommNotStarted();
        }
        nAppBuffer.setDefaultTimers(this.lonworks);
        LonTransaction lonTransaction = n == 15 ? this.transactionManager.getLonTransactionTag15(nAppBuffer) : this.transactionManager.getLonTransaction(nAppBuffer);
        LonTransaction lonTransaction2 = lonTransaction;
        synchronized (lonTransaction2) {
            this.linkLayer.sendLonMessage(nAppBuffer);
            try {
                lonTransaction.wait();
                lonTransaction.setComplete(true);
            }
            catch (InterruptedException interruptedException) {}
            NAppBuffer nAppBuffer2 = lonTransaction.getResponseMessage();
            LonException lonException = lonTransaction.getException();
            this.transactionManager.freeLonTransaction(lonTransaction);
            if (nAppBuffer2 == null && lonException != null) {
                throw new LonException("send failed", (Throwable)((Object)lonException));
            }
            if (lonException != null) {
                nAppBuffer2.exception = lonException;
            }
            return nAppBuffer2;
        }
    }

    public void sendResponse(LonMessage lonMessage, LonMessage lonMessage2) {
        if (!this.serviceStarted) {
            this.lonCommNotStarted();
        }
        NAppBuffer nAppBuffer = NAppBuffer.makeAppBuffer();
        nAppBuffer.setTag(lonMessage.getTag());
        nAppBuffer.setServiceType(BLonServiceType.request);
        nAppBuffer.setPriority(lonMessage.isPriority());
        nAppBuffer.setResp(true);
        nAppBuffer.setDestAddress(lonMessage.getSourceAddress());
        nAppBuffer.setMessage(lonMessage2);
        this.doSendResponse(nAppBuffer);
    }

    public void doSendResponse(NAppBuffer nAppBuffer) {
        nAppBuffer.setNoTransaction(true);
        this.linkLayer.sendLonMessage(nAppBuffer);
    }

    public void sendAcked(LonAddress lonAddress, LonMessage lonMessage) throws LonException {
        NAppBuffer nAppBuffer = NAppBuffer.makeAppBuffer();
        nAppBuffer.setServiceType(BLonServiceType.acked);
        nAppBuffer.setAuthenticate(lonMessage.isAuthenticate());
        nAppBuffer.setDomainIndex(this.workingDomain);
        nAppBuffer.setDestAddress(lonAddress);
        nAppBuffer.setMessage(lonMessage);
        this.sendNormal(nAppBuffer);
    }

    public void sendUnacknowledged(LonAddress lonAddress, LonMessage lonMessage) throws LonException {
        NAppBuffer nAppBuffer = NAppBuffer.makeAppBuffer();
        nAppBuffer.setQueue(4);
        nAppBuffer.setServiceType(BLonServiceType.unacked);
        nAppBuffer.setAuthenticate(false);
        nAppBuffer.setDomainIndex(this.workingDomain);
        nAppBuffer.setDestAddress(lonAddress);
        nAppBuffer.setMessage(lonMessage);
        this.sendNormal(nAppBuffer);
    }

    public void sendUnackRepeat(LonAddress lonAddress, LonMessage lonMessage) throws LonException {
        NAppBuffer nAppBuffer = NAppBuffer.makeAppBuffer();
        nAppBuffer.setQueue(2);
        nAppBuffer.setServiceType(BLonServiceType.unackedRpt);
        nAppBuffer.setAuthenticate(false);
        nAppBuffer.setDomainIndex(this.workingDomain);
        nAppBuffer.setDestAddress(lonAddress);
        nAppBuffer.setMessage(lonMessage);
        this.sendNormal(nAppBuffer);
    }

    public void sendNormal(NAppBuffer nAppBuffer) throws LonException {
        LonException lonException = null;
        NAppBuffer nAppBuffer2 = null;
        try {
            nAppBuffer2 = this.doLonCommSendNormal(nAppBuffer);
            if (nAppBuffer2 != null && nAppBuffer2.exception != null) {
                lonException = new LonException("sendNormal failed", (Throwable)((Object)nAppBuffer2.exception));
            }
        }
        catch (LonException lonException2) {
            lonException = lonException2;
        }
        if (!nAppBuffer.isNoTransaction()) {
            nAppBuffer.releaseAppBuffer();
        }
        if (nAppBuffer2 != null) {
            nAppBuffer2.releaseAppBuffer();
        }
        if (lonException != null) {
            throw lonException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NAppBuffer doLonCommSendNormal(NAppBuffer nAppBuffer) throws LonException {
        if (!this.serviceStarted) {
            this.lonCommNotStarted();
        }
        nAppBuffer.setDefaultTimers(this.lonworks);
        if (nAppBuffer.isLocalAddress()) {
            nAppBuffer.setNoTransaction(true);
            this.linkLayer.sendLonMessage(nAppBuffer);
            return null;
        }
        LonTransaction lonTransaction = this.transactionManager.getLonTransaction(nAppBuffer);
        LonTransaction lonTransaction2 = lonTransaction;
        synchronized (lonTransaction2) {
            this.linkLayer.sendLonMessage(nAppBuffer);
            try {
                lonTransaction.wait();
                lonTransaction.setComplete(true);
            }
            catch (InterruptedException interruptedException) {}
            NAppBuffer nAppBuffer2 = lonTransaction.getResponseMessage();
            LonException lonException = lonTransaction.getException();
            this.transactionManager.freeLonTransaction(lonTransaction);
            if (nAppBuffer2 == null && lonException != null) {
                throw new LonException("sendNormal failed", (Throwable)((Object)lonException));
            }
            if (lonException != null) {
                nAppBuffer2.exception = lonException;
            }
            return nAppBuffer2;
        }
    }

    public void sendLocalCommand(int n) throws LonException {
        if (!this.serviceStarted) {
            this.lonCommNotStarted();
        }
        NAppBuffer nAppBuffer = NAppBuffer.makeAppBuffer();
        nAppBuffer.setLocalCommand(n);
        nAppBuffer.setNoTransaction(true);
        this.linkLayer.sendLonMessage(nAppBuffer);
    }

    public void receiveLonMessage(NAppBuffer nAppBuffer) {
        if (nAppBuffer.isIncoming()) {
            try {
                if ((nAppBuffer.getMessageCode() & 0x80) == 128) {
                    this.routeToNvListener(nAppBuffer);
                } else {
                    this.routeToListeners(nAppBuffer);
                }
            }
            catch (LonException lonException) {
                this.lonworks.log().error("Unable to process received message. \n" + nAppBuffer + '\n', (Throwable)((Object)lonException));
            }
            nAppBuffer.releaseAppBuffer();
        } else {
            this.lonworks.log().error("Unknown app buffer msg type. \n" + nAppBuffer);
            nAppBuffer.releaseAppBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handleFailedTransmit(NAppBuffer nAppBuffer, LonException lonException) {
        if (nAppBuffer.isNoTransaction()) {
            return;
        }
        int n = nAppBuffer.getTransactionTag();
        LonTransaction lonTransaction = this.getTransactionManager().getLonTransactionMatch(n);
        LonTransaction lonTransaction2 = lonTransaction;
        synchronized (lonTransaction2) {
            lonTransaction.setResponseMessage(null);
            lonTransaction.setException(lonException);
            lonTransaction.notify();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleResponseMessage(NAppBuffer nAppBuffer) {
        int n = nAppBuffer.getTransactionTag();
        LonTransaction lonTransaction = this.getTransactionManager().getLonTransactionMatch(n);
        LonTransaction lonTransaction2 = lonTransaction;
        synchronized (lonTransaction2) {
            if (!lonTransaction.isUsed()) {
                this.lonworks.log().warning("Received response message with no matching transaction.\n" + nAppBuffer);
                nAppBuffer.releaseAppBuffer();
                return;
            }
            lonTransaction.addResponseMessage(nAppBuffer);
            BLonCompletionCode bLonCompletionCode = nAppBuffer.getComplCode();
            if (bLonCompletionCode == BLonCompletionCode.notComp) {
                if (lonTransaction.isLocal()) {
                    lonTransaction.notify();
                }
            } else if (bLonCompletionCode == BLonCompletionCode.succeeds) {
                lonTransaction.notify();
            } else if (bLonCompletionCode == BLonCompletionCode.fails) {
                LonException lonException = nAppBuffer.exception != null ? nAppBuffer.exception : new LonException("Neuron timeout before response received");
                lonTransaction.setException(lonException);
                lonTransaction.notify();
            }
            return;
        }
    }

    private final void lonCommNotStarted() {
        throw new BajaRuntimeException("LonComm not started.");
    }

    public void registerNvListener(LonListener lonListener) {
        this.nvListner = lonListener;
    }

    private final void routeToNvListener(NAppBuffer nAppBuffer) throws LonException {
        if (this.nvListner == null) {
            return;
        }
        Class clazz = class$com$tridium$lonworks$netmessages$UnprocessedNV;
        if (clazz == null) {
            clazz = class$com$tridium$lonworks$netmessages$UnprocessedNV = NLonComm.class("[Lcom.tridium.lonworks.netmessages.UnprocessedNV;", false);
        }
        LonMessage lonMessage = nAppBuffer.getLonMessage(clazz);
        this.nvListner.receiveLonMessage(lonMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void registerLonListener(LonListener lonListener, int n, BSubnetNode bSubnetNode, Class clazz) {
        IntHashMap intHashMap = this.listners;
        synchronized (intHashMap) {
            if (n < 0 || n > 127) {
                throw new IllegalArgumentException("Invalid message code " + n + ", must be in range 0 to 127");
            }
            Vector<ListenerData> vector = (Vector<ListenerData>)this.listners.get(n);
            if (vector == null) {
                vector = new Vector<ListenerData>(4);
                this.listners.put(n, vector);
            }
            int n2 = 0;
            while (n2 < vector.size()) {
                ListenerData listenerData = (ListenerData)vector.elementAt(n2);
                if (lonListener == listenerData.listner && (listenerData.address == null || bSubnetNode == listenerData.address)) {
                    return;
                }
                ++n2;
            }
            vector.addElement(new ListenerData(lonListener, bSubnetNode, clazz));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unregisterLonListener(LonListener lonListener, int n, BSubnetNode bSubnetNode) {
        IntHashMap intHashMap = this.listners;
        synchronized (intHashMap) {
            block6: {
                block5: {
                    if (n != -1) break block5;
                    IntHashMap.Iterator iterator = this.listners.iterator();
                    while (iterator.hasNext()) {
                        this.unregister((Vector)iterator.next(), lonListener, bSubnetNode);
                    }
                    break block6;
                }
                Vector vector = (Vector)this.listners.get(n);
                if (vector == null) {
                    return;
                }
                this.unregister(vector, lonListener, bSubnetNode);
            }
            return;
        }
    }

    private final void unregister(Vector vector, LonListener lonListener, BSubnetNode bSubnetNode) {
        int n = vector.size() - 1;
        while (n >= 0) {
            ListenerData listenerData = (ListenerData)vector.elementAt(n);
            if (lonListener == listenerData.listner && (bSubnetNode == null || bSubnetNode == listenerData.address)) {
                vector.removeElementAt(n);
            }
            --n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private final void routeToListeners(NAppBuffer nAppBuffer) throws LonException {
        boolean bl;
        block5: {
            bl = false;
            IntHashMap intHashMap = this.listners;
            // MONITORENTER : intHashMap
            Vector vector = (Vector)this.listners.get(nAppBuffer.getMessageCode());
            if (vector == null) break block5;
            int n = 0;
            while (n < vector.size()) {
                ListenerData listenerData = (ListenerData)vector.elementAt(n);
                if (listenerData.address == null || listenerData.address.equals(nAppBuffer.getSourceAddress())) {
                    LonMessage lonMessage = nAppBuffer.getLonMessage(listenerData.messageClass);
                    listenerData.listner.receiveLonMessage(lonMessage);
                    bl = true;
                }
                ++n;
            }
        }
        // MONITOREXIT : intHashMap
        if (bl) return;
        this.lonworks.log().warning("No listener for received message:" + nAppBuffer);
        if (!nAppBuffer.isRequest()) return;
        NmUtil.sendFailedResponse(this, nAppBuffer.getLonMessage(null));
    }

    private final LonTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public boolean getLinkDebug() {
        return this.lonworks.getLonCommConfig().getLinkDebug();
    }

    public BLonNetwork lonNetwork() {
        return this.lonworks;
    }

    public void updateWorkingDomain() {
        this.workingDomain = this.lonworks.getLocalLonDevice().getDeviceData().getWorkingDomain();
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        this.transactionManager.spy(spyWriter);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.serviceStarted = false;
        this.workingDomain = 0;
        this.listners = new IntHashMap(32);
        this.nvListner = null;
    }

    public NLonComm(BLonNetwork bLonNetwork) {
        this.this();
        this.lonworks = bLonNetwork;
        this.transactionManager = new LonTransactionManager(this);
        this.linkLayer = bLonNetwork.getLonCommConfig().makeLonLinkLayer(this, bLonNetwork);
    }

    private static class ListenerData {
        LonListener listner;
        BSubnetNode address;
        Class messageClass;

        ListenerData(LonListener lonListener, BSubnetNode bSubnetNode, Class clazz) {
            this.listner = lonListener;
            this.address = bSubnetNode;
            this.messageClass = clazz;
        }
    }
}

