/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.loncomm;

import com.tridium.lonworks.loncomm.LonTransaction;
import com.tridium.lonworks.loncomm.NAppBuffer;
import com.tridium.lonworks.loncomm.NLonComm;
import com.tridium.lonworks.util.LonByteArrayUtil;
import java.util.Vector;
import javax.baja.lonworks.LonException;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Clock;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class LonTransactionManager {
    private static final int MAX_TAG = 14;
    private static final int NUM_OF_LON_TRANSACTIONS = 16;
    long tryCnt;
    private LonTransaction[] lonTransactionBuffers;
    private boolean transactionInProgress;
    private int lastTagUsed;
    private NLonComm lonComm;
    private TransactionTimer transactionTimer;
    private Thread timerThread;
    private boolean done;

    final void start() {
        this.done = false;
        this.transactionTimer = new TransactionTimer();
        this.timerThread = new Thread((Runnable)this.transactionTimer, this.lonComm.lonNetwork().getLogName() + ".TransactionTimer");
        this.timerThread.start();
        this.timerThread.setPriority(5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final synchronized void stop() {
        this.done = true;
        if (this.timerThread != null) {
            this.timerThread.interrupt();
            this.timerThread = null;
        }
        this.notifyAll();
        int n = 0;
        while (n < 16) {
            LonTransaction lonTransaction = this.lonTransactionBuffers[n];
            this.freeLonTransaction(lonTransaction);
            LonTransaction lonTransaction2 = lonTransaction;
            synchronized (lonTransaction2) {
                lonTransaction.notify();
                // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl14 : MonitorExitStatement: MONITOREXIT : var3_3
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected final LonTransaction getLonTransaction(NAppBuffer nAppBuffer) {
        while (!this.done) {
            LonTransactionManager lonTransactionManager = this;
            // MONITORENTER : lonTransactionManager
            {
                int n = this.lastTagUsed >= 14 ? 0 : this.lastTagUsed + 1;
                if (!this.transactionInProgress) {
                    int n2 = n;
                    while (n2 <= 14) {
                        if (!this.lonTransactionBuffers[n2].isUsed()) {
                            this.lastTagUsed = n2;
                            this.initTransaction(n2, nAppBuffer);
                            // MONITOREXIT : lonTransactionManager
                            return this.lonTransactionBuffers[n2];
                        }
                        ++n2;
                    }
                    n2 = 0;
                    while (n2 < n) {
                        if (!this.lonTransactionBuffers[n2].isUsed()) {
                            this.lastTagUsed = n2;
                            this.initTransaction(n2, nAppBuffer);
                            // MONITOREXIT : lonTransactionManager
                            return this.lonTransactionBuffers[n2];
                        }
                        ++n2;
                    }
                }
                ++this.tryCnt;
                try {
                    this.wait(2000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected final LonTransaction getLonTransactionTag15(NAppBuffer nAppBuffer) {
        int n = 15;
        while (!this.done) {
            LonTransactionManager lonTransactionManager = this;
            // MONITORENTER : lonTransactionManager
            {
                if (!this.transactionInProgress && !this.lonTransactionBuffers[n].isUsed()) {
                    this.initTransaction(n, nAppBuffer);
                    // MONITOREXIT : lonTransactionManager
                    return this.lonTransactionBuffers[n];
                }
                try {
                    this.wait(2000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return null;
    }

    private final void initTransaction(int n, NAppBuffer nAppBuffer) {
        LonTransaction lonTransaction = this.lonTransactionBuffers[n];
        lonTransaction.setUsed(true);
        lonTransaction.setLocal(nAppBuffer.isLocalAddress());
        lonTransaction.setOutgoingMessage(nAppBuffer);
        nAppBuffer.setTransactionTag(n);
        this.transactionTimer.start(lonTransaction);
        this.transactionInProgress = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void freeLonTransaction(LonTransaction lonTransaction) {
        LonTransactionManager lonTransactionManager = this;
        synchronized (lonTransactionManager) {
            if (this.transactionTimer != null) {
                this.transactionTimer.cancel(lonTransaction);
            }
            lonTransaction.setOutgoingMessage(null);
            lonTransaction.setResponseMessage(null);
            lonTransaction.setLocal(false);
            lonTransaction.setUsed(false);
            lonTransaction.setComplete(false);
            lonTransaction.setException(null);
            this.transactionInProgress = false;
            this.notify();
            return;
        }
    }

    protected final LonTransaction getLonTransactionMatch(int n) {
        return this.lonTransactionBuffers[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void timeOut(LonTransaction lonTransaction) {
        String string = "LonTransaction timed out " + lonTransaction.getTag() + " :";
        NAppBuffer nAppBuffer = lonTransaction.getOutgoingMessage();
        if (nAppBuffer != null) {
            string = string.concat(LonByteArrayUtil.toString(nAppBuffer.getReadBuffer(), nAppBuffer.getWriteBufferLen()));
        }
        this.lonComm.lonworks.log().warning(string);
        LonTransaction lonTransaction2 = lonTransaction;
        synchronized (lonTransaction2) {
            if (lonTransaction.isUsed() && !lonTransaction.isComplete()) {
                lonTransaction.setResponseMessage(null);
                lonTransaction.setException(new LonException("Timed out waiting for neuron to respond."));
                lonTransaction.notify();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void spy(SpyWriter spyWriter) throws Exception {
        spyWriter.startProps("Transaction Manager");
        spyWriter.prop((Object)"transactionInProgress", this.transactionInProgress);
        spyWriter.prop((Object)"lastTagUsed", this.lastTagUsed);
        spyWriter.prop((Object)"timerThread alive", this.timerThread.isAlive());
        spyWriter.prop((Object)"done", this.done);
        spyWriter.prop((Object)"tryCnt", (double)this.tryCnt);
        spyWriter.endProps();
        spyWriter.startTable(true);
        spyWriter.trTitle((Object)"transactions", 4);
        spyWriter.w((Object)"<tr>").th((Object)"tag").th((Object)"local").th((Object)"cmpl").th((Object)"end").th((Object)"msg").w((Object)"</tr>\n");
        LonTransactionManager lonTransactionManager = this;
        synchronized (lonTransactionManager) {
            long l = Clock.ticks();
            int n = 0;
            while (n < this.lonTransactionBuffers.length) {
                LonTransaction lonTransaction = this.lonTransactionBuffers[n];
                if (lonTransaction.isUsed()) {
                    spyWriter.tr((Object)Integer.toString(lonTransaction.getTag()), (Object)Boolean.toString(lonTransaction.isLocal()), (Object)Boolean.toString(lonTransaction.isComplete()), (Object)Long.toString(lonTransaction.getEndTime() - l), (Object)Integer.toString(lonTransaction.getOutgoingMessage().getMessageCode()));
                }
                ++n;
            }
        }
        spyWriter.endTable();
    }

    static final /* synthetic */ int access$0() {
        return 16;
    }

    private final /* synthetic */ void this() {
        this.tryCnt = 0L;
        this.lonTransactionBuffers = new LonTransaction[16];
        this.transactionInProgress = false;
        this.lastTagUsed = 15;
        this.lonComm = null;
        this.timerThread = null;
        this.done = false;
    }

    LonTransactionManager(NLonComm nLonComm) {
        this.this();
        this.lonComm = nLonComm;
        int n = 0;
        while (n < 16) {
            LonTransaction lonTransaction;
            this.lonTransactionBuffers[n] = lonTransaction = new LonTransaction(n);
            ++n;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class TransactionTimer
    implements Runnable {
        private Vector v;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            while (!LonTransactionManager.this.done) {
                TransactionTimer transactionTimer = this;
                // MONITORENTER : transactionTimer
                {
                    long l = Clock.ticks();
                    int n = 10000;
                    if (!this.v.isEmpty()) {
                        LonTransaction lonTransaction = (LonTransaction)this.v.firstElement();
                        long l2 = lonTransaction.getEndTime();
                        if (l2 <= l) {
                            this.v.removeElement(lonTransaction);
                            LonTransactionManager.this.timeOut(lonTransaction);
                            n = 0;
                        } else {
                            n = (int)(l2 - l);
                        }
                    }
                    try {
                        this.wait(n);
                    }
                    catch (Exception exception) {}
                }
            }
        }

        synchronized void start(LonTransaction lonTransaction) {
            long l = lonTransaction.getOutgoingMessage().getMaxTransactionTime();
            if (l > 8000L) {
                l = 8000L;
            }
            long l2 = Clock.ticks() + l + 1000L;
            lonTransaction.setEndTime(l2);
            int n = 0;
            while (n < this.v.size()) {
                if (((LonTransaction)this.v.elementAt(n)).getEndTime() > l2) break;
                ++n;
            }
            this.v.insertElementAt(lonTransaction, n);
            if (n == 0) {
                this.notifyAll();
            }
        }

        synchronized void cancel(LonTransaction lonTransaction) {
            lonTransaction.setEndTime(0L);
            this.v.removeElement(lonTransaction);
            this.notifyAll();
        }

        private final /* synthetic */ void this() {
            this.v = new Vector(16);
        }

        private TransactionTimer() {
            this.this();
        }
    }
}

