/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.file;

import com.tridium.lonworks.netmessages.NetMessages;
import com.tridium.lonworks.util.Neuron;
import com.tridium.lonworks.util.NmUtil;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BNetworkVariable;
import javax.baja.lonworks.LonComm;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.datatypes.LonAddress;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.londata.BLonPrimitive;
import javax.baja.lonworks.util.LonFile;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LonFileReadWrite
extends LonFile
implements NetMessages {
    private static int SZ_FILE_DIR_HEADER = 2;
    private static int SZ_FILE_DESCRIPTOR_10 = 5;
    private static int SZ_FILE_DESCRIPTOR_20 = 6;
    private static final int MAX_DATA_SIZE = 16;
    private boolean opened;
    private LonAddress sendAddr;
    private LonComm lonComm;
    private String devName;
    private boolean auth;
    private int filePtr;
    private FileDirectory dir;
    private int size;
    private int offset;

    public LonFile copy() {
        return new LonFileReadWrite(this);
    }

    public void open(int n, boolean bl, boolean bl2) throws LonException {
        FileDescriptor fileDescriptor = this.dir.files[n];
        this.filePtr = fileDescriptor.filePtr;
        this.size = fileDescriptor.size;
        this.opened = true;
    }

    public byte[] read(int n, int n2) throws LonException {
        this.offset = n;
        return this.read(n2);
    }

    public byte[] read() throws LonException {
        this.offset = 0;
        return this.read(this.size);
    }

    public byte[] read(int n) throws LonException {
        if (n > this.size - this.offset) {
            throw new LonException("Attempt to access beyond end of file.  size=" + this.size + " offset=" + this.offset + "  length=" + n);
        }
        byte[] byArray = Neuron.readMemory(this.lonComm, 0, this.sendAddr, this.filePtr + this.offset, n, this.auth);
        this.offset += n;
        return byArray;
    }

    public void write(byte[] byArray, int n) throws LonException {
        this.offset = n;
        this.write(byArray);
    }

    public void write(byte[] byArray) throws LonException {
        Neuron.writeMemory(this.lonComm, 0, this.sendAddr, this.filePtr + this.offset, 0, byArray, this.auth, false);
    }

    public void close() throws LonException {
        this.opened = false;
    }

    public boolean isOpen() {
        return this.opened;
    }

    public void flush() throws LonException {
    }

    public String getDirectoryString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("File Directory Structure for " + this.devName);
        stringBuffer.append("\n   File Version = " + ((this.dir.version & 0xF0) >> 4) + '.' + (this.dir.version & 0xF));
        stringBuffer.append("\n   Number of files =  " + this.dir.numFiles);
        int n = 0;
        while (n < this.dir.numFiles) {
            FileDescriptor fileDescriptor = this.dir.files[n];
            stringBuffer.append("\n\n   File #" + n);
            stringBuffer.append("\n   size " + fileDescriptor.size);
            stringBuffer.append("\n   type " + fileDescriptor.type);
            switch (fileDescriptor.type) {
                case 1: {
                    stringBuffer.append(" (Configuration Parameter Value File)");
                    break;
                }
                case 2: {
                    stringBuffer.append(" (Configuration Parameter Template File)");
                    break;
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public int findFileNum(int n) {
        return this.findFileNum(n, -1);
    }

    public int findFileNum(int n, int n2) {
        if (this.dir == null) {
            return -1;
        }
        int n3 = n2 + 1;
        while (n3 < this.dir.numFiles) {
            if (this.dir.files[n3].type == n) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    private final boolean validateFileNum(int n) {
        if (this.dir == null) {
            return false;
        }
        return n < this.dir.numFiles;
    }

    private final /* synthetic */ void this() {
        this.opened = false;
        this.offset = 0;
    }

    public LonFileReadWrite(BLonDevice bLonDevice, BNetworkVariable bNetworkVariable) throws LonException {
        this.this();
        this.sendAddr = NmUtil.getSendAddress(bLonDevice);
        this.lonComm = bLonDevice.lonComm();
        this.devName = bLonDevice.getDisplayName(null);
        this.auth = bLonDevice.getDeviceData().getAuthenticate();
        bNetworkVariable.doForceRead();
        this.filePtr = (int)((BLonPrimitive)bNetworkVariable.getData().get("address")).getDataAsDouble();
        this.dir = new FileDirectory(this.lonComm, this.sendAddr, this.filePtr);
    }

    public LonFileReadWrite(LonAddress lonAddress, LonComm lonComm, int n) throws LonException {
        this.this();
        this.sendAddr = lonAddress;
        this.lonComm = lonComm;
        this.devName = "xdev";
        this.auth = Neuron.isNMAuthSet(lonComm, lonAddress, false, false);
        byte[] byArray = NmUtil.fetchNv(lonComm, this.sendAddr, n, this.auth);
        LonInputStream lonInputStream = new LonInputStream(byArray);
        this.filePtr = lonInputStream.readUnsigned16();
        this.dir = new FileDirectory(lonComm, this.sendAddr, this.filePtr);
    }

    private LonFileReadWrite(LonFileReadWrite lonFileReadWrite) {
        this.this();
        this.sendAddr = lonFileReadWrite.sendAddr;
        this.lonComm = lonFileReadWrite.lonComm;
        this.devName = lonFileReadWrite.devName;
        this.filePtr = lonFileReadWrite.filePtr;
        this.auth = lonFileReadWrite.auth;
        this.dir = lonFileReadWrite.dir;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class FileDirectory {
        public int version;
        public int numFiles;
        public FileDescriptor[] files;

        public FileDirectory(LonComm lonComm, LonAddress lonAddress, int n) throws LonException {
            byte[] byArray = Neuron.readMemory(lonComm, 0, lonAddress, n, SZ_FILE_DIR_HEADER, LonFileReadWrite.this.auth);
            LonInputStream lonInputStream = new LonInputStream(byArray);
            this.version = lonInputStream.read();
            this.numFiles = lonInputStream.read();
            int n2 = this.version >= 32 ? SZ_FILE_DESCRIPTOR_20 : SZ_FILE_DESCRIPTOR_10;
            this.files = new FileDescriptor[this.numFiles];
            int n3 = 0;
            while (n3 < this.numFiles) {
                int n4 = n + SZ_FILE_DIR_HEADER + n2 * n3;
                byArray = Neuron.readMemory(lonComm, 0, lonAddress, n4, n2, LonFileReadWrite.this.auth);
                lonInputStream = new LonInputStream(byArray);
                this.files[n3] = new FileDescriptor(lonInputStream, this.version);
                ++n3;
            }
        }
    }

    private static class FileDescriptor {
        public int size;
        public int type;
        public int filePtr;

        public FileDescriptor(LonInputStream lonInputStream, int n) throws LonException {
            this.size = lonInputStream.readUnsigned16();
            this.type = n >= 32 ? lonInputStream.readUnsigned16() : lonInputStream.read();
            this.filePtr = lonInputStream.readUnsigned16();
        }
    }
}

