/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.device;

import com.tridium.lonworks.Lon;
import com.tridium.lonworks.device.DeviceFacets;
import com.tridium.lonworks.util.NameUtil;
import com.tridium.lonworks.util.NmUtil;
import com.tridium.lonworks.util.selfdoc.NodeSelfDoc;
import com.tridium.lonworks.xml.XConfigProperty;
import com.tridium.lonworks.xml.XCpTypeDef;
import com.tridium.lonworks.xml.XDeviceData;
import com.tridium.lonworks.xml.XDeviceFacets;
import com.tridium.lonworks.xml.XLonDataUtil;
import com.tridium.lonworks.xml.XLonDevice;
import com.tridium.lonworks.xml.XLonInterfaceFile;
import com.tridium.lonworks.xml.XMessageTag;
import com.tridium.lonworks.xml.XNetworkConfig;
import com.tridium.lonworks.xml.XNetworkVariable;
import com.tridium.lonworks.xml.XUtil;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.lonworks.BConfigParameter;
import javax.baja.lonworks.BDynamicDevice;
import javax.baja.lonworks.BINetworkVariable;
import javax.baja.lonworks.BINvContainer;
import javax.baja.lonworks.BLonComponent;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BLonObject;
import javax.baja.lonworks.BMessageTag;
import javax.baja.lonworks.BNetworkConfig;
import javax.baja.lonworks.BNetworkVariable;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.datatypes.BAliasTable;
import javax.baja.lonworks.datatypes.BConfigProps;
import javax.baja.lonworks.datatypes.BDeviceData;
import javax.baja.lonworks.datatypes.BExtDeviceData;
import javax.baja.lonworks.datatypes.BImportParameters;
import javax.baja.lonworks.datatypes.BModifyFlags;
import javax.baja.lonworks.datatypes.BNcProps;
import javax.baja.lonworks.datatypes.BNvConfigData;
import javax.baja.lonworks.datatypes.BNvProps;
import javax.baja.lonworks.datatypes.BProgramId;
import javax.baja.lonworks.enums.BLonConfigScope;
import javax.baja.lonworks.enums.BLonNvDirection;
import javax.baja.lonworks.enums.BLonServiceType;
import javax.baja.lonworks.londata.BLonData;
import javax.baja.lonworks.londata.BLonPrimitive;
import javax.baja.lonworks.proxy.BLonProxyExt;
import javax.baja.lonworks.util.ScptUtil;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.SortUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.sync.Transaction;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DynaDev {
    private static final int CURRENT = 0;
    private static final int NEW = 1;
    private static final int OBSOLETE = 2;
    private static final BFacets DEVICE_SPEC = BFacets.make((String)"deviceSpecific", (boolean)true);
    private Prop[] props;
    private Obj[] objects;
    private Log log;
    BDynamicDevice dev;
    int[] nvObjNdx;
    boolean useLonObjects;
    boolean syncNvConfig;
    boolean useZeroBasedArrays;
    static /* synthetic */ Class class$javax$baja$lonworks$londata$BLonData;
    static /* synthetic */ Class class$com$tridium$lonworks$device$DynaDev$Obj;
    static /* synthetic */ Class class$com$tridium$lonworks$device$DynaDev$Prop;

    public static void importXLon(BDynamicDevice bDynamicDevice, XLonInterfaceFile xLonInterfaceFile, BImportParameters bImportParameters) {
        DynaDev dynaDev = new DynaDev(bDynamicDevice);
        if (bImportParameters != null) {
            dynaDev.useLonObjects = bImportParameters.getUseLonObjects();
            dynaDev.syncNvConfig = bImportParameters.getSyncNvConfig();
        }
        dynaDev.useZeroBasedArrays = xLonInterfaceFile.getLonDevice().useZeroBasedArrays;
        dynaDev.doImportXLon(xLonInterfaceFile);
    }

    public static void importXLon(BDynamicDevice bDynamicDevice, XLonDevice xLonDevice, boolean bl) throws Exception {
        DynaDev dynaDev = new DynaDev(bDynamicDevice);
        dynaDev.useLonObjects = bl;
        dynaDev.useZeroBasedArrays = xLonDevice.useZeroBasedArrays;
        dynaDev.dynamicUpdate(xLonDevice, null);
    }

    private final void doImportXLon(XLonInterfaceFile xLonInterfaceFile) {
        XLonInterfaceFile xLonInterfaceFile2 = XUtil.getStandard();
        if (xLonInterfaceFile2 != null) {
            xLonInterfaceFile.addAttribute("standard", xLonInterfaceFile2);
        }
        if (this.log().isTraceOn()) {
            this.log().trace("importXlon " + this.dev.getDisplayName(null));
        }
        try {
            XLonDevice xLonDevice = xLonInterfaceFile.getLonDevice();
            this.dynamicUpdate(xLonDevice, xLonInterfaceFile);
            if (this.dev.isRunning() && this.syncNvConfig) {
                this.uploadNvConfig();
            }
        }
        catch (Throwable throwable) {
            this.log().error("error in doImportXml", throwable);
        }
    }

    private final void dynamicUpdate(XLonDevice xLonDevice, XLonInterfaceFile xLonInterfaceFile) throws Exception {
        int n;
        this.initPropertyList();
        this.dev.initImport();
        Context context = Transaction.start((BComponent)this.dev, (Context)new BasicContext());
        this.addObjects(xLonDevice, context);
        int n2 = 0;
        XNetworkVariable[] xNetworkVariableArray = xLonDevice.getNetworkVariables();
        int n3 = 0;
        while (n3 < xNetworkVariableArray.length) {
            this.addNetworkVariable(xNetworkVariableArray[n3], xLonInterfaceFile, context);
            n = xNetworkVariableArray[n3].getMaxIndex();
            if (n > n2) {
                n2 = n;
            }
            ++n3;
        }
        XNetworkConfig[] xNetworkConfigArray = xLonDevice.getNetworkConfigs();
        int n4 = 0;
        while (n4 < xNetworkConfigArray.length) {
            this.addNetworkConfigs(xNetworkConfigArray[n4], xLonInterfaceFile, context);
            n = xNetworkConfigArray[n4].getMaxIndex();
            if (n > n2) {
                n2 = n;
            }
            ++n4;
        }
        XConfigProperty[] xConfigPropertyArray = xLonDevice.getConfigProperties();
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n7 < xConfigPropertyArray.length) {
            if (xLonDevice.hasReadOnlyFile && XLonDataUtil.isReadOnly(xConfigPropertyArray[n7].modifyFlag)) {
                n6 += this.addConfigProperty(xConfigPropertyArray[n7], xLonInterfaceFile, xLonDevice, n6, context);
            } else {
                n5 += this.addConfigProperty(xConfigPropertyArray[n7], xLonInterfaceFile, xLonDevice, n5, context);
            }
            ++n7;
        }
        XMessageTag[] xMessageTagArray = xLonDevice.getMessageTags();
        int n8 = 0;
        while (n8 < xMessageTagArray.length) {
            this.addMessageTag(xMessageTagArray[n8], context);
            ++n8;
        }
        this.addDeviceData(xLonDevice.deviceData, xLonDevice.deviceFacets, n2, xMessageTagArray.length, context);
        this.processLonObject(context);
        this.removeRemainingProps(context);
        Transaction.end((BComponent)this.dev, (Context)context);
        this.reorder();
        this.dev.closeImport();
        this.dev.fireDynamicOpComplete((BValue)BString.make((String)"hi"));
    }

    private final void addDeviceData(XDeviceData xDeviceData, XDeviceFacets xDeviceFacets, int n, int n2, Context context) {
        BFacets bFacets;
        int n3;
        NodeSelfDoc nodeSelfDoc;
        boolean bl;
        BDeviceData bDeviceData = this.dev.getDeviceData();
        boolean bl2 = false;
        if (xDeviceData.maxNetMgmtVer > 0) {
            bl2 = true;
        }
        boolean bl3 = bl2;
        int n4 = Math.max(xDeviceData.addressTableEntries, xDeviceData.numEcsAddressEntries);
        boolean bl4 = false;
        if ((bl3 || n4 > 15) && !(bDeviceData instanceof BExtDeviceData)) {
            bl4 = true;
        }
        if ((bDeviceData = (bl = bl4) ? BExtDeviceData.make(bDeviceData) : (BDeviceData)bDeviceData.newCopy(true)) instanceof BExtDeviceData) {
            ((BExtDeviceData)bDeviceData).setExtended(bl3);
        }
        bDeviceData.setProgramId(BProgramId.make(xDeviceData.programID));
        bDeviceData.setAliasTable(new BAliasTable(xDeviceData.aliasCount));
        bDeviceData.getAliasTable().setAliasOffset(Math.max(xDeviceData.maxNumNvSupported, n + 1));
        bDeviceData.setBindingII(xDeviceData.bindingII);
        bDeviceData.setHosted(XLonDataUtil.isHostedApplication(xDeviceData.applicationType));
        boolean bl5 = false;
        if (xDeviceData.domains == 2) {
            bl5 = true;
        }
        bDeviceData.setTwoDomains(bl5);
        bDeviceData.setAddressCount(n4);
        bDeviceData.setMsgTagCount(Math.max(n2, xDeviceData.numEcsMessageTags));
        bDeviceData.setSelfDoc(xDeviceData.nodeSelfID);
        bDeviceData.setFreezeChannelPriorities(xDeviceData.freezeChannelPriorities);
        try {
            nodeSelfDoc = new NodeSelfDoc(xDeviceData.nodeSelfID);
        }
        catch (Exception exception) {
            nodeSelfDoc = null;
        }
        boolean bl6 = false;
        if (nodeSelfDoc != null && nodeSelfDoc.hasNodeObject()) {
            bl6 = true;
        }
        bDeviceData.setHasNodeObject(bl6);
        if (nodeSelfDoc != null && (n3 = nodeSelfDoc.getNodeObjectIndex()) > 0) {
            if (xDeviceFacets == null) {
                xDeviceFacets = new XDeviceFacets();
            }
            xDeviceFacets.nodeObjectIndex = n3;
        }
        if (xDeviceFacets != null && (bFacets = DeviceFacets.makeDeviceFacets(xDeviceFacets)) != null) {
            bDeviceData.setFacets(bFacets);
        }
        if (bl) {
            this.dev.set(BLonDevice.deviceData, (BValue)bDeviceData, context);
        } else {
            this.dev.getDeviceData().copyFrom((BComplex)bDeviceData, BDeviceData.importChanges);
        }
        if (bDeviceData.getProgramId().hasChangeableNvs()) {
            this.dev.deviceDataChanged(BDeviceData.programId, null);
        }
    }

    private final void addNetworkVariable(XNetworkVariable xNetworkVariable, XLonInterfaceFile xLonInterfaceFile, Context context) {
        int n;
        int n2 = xNetworkVariable.arraySize;
        if (n2 <= 0) {
            n2 = 1;
        }
        if ((n = xNetworkVariable.memberArraySize) <= 0) {
            n = 1;
        }
        int[] nArray = this.getObjectIndexArray(n2, n, xNetworkVariable.objectIndex);
        int[] nArray2 = this.getMemberIndexArray(n2, n, xNetworkVariable.memberIndex);
        int n3 = XLonDataUtil.snvtTypeFromString(xNetworkVariable.snvtType);
        BLonData bLonData = XUtil.getLonDataNv(xNetworkVariable, xLonInterfaceFile);
        if (bLonData != null && bLonData.getByteLength() > Lon.maxNvLength()) {
            this.log().error(xNetworkVariable.getName() + " ignored because length " + bLonData.getByteLength() + " > " + Lon.maxNvLength() + " bytes");
            return;
        }
        if (bLonData != null) {
            DynaDev.setNonCritical(bLonData);
        }
        int n4 = 0;
        while (n4 < n2) {
            int n5;
            BNetworkVariable bNetworkVariable = new BNetworkVariable();
            BNvProps bNvProps = bNetworkVariable.getNvProps();
            bNvProps.setNvIndex(xNetworkVariable.index + n4);
            bNvProps.setSnvtType(n3);
            bNvProps.setObjectIndex(nArray[n4]);
            bNvProps.setMemberIndex(nArray2[n4]);
            bNvProps.setPolled(xNetworkVariable.polled);
            bNvProps.setAuthConf(xNetworkVariable.authenticatedConfigurable);
            bNvProps.setServiceConf(xNetworkVariable.serviceTypeConfigurable);
            bNvProps.setPriorityConf(xNetworkVariable.priorityConfigurable);
            bNvProps.setModifyOffline(xNetworkVariable.offline);
            bNvProps.setSync(xNetworkVariable.sync);
            bNvProps.setChangeableType(xNetworkVariable.changeType);
            BNvConfigData bNvConfigData = bNetworkVariable.getNvConfigData();
            bNvConfigData.setPriority(xNetworkVariable.priority);
            bNvConfigData.setDirection((BLonNvDirection)bNvConfigData.getDirection().getRange().get(xNetworkVariable.direction));
            bNvConfigData.setSelector(16383 - xNetworkVariable.index - n4);
            BLonServiceType bLonServiceType = (BLonServiceType)bNvConfigData.getServiceType().getRange().get(xNetworkVariable.serviceType);
            bNvConfigData.setServiceType(bLonServiceType.getWriteServiceType());
            bNvConfigData.setAuthenticated(xNetworkVariable.authenticated);
            this.nvObjNdx[bNvProps.getNvIndex()] = bNvProps.getObjectIndex();
            String string = xNetworkVariable.getName();
            String string2 = NameUtil.toJavaName(string, false);
            if (n2 > 1) {
                string = this.arrayedName(string, n4);
                string2 = this.arrayedName(string2, n4);
            }
            if (bLonData == null) {
                this.log().warning("No lonData for " + this.dev.getDisplayName(null) + '.' + string);
                return;
            }
            if (n4 > 0) {
                bLonData = (BLonData)bLonData.newCopy();
            }
            if (bNvConfigData.isOutput()) {
                this.setReadonly(bLonData);
            }
            bNetworkVariable.setData(bLonData);
            int n6 = n5 = bNvConfigData.isInput() ? 1024 : 0;
            if (this.log().isTraceOn()) {
                this.log().trace("add nv " + bNvProps.getNvIndex() + ' ' + string);
            }
            this.addLonComponent(string, string2, bNetworkVariable, n5, context, BFacets.NULL, nArray[n4]);
            ++n4;
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void setReadonly(BLonData var1_1) {
        Flags.setAllReadonly((BComponent)var1_1, (boolean)true, null);
        var2_2 = var1_1.getProperties();
        if (true) ** GOTO lbl6
        do {
            this.setReadonly((BLonData)var2_2.get());
lbl6:
            // 2 sources

            if ((v0 = DynaDev.class$javax$baja$lonworks$londata$BLonData) != null) continue;
            v0 = DynaDev.class("[Ljavax.baja.lonworks.londata.BLonData;", false);
        } while (var2_2.next(v0));
    }

    public static void setNonCritical(BLonData bLonData) {
        SlotCursor slotCursor = bLonData.getProperties();
        while (slotCursor.next()) {
            BObject bObject = slotCursor.get();
            if (bObject instanceof BLonPrimitive) {
                Property property = slotCursor.property();
                bLonData.setFlags((Slot)property, bLonData.getFlags((Slot)property) | 0x10000);
                continue;
            }
            if (!(bObject instanceof BLonData)) continue;
            DynaDev.setNonCritical((BLonData)bObject);
        }
    }

    private final void addNetworkConfigs(XNetworkConfig xNetworkConfig, XLonInterfaceFile xLonInterfaceFile, Context context) {
        int n = xNetworkConfig.arraySize;
        if (n <= 0) {
            n = 1;
        }
        String[] stringArray = this.getSelects(n, xNetworkConfig.select);
        BLonConfigScope bLonConfigScope = this.getScope(xNetworkConfig.scope);
        int n2 = XLonDataUtil.snvtTypeFromString(xNetworkConfig.snvtType);
        BLonData bLonData = XUtil.getLonDataNc(xNetworkConfig, xLonInterfaceFile);
        if (bLonData != null && bLonData.getByteLength() > Lon.maxNvLength()) {
            this.log().error(xNetworkConfig.getName() + " ignored because length " + bLonData.getByteLength() + " > " + Lon.maxNvLength() + " bytes");
            return;
        }
        int n3 = 0;
        while (n3 < n) {
            BNetworkConfig bNetworkConfig = new BNetworkConfig();
            BNcProps bNcProps = bNetworkConfig.getNcProps();
            bNcProps.setNvIndex(xNetworkConfig.index + n3);
            bNcProps.setConfigIndex(XLonDataUtil.scptTypeFromString(xNetworkConfig.scptType));
            bNcProps.setSnvtType(n2);
            bNcProps.setModifyFlag(this.getModifyFlags(xNetworkConfig.modifyFlag));
            bNcProps.setScope(bLonConfigScope);
            bNcProps.setSelect(stringArray[n3]);
            BNvConfigData bNvConfigData = bNetworkConfig.getNvConfigData();
            bNvConfigData.setPriority(xNetworkConfig.priority);
            bNvConfigData.setDirection((BLonNvDirection)bNvConfigData.getDirection().getRange().get(xNetworkConfig.direction));
            bNvConfigData.setSelector(16383 - xNetworkConfig.index - n3);
            BLonServiceType bLonServiceType = (BLonServiceType)bNvConfigData.getServiceType().getRange().get(xNetworkConfig.serviceType);
            bNvConfigData.setServiceType(bLonServiceType.getWriteServiceType());
            bNvConfigData.setAuthenticated(xNetworkConfig.authenticated);
            String string = xNetworkConfig.getName();
            String string2 = NameUtil.toJavaName(string, false);
            if (n > 1) {
                string = this.arrayedName(string, n3);
                string2 = this.arrayedName(string2, n3);
            }
            if (bLonData == null) {
                this.log().warning("No lonData for " + this.dev.getDisplayName(null) + '.' + xNetworkConfig.getName());
                return;
            }
            if (n3 > 0) {
                bLonData = (BLonData)bLonData.newCopy();
            }
            if (!bNcProps.getModifyFlag().isReadWrite()) {
                this.setReadonly(bLonData);
            }
            BFacets bFacets = this.isDeviceSpecific(xNetworkConfig.modifyFlag) ? DEVICE_SPEC : BFacets.NULL;
            bNetworkConfig.setData(bLonData);
            if (this.log().isTraceOn()) {
                this.log().trace("add nci " + bNcProps.getNvIndex() + ' ' + string);
            }
            this.addLonComponent(string, string2, bNetworkConfig, 0, context, bFacets, this.getObjectNdx(bLonConfigScope, stringArray[n3]));
            ++n3;
        }
    }

    private final int addConfigProperty(XConfigProperty xConfigProperty, XLonInterfaceFile xLonInterfaceFile, XLonDevice xLonDevice, int n, Context context) {
        int n2 = xConfigProperty.dimension;
        if (n2 <= 0) {
            n2 = 1;
        }
        String[] stringArray = this.getSelects(n2, xConfigProperty.select);
        BLonConfigScope bLonConfigScope = this.getScope(xConfigProperty.scope);
        int n3 = 0;
        while (n3 < n2) {
            BConfigParameter bConfigParameter = new BConfigParameter();
            BConfigProps bConfigProps = bConfigParameter.getConfigProps();
            bConfigProps.setConfigIndex(XLonDataUtil.scptTypeFromString(xConfigProperty.scptType));
            bConfigProps.setOffset(n + n3 * xConfigProperty.length);
            bConfigProps.setLength(xConfigProperty.length);
            bConfigProps.setModifyFlag(this.getModifyFlags(xConfigProperty.modifyFlag));
            bConfigProps.setScope(bLonConfigScope);
            bConfigProps.setSelect(stringArray[n3]);
            String string = xConfigProperty.getName();
            String string2 = NameUtil.toJavaName(string, false);
            if (n2 > 1) {
                string = this.arrayedName(string, n3);
                string2 = this.arrayedName(string2, n3);
            }
            BLonData bLonData = XUtil.getLonDataCp(xConfigProperty, xLonInterfaceFile, xLonDevice, bLonConfigScope, stringArray[n3], this.dev, n3);
            if (!bConfigProps.getModifyFlag().isReadWrite()) {
                this.setReadonly(bLonData);
            }
            bConfigParameter.setData(bLonData);
            XCpTypeDef xCpTypeDef = (XCpTypeDef)xConfigProperty.getXTypeDef();
            BFacets bFacets = BFacets.NULL;
            if (xCpTypeDef != null && xCpTypeDef.inherited) {
                if (xConfigProperty.scope.equals("object")) {
                    try {
                        int n4 = XUtil.getInheritanceSourceNv(xConfigProperty, xLonDevice, bConfigProps.getSelect());
                        bFacets = BFacets.make((String)"inherited", (BIDataValue)BBoolean.TRUE, (String)"sourceNv", (BIDataValue)BInteger.make((int)n4));
                    }
                    catch (Throwable throwable) {}
                } else {
                    bFacets = BFacets.make((String)"inherited", (boolean)true);
                }
            }
            if (this.isDeviceSpecific(xConfigProperty.modifyFlag)) {
                bFacets = BFacets.make((BFacets)bFacets, (BFacets)DEVICE_SPEC);
            }
            if (this.log().isTraceOn()) {
                this.log().trace("add cp " + bConfigProps.getOffset() + ':' + bConfigProps.getLength() + ' ' + string);
            }
            this.addLonComponent(string, string2, bConfigParameter, 0, context, bFacets, this.getObjectNdx(bLonConfigScope, stringArray[n3]));
            ++n3;
        }
        return xConfigProperty.length * n2;
    }

    private final int getObjectNdx(BLonConfigScope bLonConfigScope, String string) {
        if (string == null) {
            return -1;
        }
        int[] nArray = ScptUtil.decomposeSelect(string);
        if (nArray.length == 0) {
            return -1;
        }
        if (bLonConfigScope == BLonConfigScope.object) {
            if (nArray.length > 1) {
                return -1;
            }
            return nArray[0];
        }
        if (bLonConfigScope == BLonConfigScope.nv) {
            int n = this.nvObjNdx[nArray[0]];
            int n2 = 1;
            while (n2 < nArray.length) {
                int n3 = this.nvObjNdx[nArray[n2]];
                if (n3 == -1 || n3 != n) {
                    return -1;
                }
                ++n2;
            }
            return n;
        }
        return -1;
    }

    private final void addLonComponent(String string, String string2, BLonComponent bLonComponent, int n, Context context, BFacets bFacets, int n2) {
        Prop prop;
        BINvContainer bINvContainer = this.dev;
        boolean bl = false;
        if (this.objects != null && n2 >= 0 && n2 < this.objects.length && !this.objects[n2].isObsolete()) {
            bINvContainer = this.objects[n2].lonObj;
            bl = this.objects[n2].isNew();
        }
        if ((prop = this.findAndRemoveProperty(string, (BComplex)bLonComponent, (BComponent)bINvContainer, context)) == null) {
            prop = this.findAndRemoveProperty(string2, (BComplex)bLonComponent, (BComponent)bINvContainer, context);
        }
        if (prop != null) {
            ((BComplex)bINvContainer.get(prop.p)).copyFrom((BComplex)bLonComponent);
            bINvContainer.setFacets((Slot)prop.p, bFacets, context);
            bINvContainer.setFlags((Slot)prop.p, n, bl ? null : context);
        } else {
            if (!SlotPath.isValidName((String)string2)) {
                this.log().warning("could not add lonComponent - invalid name " + string2);
                return;
            }
            bINvContainer.add(string2 + '?', (BValue)bLonComponent, n, bFacets, bl ? null : context);
        }
    }

    private final void addObjects(XLonDevice xLonDevice, Context context) {
        Object object;
        Object object2;
        Class clazz = class$com$tridium$lonworks$device$DynaDev$Obj;
        if (clazz == null) {
            clazz = class$com$tridium$lonworks$device$DynaDev$Obj = DynaDev.class("[Lcom.tridium.lonworks.device.DynaDev$Obj;", false);
        }
        Array array = new Array(clazz);
        BLonObject[] bLonObjectArray = this.dev.getLonObjects();
        int n = 0;
        while (n < bLonObjectArray.length) {
            object2 = bLonObjectArray[n];
            object = new Obj((BLonObject)object2, 2, object2.getName());
            array.add(((BLonObject)object2).getObjectId(), object);
            ++n;
        }
        String string = xLonDevice.deviceData.nodeSelfID;
        object2 = new NodeSelfDoc(string);
        object = ((NodeSelfDoc)object2).getObjects();
        if (this.useLonObjects && object != null && ((NodeSelfDoc.LonMarkObj[])object).length != 0) {
            int n2 = 0;
            while (n2 < ((NodeSelfDoc.LonMarkObj[])object).length) {
                BLonObject bLonObject;
                Obj obj;
                String string2 = Integer.toString(object[n2].type);
                String string3 = object[n2].name;
                if (string3 == null) {
                    string3 = "Type" + string2;
                }
                string3 = SlotPath.escape((String)string3);
                Obj obj2 = obj = array.size() > n2 ? (Obj)array.get(n2) : null;
                if (obj != null) {
                    bLonObject = obj.lonObj;
                    if (!string2.equals(bLonObject.getObjectType())) {
                        bLonObject.setString(BLonObject.objectType, string2, context);
                    }
                    if (!obj.name.equals(string3)) {
                        ((BComponent)bLonObject.getParent()).rename(bLonObject.getPropertyInParent(), string3, context);
                    }
                    obj.state = 0;
                } else {
                    bLonObject = new BLonObject();
                    bLonObject.setObjectId(n2);
                    bLonObject.setObjectType(string2);
                    obj = new Obj(bLonObject, 1, string3);
                    array.add((Object)obj);
                }
                ++n2;
            }
        }
        this.objects = (Obj[])array.trim();
    }

    private final void processLonObject(Context context) {
        int n = 0;
        while (n < this.objects.length) {
            if (this.objects[n].isNew()) {
                this.dev.add(this.objects[n].name + '?', (BValue)this.objects[n].lonObj, context);
            } else if (this.objects[n].isObsolete()) {
                this.dev.remove(this.objects[n].lonObj.getPropertyInParent(), context);
            }
            ++n;
        }
    }

    private final void addMessageTag(String string, BMessageTag bMessageTag, Context context) {
        Prop prop = this.findAndRemoveProperty(string, (BComplex)bMessageTag, (BComponent)this.dev, context);
        if (prop != null) {
            ((BComplex)prop.c.get(prop.p)).copyFrom((BComplex)bMessageTag);
        } else {
            this.dev.add(string + '?', (BValue)bMessageTag, 0, context);
        }
    }

    private final void addMessageTag(XMessageTag xMessageTag, Context context) {
        BMessageTag bMessageTag = new BMessageTag();
        bMessageTag.setIndex(xMessageTag.index);
        bMessageTag.setDirection(BLonNvDirection.output);
        if (this.log().isTraceOn()) {
            this.log().trace("add mt " + bMessageTag.getIndex() + ' ' + xMessageTag.getName());
        }
        this.addMessageTag(xMessageTag.getName(), bMessageTag, context);
    }

    private final String arrayedName(String string, int n) {
        if (!this.useZeroBasedArrays) {
            ++n;
        }
        return string + '_' + n;
    }

    private final void initPropertyList() {
        Class clazz = class$com$tridium$lonworks$device$DynaDev$Prop;
        if (clazz == null) {
            clazz = class$com$tridium$lonworks$device$DynaDev$Prop = DynaDev.class("[Lcom.tridium.lonworks.device.DynaDev$Prop;", false);
        }
        Array array = new Array(clazz);
        this.initPropertyList(array, (BComponent)this.dev);
        this.props = (Prop[])array.trim();
    }

    private final void initPropertyList(Array array, BComponent bComponent) {
        Property[] propertyArray = bComponent.getPropertiesArray();
        int n = 0;
        while (n < propertyArray.length) {
            Type type = propertyArray[n].getType();
            if (type.is(BINvContainer.TYPE)) {
                this.initPropertyList(array, (BComponent)bComponent.get(propertyArray[n]));
            } else if (type.is(BLonComponent.TYPE) || type.is(BMessageTag.TYPE)) {
                array.add((Object)new Prop(bComponent, propertyArray[n]));
            }
            ++n;
        }
    }

    private final Prop findAndRemoveProperty(String string, BComplex bComplex, BComponent bComponent, Context context) {
        int n = 0;
        while (n < this.props.length) {
            Property property;
            Prop prop = this.props[n];
            if (prop != null && (property = prop.p) != null && property.getName().equals(string) && !property.isFrozen()) {
                if (property.getType() != bComplex.getType()) {
                    this.log().trace("remove property because of type change " + property.getDefaultDisplayName(null));
                    this.removeLonProperty(prop, context);
                    prop = null;
                } else if (property.getType().is(BLonComponent.TYPE) && !((BLonComponent)prop.c.get(property)).getData().hasEquivalentElements(((BLonComponent)bComplex).getData())) {
                    this.log().trace("remove because data elements don't match " + property.getDefaultDisplayName(null));
                    this.removeLonProperty(prop, context);
                    prop = null;
                } else if (bComponent != prop.c) {
                    this.log().trace("move to a new container " + property.getDefaultDisplayName(null));
                    this.removeLonProperty(prop, context);
                    prop = null;
                } else if (property.getType().is(BINetworkVariable.TYPE)) {
                    BINetworkVariable bINetworkVariable = (BINetworkVariable)prop.c.get(property);
                    BINetworkVariable bINetworkVariable2 = (BINetworkVariable)bComplex;
                    if ((bINetworkVariable.getSnvtType() > 0 || bINetworkVariable2.getSnvtType() > 0) && bINetworkVariable.getSnvtType() != bINetworkVariable2.getSnvtType()) {
                        this.log().trace("remove because snvt types don't match " + property.getDefaultDisplayName(null));
                        this.removeLonProperty(prop, context);
                        prop = null;
                    }
                }
                this.props[n] = null;
                return prop;
            }
            ++n;
        }
        return null;
    }

    private final void removeRemainingProps(Context context) {
        int n = 0;
        while (n < this.props.length) {
            Type type;
            Property property;
            Prop prop = this.props[n];
            if (prop != null && !(property = prop.p).isFrozen() && ((type = property.getType()).is(BLonComponent.TYPE) || type.is(BMessageTag.TYPE))) {
                this.removeLonProperty(prop, context);
            }
            ++n;
        }
    }

    private final void removeLonProperty(Prop prop, Context context) {
        Property property = prop.p;
        if (property.getType().is(BLonComponent.TYPE)) {
            String string = property.getName();
            BControlPoint[] bControlPointArray = this.dev.getLonProxies();
            int n = 0;
            while (n < bControlPointArray.length) {
                BControlPoint bControlPoint = bControlPointArray[n];
                BLonProxyExt bLonProxyExt = (BLonProxyExt)bControlPoint.getProxyExt();
                String string2 = bLonProxyExt.getTargetComp();
                if (string2.lastIndexOf(47) >= 0) {
                    string2 = string2.substring(string2.lastIndexOf(47) + 1);
                }
                if (string2.equals(string)) {
                    ((BComponent)bControlPoint.getParent()).remove(bControlPoint.getPropertyInParent(), context);
                }
                ++n;
            }
        }
        prop.c.remove(property, context);
    }

    private final BModifyFlags getModifyFlags(String string) {
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("mfgOnly")) {
                bl2 = true;
                bl = false;
                continue;
            }
            if (string2.equals("reset")) {
                bl3 = true;
                continue;
            }
            if (string2.equals("constant")) {
                bl4 = true;
                bl = false;
                continue;
            }
            if (string2.equals("offline")) {
                bl5 = true;
                continue;
            }
            if (string2.equals("objDisable")) {
                bl6 = true;
                continue;
            }
            if (!string2.equals("deviceSpecific")) continue;
            bl4 = true;
            bl = false;
        }
        return BModifyFlags.make(bl, bl2, bl3, bl4, bl5, bl6);
    }

    private final boolean isDeviceSpecific(String string) {
        boolean bl = false;
        if (string.indexOf("deviceSpecific") >= 0) {
            bl = true;
        }
        return bl;
    }

    private final BLonConfigScope getScope(String string) {
        if (string.equals("node")) {
            return BLonConfigScope.node;
        }
        if (string.equals("object")) {
            return BLonConfigScope.object;
        }
        if (string.equals("nv")) {
            return BLonConfigScope.nv;
        }
        return BLonConfigScope.node;
    }

    private final int[] getObjectIndexArray(int n, int n2, String string) {
        int[] nArray = new int[n];
        if (string != null && string.length() > 0) {
            try {
                int n3;
                StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
                int n4 = n3 = Integer.decode(stringTokenizer.nextToken()).intValue();
                int n5 = 0;
                while (n5 < n) {
                    int n6 = 0;
                    while (n6 < n2) {
                        nArray[n5 + n6] = n4;
                        ++n6;
                    }
                    ++n4;
                    n5 += n2;
                }
                return nArray;
            }
            catch (Throwable throwable) {}
        }
        int n7 = 0;
        while (n7 < n) {
            nArray[n7] = -1;
            ++n7;
        }
        return nArray;
    }

    private final int[] getMemberIndexArray(int n, int n2, int n3) {
        int[] nArray = new int[n];
        int n4 = 0;
        while (n4 < n) {
            int n5 = 0;
            while (n5 < n2) {
                nArray[n4 + n5] = n3 + n5;
                ++n5;
            }
            n4 += n2;
        }
        return nArray;
    }

    private final String[] getSelects(int n, String string) {
        String[] stringArray = new String[n];
        if (string != null && string.length() > 0) {
            try {
                if (string.indexOf(126) > 0) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string, "~");
                    int n2 = Integer.decode(stringTokenizer.nextToken());
                    int n3 = Integer.decode(stringTokenizer.nextToken());
                    if (n3 - n2 + 1 != n) {
                        this.log().warning("select " + string + " doesn't match arraySize " + n);
                    }
                    int n4 = 0;
                    while (n4 < n) {
                        stringArray[n4] = Integer.toString(n2 + n4);
                        ++n4;
                    }
                } else if (string.indexOf(47) > 0) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
                    int n5 = 0;
                    while (n5 < n) {
                        stringArray[n5] = stringTokenizer.nextToken();
                        ++n5;
                    }
                } else {
                    int n6 = 0;
                    while (n6 < n) {
                        stringArray[n6] = string;
                        ++n6;
                    }
                }
                return stringArray;
            }
            catch (Throwable throwable) {}
        }
        int n7 = 0;
        while (n7 < n) {
            stringArray[n7] = "";
            ++n7;
        }
        return stringArray;
    }

    private final void uploadNvConfig() throws LonException {
        BINetworkVariable[] bINetworkVariableArray = this.dev.getNetworkVariables();
        int n = 0;
        while (n < bINetworkVariableArray.length) {
            if (bINetworkVariableArray[n] != null) {
                BNvConfigData bNvConfigData = NmUtil.queryNvConfigData(this.dev, n);
                BNetworkVariable bNetworkVariable = (BNetworkVariable)bINetworkVariableArray[n];
                BNvConfigData bNvConfigData2 = bNetworkVariable.getNvConfigData();
                if (bNvConfigData.getDirection() != bNvConfigData2.getDirection()) {
                    String string = "BINetworkVariable direction mismatch for " + bNetworkVariable.getDisplayName(null) + '(' + n + ')';
                    this.log().warning(string);
                    throw new BajaRuntimeException(string);
                }
                bNvConfigData2.copyFrom((BComplex)bNvConfigData);
            }
            ++n;
        }
    }

    private final void reorder() {
        Object[] objectArray;
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        SlotCursor slotCursor = this.dev.getProperties();
        while (slotCursor.next()) {
            objectArray = slotCursor.property();
            if (objectArray.isFrozen()) continue;
            arrayList.add(objectArray);
        }
        objectArray = arrayList.toArray(new Property[arrayList.size()]);
        Object[] objectArray2 = new String[objectArray.length];
        int n = 0;
        while (n < objectArray2.length) {
            BValue bValue = this.dev.get((Property)objectArray[n]);
            if (bValue.getType().is(BLonObject.TYPE)) {
                objectArray2[n] = this.getKey("a", ((BLonObject)bValue).getObjectId());
            } else if (bValue.getType().is(BINetworkVariable.TYPE)) {
                objectArray2[n] = this.getKey("b", ((BINetworkVariable)bValue).getNvIndex());
            } else if (bValue.getType().is(BConfigParameter.TYPE)) {
                String string = ((BConfigParameter)bValue).getConfigProps().getModifyFlag().isConst() ? "co" : "c";
                objectArray2[n] = this.getKey(string, ((BConfigParameter)bValue).getConfigProps().getOffset());
            } else {
                objectArray2[n] = bValue.getType().is(BMessageTag.TYPE) ? "m" + ((BMessageTag)bValue).getName() : "z" + Integer.toString(n);
            }
            ++n;
        }
        SortUtil.sort((Object[])objectArray2, (Object[])objectArray, (boolean)true);
        if (objectArray.length > 0) {
            this.dev.reorder((Property[])objectArray);
        }
    }

    private final String getKey(String string, int n) {
        String string2 = Integer.toString(n);
        return string + TextUtil.getSpaces((int)(5 - string2.length())) + string2;
    }

    public final Log log() {
        if (this.log == null && this.dev.getLonNetwork() != null) {
            this.log = Log.getLog((String)(this.dev.getLonNetwork().getLogName() + ".DynaDev"));
        }
        if (this.log == null) {
            this.log = Log.getLog((String)"lon.DynaDev");
        }
        return this.log;
    }

    static /* synthetic */ int access$0() {
        return 1;
    }

    static /* synthetic */ int access$1() {
        return 2;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.objects = null;
        this.log = null;
        this.nvObjNdx = new int[4095];
        this.useLonObjects = false;
        this.syncNvConfig = false;
        this.useZeroBasedArrays = false;
    }

    private DynaDev(BDynamicDevice bDynamicDevice) {
        this.this();
        this.dev = bDynamicDevice;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class Obj {
        BLonObject lonObj;
        String name;
        int state;

        boolean isNew() {
            boolean bl = false;
            if (this.state == 1) {
                bl = true;
            }
            return bl;
        }

        boolean isObsolete() {
            boolean bl = false;
            if (this.state == 2) {
                bl = true;
            }
            return bl;
        }

        private final /* synthetic */ void this() {
            this.state = 0;
        }

        Obj(BLonObject bLonObject, int n, String string) {
            this.this();
            this.lonObj = bLonObject;
            this.state = n;
            this.name = string;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class Prop {
        BComponent c;
        Property p;

        Prop(BComponent bComponent, Property property) {
            this.c = bComponent;
            this.p = property;
        }
    }
}

