/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.device;

import com.tridium.lonworks.util.NmUtil;
import com.tridium.lonworks.util.TimedCoalesceQueue;
import com.tridium.lonworks.xml.XDeviceFacets;
import javax.baja.data.BIDataValue;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BNetworkVariable;
import javax.baja.lonworks.datatypes.BDeviceData;
import javax.baja.nre.util.Array;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.util.Invocation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DeviceFacets {
    private int delayToReset;
    private int delayToHardOffline;
    private int minNvUpdateInterMsgDelay;
    private boolean disableSetOfflineInBind;
    private boolean disableToggleMode;
    private int nodeObjectIndex;
    private long lastNvWriteTime;
    private int delayCnt;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$baja$data$BIDataValue;

    public static int getNodeObjectIndex(BLonDevice bLonDevice) {
        DeviceFacets deviceFacets = DeviceFacets.getPickle(bLonDevice);
        if (deviceFacets != null) {
            return deviceFacets.nodeObjectIndex;
        }
        return 0;
    }

    public static int getDelayToReset(BLonDevice bLonDevice) {
        DeviceFacets deviceFacets = DeviceFacets.getPickle(bLonDevice);
        if (deviceFacets != null) {
            return deviceFacets.delayToReset;
        }
        return 0;
    }

    public static void delayToReset(BLonDevice bLonDevice) {
        int n = DeviceFacets.getDelayToReset(bLonDevice);
        if (n > 0) {
            NmUtil.wait(n);
        }
    }

    public static int getDelayToHardOffline(BLonDevice bLonDevice) {
        DeviceFacets deviceFacets = DeviceFacets.getPickle(bLonDevice);
        if (deviceFacets != null) {
            return deviceFacets.delayToHardOffline;
        }
        return 0;
    }

    public static void delayToHardOffline(BLonDevice bLonDevice) {
        int n = DeviceFacets.getDelayToHardOffline(bLonDevice);
        if (n > 0) {
            NmUtil.wait(n);
        }
    }

    public static int getMinNvUpdateInterMsgDelay(BLonDevice bLonDevice) {
        DeviceFacets deviceFacets = DeviceFacets.getPickle(bLonDevice);
        if (deviceFacets != null) {
            return deviceFacets.minNvUpdateInterMsgDelay;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean delayNvUpdate(BLonDevice bLonDevice, BNetworkVariable bNetworkVariable) {
        DeviceFacets deviceFacets = DeviceFacets.getPickle(bLonDevice);
        int n = 0;
        if (deviceFacets != null) {
            n = deviceFacets.minNvUpdateInterMsgDelay;
        }
        int n2 = n;
        int n3 = bNetworkVariable.getWriteDelay();
        if (n2 == 0 && n3 == 0) {
            return false;
        }
        Object object = deviceFacets != null ? deviceFacets : bNetworkVariable;
        Object object2 = object;
        synchronized (object2) {
            long l;
            long l2;
            long l3 = l2 = Clock.ticks();
            if (deviceFacets != null && n2 > 0) {
                l3 = deviceFacets.lastNvWriteTime + (long)(n2 * (deviceFacets.delayCnt + 1));
            }
            if (n3 > 0 && (l = l2 + (long)n3) > l3) {
                l3 = l;
            }
            if (l2 < l3) {
                TimedCoalesceQueue timedCoalesceQueue = (TimedCoalesceQueue)bLonDevice.lonNetwork().getTimedQueue().getTodo();
                TimedInvocation timedInvocation = new TimedInvocation((BComponent)bNetworkVariable, BNetworkVariable.forceWrite, deviceFacets, l3);
                try {
                    if (timedCoalesceQueue.enqueue(timedInvocation) && deviceFacets != null) {
                        ++deviceFacets.delayCnt;
                    }
                    return true;
                }
                catch (Throwable throwable) {
                    System.out.println("in delayNvUpdate could not queue TimedInvocation " + throwable);
                }
            }
            if (deviceFacets != null) {
                deviceFacets.lastNvWriteTime = Clock.ticks();
            }
            return false;
        }
    }

    public static boolean disableToggleMode(BLonDevice bLonDevice) {
        DeviceFacets deviceFacets = DeviceFacets.getPickle(bLonDevice);
        if (deviceFacets != null) {
            return deviceFacets.disableToggleMode;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void delayedWrite(BNetworkVariable bNetworkVariable, DeviceFacets deviceFacets) {
        Object object = deviceFacets != null ? deviceFacets : bNetworkVariable;
        Object object2 = object;
        synchronized (object2) {
            bNetworkVariable.doForceWrite();
            if (deviceFacets != null) {
                --deviceFacets.delayCnt;
                deviceFacets.lastNvWriteTime = Clock.ticks();
            }
            return;
        }
    }

    public static boolean getDisableSetOfflineInBind(BLonDevice bLonDevice) {
        DeviceFacets deviceFacets = DeviceFacets.getPickle(bLonDevice);
        if (deviceFacets != null) {
            return deviceFacets.disableSetOfflineInBind;
        }
        return false;
    }

    private static final DeviceFacets getPickle(BLonDevice bLonDevice) {
        BDeviceData bDeviceData = bLonDevice.getDeviceData();
        BFacets bFacets = bDeviceData.getFacets();
        if (BFacets.NULL == bFacets) {
            return null;
        }
        Object object = bDeviceData.getPickle();
        if (object != null) {
            return (DeviceFacets)object;
        }
        DeviceFacets deviceFacets = new DeviceFacets();
        deviceFacets.delayToReset = bFacets.geti("delayToReset", 0);
        deviceFacets.delayToHardOffline = bFacets.geti("delayToHardOffline", 0);
        deviceFacets.minNvUpdateInterMsgDelay = bFacets.geti("minNvUpdateInterMsgDelay", 0);
        deviceFacets.disableSetOfflineInBind = bFacets.getb("disableSetOfflineInBind", false);
        deviceFacets.disableToggleMode = bFacets.getb("disableToggleMode", false);
        deviceFacets.nodeObjectIndex = bFacets.geti("nodeObjectIndex", 0);
        bDeviceData.setPickle(deviceFacets);
        return deviceFacets;
    }

    public static void moveDeviceFacets(BLonDevice bLonDevice) {
        if (bLonDevice.getDeviceData().getFacets() != BFacets.NULL) {
            return;
        }
        Property property = bLonDevice.getPropertyInParent();
        if (property == null) {
            return;
        }
        BFacets bFacets = property.getFacets();
        if (bFacets == BFacets.NULL) {
            return;
        }
        bLonDevice.getDeviceData().setFacets(bFacets);
        ((BComponent)bLonDevice.getParent()).setFacets((Slot)bLonDevice.getPropertyInParent(), BFacets.NULL, null);
    }

    public static BFacets makeDeviceFacets(XDeviceFacets xDeviceFacets) {
        Class clazz = class$java$lang$String;
        if (clazz == null) {
            clazz = class$java$lang$String = DeviceFacets.class("[Ljava.lang.String;", false);
        }
        Array array = new Array(clazz);
        Class clazz2 = class$javax$baja$data$BIDataValue;
        if (clazz2 == null) {
            clazz2 = class$javax$baja$data$BIDataValue = DeviceFacets.class("[Ljavax.baja.data.BIDataValue;", false);
        }
        Array array2 = new Array(clazz2);
        if (xDeviceFacets.delayToReset > 0) {
            array.add((Object)"delayToReset");
            array2.add((Object)BInteger.make((int)xDeviceFacets.delayToReset));
        }
        if (xDeviceFacets.delayToHardOffline > 0) {
            array.add((Object)"delayToHardOffline");
            array2.add((Object)BInteger.make((int)xDeviceFacets.delayToHardOffline));
        }
        if (xDeviceFacets.minNvUpdateInterMsgDelay > 0) {
            array.add((Object)"minNvUpdateInterMsgDelay");
            array2.add((Object)BInteger.make((int)xDeviceFacets.minNvUpdateInterMsgDelay));
        }
        if (xDeviceFacets.disableSetOfflineInBind) {
            array.add((Object)"disableSetOfflineInBind");
            array2.add((Object)BBoolean.make((boolean)xDeviceFacets.disableSetOfflineInBind));
        }
        if (xDeviceFacets.disableToggleMode) {
            array.add((Object)"disableToggleMode");
            array2.add((Object)BBoolean.make((boolean)xDeviceFacets.disableToggleMode));
        }
        if (xDeviceFacets.nodeObjectIndex > 0) {
            array.add((Object)"nodeObjectIndex");
            array2.add((Object)BInteger.make((int)xDeviceFacets.nodeObjectIndex));
        }
        if (array.size() == 0) {
            return null;
        }
        String[] stringArray = (String[])array.trim();
        BIDataValue[] bIDataValueArray = (BIDataValue[])array2.trim();
        BFacets bFacets = BFacets.make((String[])stringArray, (BIDataValue[])bIDataValueArray);
        return bFacets;
    }

    public static void spy(BLonDevice bLonDevice, SpyWriter spyWriter) throws Exception {
        DeviceFacets deviceFacets = DeviceFacets.getPickle(bLonDevice);
        if (deviceFacets == null) {
            return;
        }
        spyWriter.startProps("DeviceFacets");
        spyWriter.prop((Object)"DelayToReset", deviceFacets.delayToReset);
        spyWriter.prop((Object)"DelayToHardOffline", deviceFacets.delayToHardOffline);
        spyWriter.prop((Object)"MinNvUpdateInterMsgDelay", deviceFacets.minNvUpdateInterMsgDelay);
        spyWriter.prop((Object)"DisableSetOfflineInBind", deviceFacets.disableSetOfflineInBind);
        spyWriter.prop((Object)"disableToggleMode", deviceFacets.disableToggleMode);
        spyWriter.prop((Object)"nodeObjectIndex", deviceFacets.nodeObjectIndex);
        spyWriter.prop((Object)"ticks since last NvWrite", (Object)Long.toString(Clock.ticks() - deviceFacets.lastNvWriteTime));
        spyWriter.prop((Object)"DelayCnt", deviceFacets.delayCnt);
        spyWriter.endProps();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.delayToReset = 0;
        this.delayToHardOffline = 0;
        this.minNvUpdateInterMsgDelay = 0;
        this.disableSetOfflineInBind = false;
        this.disableToggleMode = false;
        this.lastNvWriteTime = 0L;
        this.delayCnt = 0;
    }

    public DeviceFacets() {
        this.this();
    }

    public static class TimedInvocation
    extends Invocation
    implements TimedCoalesceQueue.ITimed {
        DeviceFacets devFacets;
        long invocationTime;

        public void run() {
            DeviceFacets.delayedWrite((BNetworkVariable)this.instance, this.devFacets);
        }

        public boolean equals(Object object) {
            return super.equals(object);
        }

        public long getTime() {
            return this.invocationTime;
        }

        public String getName() {
            return this.instance.getParent().getDisplayName(null) + ':' + this.instance.getDisplayName(null);
        }

        public TimedInvocation(BComponent bComponent, Action action, DeviceFacets deviceFacets, long l) {
            super(bComponent, action, null, null);
            this.devFacets = deviceFacets;
            this.invocationTime = l;
        }
    }
}

