/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.device;

import com.tridium.lonworks.device.ChangeableNvUtil;
import com.tridium.lonworks.netmgmt.BLonNetmgmtJob;
import com.tridium.lonworks.util.NmUtil;
import javax.baja.driver.BIDeviceFolder;
import javax.baja.driver.loadable.BUploadParameters;
import javax.baja.job.JobCancelException;
import javax.baja.lonworks.BILonLoadable;
import javax.baja.lonworks.BINvContainer;
import javax.baja.lonworks.BLonComponent;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BUploadJob
extends BLonNetmgmtJob
implements Runnable {
    public static final Type TYPE;
    BLonDevice dev;
    BUploadParameters parm;
    Context cx;
    BILonLoadable ld;
    BIDeviceFolder devFdr;
    boolean deviceFolder;
    String name;
    int lcCnt;
    int inc;
    boolean trans;
    boolean pers;
    static /* synthetic */ Class class$com$tridium$lonworks$device$BUploadJob;

    public Type getType() {
        return TYPE;
    }

    public void run() {
        try {
            if (this.deviceFolder) {
                this.uploadDeviceFolder(this.devFdr);
            } else {
                this.uploadLoadable(this.ld);
            }
        }
        catch (JobCancelException jobCancelException) {
            this.canceled();
        }
        catch (Throwable throwable) {
            this.fatal("Upload failed for " + this.name, throwable);
        }
        this.end();
    }

    void uploadDeviceFolder(BIDeviceFolder bIDeviceFolder) {
        BLonDevice[] bLonDeviceArray = NmUtil.getLonDevices(bIDeviceFolder);
        int n = 0;
        while (n < bLonDeviceArray.length) {
            if (!bLonDeviceArray[n].isLocal()) {
                this.uploadLoadable(bLonDeviceArray[n]);
            }
            ++n;
        }
    }

    void uploadLoadable(BILonLoadable bILonLoadable) {
        this.myProgress(20);
        int n = this.countReadable(bILonLoadable);
        this.inc = 80 / (n + 1);
        this.lcCnt = 0;
        this.upload(bILonLoadable);
    }

    void checkChanges(BINvContainer bINvContainer) {
        if (bINvContainer.getLonDevice().hasChangeableNvs()) {
            ChangeableNvUtil.uploadChangeables(bINvContainer);
        }
    }

    void upload(BILonLoadable bILonLoadable) {
        BComponent bComponent = (BComponent)bILonLoadable;
        bILonLoadable.beginUpload();
        this.status("Upload " + bComponent.getDisplayName(null));
        if (bComponent.getType().is(BINvContainer.TYPE)) {
            this.checkChanges((BINvContainer)bComponent);
        }
        SlotCursor slotCursor = bComponent.getProperties();
        while (slotCursor.nextComponent()) {
            BComponent bComponent2 = (BComponent)slotCursor.get();
            if (bComponent2.getType().is(BLonComponent.TYPE)) {
                BLonComponent bLonComponent = (BLonComponent)bComponent2;
                boolean bl = bLonComponent.isForeignPersistent();
                if ((!bl || !this.pers) && (bl || !this.trans)) continue;
                try {
                    bLonComponent.doForceRead();
                    this.status("Uploaded " + bLonComponent.getDisplayName(null));
                }
                catch (Throwable throwable) {
                    this.error("failed " + bLonComponent.getDisplayName(null), throwable);
                }
                this.myProgress(this.inc * this.lcCnt++);
                continue;
            }
            if (!bComponent2.getType().is(BILonLoadable.TYPE)) continue;
            this.upload((BILonLoadable)bComponent2);
        }
        bILonLoadable.endUpload();
    }

    int countReadable(BILonLoadable bILonLoadable) {
        int n = 0;
        SlotCursor slotCursor = ((BComponent)bILonLoadable).getProperties();
        while (slotCursor.nextComponent()) {
            BComponent bComponent = (BComponent)slotCursor.get();
            if (bComponent.getType().is(BLonComponent.TYPE)) {
                boolean bl = ((BLonComponent)bComponent).isForeignPersistent();
                if ((!bl || !this.pers) && (bl || !this.trans)) continue;
                ++n;
                continue;
            }
            if (!bComponent.getType().is(BILonLoadable.TYPE)) continue;
            n += this.countReadable((BILonLoadable)bComponent);
        }
        return n;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.deviceFolder = false;
    }

    public BUploadJob() {
        this.this();
    }

    public BUploadJob(BIDeviceFolder bIDeviceFolder, BUploadParameters bUploadParameters, Context context) {
        super((BLonNetwork)bIDeviceFolder.getNetwork());
        this.this();
        this.ld = null;
        this.devFdr = bIDeviceFolder;
        this.parm = bUploadParameters;
        this.cx = context;
        this.trans = this.parm.getUploadTransient();
        this.pers = this.parm.getUploadPersistent();
        this.name = ((BComponent)bIDeviceFolder).getDisplayName(null);
        this.deviceFolder = true;
    }

    public BUploadJob(BILonLoadable bILonLoadable, BUploadParameters bUploadParameters, Context context) {
        super(bILonLoadable.getLonDevice().lonNetwork());
        this.this();
        this.ld = bILonLoadable;
        this.parm = bUploadParameters;
        this.cx = context;
        this.trans = this.parm.getUploadTransient();
        this.pers = this.parm.getUploadPersistent();
        this.name = ((BComponent)bILonLoadable).getDisplayName(null);
        this.deviceFolder = false;
    }

    static {
        Class clazz = class$com$tridium$lonworks$device$BUploadJob;
        if (clazz == null) {
            clazz = class$com$tridium$lonworks$device$BUploadJob = BUploadJob.class("[Lcom.tridium.lonworks.device.BUploadJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

