/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.device;

import com.tridium.lonworks.netmgmt.BLonNetmgmtJob;
import com.tridium.lonworks.util.NmUtil;
import com.tridium.lonworks.util.selfdoc.SelfDocUtil;
import javax.baja.driver.BIDeviceFolder;
import javax.baja.driver.loadable.BDownloadParameters;
import javax.baja.job.JobCancelException;
import javax.baja.lonworks.BConfigParameter;
import javax.baja.lonworks.BILonLoadable;
import javax.baja.lonworks.BLonComponent;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.BNetworkConfig;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.datatypes.BConfigProps;
import javax.baja.lonworks.datatypes.BModifyFlags;
import javax.baja.lonworks.datatypes.BNcProps;
import javax.baja.lonworks.enums.BLonConfigScope;
import javax.baja.lonworks.enums.BLonNodeState;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IntHashMap;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BDownloadJob
extends BLonNetmgmtJob
implements Runnable {
    public static final Type TYPE;
    BILonLoadable ld;
    BDownloadParameters parm;
    Context cx;
    boolean resetRequired;
    boolean offlineRequired;
    boolean online;
    IntHashMap disabledObjects;
    BIDeviceFolder devFdr;
    boolean deviceFolder;
    String name;
    int lcCnt;
    int inc;
    int total;
    static /* synthetic */ Class class$com$tridium$lonworks$device$BDownloadJob;

    public Type getType() {
        return TYPE;
    }

    public void run() {
        try {
            if (this.deviceFolder) {
                this.downloadDeviceFolder(this.devFdr);
            } else {
                this.initForDownload(this.ld);
                this.downloadLoadable(this.ld);
                this.resetAfterDownload(this.ld);
            }
        }
        catch (JobCancelException jobCancelException) {
            this.canceled();
        }
        catch (Throwable throwable) {
            this.fatal("Download failed for " + this.name, throwable);
        }
        this.end();
    }

    void downloadDeviceFolder(BIDeviceFolder bIDeviceFolder) {
        BLonDevice[] bLonDeviceArray = NmUtil.getLonDevices(bIDeviceFolder);
        int n = 0;
        while (n < bLonDeviceArray.length) {
            if (!bLonDeviceArray[n].isLocal()) {
                this.initForDownload(bLonDeviceArray[n]);
                this.downloadLoadable(bLonDeviceArray[n]);
                this.resetAfterDownload(bLonDeviceArray[n]);
            }
            ++n;
        }
    }

    void downloadLoadable(BILonLoadable bILonLoadable) {
        boolean bl = bILonLoadable instanceof BLonDevice;
        if (!bl) {
            bILonLoadable.getLonDevice().beginDownload();
        }
        this.downLoad(bILonLoadable);
        if (!bl) {
            bILonLoadable.getLonDevice().endDownload();
        }
    }

    void downLoad(BILonLoadable bILonLoadable) {
        bILonLoadable.beginDownload();
        this.status("download " + bILonLoadable.getDisplayName(null));
        SlotCursor slotCursor = ((BComponent)bILonLoadable).getProperties();
        while (slotCursor.nextComponent()) {
            BComponent bComponent = (BComponent)slotCursor.get();
            if (bComponent.getType().is(BLonComponent.TYPE)) {
                BLonComponent bLonComponent = (BLonComponent)bComponent;
                if (!bLonComponent.isForeignPersistent() || !bLonComponent.isWriteable()) continue;
                try {
                    bLonComponent.doForceWrite();
                    this.status("download " + bLonComponent.getDisplayName(null));
                    this.myProgress(this.inc * this.lcCnt++);
                }
                catch (Throwable throwable) {
                    this.error("failed " + bLonComponent.getDisplayName(null), throwable);
                }
                continue;
            }
            if (!bComponent.getType().is(BILonLoadable.TYPE)) continue;
            this.downLoad((BILonLoadable)bComponent);
        }
        bILonLoadable.endDownload();
    }

    private final void initForDownload(BILonLoadable bILonLoadable) {
        BLonDevice bLonDevice = bILonLoadable.getLonDevice();
        this.resetRequired = false;
        this.offlineRequired = false;
        this.online = bLonDevice.isConfigOnline();
        this.total = this.init(bILonLoadable);
        if (this.disabledObjects != null) {
            this.enableObjects(bLonDevice, false);
        }
        if (this.offlineRequired) {
            try {
                NmUtil.setDeviceState(bLonDevice, BLonNodeState.configOffline);
            }
            catch (LonException lonException) {
                System.out.println((Object)lonException);
            }
        }
        this.inc = 80 / (this.total + 1);
        this.lcCnt = 0;
        this.myProgress(20);
    }

    private final int init(BILonLoadable bILonLoadable) {
        int n = 0;
        SlotCursor slotCursor = ((BComponent)bILonLoadable).getProperties();
        while (slotCursor.nextComponent()) {
            BComponent bComponent = (BComponent)slotCursor.get();
            if (bComponent.getType().is(BLonComponent.TYPE)) {
                BLonComponent bLonComponent = (BLonComponent)bComponent;
                if (!bLonComponent.isForeignPersistent() || !bLonComponent.isWriteable()) continue;
                this.init(bLonComponent);
                ++n;
                continue;
            }
            if (!bComponent.getType().is(BILonLoadable.TYPE)) continue;
            n += this.init((BILonLoadable)bComponent);
        }
        return n;
    }

    private final void init(BLonComponent bLonComponent) {
        String string;
        BLonConfigScope bLonConfigScope;
        BModifyFlags bModifyFlags;
        if (bLonComponent.isConfigParameter()) {
            BConfigProps bConfigProps = ((BConfigParameter)bLonComponent).getConfigProps();
            bModifyFlags = bConfigProps.getModifyFlag();
            bLonConfigScope = bConfigProps.getScope();
            string = bConfigProps.getSelect();
        } else if (bLonComponent.isNetworkConfig()) {
            BNcProps bNcProps = ((BNetworkConfig)bLonComponent).getNcProps();
            bModifyFlags = bNcProps.getModifyFlag();
            bLonConfigScope = bNcProps.getScope();
            string = bNcProps.getSelect();
        } else {
            return;
        }
        if (this.online && bModifyFlags.isDisabled() && bLonConfigScope == BLonConfigScope.object) {
            this.addObjects(string);
        }
        if (this.online && bModifyFlags.isOffline()) {
            this.offlineRequired = true;
        }
        if (bModifyFlags.isReset()) {
            this.resetRequired = true;
        }
    }

    private final void enableObjects(BLonDevice bLonDevice, boolean bl) {
        if (this.disabledObjects == null) {
            return;
        }
        Object[] objectArray = new Integer[this.disabledObjects.size()];
        this.disabledObjects.toArray(objectArray);
        int n = 0;
        while (n < objectArray.length) {
            bLonDevice.enableObject((Integer)objectArray[n], bl);
            ++n;
        }
    }

    private final void addObjects(String string) {
        int[] nArray = SelfDocUtil.selectToIntArray(string);
        int n = 0;
        while (n < nArray.length) {
            this.addObject(nArray[n]);
            ++n;
        }
    }

    private final void addObject(int n) {
        if (this.disabledObjects == null) {
            this.disabledObjects = new IntHashMap();
        }
        if (this.disabledObjects.get(n) != null) {
            return;
        }
        this.disabledObjects.put(n, (Object)new Integer(n));
    }

    private final void resetAfterDownload(BILonLoadable bILonLoadable) {
        BLonDevice bLonDevice = bILonLoadable.getLonDevice();
        if (this.disabledObjects != null) {
            this.enableObjects(bLonDevice, true);
            this.disabledObjects.clear();
            this.disabledObjects = null;
        }
        if (this.offlineRequired) {
            try {
                NmUtil.setDeviceState(bLonDevice, BLonNodeState.configOnline);
            }
            catch (LonException lonException) {
                System.out.println((Object)lonException);
            }
            this.offlineRequired = false;
        }
        if (this.resetRequired) {
            bLonDevice.doReset();
        }
        this.resetRequired = false;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.disabledObjects = null;
        this.deviceFolder = false;
    }

    public BDownloadJob() {
        this.this();
    }

    public BDownloadJob(BIDeviceFolder bIDeviceFolder, BDownloadParameters bDownloadParameters, Context context) {
        super((BLonNetwork)bIDeviceFolder.getNetwork());
        this.this();
        this.ld = null;
        this.devFdr = bIDeviceFolder;
        this.parm = bDownloadParameters;
        this.cx = context;
        this.name = ((BComponent)bIDeviceFolder).getDisplayName(null);
        this.deviceFolder = true;
    }

    public BDownloadJob(BILonLoadable bILonLoadable, BDownloadParameters bDownloadParameters, Context context) {
        super(bILonLoadable.getLonDevice().lonNetwork());
        this.this();
        this.ld = bILonLoadable;
        this.parm = bDownloadParameters;
        this.cx = context;
        this.name = ((BComponent)bILonLoadable).getDisplayName(null);
        this.deviceFolder = false;
    }

    static {
        Class clazz = class$com$tridium$lonworks$device$BDownloadJob;
        if (clazz == null) {
            clazz = class$com$tridium$lonworks$device$BDownloadJob = BDownloadJob.class("[Lcom.tridium.lonworks.device.BDownloadJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

