/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks;

import com.tridium.lonworks.BLonRouter;
import com.tridium.lonworks.NAddressManager;
import com.tridium.lonworks.datatypes.BLonRouteTable;
import com.tridium.lonworks.enums.BLonRouterMode;
import com.tridium.lonworks.enums.BLonRouterType;
import com.tridium.lonworks.netmessages.NetMessages;
import com.tridium.lonworks.netmgmt.NetMgmtConst;
import com.tridium.lonworks.util.LonByteArrayUtil;
import com.tridium.lonworks.util.RouterUtil;
import java.util.BitSet;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.LonException;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BajaRuntimeException;

public class RouterManager
implements NetMgmtConst,
NetMessages {
    private NAddressManager addMan;
    private Router[] rtrTab;
    private int maxChanId;
    private BLonNetwork lon;

    public void update() {
        Object object;
        BLonRouter[] bLonRouterArray = this.addMan.getRouterList();
        this.rtrTab = new Router[bLonRouterArray.length];
        int n = 0;
        while (n < bLonRouterArray.length) {
            object = new Router();
            ((Router)object).nearChan = bLonRouterArray[n].getNearDeviceData().getChannelId();
            ((Router)object).farChan = bLonRouterArray[n].getFarDeviceData().getChannelId();
            ((Router)object).nearGroupTable = this.newRouteTableArray();
            ((Router)object).farGroupTable = this.newRouteTableArray();
            this.rtrTab[n] = object;
            ++n;
        }
        this.maxChanId = this.addMan.getMaxChannelId();
        n = 0;
        while (n < this.rtrTab.length) {
            object = new BitSet(this.maxChanId + 1);
            this.setFarChannelBits((BitSet)object, this.rtrTab[n], this.maxChanId);
            this.rtrTab[n].farChannels = object;
            ++n;
        }
    }

    private final void setFarChannelBits(BitSet bitSet, Router router, int n) {
        if (n == 0) {
            String string = "INTERNAL ERROR int RouterManager - illegal network connection";
            this.lon.log().error(string);
            throw new BajaRuntimeException(string);
        }
        bitSet.set(router.farChan);
        int n2 = 0;
        while (n2 < this.rtrTab.length) {
            if (this.rtrTab[n2].nearChan == router.farChan) {
                this.setFarChannelBits(bitSet, this.rtrTab[n2], n - 1);
            }
            ++n2;
        }
    }

    public void updateRouteTables(BLonRouter bLonRouter) {
        Router router = this.getRouter(bLonRouter);
        BLonRouteTable bLonRouteTable = this.getFarRouteTable(router);
        bLonRouter.setFarSubnetTable(bLonRouteTable);
        BLonRouteTable bLonRouteTable2 = bLonRouteTable.invert(this.addMan.getSubnetMap());
        bLonRouter.setNearSubnetTable(bLonRouteTable2);
    }

    private final BLonRouteTable getFarRouteTable(Router router) {
        BitSet bitSet = router.farChannels;
        byte[] byArray = this.newRouteTableArray();
        this.clearFlag(0, byArray);
        int n = 0;
        while (n < bitSet.size()) {
            int[] nArray;
            if (bitSet.get(n) && (nArray = this.addMan.getSubnetMap()) != null) {
                int n2 = 0;
                while (n2 < nArray.length) {
                    if (nArray[n2] == n) {
                        this.clearFlag(n2, byArray);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return BLonRouteTable.make(byArray);
    }

    private final byte[] newRouteTableArray() {
        return BLonRouteTable.DEFAULT.getByteArrayCopy();
    }

    private final void clearFlag(int n, byte[] byArray) {
        int n2 = n / 8;
        int n3 = n % 8;
        int n4 = n2;
        byArray[n4] = (byte)(byArray[n4] & ~(1 << n3));
    }

    private final Router getRouter(BLonRouter bLonRouter) {
        int n = bLonRouter.getFarDeviceData().getChannelId();
        int n2 = 0;
        while (n2 < this.rtrTab.length) {
            if (this.rtrTab[n2].farChan == n) {
                return this.rtrTab[n2];
            }
            ++n2;
        }
        return null;
    }

    public void verifySubnets() {
        BLonRouter[] bLonRouterArray = this.addMan.getRouterList();
        int n = 0;
        while (n < bLonRouterArray.length) {
            boolean bl = false;
            BLonRouter bLonRouter = bLonRouterArray[n];
            BLonRouteTable bLonRouteTable = this.getFarRouteTable(this.rtrTab[n]);
            try {
                BLonRouterMode bLonRouterMode;
                BLonRouteTable bLonRouteTable2 = bLonRouter.getFarSubnetTable();
                if (!bLonRouteTable2.equals((Object)bLonRouteTable)) {
                    RouterUtil.updateTable(bLonRouter, 0, true, bLonRouteTable, bLonRouteTable2);
                    bLonRouter.setFarSubnetTable(bLonRouteTable);
                    bl = true;
                }
                BLonRouteTable bLonRouteTable3 = bLonRouteTable.invert(this.addMan.getSubnetMap());
                bLonRouteTable2 = bLonRouter.getNearSubnetTable();
                if (!bLonRouteTable2.equals((Object)bLonRouteTable3)) {
                    RouterUtil.updateTable(bLonRouter, 0, false, bLonRouteTable3, bLonRouteTable2);
                    bLonRouter.setNearSubnetTable(bLonRouteTable3);
                    bl = true;
                }
                if (bl && bLonRouter.getRouterType() == BLonRouterType.configured && (bLonRouterMode = bLonRouter.getRouterMode()) == BLonRouterMode.normal) {
                    RouterUtil.setRouterMode(bLonRouter, BLonRouterMode.initRouterTable);
                    if (this.lon.netmgmt().getTempBridge()) {
                        RouterUtil.setRouterMode(bLonRouter, BLonRouterMode.normal);
                    }
                }
            }
            catch (LonException lonException) {
                this.lon.log().error("Unable to update subnet route table in " + bLonRouter.getDisplayName(null));
            }
            ++n;
        }
    }

    public NAddressManager getAddressManager() {
        return this.addMan;
    }

    public void initGroupRouteUpdate() {
        int n = 0;
        while (n < this.rtrTab.length) {
            this.rtrTab[n].nearGroupTable = this.newRouteTableArray();
            this.rtrTab[n].farGroupTable = this.newRouteTableArray();
            ++n;
        }
    }

    public void setGroupRouteFlags(int n, BitSet bitSet) {
        int n2 = 0;
        while (n2 < this.rtrTab.length) {
            BitSet bitSet2 = this.rtrTab[n2].farChannels;
            boolean bl = false;
            boolean bl2 = false;
            int n3 = 1;
            while (n3 <= this.maxChanId) {
                if (bitSet.get(n3)) {
                    if (bitSet2.get(n3)) {
                        bl = true;
                    } else {
                        bl2 = true;
                    }
                }
                ++n3;
            }
            if (bl && !bl2) {
                this.clearFlag(n, this.rtrTab[n2].farGroupTable);
            } else if (bl2 && !bl) {
                this.clearFlag(n, this.rtrTab[n2].nearGroupTable);
            }
            ++n2;
        }
    }

    public void updateGroupRouteFlags() {
        BLonRouter[] bLonRouterArray = this.addMan.getRouterList();
        int n = 0;
        while (n < bLonRouterArray.length) {
            BLonRouter bLonRouter = bLonRouterArray[n];
            try {
                BLonRouterMode bLonRouterMode;
                boolean bl = false;
                BLonRouteTable bLonRouteTable = BLonRouteTable.make(this.rtrTab[n].nearGroupTable);
                BLonRouteTable bLonRouteTable2 = bLonRouter.getNearGroupTable();
                if (!bLonRouteTable2.equals((Object)bLonRouteTable)) {
                    RouterUtil.updateTable(bLonRouter, 1, false, bLonRouteTable, bLonRouteTable2);
                    bLonRouter.setNearGroupTable(bLonRouteTable);
                    bl = true;
                }
                bLonRouteTable = BLonRouteTable.make(this.rtrTab[n].farGroupTable);
                bLonRouteTable2 = bLonRouter.getFarGroupTable();
                if (!bLonRouteTable2.equals((Object)bLonRouteTable)) {
                    RouterUtil.updateTable(bLonRouter, 1, true, bLonRouteTable, bLonRouteTable2);
                    bLonRouter.setFarGroupTable(bLonRouteTable);
                    bl = true;
                }
                if (bl && bLonRouter.getRouterType() == BLonRouterType.configured && (bLonRouterMode = bLonRouter.getRouterMode()) == BLonRouterMode.normal) {
                    RouterUtil.setRouterMode(bLonRouter, BLonRouterMode.initRouterTable);
                    if (this.lon.netmgmt().getTempBridge()) {
                        RouterUtil.setRouterMode(bLonRouter, BLonRouterMode.normal);
                    }
                }
            }
            catch (LonException lonException) {
                this.lon.log().error("Unable to update group route table in " + bLonRouter.getDisplayName(null));
            }
            ++n;
        }
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        BLonRouter[] bLonRouterArray = this.addMan.getRouterList();
        spyWriter.startProps("Router table");
        int n = 0;
        while (n < this.rtrTab.length) {
            Router router = this.rtrTab[n];
            spyWriter.prop((Object)bLonRouterArray[n].getName(), (Object)"");
            spyWriter.prop((Object)"nearChan", (Object)Integer.toString(router.nearChan));
            spyWriter.prop((Object)"farChan", (Object)Integer.toString(router.farChan));
            spyWriter.prop((Object)"farChannels", (Object)router.farChannels.toString());
            spyWriter.prop((Object)"nearGroupTable", (Object)LonByteArrayUtil.toString(router.nearGroupTable));
            spyWriter.prop((Object)"farGroupTable", (Object)LonByteArrayUtil.toString(router.farGroupTable));
            ++n;
        }
        spyWriter.endProps();
    }

    public RouterManager(NAddressManager nAddressManager, BLonNetwork bLonNetwork) {
        this.addMan = nAddressManager;
        this.lon = bLonNetwork;
    }

    public static class Router {
        int nearChan;
        int farChan;
        BitSet farChannels;
        byte[] nearGroupTable;
        byte[] farGroupTable;
    }
}

