/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks;

import com.tridium.lonworks.loncomm.NLonComm;
import com.tridium.lonworks.netmessages.UnprocessedNV;
import javax.baja.lonworks.BINetworkVariable;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.LonComm;
import javax.baja.lonworks.LonListener;
import javax.baja.lonworks.LonMessage;
import javax.baja.lonworks.datatypes.BSubnetNode;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BComponent;
import javax.baja.util.IntHashMap;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NvManager
implements LonListener {
    private BLonNetwork lonworks;
    private LonComm lonComm;
    private IntHashMap hash;

    public void receiveLonMessage(LonMessage lonMessage) {
        UnprocessedNV unprocessedNV = (UnprocessedNV)lonMessage;
        BSubnetNode bSubnetNode = (BSubnetNode)lonMessage.getSourceAddress();
        int n = unprocessedNV.getNvSelector();
        BComponent bComponent = (BComponent)this.hash.get(this.hashCode(n, bSubnetNode));
        if (bComponent == null) {
            if (!this.lonworks.getLocalLonDevice().receiveNvUpdate(n, unprocessedNV)) {
                this.lonworks.log().trace("Received unmapped nv update for selector=" + n + " from " + bSubnetNode);
            }
            return;
        }
        BINetworkVariable bINetworkVariable = (BINetworkVariable)bComponent;
        bINetworkVariable.receiveUpdate(unprocessedNV.getData());
    }

    private final int hashCode(int n, BSubnetNode bSubnetNode) {
        return (bSubnetNode.getSubnetId() << 22) + (bSubnetNode.getNodeId() << 15) + n;
    }

    public void registerSelector(int n, BINetworkVariable bINetworkVariable, BLonDevice bLonDevice) {
        BComponent bComponent = (BComponent)this.hash.put(this.hashCode(n, bLonDevice.getSubnetNodeAddress()), (Object)bINetworkVariable);
        if (bComponent != null && bComponent != bINetworkVariable) {
            System.out.println("INTERNAL ERROR: registerSelector selector=" + n + " yielded nv " + bComponent.getParent().getDisplayName(null) + ':' + bComponent.getDisplayName(null) + " instead of " + ((BComponent)bINetworkVariable).getParent().getDisplayName(null) + ':' + ((BComponent)bINetworkVariable).getDisplayName(null));
        }
    }

    public void unregisterSelector(int n, BINetworkVariable bINetworkVariable, BLonDevice bLonDevice) {
        BComponent bComponent = (BComponent)this.hash.remove(this.hashCode(n, bLonDevice.getSubnetNodeAddress()));
        if (bComponent == null) {
            IntHashMap.Iterator iterator = this.hash.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() != bINetworkVariable) continue;
                this.hash.remove(iterator.key());
            }
        }
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        spyWriter.startProps("NvManager hash table");
        IntHashMap.Iterator iterator = this.hash.iterator();
        while (iterator.hasNext()) {
            BComponent bComponent = (BComponent)iterator.next();
            int n = iterator.key();
            spyWriter.prop((Object)Integer.toString(n & 0x3FFF, 16), (Object)(bComponent.getParent().getDisplayName(null) + ':' + bComponent.getDisplayName(null)));
        }
        spyWriter.endProps();
    }

    private final /* synthetic */ void this() {
        this.hash = new IntHashMap(500);
    }

    public NvManager(BLonNetwork bLonNetwork) {
        this.this();
        this.lonworks = bLonNetwork;
        this.lonComm = this.lonworks.lonComm();
        ((NLonComm)this.lonComm).registerNvListener(this);
    }
}

