/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.util;

import com.tridium.ccn.BCcnDevice;
import com.tridium.ccn.BCcnNetwork;
import com.tridium.ccn.components.BCcnPointEntry;
import com.tridium.ccn.components.BCcnTableEntry;
import com.tridium.ccn.components.BFidPointConfig;
import com.tridium.ccn.enums.BCcnAlarmStatusEnum;
import com.tridium.ccn.enums.BCcnDataTypeEnum;
import com.tridium.ccn.enums.BCcnDiscreteStateEnum;
import com.tridium.ccn.enums.BCcnForceStatusEnum;
import com.tridium.ccn.enums.BCcnTableGroupTypeEnum;
import com.tridium.ccn.enums.BCcnUnitMappingEnum;
import com.tridium.ccn.exceptions.CcnException;
import com.tridium.ccn.messages.CcnMessageConst;
import com.tridium.ccn.messages.CcnReadTableRequest;
import com.tridium.ccn.messages.CcnResponseMessage;
import com.tridium.ccn.point.BCcnProxyExt;
import com.tridium.ccn.tables.BCcnAHTable;
import com.tridium.ccn.tables.BCcnDataTable;
import com.tridium.ccn.tables.BCcnFidTable;
import com.tridium.ccn.tables.BCcnPicTable;
import com.tridium.ccn.tables.BCcnPocTable;
import com.tridium.ccn.tables.BCcnTable;
import com.tridium.ccn.tables.BCcnTableGroup;
import com.tridium.ccn.util.CcnEnumsUtil;
import com.tridium.ccn.util.CcnRspDataUtil;
import com.tridium.ccn.util.CcnRspFidUtil;
import com.tridium.ccn.util.CcnRspPicPocUtil;
import com.tridium.ccn.util.CcnRspPicUtil;
import com.tridium.ccn.util.CcnRspPocUtil;
import com.tridium.platCcn.CcnTableDef;
import java.util.Vector;
import javax.baja.log.Log;
import javax.baja.sys.BComponent;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.util.BFolder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CcnUtil
implements CcnMessageConst {
    public static final int NONE_DATA_TYPE = 0;
    public static final int INT_DATA_TYPE = 1;
    public static final int FLOAT_DATA_TYPE = 2;
    public static final int DATE_DATA_TYPE = 3;
    public static final int TIME_DATA_TYPE = 4;
    public static final int BOOLEAN_DATA_TYPE = 5;
    public static final int STRING_DATA_TYPE = 9;
    public static final int INT_READONLY_DATA_TYPE = 10;
    public static final int FLOAT_READONLY_DATA_TYPE = 11;
    public static final int DATE_READONLY_DATA_TYPE = 12;
    public static final int TIME_READONLY_DATA_TYPE = 13;
    public static final int BOOLEAN_READONLY_DATA_TYPE = 14;
    public static final int STRING_READONLY_DATA_TYPE = 18;
    public static final int SUCCESSFUL_OPERATION = 0;
    public static final int NO_OPERATION_NODE_OOS = 1;
    public static final int UNRESPONSIVE_OPERATION = 2;
    public static final int UNSUCCESSFUL_OPERATION = 3;
    public static final int POLL_ACTION = 0;
    public static final int WRITE_ACTION = 1;
    public static final String NODE_NAME_SPECIAL_CHARS = "_";
    public static BCcnPointEntry pointEntry;
    public static BFidPointConfig pointConfig;
    public static BCcnPicTable ccnPicTable;
    public static BCcnPocTable ccnPocTable;
    static Log ccnMessageLog;
    static /* synthetic */ Class class$com$tridium$ccn$components$BCcnPointEntry;

    public static int getControlPointType(BCcnPointEntry bCcnPointEntry) {
        if (bCcnPointEntry.isDiscrete()) {
            return 5;
        }
        return CcnUtil.getControlPointType(bCcnPointEntry.getPointDataType());
    }

    public static int getControlPointType(int n) {
        switch (n) {
            case 2: 
            case 10: {
                return 1;
            }
            case 0: 
            case 1: 
            case 9: 
            case 12: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                return 9;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                return 0;
            }
            case 6: {
                return 11;
            }
            case 7: 
            case 17: 
            case 48: 
            case 49: 
            case 50: {
                return 2;
            }
            case 51: {
                return 18;
            }
        }
        return 0;
    }

    public static BCcnTableGroup findCcnTableGroup(BComponent bComponent, BCcnTableGroupTypeEnum bCcnTableGroupTypeEnum) {
        BCcnTableGroup bCcnTableGroup = null;
        BComponent[] bComponentArray = bComponent.getChildComponents();
        boolean bl = false;
        int n = 0;
        while (n < bComponentArray.length) {
            BComponent bComponent2 = bComponentArray[n];
            if (bComponent2 instanceof BCcnTableGroup) {
                bCcnTableGroup = (BCcnTableGroup)bComponent2;
                if (bCcnTableGroup.getName().equalsIgnoreCase(bCcnTableGroupTypeEnum.getTag())) {
                    bl = true;
                    break;
                }
                BCcnTableGroup bCcnTableGroup2 = CcnUtil.findCcnTableGroup(bComponent2, bCcnTableGroupTypeEnum);
                if (bCcnTableGroup2 != null) {
                    return bCcnTableGroup2;
                }
            }
            ++n;
        }
        if (bl) {
            return bCcnTableGroup;
        }
        return null;
    }

    public static BCcnTable findCcnTable(BComponent bComponent, BCcnTableEntry bCcnTableEntry) {
        BCcnTable bCcnTable = null;
        boolean bl = false;
        BComponent[] bComponentArray = bComponent.getChildComponents();
        int n = 0;
        while (n < bComponentArray.length) {
            Object object;
            BComponent bComponent2 = bComponentArray[n];
            if (bComponent2 instanceof BCcnPicTable || bComponent2 instanceof BCcnPocTable || bComponent2 instanceof BCcnAHTable || bComponent2 instanceof BCcnFidTable || bComponent2 instanceof BCcnDataTable) {
                bCcnTable = (BCcnTable)bComponent2;
                object = bCcnTable.getName().trim();
                if (object.equalsIgnoreCase(bCcnTableEntry.getTableName()) && bCcnTable.getTableNum() == bCcnTableEntry.getTableNum()) {
                    bl = true;
                    break;
                }
            } else {
                object = CcnUtil.findCcnTable(bComponent2, bCcnTableEntry);
                if (object != null) {
                    return object;
                }
            }
            ++n;
        }
        if (bl) {
            return bCcnTable;
        }
        return null;
    }

    public static BCcnDevice findCcnDevice(BComponent bComponent, int n, int n2) {
        BCcnDevice bCcnDevice = null;
        boolean bl = false;
        BComponent[] bComponentArray = bComponent.getChildComponents();
        int n3 = 0;
        while (n3 < bComponentArray.length) {
            BComponent bComponent2 = bComponentArray[n3];
            if (bComponent2 instanceof BCcnDevice) {
                bCcnDevice = (BCcnDevice)bComponent2;
                if (bCcnDevice.getBusNo() == n && bCcnDevice.getElemNo() == n2) {
                    bl = true;
                }
            } else {
                BCcnDevice bCcnDevice2 = CcnUtil.findCcnDevice(bComponent2, n, n2);
                if (bCcnDevice2 != null) {
                    return bCcnDevice2;
                }
            }
            ++n3;
        }
        if (bl) {
            return bCcnDevice;
        }
        return null;
    }

    public static CcnResponseMessage getBlockDataFromTable(BCcnDevice bCcnDevice, int n, int n2, int n3) {
        CcnResponseMessage ccnResponseMessage = new CcnResponseMessage();
        BCcnNetwork bCcnNetwork = bCcnDevice.getCcnNetwork();
        int n4 = bCcnDevice.getBusNo();
        int n5 = bCcnDevice.getElemNo();
        int n6 = 0;
        while (n6 < 3) {
            ccnResponseMessage = new CcnResponseMessage();
            CcnReadTableRequest ccnReadTableRequest = new CcnReadTableRequest(new CcnTableDef((byte)n5, (byte)n4, null, (short)n, (byte)n2, (byte)n3, 0, 0));
            ccnResponseMessage = bCcnNetwork.getCcnComm().ccnAsyncRequest().sendAsyncRequest(ccnReadTableRequest);
            if (ccnResponseMessage != null && ccnResponseMessage.getResponseCommand() == 21) {
                return ccnResponseMessage;
            }
            if (ccnResponseMessage != null && ccnResponseMessage.getResponseCommand() == 6 && n3 == ccnResponseMessage.getBlock() && n2 == ccnResponseMessage.getTableInstance() && n == ccnResponseMessage.getTableType()) {
                return ccnResponseMessage;
            }
            ++n6;
        }
        if (ccnResponseMessage != null) {
            ccnMessageLog.trace("\n****  createTablesRequest... return from block read, device: " + n4 + ',' + n5 + " for table= " + Integer.toHexString(n) + ',' + n2 + " curBlock= " + n3 + " blockLen= " + ccnResponseMessage.getBlockLen());
        }
        if (ccnResponseMessage == null) {
            ccnMessageLog.trace("\n****  createTablesRequest... getBlockDataFromTable failed to get block from block read, device: " + n4 + ',' + n5 + " for table= " + Integer.toHexString(n) + ',' + n2 + " curBlock= " + n3);
        }
        return ccnResponseMessage;
    }

    public static boolean isNetworkDeviceStatusOk(BCcnDevice bCcnDevice) {
        boolean bl = true;
        BCcnNetwork bCcnNetwork = null;
        try {
            bCcnNetwork = bCcnDevice.getCcnNetwork();
        }
        catch (Exception exception) {
            bCcnNetwork = null;
        }
        if (bCcnNetwork == null) {
            bl = false;
        } else if (!CcnUtil.isNetworkStatusOk(bCcnNetwork)) {
            bl = false;
        } else if (!CcnUtil.isDeviceStatusOk(bCcnDevice)) {
            bl = false;
        }
        return bl;
    }

    public static boolean isNetworkStatusOk(BCcnNetwork bCcnNetwork) {
        return !bCcnNetwork.isDown() && !bCcnNetwork.isDisabled() && !bCcnNetwork.isFatalFault();
    }

    public static boolean isDeviceStatusOk(BCcnDevice bCcnDevice) {
        return !bCcnDevice.isDown() && !bCcnDevice.isDisabled() && !bCcnDevice.isFatalFault();
    }

    public static String makeValidName(String string) {
        return CcnUtil.makeValidName(string, NODE_NAME_SPECIAL_CHARS, '_');
    }

    public static String makeValidName(String string, String string2, char c) {
        char[] cArray = string.toCharArray();
        if (!Character.isLetter(cArray[0])) {
            cArray[0] = 120;
        }
        int n = 1;
        while (n < cArray.length) {
            char c2 = cArray[n];
            if (!Character.isLetterOrDigit(c2) && string2.indexOf(c2) < 0) {
                cArray[n] = c;
            }
            ++n;
        }
        return new String(cArray);
    }

    public static String massageFloatToTimeString(BCcnProxyExt bCcnProxyExt, String string) throws CcnException {
        String string2 = new String();
        try {
            int n = new Float(string).intValue();
            if (n < 9999) {
                int n2 = n / 100;
                int n3 = n % 100;
                string2 = n2 > 24 || n2 < 0 || n3 > 60 || n3 < 0 ? null : CcnRspFidUtil.get2DigString(n2) + ':' + CcnRspFidUtil.get2DigString(n3);
            }
        }
        catch (Exception exception) {
            bCcnProxyExt.getTable().updateObject(null, 3, 1, bCcnProxyExt);
            throw new CcnException(6488174, "Enter time value in hhmm format");
        }
        return string2;
    }

    public static String formatTime(String string) {
        if (string.indexOf(":") == -1) {
            throw new LocalizableRuntimeException("ccn", "CCNTimeFomat.Error");
        }
        if (string.substring(0, string.indexOf(":")).length() == 1) {
            string = "0" + string;
        }
        if (string.substring(string.indexOf(":") + 1).length() == 1) {
            string = string.substring(0, string.indexOf(":") + 1) + '0' + string.substring(string.indexOf(":") + 1);
        }
        return string;
    }

    public static String formatDoubleTime(String string) {
        String string2 = string.substring(0, string.indexOf(" "));
        String string3 = string.substring(string.indexOf(" ") + 1);
        string = CcnUtil.formatTime(string2) + ' ' + CcnUtil.formatTime(string3);
        return string;
    }

    public static CcnResponseMessage[] interrogateTableForPointData(BCcnDevice bCcnDevice, int n, int n2, int n3) {
        BCcnNetwork bCcnNetwork = bCcnDevice.getCcnNetwork();
        CcnResponseMessage[] ccnResponseMessageArray = new CcnResponseMessage[n3];
        if (!bCcnDevice.isDeviceFID()) {
            int n4 = 2;
            while (n4 <= n3) {
                if ((20 > n || n > 22) && n != 24 || n4 != 5 && n4 != 9) {
                    bCcnNetwork.setDiscoveryInProgress(true);
                    ccnResponseMessageArray[n4 - 1] = CcnUtil.getBlockDataFromTable(bCcnDevice, n, n2, n4);
                }
                ++n4;
            }
        } else {
            int n5 = 1;
            while (n5 <= n3) {
                if (n5 != 1 || n == 1281) {
                    bCcnNetwork.setDiscoveryInProgress(true);
                    ccnResponseMessageArray[n5 - 1] = CcnUtil.getBlockDataFromTable(bCcnDevice, n, n2, n5);
                    if (ccnResponseMessageArray[n5 - 1] == null) {
                        return null;
                    }
                }
                ++n5;
            }
        }
        return ccnResponseMessageArray;
    }

    public static void convertBlockDataToTableData(BCcnDevice bCcnDevice, BCcnPointEntry[] bCcnPointEntryArray, BFidPointConfig[] bFidPointConfigArray, int n, CcnResponseMessage[] ccnResponseMessageArray, BCcnTable bCcnTable, int n2) {
        block33: {
            block37: {
                block36: {
                    block35: {
                        block34: {
                            int n3 = bCcnPointEntryArray.length;
                            int n4 = ccnResponseMessageArray.length;
                            int[] nArray = new int[n4];
                            ccnMessageLog.trace("Inside convertBlockDataToTableData method-->tableFieldCount::" + n3 + "::tableBlockCount::" + n4);
                            ccnMessageLog.trace("blockIndices Array Length is::" + nArray.length);
                            int n5 = 0;
                            if (bCcnDevice.isDeviceFID()) break block34;
                            int n6 = 0;
                            while (n6 < n3) {
                                pointEntry = new BCcnPointEntry();
                                int n7 = 2 + n6 / 20;
                                int n8 = nArray[n7 - 1];
                                if (n8 != -1) {
                                    nArray[n7 - 1] = n5 = CcnUtil.getBlock_2_3_4_Data(bCcnDevice, pointEntry, n, n6, ccnResponseMessageArray[n7 - 1], n8);
                                }
                                if ((n8 = nArray[(n7 = 5) - 1]) != -1) {
                                    nArray[n7 - 1] = n5 = CcnUtil.getBlock_5_Data(pointEntry, n, n6, ccnResponseMessageArray[n7 - 1], n8, n7);
                                }
                                if ((n8 = nArray[(n7 = 6) - 1]) != -1) {
                                    nArray[n7 - 1] = n5 = CcnUtil.getBlock_6_Data(bCcnTable, n, n6, ccnResponseMessageArray[n7 - 1], n8);
                                }
                                if (nArray[(n7 = 7) - 1] >= 240) {
                                    n7 = 8;
                                }
                                n8 = nArray[n7 - 1];
                                ccnMessageLog.trace("BlockIndex::" + n8 + "::BlockNumber::" + n7);
                                if (n8 != -1) {
                                    nArray[n7 - 1] = n5 = CcnUtil.getFieldLimits(n, n6, ccnResponseMessageArray[n7 - 1], n8, n7);
                                }
                                if ((n8 = nArray[(n7 = 9) - 1]) != -1) {
                                    nArray[n7 - 1] = n5 = CcnUtil.getFieldVariableNo(n, n6, ccnResponseMessageArray[n7 - 1], n8);
                                }
                                if ((n8 = nArray[(n7 = 10 + n6 / 10) - 1]) != -1) {
                                    nArray[n7 - 1] = n5 = CcnUtil.getFieldDescription(n, n6, ccnResponseMessageArray[n7 - 1], n8);
                                }
                                bCcnPointEntryArray[n6] = pointEntry;
                                ++n6;
                            }
                            break block33;
                        }
                        if (n != 1281) break block35;
                        pointConfig = new BFidPointConfig();
                        pointEntry = new BCcnPointEntry();
                        try {
                            int n9 = 1;
                            pointEntry.setFieldIndex(n2 - 1);
                            pointConfig.setPointIndex(n2 - 1);
                            String string = CcnRspFidUtil.getPointName(ccnResponseMessageArray[n9 - 1]).trim();
                            if (string.equals("IO")) {
                                string = string + CcnRspFidUtil.get2DigString(n2);
                            }
                            pointEntry.setFieldName(string);
                            pointEntry.setDisplayType(bCcnDevice.getCcnNetwork().getDisplayMetric());
                            pointEntry.setFieldByteCount(2);
                            pointEntry.setConfigFlags(0);
                            pointEntry.setVariableNo(n2 + 1);
                            pointEntry.setForceableFlag(true);
                            n9 = 2;
                            if (!CcnRspFidUtil.getInSystem(ccnResponseMessageArray[n9 - 1])) {
                                ccnMessageLog.trace("\n****  convertBlockDataToTableData tt=0x501 fidPointInstance:" + n2 + " not inSystem, so no point entry will be created");
                                return;
                            }
                            byte by = CcnRspFidUtil.getDeviceType(ccnResponseMessageArray[n9 - 1]);
                            if (by < 0 || by > 5) {
                                ccnMessageLog.trace("\n****  convertBlockDataToTableData tt=0x501 fidPointInstance:" + n2 + " deviceType:" + by + " not in valid 1-4 range, so no point entry will be created");
                                return;
                            }
                            pointConfig.setDeviceType(by);
                            byte by2 = 0;
                            by2 = by == 4 ? CcnRspFidUtil.getSensedPulsed(ccnResponseMessageArray[n9 - 1]) : CcnRspFidUtil.getCtrlSensType(ccnResponseMessageArray[n9 - 1]);
                            pointConfig.setCtrlSensType(by2);
                            String string2 = CcnRspFidUtil.getEUC(by, by2);
                            pointEntry.setLoLimit(CcnRspFidUtil.getLoLimit(by, by2));
                            pointEntry.setHiLimit(CcnRspFidUtil.getHiLimit(by, by2));
                            int n10 = CcnRspFidUtil.getUnitsIndex(ccnResponseMessageArray[n9 - 1]);
                            if (string2 == null || string2.length() < 1) {
                                ccnMessageLog.trace("\n****  convertBlockDataToTableData tt=0x501 fidPointInstance:" + n2 + " euc:" + string2 + " not valid euc, so no point entry will be created");
                                return;
                            }
                            if (by == 2 && n10 != 0) {
                                string2 = "TINC";
                            }
                            pointConfig.setEUC(string2);
                            pointEntry.setEUC(pointConfig.getEUC());
                            if (string2.equals("TPER") || string2.equals("TNUM") || string2.equals("TOFF") || string2.length() <= 1) {
                                pointEntry.setPointDataType(2);
                                pointEntry.setDataTypeEnum(CcnEnumsUtil.setProperDataTypeEnum(2));
                                pointEntry.setDisplayDigits(96);
                            } else {
                                pointEntry.setPointDataType(7);
                                pointEntry.setDataTypeEnum(BCcnDataTypeEnum.make(7).getTag());
                                pointEntry.setDisplayDigits(97);
                            }
                            if (by == 1 || by == 4) {
                                pointEntry.setConfigFlags(-128);
                                if (n10 == 0) {
                                    pointEntry.setDiscreteTextOffset((byte)BCcnDiscreteStateEnum.OnOff_Off.getOrdinal());
                                } else {
                                    pointEntry.setDiscreteTextOffset((byte)n10);
                                }
                            } else if (by == 2 || by == 3) {
                                if (n10 == 0) {
                                    n10 = CcnRspFidUtil.getPointUnits(by, by2);
                                }
                                pointEntry.setUnits(n10);
                                pointEntry.setUnitsEnum(CcnEnumsUtil.setProperUnitsMappingEnum(BCcnUnitMappingEnum.parseId(n10, bCcnDevice.getCcnNetwork().getDisplayMetric())));
                            }
                            pointEntry.setValueBlock(6);
                            pointEntry.setValueBlockOffset((n2 - 1) * 3);
                            pointEntry.setDescription(CcnRspFidUtil.getPointDesc(by, by2));
                        }
                        catch (CcnException ccnException) {
                            ccnMessageLog.error("<CcnCreateTablesRequest: FID table tt=0x501 Point Entry Data ERROR: " + (Object)((Object)ccnException));
                        }
                        if (pointEntry.getLoLimit().trim().length() != 0 && pointEntry.getHiLimit().trim().length() != 0 && pointEntry.getDescription().trim().length() != 0) {
                            bCcnPointEntryArray[0] = pointEntry;
                        }
                        bFidPointConfigArray[0] = pointConfig;
                        break block33;
                    }
                    if (n != 1284) break block36;
                    try {
                        int n11 = 2;
                        int n12 = CcnRspFidUtil.getSetpointType(ccnResponseMessageArray[n11 - 1]);
                        ((BCcnFidTable)bCcnTable).setSetpointType(n12);
                        int n13 = 0;
                        while (n13 < 4) {
                            pointEntry = new BCcnPointEntry();
                            pointEntry.setFieldIndex(n13);
                            String string = "SS" + CcnRspFidUtil.get2DigString(n13 + 2);
                            pointEntry.setFieldName(string);
                            pointEntry.setPointDataType(1);
                            pointEntry.setDataTypeEnum(BCcnDataTypeEnum.make(1).getTag());
                            pointEntry.setDisplayType(bCcnDevice.getCcnNetwork().getDisplayMetric());
                            pointEntry.setFieldByteCount(1);
                            pointEntry.setDisplayDigits(97);
                            int n14 = CcnRspFidUtil.getSetpointUnits(n12);
                            pointEntry.setUnits(n14);
                            pointEntry.setUnitsEnum(CcnEnumsUtil.setProperUnitsMappingEnum(BCcnUnitMappingEnum.parseId(n14, bCcnDevice.getCcnNetwork().getDisplayMetric())));
                            pointEntry.setPointValue(CcnRspFidUtil.getValue(ccnResponseMessageArray[n11 - 1], pointEntry));
                            pointEntry.setValueBlock(2);
                            pointEntry.setValueBlockOffset(n13);
                            pointEntry.setLoLimit(CcnRspFidUtil.getSetPointLoLimit(n12));
                            pointEntry.setHiLimit(CcnRspFidUtil.getSetPointHiLimit(n12));
                            pointEntry.setDescription(CcnRspFidUtil.getSetPointDesc(n13));
                            bCcnPointEntryArray[n13] = pointEntry;
                            ++n13;
                        }
                        break block33;
                    }
                    catch (CcnException ccnException) {
                        ccnMessageLog.error("<CcnCreateTablesRequest: FID table tt=0x504 Point Entry Data ERROR: " + (Object)((Object)ccnException));
                    }
                    break block33;
                }
                if (n != 1283) break block37;
                try {
                    int n15 = 2;
                    int n16 = 0;
                    while (n16 < 7) {
                        bCcnPointEntryArray[n16 * 3].setPointValue(CcnRspFidUtil.getPeriodOccTime(ccnResponseMessageArray[n15 - 1], n16 + 1));
                        bCcnPointEntryArray[n16 * 3 + 1].setPointValue(CcnRspFidUtil.getPeriodUnoccTime(ccnResponseMessageArray[n15 - 1], n16 + 1));
                        bCcnPointEntryArray[n16 * 3 + 2].setPointValue(CcnRspFidUtil.getDaysFlags(ccnResponseMessageArray[n15 - 1], n16 + 1));
                        ++n16;
                    }
                    break block33;
                }
                catch (CcnException ccnException) {
                    ccnMessageLog.error("<CcnCreateTablesRequest: FID table tt=0x504 Point Entry Data ERROR: " + (Object)((Object)ccnException));
                }
                break block33;
            }
            if (n != 1285) break block33;
            try {
                int n17 = 2;
                int n18 = 0;
                while (n18 < 30) {
                    bCcnPointEntryArray[n18 * 2].setPointValue(CcnRspFidUtil.getHolidayMonth(ccnResponseMessageArray[n17 - 1], n18 + 1));
                    bCcnPointEntryArray[n18 * 2 + 1].setPointValue(CcnRspFidUtil.getHolidayDay(ccnResponseMessageArray[n17 - 1], n18 + 1));
                    ++n18;
                }
            }
            catch (CcnException ccnException) {
                ccnMessageLog.error("<CcnCreateTablesRequest: FID table tt=0x505 Point Entry Data ERROR: " + (Object)((Object)ccnException));
            }
        }
    }

    public static int getBlock_2_3_4_Data(BCcnDevice bCcnDevice, BCcnPointEntry bCcnPointEntry, int n, int n2, CcnResponseMessage ccnResponseMessage, int n3) {
        if (16 <= n && n <= 24) {
            if (ccnResponseMessage == null || ccnResponseMessage.getResponseCommand() != 6) {
                return -1;
            }
            int n4 = ccnResponseMessage.getBlockLen() - 3;
            if (n3 + 12 <= n4) {
                bCcnPointEntry.setFieldIndex(n2);
                try {
                    bCcnPointEntry.setFieldName(CcnRspPicPocUtil.getFieldName(ccnResponseMessage, n2).trim());
                    byte by = CcnRspPicPocUtil.getDataType(ccnResponseMessage, n2);
                    bCcnPointEntry.setPointDataType(by);
                    bCcnPointEntry.setDataTypeEnum(CcnEnumsUtil.setProperDataTypeEnum(by));
                    bCcnPointEntry.setDisplayType(bCcnDevice.getCcnNetwork().getDisplayMetric());
                    bCcnPointEntry.setFieldByteCount(CcnRspPicPocUtil.getFieldByteCount(ccnResponseMessage, by, n2));
                    byte by2 = CcnRspPicPocUtil.getConfigFlags(ccnResponseMessage, n2);
                    bCcnPointEntry.setConfigFlags(by2);
                    if ((by2 & 0x80) != 0) {
                        bCcnPointEntry.setDiscreteTextOffset(CcnRspPicPocUtil.getDiscreteTextOffset(ccnResponseMessage, n2));
                        bCcnPointEntry.setDisplayDigits(16);
                    } else if (by == 0 || by == 1 || by == 2 || by == 6 || by == 7 || by == 9 || by == 10 || by == 19 || by == 30 || by == 31 || by == 32) {
                        bCcnPointEntry.setDisplayDigits(CcnRspPicPocUtil.getDisplayDigits(ccnResponseMessage, by, n2));
                    }
                    bCcnPointEntry.setUnits(CcnRspPicPocUtil.getUnits(ccnResponseMessage, n2));
                    bCcnPointEntry.setUnitsEnum(CcnEnumsUtil.setProperUnitsMappingEnum(BCcnUnitMappingEnum.parseId(CcnRspPicPocUtil.getUnits(ccnResponseMessage, n2), bCcnDevice.getCcnNetwork().getDisplayMetric())));
                }
                catch (CcnException ccnException) {
                    ccnMessageLog.error("<CcnCreateTablesRequest: Pic or Poc table getBlock_2_3_4_Data ERROR: " + (Object)((Object)ccnException));
                }
                return n3 += 12;
            }
        }
        return -1;
    }

    public static int getBlock_5_Data(BCcnPointEntry bCcnPointEntry, int n, int n2, CcnResponseMessage ccnResponseMessage, int n3, int n4) {
        if (16 <= n && n <= 19 || n == 23) {
            if (ccnResponseMessage == null || ccnResponseMessage.getResponseCommand() != 6) {
                return -1;
            }
            int n5 = ccnResponseMessage.getBlockLen() - 3;
            int n6 = bCcnPointEntry.getFieldByteCount();
            if (n3 + n6 <= n5) {
                try {
                    bCcnPointEntry.setPointValue(CcnRspPicUtil.getValue(ccnResponseMessage, n3, bCcnPointEntry).trim());
                    bCcnPointEntry.setValueBlock((byte)n4);
                    bCcnPointEntry.setValueBlockOffset(n3);
                }
                catch (CcnException ccnException) {
                    ccnMessageLog.error("<CcnCreateTablesRequest: Pic table getBlock_5_Data ERROR: " + (Object)((Object)ccnException));
                }
                return n3 += n6;
            }
        }
        return -1;
    }

    public static int getBlock_6_Data(BCcnTable bCcnTable, int n, int n2, CcnResponseMessage ccnResponseMessage, int n3) {
        int n4;
        if (bCcnTable instanceof BCcnPicTable) {
            ccnPicTable = (BCcnPicTable)bCcnTable;
        }
        if (bCcnTable instanceof BCcnPocTable) {
            ccnPocTable = (BCcnPocTable)bCcnTable;
        }
        if (17 == n || n == 18) {
            if (ccnResponseMessage == null || ccnResponseMessage.getResponseCommand() != 6) {
                return -1;
            }
            n4 = ccnResponseMessage.getBlockLen() - 3;
            if (n3 + 1 <= n4) {
                try {
                    byte by = CcnRspPicUtil.getStatus(ccnResponseMessage, n2);
                    int n5 = by & 7;
                    if (pointEntry.isDiscrete() && n5 == 3) {
                        n5 += 2;
                    }
                    int n6 = by >> 4 & 0xF;
                    if (n5 >= 0 && n5 <= 5) {
                        pointEntry.setAlrmStatus(BCcnAlarmStatusEnum.make(n5));
                    }
                    pointEntry.setForceLevel(BCcnForceStatusEnum.make(n6));
                }
                catch (CcnException ccnException) {
                    ccnMessageLog.error("<CcnCreateTablesRequest: Pic table getBlock_6_Data ERROR: " + (Object)((Object)ccnException));
                }
                return ++n3;
            }
        }
        if (20 <= n && n <= 22 || n == 24) {
            if (ccnResponseMessage == null || ccnResponseMessage.getResponseCommand() != 6) {
                return -1;
            }
            n4 = ccnResponseMessage.getBlockLen() - 3;
            if (n3 + 1 <= n4) {
                try {
                    ccnPocTable.setDataTableType(CcnRspPocUtil.getDataTableType(ccnResponseMessage));
                    int n7 = CcnRspPocUtil.getDataTableBlock(ccnResponseMessage);
                    ccnPocTable.setDataTableBlock(n7);
                    pointEntry.setValueBlock((byte)(n7 & 0xFF));
                    if (n7 == 255) {
                        ccnPocTable.setDataTableStartBlock(CcnRspPocUtil.getDataTableStrBlock(ccnResponseMessage));
                        ccnPocTable.setDataTableEndBlock(CcnRspPocUtil.getDataTableEndBlock(ccnResponseMessage));
                    }
                }
                catch (CcnException ccnException) {
                    ccnMessageLog.error("<CcnCreateTablesRequest: Poc table getBlock_6_Data ERROR: " + (Object)((Object)ccnException));
                }
                return ++n3;
            }
        }
        return -1;
    }

    public static int getFieldLimits(int n, int n2, CcnResponseMessage ccnResponseMessage, int n3, int n4) {
        if (ccnResponseMessage == null || ccnResponseMessage.getResponseCommand() != 6) {
            return -1;
        }
        int n5 = ccnResponseMessage.getBlockLen() - 3;
        int n6 = pointEntry.getConfigFlags();
        int n7 = pointEntry.getPointDataType();
        int n8 = pointEntry.getFieldByteCount();
        boolean bl = false;
        boolean bl2 = false;
        if ((n6 & 1) != 0) {
            bl = true;
        }
        if ((n6 & 2) != 0) {
            bl2 = true;
        }
        if (16 <= n && n <= 24) {
            if (!bl && !bl2) {
                if (n7 == 0) {
                    pointEntry.setLoLimit(new String("0"));
                    pointEntry.setHiLimit(new String("255"));
                } else if (n7 == 1 || n7 == 25 || n7 == 49 || n7 == 50) {
                    pointEntry.setLoLimit(new String("0"));
                    pointEntry.setHiLimit(new String("255"));
                } else if (n7 == 2) {
                    pointEntry.setLoLimit(new String("0"));
                    pointEntry.setHiLimit(new String("65535"));
                } else if (n7 == 7 || n7 == 48) {
                    pointEntry.setLoLimit(new String("0"));
                    pointEntry.setHiLimit(new String("999999.99"));
                } else if (n7 == 9) {
                    pointEntry.setLoLimit(new String("-128"));
                    pointEntry.setHiLimit(new String("127"));
                } else if (n7 == 10) {
                    pointEntry.setLoLimit(new String("-32768"));
                    pointEntry.setHiLimit(new String("32767"));
                }
            }
            if (bl) {
                if (n3 + n8 <= n5) {
                    try {
                        pointEntry.setLoLimit(CcnRspPicPocUtil.getLimit(ccnResponseMessage, n3, pointEntry).trim());
                        pointEntry.setLoLimitBlock((byte)n4);
                        pointEntry.setLoLimitBlockOffset(n3);
                    }
                    catch (CcnException ccnException) {
                        ccnMessageLog.error("<CcnCreateTablesRequest: Pic or Poc table getFieldLimits - lo ERROR: " + (Object)((Object)ccnException));
                    }
                    n3 += n8;
                }
                if (bl2) {
                    if (n3 + n8 <= n5) {
                        try {
                            pointEntry.setHiLimit(CcnRspPicPocUtil.getLimit(ccnResponseMessage, n3, pointEntry).trim());
                            pointEntry.setHiLimitBlock((byte)n4);
                            pointEntry.setHiLimitBlockOffset(n3);
                        }
                        catch (CcnException ccnException) {
                            ccnMessageLog.error("<CcnCreateTablesRequest: Pic or Poc table getFieldLimits - hi ERROR: " + (Object)((Object)ccnException));
                        }
                        n3 += n8;
                    }
                } else if (n7 == 0) {
                    pointEntry.setHiLimit(new String("255"));
                } else if (n7 == 1 || n7 == 25 || n7 == 49 || n7 == 50) {
                    pointEntry.setHiLimit(new String("255"));
                } else if (n7 == 2) {
                    pointEntry.setHiLimit(new String("65535"));
                } else if (n7 == 7 || n7 == 48) {
                    pointEntry.setHiLimit(new String("999999.99"));
                } else if (n7 == 9) {
                    pointEntry.setHiLimit(new String("127"));
                } else if (n7 == 10) {
                    pointEntry.setHiLimit(new String("32767"));
                }
            } else {
                if (n7 == 1 || n7 == 25 || n7 == 49 || n7 == 50 || n7 == 2 || n7 == 7 || n7 == 48 || n7 == 9 || n7 == 10 || n7 == 0) {
                    pointEntry.setLoLimit(new String("0"));
                }
                if (bl2 && n3 + n8 <= n5) {
                    try {
                        pointEntry.setHiLimit(CcnRspPicPocUtil.getLimit(ccnResponseMessage, n3, pointEntry).trim());
                        pointEntry.setHiLimitBlock((byte)n4);
                        pointEntry.setHiLimitBlockOffset(n3);
                    }
                    catch (CcnException ccnException) {
                        ccnMessageLog.error("<CcnCreateTablesRequest: Pic or Poc table getFieldLimits - hi ERROR: " + (Object)((Object)ccnException));
                    }
                    n3 += n8;
                }
            }
            return n3;
        }
        return -1;
    }

    public static int getFieldVariableNo(int n, int n2, CcnResponseMessage ccnResponseMessage, int n3) {
        if (17 == n || n == 18) {
            if (ccnResponseMessage == null || ccnResponseMessage.getResponseCommand() != 6) {
                return -1;
            }
            int n4 = ccnResponseMessage.getBlockLen() - 3;
            if (n3 + 2 <= n4) {
                try {
                    int n5 = CcnRspPicUtil.getVariableNum(ccnResponseMessage, n2);
                    pointEntry.setVariableNo(n5);
                    if (n5 != 0 && (pointEntry.getConfigFlags() & 2) != 0) {
                        pointEntry.setForceableFlag(true);
                    }
                }
                catch (CcnException ccnException) {
                    ccnMessageLog.error("<CcnCreateTablesRequest: Poc table getFieldVariableNo ERROR: " + (Object)((Object)ccnException));
                }
                return n3 += 2;
            }
        }
        return -1;
    }

    public static int getFieldDescription(int n, int n2, CcnResponseMessage ccnResponseMessage, int n3) {
        if (ccnResponseMessage == null || ccnResponseMessage.getResponseCommand() != 6) {
            return -1;
        }
        int n4 = ccnResponseMessage.getBlockLen() - 3;
        if (n3 + 24 <= n4 && 16 <= n && n <= 24) {
            try {
                pointEntry.setDescription(CcnRspPicPocUtil.getDescription(ccnResponseMessage, n2).trim());
            }
            catch (CcnException ccnException) {
                ccnMessageLog.error("<CcnCreateTablesRequest: Pic or Poc table getFieldDescription ERROR: " + (Object)((Object)ccnException));
            }
            return n3 += 24;
        }
        return -1;
    }

    public static CcnResponseMessage interrogateDataTableForPointData(BCcnDevice bCcnDevice, int n, int n2, int n3) {
        bCcnDevice.getCcnNetwork().setDiscoveryInProgress(true);
        CcnResponseMessage ccnResponseMessage = new CcnResponseMessage();
        ccnMessageLog.trace("\n****  CcnCreateDataTablesRequest... pocTable: " + bCcnDevice.getBusNo() + ',' + bCcnDevice.getElemNo() + " for table= " + n + ',' + n2 + " curBlock= " + n3);
        ccnResponseMessage = CcnUtil.getBlockDataFromDeviceDataTable(bCcnDevice, n, n2, n3);
        if (ccnResponseMessage != null) {
            ccnMessageLog.trace("\n****  CcnCreateDataTablesRequest... interrogateTableForPointData return: " + ccnResponseMessage.getBlockLen());
        }
        return ccnResponseMessage;
    }

    public static CcnResponseMessage getBlockDataFromDeviceDataTable(BCcnDevice bCcnDevice, int n, int n2, int n3) {
        CcnResponseMessage ccnResponseMessage = null;
        int n4 = bCcnDevice.getBusNo();
        int n5 = bCcnDevice.getElemNo();
        BCcnNetwork bCcnNetwork = bCcnDevice.getCcnNetwork();
        int n6 = 0;
        while (n6 < 3) {
            CcnReadTableRequest ccnReadTableRequest = new CcnReadTableRequest(new CcnTableDef((byte)n5, (byte)n4, null, (short)n, (byte)n2, (byte)n3, 0, 0));
            ccnResponseMessage = bCcnNetwork.getCcnComm().ccnAsyncRequest().sendAsyncRequest(ccnReadTableRequest);
            if (ccnResponseMessage != null) break;
            ++n6;
        }
        if (ccnResponseMessage != null) {
            ccnMessageLog.trace("\n****  CcnCreateDataTablesRequest... return from block read, device: " + n4 + ',' + n5 + " for table= " + n + ',' + n2 + " curBlock= " + n3 + " blockLen= " + ccnResponseMessage.getBlockLen());
            return ccnResponseMessage;
        }
        return null;
    }

    public static Vector convertBlockDataToDataTableData(Vector vector, BCcnPocTable bCcnPocTable, BCcnDevice bCcnDevice, BCcnPointEntry[] bCcnPointEntryArray, int n, CcnResponseMessage ccnResponseMessage, int n2) {
        int n3 = bCcnPointEntryArray.length;
        int n4 = 0;
        ccnMessageLog.trace("\n****  CcnCreateDataTablesRequest... start convertBlockDataToTableData: " + n + '|' + n3);
        BFolder bFolder = bCcnPocTable.getLearnedSplPoints();
        Class clazz = class$com$tridium$ccn$components$BCcnPointEntry;
        if (clazz == null) {
            clazz = class$com$tridium$ccn$components$BCcnPointEntry = CcnUtil.class("[Lcom.tridium.ccn.components.BCcnPointEntry;", false);
        }
        BCcnPointEntry[] bCcnPointEntryArray2 = (BCcnPointEntry[])bFolder.getChildren(clazz);
        int n5 = 0;
        while (n5 < n3) {
            pointEntry = new BCcnPointEntry(bCcnPointEntryArray2[n5]);
            pointEntry.setValueBlock((byte)n2);
            int n6 = CcnUtil.getDataBlock_Data(n, n3, pointEntry, ccnResponseMessage, n4);
            if (n6 == -1) break;
            n4 = n6;
            vector.addElement(pointEntry);
            ++n5;
        }
        return vector;
    }

    public static int getDataBlock_Data(int n, int n2, BCcnPointEntry bCcnPointEntry, CcnResponseMessage ccnResponseMessage, int n3) {
        if (ccnResponseMessage == null || ccnResponseMessage.getResponseCommand() != 6) {
            return -1;
        }
        int n4 = ccnResponseMessage.getBlockLen() - 3;
        int n5 = bCcnPointEntry.getFieldByteCount();
        if (n3 + n5 <= n4) {
            try {
                bCcnPointEntry.setPointValue(CcnRspDataUtil.getValue(ccnResponseMessage, n3, bCcnPointEntry));
                bCcnPointEntry.setValueBlockOffset(n3);
            }
            catch (CcnException ccnException) {
                ccnMessageLog.error("<CcnCreateDataTablesRequest: Data table getDataBlock_Data ERROR: " + (Object)((Object)ccnException));
            }
            return n3 += n5;
        }
        return -1;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        ccnMessageLog = Log.getLog((String)"CCNMessagesLog");
    }
}

