/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.util;

import com.tridium.ccn.enums.BCcnTableGroupTypeEnum;
import com.tridium.ccn.exceptions.CcnException;
import com.tridium.ccn.messages.CcnMessageConst;
import com.tridium.ccn.messages.CcnResponseMessage;
import com.tridium.ccn.util.CcnErrorCodes;

public abstract class CcnRspTableUtil
implements CcnErrorCodes,
CcnMessageConst {
    protected static final int BLOCK_NO_LOCATION = 2;
    protected static final int TBL_NBR_HI = 0;
    protected static final int TBL_NBR_LO = 1;
    protected static final int REJECT_STATUS_LOCATION = 0;

    public static int parseTableNo(CcnResponseMessage ccnResponseMessage) throws CcnException {
        if (ccnResponseMessage.getResponseBuffer().getResponseCommand() == 6) {
            byte[] byArray = ccnResponseMessage.getResponseBuffer().getResponseData();
            int n = ((byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF) & (char)-1;
            return n;
        }
        throw new CcnException(0x630066, "Cannot parse table number because the read block reply was not an ACK (command 6)");
    }

    public static int parseBlockNo(CcnResponseMessage ccnResponseMessage) {
        return ccnResponseMessage.getResponseBuffer().getResponseData()[2];
    }

    public static int parseRejectStatus(CcnResponseMessage ccnResponseMessage) throws CcnException {
        if (ccnResponseMessage.getResponseBuffer().getResponseCommand() == 21) {
            return ccnResponseMessage.getResponseBuffer().getResponseData()[0];
        }
        throw new CcnException(0x630066, "Cannot parse rejection status because the read block reply was not a rejection notice (command 15)");
    }

    public static int getTableType(CcnResponseMessage ccnResponseMessage) throws CcnException {
        int n = ccnResponseMessage.getTableType();
        int n2 = CcnRspTableUtil.parseBlockNo(ccnResponseMessage);
        if (n2 == 1) {
            byte[] byArray = ccnResponseMessage.getResponseBuffer().getResponseData();
            int n3 = ((byArray[3] & 0xFF) << 8 | byArray[4] & 0xFF) & (char)-1;
            if (n3 == n) {
                return n3;
            }
            throw new CcnException(6488169, "Response tableType does not match request tableType");
        }
        throw new CcnException(6488167, "Need block 1 to getTableType");
    }

    public static String getTableName(CcnResponseMessage ccnResponseMessage) throws CcnException {
        int n = CcnRspTableUtil.parseBlockNo(ccnResponseMessage);
        if (n == 1) {
            byte[] byArray = ccnResponseMessage.getResponseBuffer().getResponseData();
            return new String(CcnRspTableUtil.getSubByteArray(byArray, 5, 8));
        }
        throw new CcnException(6488167, "Need block 1 to getTableName");
    }

    public static String getFIDTableName(CcnResponseMessage ccnResponseMessage) throws CcnException {
        int n = CcnRspTableUtil.parseBlockNo(ccnResponseMessage);
        if (n == 1) {
            byte[] byArray = ccnResponseMessage.getResponseBuffer().getResponseData();
            return new String(CcnRspTableUtil.getSubByteArray(byArray, 3, 8));
        }
        throw new CcnException(6488167, "Need block 1 to getTableName");
    }

    public static byte getBlockCount(CcnResponseMessage ccnResponseMessage) throws CcnException {
        int n = CcnRspTableUtil.parseBlockNo(ccnResponseMessage);
        if (n == 1) {
            byte[] byArray = ccnResponseMessage.getResponseBuffer().getResponseData();
            return byArray[15];
        }
        throw new CcnException(6488167, "Need block 1 to getBlockCount");
    }

    public static byte getBlockAccessRights(CcnResponseMessage ccnResponseMessage, int n) throws CcnException {
        int n2 = CcnRspTableUtil.parseBlockNo(ccnResponseMessage);
        if (n2 == 1) {
            byte[] byArray = ccnResponseMessage.getResponseBuffer().getResponseData();
            return byArray[16 + 2 * (n - 1) + 1];
        }
        throw new CcnException(6488167, "Need block 1 to getBlockAccessRights");
    }

    public static int getPointCount(CcnResponseMessage ccnResponseMessage) throws CcnException {
        int n = CcnRspTableUtil.parseBlockNo(ccnResponseMessage);
        if (n == 1) {
            byte[] byArray = ccnResponseMessage.getResponseBuffer().getResponseData();
            int n2 = byArray[18] & 0xFF;
            int n3 = byArray[20] & 0xFF;
            int n4 = byArray[22] & 0xFF;
            return (n2 + n3 + n4) / 12;
        }
        throw new CcnException(6488167, "Need block 1 to getPointCount");
    }

    protected static byte[] getSubByteArray(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        int n3 = 0;
        while (n3 < n2) {
            byArray2[n3] = byArray[n3 + n];
            ++n3;
        }
        return byArray2;
    }

    public static boolean compareFloatValues(float f, float f2) {
        float f3 = Math.abs(f - f2);
        if (f3 < 1.0f) {
            return true;
        }
        float f4 = (f + f2) / 200.0f;
        return f3 <= f4;
    }

    public static String getTableTypeString(int n) {
        if (n == 1281) {
            return BCcnTableGroupTypeEnum.StatusDisplay.getTag();
        }
        if (n == 1284) {
            return BCcnTableGroupTypeEnum.SetPoints.getTag();
        }
        if (n == 1283) {
            return BCcnTableGroupTypeEnum.TimeSchedules.getTag();
        }
        if (n == 1285) {
            return BCcnTableGroupTypeEnum.Holiday.getTag();
        }
        return BCcnTableGroupTypeEnum.Generic.getTag();
    }

    protected static boolean isTableType(int n, int[] nArray) {
        int n2 = 0;
        while (n2 < nArray.length) {
            if (n == nArray[n2]) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected static void checkTableType(int n, int[] nArray) throws CcnException {
        int n2 = 0;
        while (n2 < nArray.length) {
            if (n == nArray[n2]) {
                return;
            }
            ++n2;
        }
        new CcnException(6488168, "Unexpected tableType is " + n + " expectedTableTypes are " + nArray);
    }
}

