/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.util;

import com.tridium.ccn.exceptions.CcnException;
import com.tridium.ccn.messages.CcnResponseMessage;
import com.tridium.ccn.util.CcnErrorCodes;
import com.tridium.ccn.util.CcnRspPicPocUtil;

public abstract class CcnRspPocUtil
extends CcnRspPicPocUtil
implements CcnErrorCodes {
    public static int[] EXPECTED_POC_TBL_TYPES = new int[]{14, 15, 16, 18};

    public static byte[] convertTimeToByte(String string) {
        byte[] byArray = new byte[]{-1, -1};
        int n = string.indexOf(":");
        if (n == -1) {
            return byArray;
        }
        byte by = new Byte(string.substring(0, n));
        byte by2 = new Byte(string.substring(n + 1));
        if ((by > 59 || by < 0 || by2 > 23 || by2 < 0) && n == -1) {
            return byArray;
        }
        byArray[0] = by;
        byArray[1] = by2;
        return byArray;
    }

    public static int getDataTableType(CcnResponseMessage ccnResponseMessage) throws CcnException {
        CcnRspPocUtil.checkTableType(ccnResponseMessage.getTableType(), EXPECTED_POC_TBL_TYPES);
        int n = CcnRspPocUtil.parseBlockNo(ccnResponseMessage);
        if (6 == n) {
            byte[] byArray = ccnResponseMessage.getResponseBuffer().getResponseData();
            return ((byArray[3] & 0xFF) << 8 | byArray[4] & 0xFF) & (char)-1;
        }
        throw new CcnException(6488167, "PocTable - Need block 6 to getDataTableType");
    }

    public static int getDataTableBlock(CcnResponseMessage ccnResponseMessage) throws CcnException {
        CcnRspPocUtil.checkTableType(ccnResponseMessage.getTableType(), EXPECTED_POC_TBL_TYPES);
        int n = CcnRspPocUtil.parseBlockNo(ccnResponseMessage);
        if (6 == n) {
            byte[] byArray = ccnResponseMessage.getResponseBuffer().getResponseData();
            return byArray[5] & 0xFF;
        }
        throw new CcnException(6488167, "PocTable - Need block 6 to getDataTableBlock");
    }

    public static int getDataTableStrBlock(CcnResponseMessage ccnResponseMessage) throws CcnException {
        CcnRspPocUtil.checkTableType(ccnResponseMessage.getTableType(), EXPECTED_POC_TBL_TYPES);
        int n = CcnRspPocUtil.parseBlockNo(ccnResponseMessage);
        if (6 == n) {
            byte[] byArray = ccnResponseMessage.getResponseBuffer().getResponseData();
            return byArray[8] & 0xFF;
        }
        throw new CcnException(6488167, "PocTable - Need block 6 to getDataTableBlock");
    }

    public static int getDataTableEndBlock(CcnResponseMessage ccnResponseMessage) throws CcnException {
        CcnRspPocUtil.checkTableType(ccnResponseMessage.getTableType(), EXPECTED_POC_TBL_TYPES);
        int n = CcnRspPocUtil.parseBlockNo(ccnResponseMessage);
        if (6 == n) {
            byte[] byArray = ccnResponseMessage.getResponseBuffer().getResponseData();
            return byArray[9] & 0xFF;
        }
        throw new CcnException(6488167, "PocTable - Need block 6 to getDataTableBlock");
    }
}

