/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.util;

import com.tridium.ccn.components.BCcnPointEntry;
import com.tridium.ccn.enums.BCcnAlarmStatusEnum;
import com.tridium.ccn.enums.BCcnForceStatusEnum;
import com.tridium.ccn.exceptions.CcnException;
import com.tridium.ccn.messages.CcnResponseMessage;
import com.tridium.ccn.point.BCcnInputProxy;
import com.tridium.ccn.point.BCcnProxyExt;
import com.tridium.ccn.util.CcnEnumsUtil;
import com.tridium.ccn.util.CcnErrorCodes;
import com.tridium.ccn.util.CcnRspPicPocUtil;

public final class CcnRspPicUtil
extends CcnRspPicPocUtil
implements CcnErrorCodes {
    public static int[] EXPECTED_PIC_TBL_TYPES = new int[]{16, 17, 18, 19, 23};

    public static final void setProxyReadStatus(byte by, BCcnProxyExt bCcnProxyExt) {
        int n = by & 7;
        if (bCcnProxyExt instanceof BCcnInputProxy) {
            BCcnInputProxy bCcnInputProxy = (BCcnInputProxy)bCcnProxyExt;
            if (bCcnInputProxy.isDiscrete() && n == 3) {
                n += 2;
            }
            if (n > 5) {
                n = 0;
            }
            BCcnAlarmStatusEnum bCcnAlarmStatusEnum = BCcnAlarmStatusEnum.make(n);
            int n2 = by >> 4 & 0xF;
            BCcnForceStatusEnum bCcnForceStatusEnum = BCcnForceStatusEnum.make(n2);
            bCcnInputProxy.setForceLevel(CcnEnumsUtil.setProperForceLevel(bCcnForceStatusEnum.getTag()));
            if (n2 == 4) {
                bCcnInputProxy.setOverridden(true);
            } else {
                bCcnInputProxy.setOverridden(false);
            }
            String string = bCcnAlarmStatusEnum.getTag().equalsIgnoreCase("normal") ? "" : (bCcnAlarmStatusEnum.getTag().equalsIgnoreCase("HardwareCommError") ? "COMM..." : bCcnAlarmStatusEnum.getTag());
            bCcnInputProxy.setFieldStatus(string);
        }
    }

    public static final void setProxyReadValue(CcnResponseMessage ccnResponseMessage, int n, BCcnProxyExt bCcnProxyExt) {
        int n2;
        if (CcnRspPicUtil.isTableType(ccnResponseMessage.getTableType(), EXPECTED_PIC_TBL_TYPES) && bCcnProxyExt instanceof BCcnInputProxy && 5 == (n2 = CcnRspPicUtil.parseBlockNo(ccnResponseMessage))) {
            byte[] byArray = ccnResponseMessage.getResponseBuffer().getResponseData();
            String string = CcnRspPicUtil.getNextValue(byArray, n, bCcnProxyExt);
            ((BCcnInputProxy)bCcnProxyExt).setValue(string);
        }
    }

    public static final String getValue(CcnResponseMessage ccnResponseMessage, int n, BCcnProxyExt bCcnProxyExt) throws CcnException {
        CcnRspPicUtil.checkTableType(ccnResponseMessage.getTableType(), EXPECTED_PIC_TBL_TYPES);
        int n2 = CcnRspPicUtil.parseBlockNo(ccnResponseMessage);
        if (5 == n2) {
            byte[] byArray = ccnResponseMessage.getResponseBuffer().getResponseData();
            return CcnRspPicUtil.getNextValue(byArray, n, bCcnProxyExt);
        }
        throw new CcnException(6488167, "PicTable - Need block 5 to getValue");
    }

    public static final String getValue(CcnResponseMessage ccnResponseMessage, int n, BCcnPointEntry bCcnPointEntry) throws CcnException {
        CcnRspPicUtil.checkTableType(ccnResponseMessage.getTableType(), EXPECTED_PIC_TBL_TYPES);
        int n2 = CcnRspPicUtil.parseBlockNo(ccnResponseMessage);
        if (5 == n2) {
            byte[] byArray = ccnResponseMessage.getResponseBuffer().getResponseData();
            return CcnRspPicUtil.getNextValue(byArray, n, bCcnPointEntry);
        }
        throw new CcnException(6488167, "PicTable - Need block 5 to getValue");
    }

    public static final void setStatus(CcnResponseMessage ccnResponseMessage, BCcnProxyExt bCcnProxyExt) throws CcnException {
        if (ccnResponseMessage != null && ccnResponseMessage.getResponseBuffer() != null && ccnResponseMessage.getResponseBuffer().getResponseData() != null) {
            CcnRspPicUtil.checkTableType(ccnResponseMessage.getTableType(), EXPECTED_PIC_TBL_TYPES);
            int n = CcnRspPicUtil.parseBlockNo(ccnResponseMessage);
            if (6 == n) {
                byte[] byArray = ccnResponseMessage.getResponseBuffer().getResponseData();
                CcnRspPicUtil.setProxyReadStatus(byArray[3 + bCcnProxyExt.getFieldIndex()], bCcnProxyExt);
            }
        }
    }

    public static final byte getStatus(CcnResponseMessage ccnResponseMessage, int n) throws CcnException {
        CcnRspPicUtil.checkTableType(ccnResponseMessage.getTableType(), EXPECTED_PIC_TBL_TYPES);
        int n2 = CcnRspPicUtil.parseBlockNo(ccnResponseMessage);
        if (6 == n2) {
            byte[] byArray = ccnResponseMessage.getResponseBuffer().getResponseData();
            return byArray[3 + n];
        }
        throw new CcnException(6488167, "PicTable - Need block 6 to getStatus");
    }

    public static final int getVariableNum(CcnResponseMessage ccnResponseMessage, int n) throws CcnException {
        CcnRspPicUtil.checkTableType(ccnResponseMessage.getTableType(), EXPECTED_PIC_TBL_TYPES);
        int n2 = CcnRspPicUtil.parseBlockNo(ccnResponseMessage);
        if (9 == n2) {
            byte[] byArray = ccnResponseMessage.getResponseBuffer().getResponseData();
            return ((byArray[3 + n * 2] & 0xFF) << 8 | byArray[3 + n * 2 + 1] & 0xFF) & (char)-1;
        }
        throw new CcnException(6488167, "PicTable - Need block 9 to getVariableNum");
    }
}

