/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.util;

import com.tridium.ccn.components.BCcnPointEntry;
import com.tridium.ccn.components.BCcnTime;
import com.tridium.ccn.components.BCcnTimeScheduleEntry;
import com.tridium.ccn.components.BCcnTimeScheduleList;
import com.tridium.ccn.exceptions.CcnException;
import com.tridium.ccn.messages.CcnResponseMessage;
import com.tridium.ccn.point.BCcnProxyExt;
import com.tridium.ccn.util.BFidIOPointTypeEntry;
import com.tridium.ccn.util.CcnErrorCodes;
import com.tridium.ccn.util.CcnRspTableUtil;
import com.tridium.ccn.util.FidIOPointTypes;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public final class CcnRspFidUtil
extends CcnRspTableUtil
implements CcnErrorCodes {
    public static int[] GLOBAL_TABLE = new int[]{1280};
    public static int[] CHANNEL_IO_TABLE = new int[]{1281};
    public static int[] SETPOINT_SCHEDULE_TABLE = new int[]{1284};
    public static int[] TIME_SCHEDULE_TABLE = new int[]{1283};
    public static int[] HOLIDAY_TABLE = new int[]{1285};

    public static final byte getForceLevel(CcnResponseMessage ccnResponseMessage, int n) throws CcnException {
        CcnRspFidUtil.checkTableType(ccnResponseMessage.getTableType(), GLOBAL_TABLE);
        int n2 = CcnRspFidUtil.parseBlockNo(ccnResponseMessage);
        int n3 = 0;
        if (6 == n2) {
            byte[] byArray = ccnResponseMessage.getResponseBuffer().getResponseData();
            int n4 = byArray[3 + n * 3] & 0xFF;
            if (n4 == 0) {
                n3 = 0;
            } else if ((n4 & 1) != 0) {
                n3 = 4;
            } else if ((n4 & 0x80) != 0) {
                n3 = 8;
            } else if ((n4 & 4) != 0) {
                n3 = 10;
            } else if ((n4 & 0x10) != 0) {
                n3 = 7;
            } else if ((n4 & 2) != 0) {
                n3 = 3;
            } else if ((n4 & 8) != 0) {
                n3 = 5;
            } else if ((n4 & 0x20) != 0) {
                n3 = 6;
            } else if ((n4 & 0x40) != 0) {
                n3 = 9;
            }
        } else {
            throw new CcnException(6488167, "FidTable - Need block 6 to getForceLevel");
        }
        return (byte)n3;
    }

    public static final String getValue(CcnResponseMessage ccnResponseMessage, int n, String string, int n2) throws CcnException {
        int n3;
        Object object;
        float f = 0.0f;
        CcnRspFidUtil.checkTableType(ccnResponseMessage.getTableType(), GLOBAL_TABLE);
        int n4 = CcnRspFidUtil.parseBlockNo(ccnResponseMessage);
        if (6 == n4) {
            object = ccnResponseMessage.getResponseBuffer().getResponseData();
            n3 = object[3 + n * 3 + 1] & 0xFF;
            int n5 = object[3 + n * 3 + 2] >> 4 & 0xF;
            if (string == null || string.length() <= 1) {
                return Integer.toString(n3);
            }
            if (string.equals("TTEM")) {
                f = CcnRspFidUtil.getConversion_TTEM(n3, n5);
            } else if (string.equals("TPER")) {
                f = CcnRspFidUtil.getConversion_TPER(n3);
            } else if (string.equals("TINC")) {
                f = CcnRspFidUtil.getConversion_TINC(n3, n5);
            } else if (string.equals("TMIL")) {
                f = CcnRspFidUtil.getConversion_TMIL(n3, n5);
            } else if (string.equals("TDTM")) {
                f = CcnRspFidUtil.getConversion_TDTM(n3, n5);
            } else if (string.equals("TTMP")) {
                f = CcnRspFidUtil.getConversion_TTMP(n3, n5);
            } else {
                if (string.equals("TNUM")) {
                    return Integer.toString(CcnRspFidUtil.getConversion_TNUM(n3));
                }
                if (string.equals("TVOL")) {
                    f = CcnRspFidUtil.getConversion_TVOL(n3, n5);
                } else if (string.equals("TPSI")) {
                    f = CcnRspFidUtil.getConversion_TPSI(n3, n5);
                } else if (string.equals("TENT")) {
                    f = CcnRspFidUtil.getConversion_TENT(n3, n5);
                } else if (string.equals("TCFM")) {
                    f = CcnRspFidUtil.getConversion_TCFM(n3, n5);
                } else if (string.equals("TOFF")) {
                    return Integer.toString(CcnRspFidUtil.getConversion_TOFF(n3));
                }
            }
        } else {
            throw new CcnException(6488167, "FidTable - Need block 6 to getValue");
        }
        object = NumberFormat.getInstance();
        n3 = n2 & 0xF;
        ((NumberFormat)object).setMaximumFractionDigits(n3);
        ((NumberFormat)object).setMinimumFractionDigits(n3);
        ((DecimalFormat)object).setGroupingSize(20);
        return ((NumberFormat)object).format(f);
    }

    public static final byte getStatus(CcnResponseMessage ccnResponseMessage, int n) throws CcnException {
        CcnRspFidUtil.checkTableType(ccnResponseMessage.getTableType(), GLOBAL_TABLE);
        int n2 = CcnRspFidUtil.parseBlockNo(ccnResponseMessage);
        int n3 = 0;
        if (6 == n2) {
            byte[] byArray = ccnResponseMessage.getResponseBuffer().getResponseData();
            int n4 = byArray[3 + n * 3 + 2] & 0xF;
            if (n4 == 0) {
                n3 = 0;
            } else if ((n4 & 1) != 0) {
                n3 = 1;
            } else if ((n4 & 0x80) != 0) {
                n3 = 2;
            } else if ((n4 & 4) != 0) {
                n3 = 3;
            }
        } else {
            throw new CcnException(6488167, "FidTable - Need block 6 to getStatus");
        }
        return (byte)n3;
    }

    public static final String getPointName(CcnResponseMessage ccnResponseMessage) throws CcnException {
        CcnRspFidUtil.checkTableType(ccnResponseMessage.getTableType(), CHANNEL_IO_TABLE);
        int n = CcnRspFidUtil.parseBlockNo(ccnResponseMessage);
        if (n == 1) {
            byte[] byArray = ccnResponseMessage.getResponseBuffer().getResponseData();
            return new String(CcnRspFidUtil.getSubByteArray(byArray, 3, 8));
        }
        throw new CcnException(6488167, "FidTable - Need block 1 to getPointName");
    }

    public static final boolean getInSystem(CcnResponseMessage ccnResponseMessage) throws CcnException {
        CcnRspFidUtil.checkTableType(ccnResponseMessage.getTableType(), CHANNEL_IO_TABLE);
        int n = CcnRspFidUtil.parseBlockNo(ccnResponseMessage);
        if (n == 2) {
            byte[] byArray = ccnResponseMessage.getResponseBuffer().getResponseData();
            boolean bl = false;
            if ((byArray[3] & 1) == 1) {
                bl = true;
            }
            return bl;
        }
        throw new CcnException(6488167, "FidTable - Need block 2 to getInSystem");
    }

    public static final boolean setInSystem(boolean bl, byte[] byArray) {
        byArray[0] = bl ? (byte)(byArray[0] | 1) : (byte)(byArray[0] & 0xFE);
        return true;
    }

    public static final byte getSensedPulsed(CcnResponseMessage ccnResponseMessage) throws CcnException {
        CcnRspFidUtil.checkTableType(ccnResponseMessage.getTableType(), CHANNEL_IO_TABLE);
        int n = CcnRspFidUtil.parseBlockNo(ccnResponseMessage);
        if (n == 2) {
            byte[] byArray = ccnResponseMessage.getResponseBuffer().getResponseData();
            return (byte)((byArray[3] & 4) >> 2);
        }
        throw new CcnException(6488167, "FidTable - Need block 2 to getInSystem");
    }

    public static final boolean setSensedPulsed(boolean bl, byte[] byArray) {
        byArray[0] = bl ? (byte)(byArray[0] | 4) : (byte)(byArray[0] & 0xFB);
        return true;
    }

    public static final byte getDeviceType(CcnResponseMessage ccnResponseMessage) throws CcnException {
        CcnRspFidUtil.checkTableType(ccnResponseMessage.getTableType(), CHANNEL_IO_TABLE);
        int n = CcnRspFidUtil.parseBlockNo(ccnResponseMessage);
        if (n == 2) {
            byte[] byArray = ccnResponseMessage.getResponseBuffer().getResponseData();
            return byArray[7];
        }
        throw new CcnException(6488167, "FidTable - Need block 2 to getDeviceType");
    }

    public static final boolean setDeviceType(byte by, byte[] byArray) {
        byArray[4] = by;
        return true;
    }

    public static final byte getCtrlSensType(CcnResponseMessage ccnResponseMessage) throws CcnException {
        CcnRspFidUtil.checkTableType(ccnResponseMessage.getTableType(), CHANNEL_IO_TABLE);
        int n = CcnRspFidUtil.parseBlockNo(ccnResponseMessage);
        if (n == 2) {
            byte[] byArray = ccnResponseMessage.getResponseBuffer().getResponseData();
            return (byte)CcnRspFidUtil.getConversion_TOFF(byArray[8]);
        }
        throw new CcnException(6488167, "FidTable - Need block 2 to getCtrlSensType");
    }

    public static final boolean setCtrlSensType(byte by, byte[] byArray) {
        byArray[5] = by;
        return true;
    }

    public static final int getUnitsIndex(CcnResponseMessage ccnResponseMessage) throws CcnException {
        CcnRspFidUtil.checkTableType(ccnResponseMessage.getTableType(), CHANNEL_IO_TABLE);
        int n = CcnRspFidUtil.parseBlockNo(ccnResponseMessage);
        if (n == 2) {
            byte[] byArray = ccnResponseMessage.getResponseBuffer().getResponseData();
            return byArray[40] & 0xFF;
        }
        throw new CcnException(6488167, "FidTable - Need block 2 to getUnitsIndex");
    }

    public static final boolean setUnitsIndex(byte by, byte[] byArray) {
        byArray[37] = by;
        return true;
    }

    public static final int getSetpointType(CcnResponseMessage ccnResponseMessage) throws CcnException {
        CcnRspFidUtil.checkTableType(ccnResponseMessage.getTableType(), SETPOINT_SCHEDULE_TABLE);
        int n = CcnRspFidUtil.parseBlockNo(ccnResponseMessage);
        if (n == 2) {
            byte[] byArray = ccnResponseMessage.getResponseBuffer().getResponseData();
            byte by = byArray[7];
            return CcnRspFidUtil.getConversion_TOFF(by);
        }
        throw new CcnException(6488167, "FidTable - Need block 2 to getSetpointType");
    }

    public static final boolean setSetpointType(byte by, byte[] byArray) {
        byArray[4] = by;
        return true;
    }

    public static final float getSetpointValue(CcnResponseMessage ccnResponseMessage, int n, int n2) throws CcnException {
        CcnRspFidUtil.checkTableType(ccnResponseMessage.getTableType(), SETPOINT_SCHEDULE_TABLE);
        int n3 = CcnRspFidUtil.parseBlockNo(ccnResponseMessage);
        if (n3 == 2) {
            byte[] byArray = ccnResponseMessage.getResponseBuffer().getResponseData();
            int n4 = byArray[3 + n2] & 0xFF;
            if (n == 1) {
                return CcnRspFidUtil.getConversion_TTEM(n4, 0);
            }
            if (n == 2) {
                return CcnRspFidUtil.getConversion_TPER(n4);
            }
            if (n == 3) {
                return CcnRspFidUtil.getConversion_TINC(n4, 0);
            }
            if (n == 4) {
                return CcnRspFidUtil.getConversion_TMIL(n4, 0);
            }
            if (n == 5) {
                return CcnRspFidUtil.getConversion_TCFM(n4, 0);
            }
            return 0.0f;
        }
        throw new CcnException(6488167, "FidTable - Need block 2 to getSetpointType");
    }

    public static final boolean setSetpointValue(String string, byte[] byArray, int n, int n2) {
        int n3 = 0;
        try {
            if (n == 1) {
                n3 = (int)CcnRspFidUtil.getCounts_TTEM(new Float(string).floatValue());
            } else if (n == 2) {
                n3 = (int)CcnRspFidUtil.getCounts_TPER(new Float(string).floatValue());
            } else if (n == 3) {
                n3 = (int)CcnRspFidUtil.getCounts_TINC(new Float(string).floatValue());
            } else if (n == 4) {
                n3 = (int)CcnRspFidUtil.getCounts_TMIL(new Float(string).floatValue());
            } else if (n == 5) {
                n3 = (int)CcnRspFidUtil.getCounts_TCFM(new Float(string).floatValue());
            }
            byArray[n2 + 3] = (byte)(n3 & 0xFF);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static final int getSetpointUnits(int n) {
        if (n == 1) {
            return 1;
        }
        if (n == 2) {
            return 46;
        }
        if (n == 3) {
            return 4;
        }
        if (n == 4) {
            return 5;
        }
        if (n == 5) {
            return 52;
        }
        return 0;
    }

    public static final int getSetpointDecision(int n) {
        if (n == 1) {
            return 1;
        }
        if (n == 46) {
            return 2;
        }
        if (n == 4) {
            return 3;
        }
        if (n == 5) {
            return 4;
        }
        if (n == 52) {
            return 5;
        }
        return 0;
    }

    public static final String getSetPointDesc(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "High value - occupied";
                break;
            }
            case 1: {
                string = "High value - unoccupied";
                break;
            }
            case 2: {
                string = "Low value - occupied";
                break;
            }
            case 3: {
                string = "Low value - unoccupied";
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    public static final String getSetPointLoLimit(int n) {
        String string;
        switch (n) {
            case 1: {
                string = "-9.0";
                break;
            }
            case 2: {
                string = "0";
                break;
            }
            case 3: {
                string = "0.0";
                break;
            }
            case 4: {
                string = "4.0";
                break;
            }
            case 5: {
                string = "0.0";
                break;
            }
            default: {
                string = "0";
            }
        }
        return string;
    }

    public static final String getSetPointHiLimit(int n) {
        String string;
        switch (n) {
            case 1: {
                string = "244.0";
                break;
            }
            case 2: {
                string = "99";
                break;
            }
            case 3: {
                string = "5.0";
                break;
            }
            case 4: {
                string = "20.0";
                break;
            }
            case 5: {
                string = "10.0";
                break;
            }
            default: {
                string = "0";
            }
        }
        return string;
    }

    public static final String getPeriodOccTime(CcnResponseMessage ccnResponseMessage, int n) throws CcnException {
        CcnRspFidUtil.checkTableType(ccnResponseMessage.getTableType(), TIME_SCHEDULE_TABLE);
        int n2 = CcnRspFidUtil.parseBlockNo(ccnResponseMessage);
        if (n2 == 2) {
            byte[] byArray = ccnResponseMessage.getResponseBuffer().getResponseData();
            byte by = byArray[3 + (n - 1) * 3];
            byte by2 = byArray[33 + (n - 1) * 3];
            int n3 = by * 15 + by2;
            BCcnTime bCcnTime = new BCcnTime(n3 / 60, n3 % 60, 0);
            String string = "" + bCcnTime.getHour() + ':' + bCcnTime.getMinute();
            if (bCcnTime.getHour() == 0 && bCcnTime.getMinute() == 0 && n3 / 60 == 24) {
                string = "24" + string.substring(string.indexOf(":"));
            } else if (bCcnTime.getHour() < 10) {
                string = "0" + string;
            }
            return string;
        }
        throw new CcnException(6488167, "FidTable - Need block 2 to getSetpointType");
    }

    public static final boolean setPeriodOccTime(String string, byte[] byArray, int n) {
        if (string != null) {
            try {
                int n2 = new Integer(string.substring(0, string.indexOf(":")));
                int n3 = new Integer(string.substring(string.indexOf(":") + 1));
                int n4 = n2 * 60 + n3;
                byArray[n + 3] = (byte)(n4 / 15 & 0xFF);
                byArray[n + 30 + 3] = (byte)(n4 % 15 & 0xFF);
                return true;
            }
            catch (Exception exception) {}
        }
        return false;
    }

    public static final String getPeriodUnoccTime(CcnResponseMessage ccnResponseMessage, int n) throws CcnException {
        CcnRspFidUtil.checkTableType(ccnResponseMessage.getTableType(), TIME_SCHEDULE_TABLE);
        int n2 = CcnRspFidUtil.parseBlockNo(ccnResponseMessage);
        if (n2 == 2) {
            byte[] byArray = ccnResponseMessage.getResponseBuffer().getResponseData();
            byte by = byArray[3 + (n - 1) * 3 + 1];
            byte by2 = byArray[33 + (n - 1) * 3 + 1];
            int n3 = by * 15 + by2;
            BCcnTime bCcnTime = new BCcnTime(n3 / 60, n3 % 60, 0);
            String string = "" + bCcnTime.getHour() + ':' + bCcnTime.getMinute();
            if (bCcnTime.getHour() == 0 && bCcnTime.getMinute() == 0 && n3 / 60 == 24) {
                string = "24" + string.substring(string.indexOf(":"));
            } else if (bCcnTime.getHour() < 10) {
                string = "0" + string;
            }
            return string;
        }
        throw new CcnException(6488167, "FidTable - Need block 2 to getSetpointType");
    }

    public static final boolean setPeriodUnoccTime(String string, byte[] byArray, int n) {
        if (string != null) {
            try {
                int n2 = new Integer(string.substring(0, string.indexOf(":")));
                int n3 = new Integer(string.substring(string.indexOf(":") + 1));
                int n4 = n2 * 60 + n3;
                byArray[n + 3] = (byte)(n4 / 15 & 0xFF);
                byArray[n + 30 + 3] = (byte)(n4 % 15 & 0xFF);
                return true;
            }
            catch (Exception exception) {}
        }
        return false;
    }

    public static final String getDaysFlags(CcnResponseMessage ccnResponseMessage, int n) throws CcnException {
        CcnRspFidUtil.checkTableType(ccnResponseMessage.getTableType(), TIME_SCHEDULE_TABLE);
        int n2 = CcnRspFidUtil.parseBlockNo(ccnResponseMessage);
        if (n2 == 2) {
            byte[] byArray = ccnResponseMessage.getResponseBuffer().getResponseData();
            byte by = byArray[3 + (n - 1) * 3 + 2];
            int n3 = ((by & 1) << 7) + ((by & 2) << 5) + ((by & 4) << 3) + ((by & 8) << 1) + ((by & 0x10) >> 1) + ((by & 0x20) >> 3) + ((by & 0x40) >> 5) + ((by & 0x80) >> 7);
            String string = Integer.toBinaryString(n3);
            string = "00000000" + string;
            string = string.substring(string.length() - 8, string.length());
            return string.toString();
        }
        throw new CcnException(6488167, "FidTable - Need block 2 to getSetpointType");
    }

    public static final boolean setDaysFlags(String string, byte[] byArray, int n) {
        if (string != null) {
            try {
                int n2 = Integer.parseInt(string, 2) & 0xFF;
                int n3 = ((n2 & 1) << 7) + ((n2 & 2) << 5) + ((n2 & 4) << 3) + ((n2 & 8) << 1) + ((n2 & 0x10) >> 1) + ((n2 & 0x20) >> 3) + ((n2 & 0x40) >> 5) + ((n2 & 0x80) >> 7);
                byArray[n + 3] = (byte)n3;
                return true;
            }
            catch (Exception exception) {}
        }
        return false;
    }

    public static final String getHolidayMonth(CcnResponseMessage ccnResponseMessage, int n) throws CcnException {
        CcnRspFidUtil.checkTableType(ccnResponseMessage.getTableType(), HOLIDAY_TABLE);
        int n2 = CcnRspFidUtil.parseBlockNo(ccnResponseMessage);
        if (n2 == 2) {
            byte[] byArray = ccnResponseMessage.getResponseBuffer().getResponseData();
            byte by = byArray[3 + (n - 1) * 2];
            return new Integer(by).toString();
        }
        throw new CcnException(6488167, "FidTable - Need block 2 to getHolidayMonth");
    }

    public static final String getHolidayDay(CcnResponseMessage ccnResponseMessage, int n) throws CcnException {
        CcnRspFidUtil.checkTableType(ccnResponseMessage.getTableType(), HOLIDAY_TABLE);
        int n2 = CcnRspFidUtil.parseBlockNo(ccnResponseMessage);
        if (n2 == 2) {
            byte[] byArray = ccnResponseMessage.getResponseBuffer().getResponseData();
            byte by = byArray[3 + (n - 1) * 2 + 1];
            return new Integer(by).toString();
        }
        throw new CcnException(6488167, "FidTable - Need block 2 to getHolidayDay");
    }

    public static final boolean setHolidayMonth(String string, byte[] byArray, int n) {
        if (string != null) {
            try {
                int n2 = new Integer(string);
                if (1 <= n2 && n2 <= 12) {
                    byArray[n + 3] = (byte)(n2 & 0xFF);
                    return true;
                }
            }
            catch (Exception exception) {}
        }
        return false;
    }

    public static final boolean setHolidayDay(String string, byte[] byArray, int n) {
        if (string != null) {
            try {
                int n2 = new Integer(string);
                if (1 <= n2 && n2 <= 31) {
                    byArray[n + 3] = (byte)(n2 & 0xFF);
                    return true;
                }
            }
            catch (Exception exception) {}
        }
        return false;
    }

    public static final String getPointDesc(int n, int n2) throws CcnException {
        BFidIOPointTypeEntry bFidIOPointTypeEntry = FidIOPointTypes.getListItem(n, n2);
        if (bFidIOPointTypeEntry == null) {
            return " ";
        }
        return bFidIOPointTypeEntry.getDescription();
    }

    public static final int getPointUnits(int n, int n2) throws CcnException {
        BFidIOPointTypeEntry bFidIOPointTypeEntry = FidIOPointTypes.getListItem(n, n2);
        if (bFidIOPointTypeEntry == null) {
            return 0;
        }
        return bFidIOPointTypeEntry.getUnits();
    }

    public static final String getEUC(int n, int n2) throws CcnException {
        BFidIOPointTypeEntry bFidIOPointTypeEntry = FidIOPointTypes.getListItem(n, n2);
        if (bFidIOPointTypeEntry == null) {
            return " ";
        }
        return bFidIOPointTypeEntry.getEUC();
    }

    public static final String getLoLimit(int n, int n2) throws CcnException {
        BFidIOPointTypeEntry bFidIOPointTypeEntry = FidIOPointTypes.getListItem(n, n2);
        if (bFidIOPointTypeEntry == null) {
            return " ";
        }
        return bFidIOPointTypeEntry.getLowLim();
    }

    public static final String getHiLimit(int n, int n2) throws CcnException {
        BFidIOPointTypeEntry bFidIOPointTypeEntry = FidIOPointTypes.getListItem(n, n2);
        if (bFidIOPointTypeEntry == null) {
            return " ";
        }
        return bFidIOPointTypeEntry.getHiLim();
    }

    public static final float convertFloatToCounts(float f, String string) throws CcnException {
        if (string.equals("TTEM")) {
            return CcnRspFidUtil.getCounts_TTEM(f);
        }
        if (string.equals("TPER")) {
            return CcnRspFidUtil.getCounts_TPER(f);
        }
        if (string.equals("TINC")) {
            return CcnRspFidUtil.getCounts_TINC(f);
        }
        if (string.equals("TMIL")) {
            return CcnRspFidUtil.getCounts_TMIL(f);
        }
        if (string.equals("TDTM")) {
            return CcnRspFidUtil.getCounts_TDTM(f);
        }
        if (string.equals("TTMP")) {
            return CcnRspFidUtil.getCounts_TTMP(f);
        }
        if (string.equals("TNUM")) {
            return CcnRspFidUtil.getCounts_TNUM(f);
        }
        if (string.equals("TVOL")) {
            return CcnRspFidUtil.getCounts_TVOL(f);
        }
        if (string.equals("TPSI")) {
            return CcnRspFidUtil.getCounts_TPSI(f);
        }
        if (string.equals("TENT")) {
            return CcnRspFidUtil.getCounts_TENT(f);
        }
        if (string.equals("TCFM")) {
            return CcnRspFidUtil.getCounts_TCFM(f);
        }
        if (string.equals("TOFF")) {
            return CcnRspFidUtil.getCounts_TOFF(f);
        }
        throw new CcnException(6488180, "FidTable - convertFloatToCounts... bad EUC=" + string);
    }

    public static final String get2DigString(int n) {
        String string = "00" + Integer.toString(n);
        return string.substring(string.length() - 2);
    }

    private static final float getConversion_TTEM(int n, int n2) {
        float f = n;
        if (n > 254) {
            f = 254.0f;
        }
        float f2 = n2;
        float f3 = f - 10.0f + f2 / 10.0f;
        return f3;
    }

    private static final float getConversion_TPER(int n) {
        float f = n;
        if (n == 0) {
            f = 1.0f;
        } else if (n > 254) {
            f = 254.0f;
        }
        float f2 = (f - 1.0f) * 99.0f / 253.0f;
        return f2;
    }

    private static final float getConversion_TINC(int n, int n2) {
        float f = n;
        if (n == 0) {
            f = 1.0f;
        } else if (n > 254) {
            f = 254.0f;
        }
        float f2 = n2;
        float f3 = (f - 1.0f) * 10.0f / 506.0f + f2 / 10.0f;
        return f3;
    }

    private static final float getConversion_TMIL(int n, int n2) {
        float f = n;
        if (n > 254) {
            f = 254.0f;
        }
        float f2 = n2;
        float f3 = (f - 1.0f) * 16.0f / 253.0f + (float)4 + f2 / 10.0f;
        return f3;
    }

    private static final float getConversion_TDTM(int n, int n2) {
        float f = n;
        if (n > 253) {
            f = 253.0f;
        }
        float f2 = n2;
        float f3 = (f - 10.0f) / 10.0f + f2 / 10.0f;
        return f3;
    }

    private static final float getConversion_TTMP(int n, int n2) {
        float f = n;
        if (n == 0) {
            f = 1.0f;
        } else if (n > 253) {
            f = 253.0f;
        }
        float f2 = n2;
        float f3 = (f - 10.0f) / (float)3 + f2 / 10.0f;
        return f3;
    }

    private static final int getConversion_TNUM(int n) {
        int n2 = n;
        if (n > 255) {
            n2 = 255;
        }
        return n2;
    }

    private static final float getConversion_TVOL(int n, int n2) {
        float f = n;
        if (n == 0) {
            f = 1.0f;
        } else if (n > 254) {
            f = 254.0f;
        }
        float f2 = n2;
        float f3 = (f - 1.0f) * 10.0f / 253.0f + f2 / 10.0f;
        return f3;
    }

    private static final float getConversion_TPSI(int n, int n2) {
        float f = n;
        if (n == 0) {
            f = 1.0f;
        } else if (n > 255) {
            f = 255.0f;
        }
        float f2 = n2;
        float f3 = f * 11.0f / 170.0f + f2 / 10.0f;
        return f3;
    }

    private static final float getConversion_TENT(int n, int n2) {
        float f = n;
        if (n == 0) {
            f = 1.0f;
        } else if (n > 255) {
            f = 255.0f;
        }
        float f2 = n2;
        float f3 = f / (float)5 + f2 / 10.0f;
        return f3;
    }

    private static final float getConversion_TCFM(int n, int n2) {
        float f = n;
        if (n == 0) {
            f = 1.0f;
        } else if (n > 95) {
            f = 95.0f;
        }
        float f2 = n2;
        float f3 = (float)((double)f / 9.5) + f2 / 10.0f;
        return f3;
    }

    private static final int getConversion_TOFF(int n) {
        int n2 = n & 0xFF;
        if (n2 == 255) {
            return 0;
        }
        return n2 + 1;
    }

    private static final float getCounts_TTEM(float f) throws CcnException {
        float f2 = f + 10.0f;
        if (0.0f <= f2 && f2 <= 254.0f) {
            return f2;
        }
        throw new CcnException(6488176, "FidTable - getCounts_TTEM... bad count=" + f2);
    }

    private static final float getCounts_TPER(float f) throws CcnException {
        float f2 = f * 253.0f / 99.0f + 1.0f;
        if (1.0f <= f2 && f2 <= 254.0f) {
            return f2;
        }
        throw new CcnException(6488176, "FidTable - getCounts_TPER... bad count=" + f2);
    }

    private static final float getCounts_TINC(float f) throws CcnException {
        float f2 = f * 506.0f / 10.0f + 1.0f;
        if (1.0f <= f2 && f2 <= 254.0f) {
            return f2;
        }
        throw new CcnException(6488176, "FidTable - getCounts_TINC... bad val|count=" + f + '|' + f2);
    }

    private static final float getCounts_TMIL(float f) throws CcnException {
        float f2 = (f - (float)4) * 253.0f / 16.0f + 1.0f;
        if (0.0f <= f2 && f2 <= 254.0f) {
            return f2;
        }
        throw new CcnException(6488176, "FidTable - getCounts_TMIL... bad count=" + f2);
    }

    private static final float getCounts_TDTM(float f) throws CcnException {
        float f2 = f * 10.0f + 10.0f;
        if (0.0f <= f2 && f2 <= 253.0f) {
            return f2;
        }
        throw new CcnException(6488176, "FidTable - getCounts_TDTM... bad count=" + f2);
    }

    private static final float getCounts_TTMP(float f) throws CcnException {
        float f2 = f * (float)3 + 10.0f;
        if (1.0f <= f2 && f2 <= 253.0f) {
            return f2;
        }
        throw new CcnException(6488176, "FidTable - getCounts_TTMP... bad count=" + f2);
    }

    private static final float getCounts_TNUM(float f) throws CcnException {
        float f2 = f;
        if (0.0f <= f2 && f2 <= 255.0f) {
            return f2;
        }
        throw new CcnException(6488176, "FidTable - getCounts_TTMP... bad count=" + f2);
    }

    private static final float getCounts_TVOL(float f) throws CcnException {
        float f2 = f * 253.0f / 10.0f + 1.0f;
        if (1.0f <= f2 && f2 <= 254.0f) {
            return f2;
        }
        throw new CcnException(6488176, "FidTable - getCounts_TVOL... bad count=" + f2);
    }

    private static final float getCounts_TPSI(float f) throws CcnException {
        float f2 = f * 170.0f / 11.0f;
        if (0.0f <= f2 && f2 <= 255.0f) {
            return f2;
        }
        throw new CcnException(6488176, "FidTable - getCounts_TPSI... bad count=" + f2);
    }

    private static final float getCounts_TENT(float f) throws CcnException {
        float f2 = f * (float)5;
        if (0.0f <= f2 && f2 <= 255.0f) {
            return f2;
        }
        throw new CcnException(6488176, "FidTable - getCounts_TENT... bad count=" + f2);
    }

    private static final float getCounts_TCFM(float f) throws CcnException {
        float f2 = f * 9.5f;
        if (0.0f <= f2 && f2 <= 95.0f) {
            return f2;
        }
        throw new CcnException(6488176, "FidTable - getCounts_TCFM... bad count=" + f2);
    }

    private static final float getCounts_TOFF(float f) throws CcnException {
        float f2 = f - 1.0f;
        if (-1.0f <= f2 && f2 <= 254.0f) {
            if (f2 == -1.0f) {
                return 0.0f;
            }
            return f2;
        }
        throw new CcnException(6488176, "FidTable - getCounts_TOFF... bad count=" + f2);
    }

    public static final float getVariableValue(CcnResponseMessage ccnResponseMessage) {
        byte[] byArray = ccnResponseMessage.getResponseBuffer().getResponseData();
        int n = byArray[0] << 24 & 0xFF000000;
        n |= byArray[1] << 16 & 0xFF0000;
        n |= byArray[2] << 8 & 0xFF00;
        return Float.intBitsToFloat(n |= byArray[3] & 0xFF);
    }

    public static final String getEUValue(float f, String string, int n) {
        int n2 = (int)f;
        int n3 = (int)((f - (float)n2) * 10.0f);
        float f2 = 0.0f;
        if (string.equals("TTEM")) {
            f2 = CcnRspFidUtil.getConversion_TTEM(n2, n3);
        } else if (string.equals("TPER")) {
            f2 = CcnRspFidUtil.getConversion_TPER(n2);
        } else if (string.equals("TINC")) {
            f2 = CcnRspFidUtil.getConversion_TINC(n2, n3);
        } else if (string.equals("TMIL")) {
            f2 = CcnRspFidUtil.getConversion_TMIL(n2, n3);
        } else if (string.equals("TDTM")) {
            f2 = CcnRspFidUtil.getConversion_TDTM(n2, n3);
        } else if (string.equals("TTMP")) {
            f2 = CcnRspFidUtil.getConversion_TTMP(n2, n3);
        } else {
            if (string.equals("TNUM")) {
                return Integer.toString(CcnRspFidUtil.getConversion_TNUM(n2));
            }
            if (string.equals("TVOL")) {
                f2 = CcnRspFidUtil.getConversion_TVOL(n2, n3);
            } else if (string.equals("TPSI")) {
                f2 = CcnRspFidUtil.getConversion_TPSI(n2, n3);
            } else if (string.equals("TENT")) {
                f2 = CcnRspFidUtil.getConversion_TENT(n2, n3);
            } else if (string.equals("TCFM")) {
                f2 = CcnRspFidUtil.getConversion_TCFM(n2, n3);
            } else {
                if (string.equals("TOFF")) {
                    return Integer.toString(CcnRspFidUtil.getConversion_TOFF(n2));
                }
                return null;
            }
        }
        NumberFormat numberFormat = NumberFormat.getInstance();
        int n4 = n & 0xF;
        numberFormat.setMaximumFractionDigits(n4);
        numberFormat.setMinimumFractionDigits(n4);
        ((DecimalFormat)numberFormat).setGroupingSize(20);
        return numberFormat.format(f2);
    }

    public static final byte[] mergeNewValue(byte[] byArray, String string, BCcnPointEntry bCcnPointEntry, int n) {
        int n2 = bCcnPointEntry.getFieldIndex();
        if (n == 1283) {
            if (n2 % 3 == 0) {
                CcnRspFidUtil.setPeriodOccTime(string, byArray, n2);
            } else if (n2 % 3 == 1) {
                CcnRspFidUtil.setPeriodUnoccTime(string, byArray, n2);
            } else if (n2 % 3 == 2) {
                CcnRspFidUtil.setDaysFlags(string, byArray, n2);
            }
        } else if (n == 1284) {
            if (n2 >= 0 && n2 <= 3) {
                int n3 = CcnRspFidUtil.getSetpointDecision(bCcnPointEntry.getUnits());
                CcnRspFidUtil.setSetpointValue(string, byArray, n3, n2);
            }
        } else if (n == 1285 && n2 >= 0 && n2 <= 59) {
            if (n2 % 2 == 0) {
                CcnRspFidUtil.setHolidayMonth(string, byArray, n2);
            } else {
                CcnRspFidUtil.setHolidayDay(string, byArray, n2);
            }
        }
        return byArray;
    }

    public static final byte[] mergeNewValue(byte[] byArray, String string, BCcnProxyExt bCcnProxyExt, int n) {
        int n2 = bCcnProxyExt.getFieldIndex();
        if (n == 1283) {
            if (n2 % 3 == 0) {
                CcnRspFidUtil.setPeriodOccTime(string, byArray, n2);
            } else if (n2 % 3 == 1) {
                CcnRspFidUtil.setPeriodUnoccTime(string, byArray, n2);
            } else if (n2 % 3 == 2) {
                CcnRspFidUtil.setDaysFlags(string, byArray, n2);
            }
        } else if (n == 1284) {
            if (n2 >= 0 && n2 <= 3) {
                int n3 = CcnRspFidUtil.getSetpointDecision(bCcnProxyExt.getUnits());
                CcnRspFidUtil.setSetpointValue(string, byArray, n3, n2);
            }
        } else if (n == 1285 && n2 >= 0 && n2 <= 59) {
            if (n2 % 2 == 0) {
                CcnRspFidUtil.setHolidayMonth(string, byArray, n2);
            } else {
                CcnRspFidUtil.setHolidayDay(string, byArray, n2);
            }
        }
        return byArray;
    }

    public static final String getValue(CcnResponseMessage ccnResponseMessage, BCcnPointEntry bCcnPointEntry) throws CcnException {
        String string = new String();
        int n = ccnResponseMessage.getTableType();
        if (1283 <= n && n <= 1285) {
            int n2 = bCcnPointEntry.getFieldIndex();
            if (n == 1283) {
                int n3 = n2 / 3 + 1;
                if (n2 % 3 == 0) {
                    string = CcnRspFidUtil.getPeriodOccTime(ccnResponseMessage, n3);
                } else if (n2 % 3 == 1) {
                    string = CcnRspFidUtil.getPeriodUnoccTime(ccnResponseMessage, n3);
                } else if (n2 % 3 == 2) {
                    string = CcnRspFidUtil.getDaysFlags(ccnResponseMessage, n3);
                }
            } else if (n == 1284) {
                if (n2 >= 0 && n2 <= 3) {
                    int n4 = CcnRspFidUtil.getSetpointType(ccnResponseMessage);
                    float f = CcnRspFidUtil.getSetpointValue(ccnResponseMessage, n4, n2);
                    NumberFormat numberFormat = NumberFormat.getInstance();
                    int n5 = bCcnPointEntry.getDisplayDigits() & 0xF;
                    numberFormat.setMaximumFractionDigits(n5);
                    numberFormat.setMinimumFractionDigits(n5);
                    ((DecimalFormat)numberFormat).setGroupingSize(20);
                    return numberFormat.format(f);
                }
            } else if (n == 1285) {
                int n6 = n2 / 2 + 1;
                if (n2 >= 0 && n2 <= 59) {
                    string = n2 % 2 == 0 ? CcnRspFidUtil.getHolidayMonth(ccnResponseMessage, n6) : CcnRspFidUtil.getHolidayDay(ccnResponseMessage, n6);
                }
            }
            return string;
        }
        throw new CcnException(6488168, "FidTable: " + n + " - FID Table type not valid to getValue");
    }

    public static final String getValue(CcnResponseMessage ccnResponseMessage, BCcnProxyExt bCcnProxyExt) throws CcnException {
        String string = new String();
        int n = ccnResponseMessage.getTableType();
        if (1283 <= n && n <= 1285) {
            int n2 = bCcnProxyExt.getFieldIndex();
            if (n == 1283) {
                int n3 = n2 / 3 + 1;
                if (n2 % 3 == 0) {
                    string = CcnRspFidUtil.getPeriodOccTime(ccnResponseMessage, n3);
                } else if (n2 % 3 == 1) {
                    string = CcnRspFidUtil.getPeriodUnoccTime(ccnResponseMessage, n3);
                } else if (n2 % 3 == 2) {
                    string = CcnRspFidUtil.getDaysFlags(ccnResponseMessage, n3);
                }
            } else if (n == 1284) {
                if (n2 >= 0 && n2 <= 3) {
                    int n4 = CcnRspFidUtil.getSetpointType(ccnResponseMessage);
                    float f = CcnRspFidUtil.getSetpointValue(ccnResponseMessage, n4, n2);
                    NumberFormat numberFormat = NumberFormat.getInstance();
                    int n5 = bCcnProxyExt.getDisplayDigits() & 0xF;
                    numberFormat.setMaximumFractionDigits(n5);
                    numberFormat.setMinimumFractionDigits(n5);
                    ((DecimalFormat)numberFormat).setGroupingSize(20);
                    return numberFormat.format(f);
                }
            } else if (n == 1285) {
                int n6 = n2 / 2 + 1;
                if (n2 >= 0 && n2 <= 59) {
                    string = n2 % 2 == 0 ? CcnRspFidUtil.getHolidayMonth(ccnResponseMessage, n6) : CcnRspFidUtil.getHolidayDay(ccnResponseMessage, n6);
                }
            }
            return string;
        }
        throw new CcnException(6488168, "FidTable: " + n + " - FID Table type not valid to getValue");
    }

    public static final BCcnTimeScheduleEntry[] buildTimeSchedules(BCcnPointEntry[] bCcnPointEntryArray) {
        BCcnTimeScheduleEntry[] bCcnTimeScheduleEntryArray = new BCcnTimeScheduleEntry[7];
        BCcnTimeScheduleList bCcnTimeScheduleList = new BCcnTimeScheduleList();
        int n = 0;
        while (n < 21) {
            int n2 = n / 3;
            int n3 = Integer.parseInt(bCcnPointEntryArray[n + 2].getPointValue(), 2);
            boolean bl = false;
            if ((n3 & 0x80) == 128) {
                bl = true;
            }
            boolean bl2 = bl;
            boolean bl3 = false;
            if ((n3 & 0x40) == 64) {
                bl3 = true;
            }
            boolean bl4 = bl3;
            boolean bl5 = false;
            if ((n3 & 0x20) == 32) {
                bl5 = true;
            }
            boolean bl6 = bl5;
            boolean bl7 = false;
            if ((n3 & 0x10) == 16) {
                bl7 = true;
            }
            boolean bl8 = bl7;
            boolean bl9 = false;
            if ((n3 & 8) == 8) {
                bl9 = true;
            }
            boolean bl10 = bl9;
            boolean bl11 = false;
            if ((n3 & 4) == 4) {
                bl11 = true;
            }
            boolean bl12 = bl11;
            boolean bl13 = false;
            if ((n3 & 2) == 2) {
                bl13 = true;
            }
            boolean bl14 = bl13;
            boolean bl15 = false;
            if ((n3 & 1) == 1) {
                bl15 = true;
            }
            boolean bl16 = bl15;
            String string = bCcnPointEntryArray[n].getPointValue();
            String string2 = bCcnPointEntryArray[n + 1].getPointValue();
            String string3 = "Period " + (n2 + 1);
            bCcnTimeScheduleEntryArray[n2] = new BCcnTimeScheduleEntry(bl2, bl4, bl6, bl8, bl10, bl12, bl14, bl16, string, string2, string3);
            n += 3;
        }
        bCcnTimeScheduleList.setTimeScheduleList(bCcnTimeScheduleEntryArray);
        return bCcnTimeScheduleEntryArray;
    }
}

