/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.tables;

import com.tridium.basicdriver.util.BIBasicPollable;
import com.tridium.ccn.BCcnDevice;
import com.tridium.ccn.BCcnNetwork;
import com.tridium.ccn.components.BCcnByteEntry;
import com.tridium.ccn.components.BCcnByteList;
import com.tridium.ccn.components.BCcnPointEntry;
import com.tridium.ccn.components.BCcnPointList;
import com.tridium.ccn.components.BCcnTableEntry;
import com.tridium.ccn.components.BCcnTimeScheduleEntry;
import com.tridium.ccn.components.BCcnTimeScheduleList;
import com.tridium.ccn.enums.BCcnUnitMappingEnum;
import com.tridium.ccn.exceptions.CcnRuntimeException;
import com.tridium.ccn.messages.CcnChangeTableNameRequest;
import com.tridium.ccn.messages.CcnFetchTableDataRequest;
import com.tridium.ccn.messages.CcnReadTableRequest;
import com.tridium.ccn.messages.CcnResponseMessage;
import com.tridium.ccn.messages.CcnWriteTableRequest;
import com.tridium.ccn.objects.BCcnBaseObject;
import com.tridium.ccn.point.BCcnInputProxy;
import com.tridium.ccn.point.BCcnNumericWritable;
import com.tridium.ccn.point.BCcnProxyExt;
import com.tridium.ccn.tables.BCcnDataTable;
import com.tridium.ccn.tables.BCcnDataTableWithTimeSchedule;
import com.tridium.ccn.tables.BCcnFidTable;
import com.tridium.ccn.tables.BCcnFidTableWithTimeSchedule;
import com.tridium.ccn.tables.BCcnPicTable;
import com.tridium.ccn.tables.BCcnTableGroup;
import com.tridium.ccn.util.CcnEnumsUtil;
import com.tridium.ccn.util.CcnRspDataUtil;
import com.tridium.ccn.util.CcnRspFidUtil;
import com.tridium.ccn.util.CcnRspPicPocUtil;
import com.tridium.ccn.util.CcnRspPicUtil;
import com.tridium.ccn.util.CcnRspTableUtil;
import com.tridium.ccn.util.CcnStringNumberConverter;
import com.tridium.ccn.util.CcnUtil;
import com.tridium.platCcn.CcnTableDef;
import java.util.Vector;
import javax.baja.control.BNumericWritable;
import javax.baja.driver.util.BIPollable;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BNumber;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.IllegalChildException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.ByteArrayUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BCcnTable
extends BCcnBaseObject
implements BIBasicPollable {
    public static final Property debugOn = BCcnTable.newProperty((int)0, (boolean)false, null);
    public static final Property tableType = BCcnTable.newProperty((int)0, (int)0, null);
    public static final Property tableTypeString = BCcnTable.newProperty((int)0, (String)"", null);
    public static final Property tableInstance = BCcnTable.newProperty((int)0, (int)0, null);
    public static final Property tableNum = BCcnTable.newProperty((int)0, (int)0, null);
    public static final Property tableName = BCcnTable.newProperty((int)0, (String)" ", null);
    public static final Property duplicateTableName = BCcnTable.newProperty((int)4, (String)"", null);
    public static final Property tableBlockCount = BCcnTable.newProperty((int)0, (int)0, null);
    public static final Property disablePoll = BCcnTable.newProperty((int)4, (boolean)false, null);
    public static final Property learnStatus = BCcnTable.newProperty((int)2, (String)"Idle", null);
    public static final Property overwriteExisting = BCcnTable.newProperty((int)4, (boolean)false, null);
    public static final Property preMetricDisplay = BCcnTable.newProperty((int)4, (boolean)false, null);
    public static final Property curMetricDisplay = BCcnTable.newProperty((int)4, (boolean)false, null);
    public static final Property isEnhancedVersion = BCcnTable.newProperty((int)6, (boolean)false, null);
    public static final Property pollFrequency = BCcnTable.newProperty((int)0, (BValue)BPollFrequency.normal, null);
    public static final Action fetch = BCcnTable.newAction((int)0, null);
    public static final Type TYPE;
    BCcnTableGroup tGroup;
    BIcon icon;
    boolean changingDisplay;
    protected BCcnProxyExt[] points;
    BCcnTableEntry entry;
    protected int createdPointsCount;
    Log ccnTablesLog;
    Log ccnTimeLog;
    Log ccnSubscribedPointLog;
    Vector vPollAttributeProxyExts;
    static /* synthetic */ Class class$com$tridium$ccn$tables$BCcnTable;
    static /* synthetic */ Class class$com$tridium$ccn$components$BCcnByteEntry;

    public boolean getDebugOn() {
        return this.getBoolean(debugOn);
    }

    public void setDebugOn(boolean bl) {
        this.setBoolean(debugOn, bl, null);
    }

    public int getTableType() {
        return this.getInt(tableType);
    }

    public void setTableType(int n) {
        this.setInt(tableType, n, null);
    }

    public String getTableTypeString() {
        return this.getString(tableTypeString);
    }

    public void setTableTypeString(String string) {
        this.setString(tableTypeString, string, null);
    }

    public int getTableInstance() {
        return this.getInt(tableInstance);
    }

    public void setTableInstance(int n) {
        this.setInt(tableInstance, n, null);
    }

    public int getTableNum() {
        return this.getInt(tableNum);
    }

    public void setTableNum(int n) {
        this.setInt(tableNum, n, null);
    }

    public String getTableName() {
        return this.getString(tableName);
    }

    public void setTableName(String string) {
        this.setString(tableName, string, null);
    }

    public String getDuplicateTableName() {
        return this.getString(duplicateTableName);
    }

    public void setDuplicateTableName(String string) {
        this.setString(duplicateTableName, string, null);
    }

    public int getTableBlockCount() {
        return this.getInt(tableBlockCount);
    }

    public void setTableBlockCount(int n) {
        this.setInt(tableBlockCount, n, null);
    }

    public boolean getDisablePoll() {
        return this.getBoolean(disablePoll);
    }

    public void setDisablePoll(boolean bl) {
        this.setBoolean(disablePoll, bl, null);
    }

    public String getLearnStatus() {
        return this.getString(learnStatus);
    }

    public void setLearnStatus(String string) {
        this.setString(learnStatus, string, null);
    }

    public boolean getOverwriteExisting() {
        return this.getBoolean(overwriteExisting);
    }

    public void setOverwriteExisting(boolean bl) {
        this.setBoolean(overwriteExisting, bl, null);
    }

    public boolean getPreMetricDisplay() {
        return this.getBoolean(preMetricDisplay);
    }

    public void setPreMetricDisplay(boolean bl) {
        this.setBoolean(preMetricDisplay, bl, null);
    }

    public boolean getCurMetricDisplay() {
        return this.getBoolean(curMetricDisplay);
    }

    public void setCurMetricDisplay(boolean bl) {
        this.setBoolean(curMetricDisplay, bl, null);
    }

    public boolean getIsEnhancedVersion() {
        return this.getBoolean(isEnhancedVersion);
    }

    public void setIsEnhancedVersion(boolean bl) {
        this.setBoolean(isEnhancedVersion, bl, null);
    }

    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    public void setPollFrequency(BPollFrequency bPollFrequency) {
        this.set(pollFrequency, (BValue)bPollFrequency, null);
    }

    public void fetch() {
        this.invoke(fetch, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        this.reviewLicense();
        super.started();
    }

    public void stopped() throws Exception {
        super.stopped();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.getName().equalsIgnoreCase("tablename")) {
            String string = this.getTableName();
            String string2 = this.getDuplicateTableName();
            if (string2.equalsIgnoreCase("SPSCHPOC")) {
                this.ccnTablesLog.trace(this.getSummaryString() + "<CcnTable: asyncPropertyChange CcnChangeTableNameRequest... change name not allowed for this table: ");
                return;
            }
            if (string.trim().length() == 0 || !Character.isLetter(string.charAt(0))) {
                string = "T";
            }
            if (string.length() > 8) {
                string = string.substring(0, 8);
            }
            if (this.writeTableName(string)) {
                this.ccnTablesLog.trace(this.getSummaryString() + "<CcnTable: asyncPropertyChange CcnChangeTableNameRequest name commit : " + string);
                this.setDuplicateTableName(string);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void registerPollProxyExt(BCcnProxyExt bCcnProxyExt) {
        Vector vector = this.vPollAttributeProxyExts;
        synchronized (vector) {
            this.vPollAttributeProxyExts.addElement(bCcnProxyExt);
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl5 : MonitorExitStatement: MONITOREXIT : var2_2
            if (this.vPollAttributeProxyExts.size() > 0) {
                this.register();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unregisterPollProxyExt(BCcnProxyExt bCcnProxyExt) {
        Vector vector = this.vPollAttributeProxyExts;
        synchronized (vector) {
            this.vPollAttributeProxyExts.removeElement(bCcnProxyExt);
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl6 : MonitorExitStatement: MONITOREXIT : var2_2
            if (this.vPollAttributeProxyExts.size() == 0) {
                this.unregister();
            }
            return;
        }
    }

    protected void register() {
        if (this.registered) {
            return;
        }
        try {
            if (this.vPollAttributeProxyExts.size() > 0) {
                this.getCcnDevice().getCcnNetwork().getPollScheduler().subscribe((BIPollable)this);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.registered = true;
    }

    protected void unregister() {
        this.ccnTablesLog.trace(this.getSummaryString() + ": table:unregister=" + this.registered);
        try {
            this.getCcnDevice().getCcnNetwork().getPollScheduler().unsubscribe((BIPollable)this);
        }
        catch (Exception exception) {}
        this.registered = false;
    }

    public boolean isParentLegal(BComponent bComponent) throws IllegalChildException {
        if (bComponent instanceof BCcnTableGroup) {
            return true;
        }
        throw new LocalizableRuntimeException("ccn", "CcnTable.Drop");
    }

    public boolean isChildLegal(BComponent bComponent) throws LocalizableRuntimeException {
        if (bComponent instanceof BCcnTable) {
            throw new LocalizableRuntimeException("ccn", "CcnTable nodes may not be under other CcnTable nodes");
        }
        return true;
    }

    public void doFetch() {
        try {
            this.ccnTablesLog.trace(this.getSummaryString() + "CcnTable:doFetch()");
            CcnFetchTableDataRequest ccnFetchTableDataRequest = new CcnFetchTableDataRequest(this, this.getCcnDevice());
            this.getCcnDevice().getCcnNetwork().getCcnComm().ccnAsyncRequest().submitRequest(ccnFetchTableDataRequest);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private final void reviewLicense() {
        try {
            if (Sys.getLicenseManager().getFeature("Tridium", "ccn").getFeatureName().equalsIgnoreCase("ccn")) {
                this.setIsEnhancedVersion(true);
            }
            return;
        }
        catch (FeatureNotLicensedException featureNotLicensedException) {
            if (Sys.getLicenseManager().getFeature("Tridium", "ccnl").getFeatureName().equalsIgnoreCase("ccnl")) {
                this.setIsEnhancedVersion(false);
                return;
            }
            this.setIsEnhancedVersion(false);
            return;
        }
    }

    public void checkFullAccessPermitted(String string) {
        if (this.isFullAccessPermittedByLicense()) {
            return;
        }
        String string2 = "Cannot " + string + " because table not licensed.";
        throw new CcnRuntimeException(6488275, string2);
    }

    public void recalcCreatedPointsCount() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.points.length) {
            if (this.points[n2] != null) {
                ++n;
            }
            ++n2;
        }
        if (this instanceof BCcnPicTable) {
            ((BCcnPicTable)this).setPointCreateCount(n);
        } else if (this instanceof BCcnDataTable) {
            ((BCcnDataTable)this).setPointCreateCount(n);
        } else if (this instanceof BCcnFidTable) {
            ((BCcnFidTable)this).setPointCreateCount(n);
        }
        this.createdPointsCount = n;
    }

    public void poll() {
        if (!CcnUtil.isNetworkDeviceStatusOk(this.getCcnDevice())) {
            return;
        }
        if (!this.getCcnDevice().getCcnNetwork().getPollScheduler().getPollEnabled()) {
            return;
        }
        this.pollForData();
    }

    public void pollForData() {
    }

    public boolean writeTableName(String string) {
        this.ccnTablesLog.trace("<CcnTable: asyncPropertyChange CcnChangeTableNameRequest name: " + string);
        byte[] byArray = string.getBytes();
        int n = this.getCcnDevice().getBusNo();
        int n2 = this.getCcnDevice().getElemNo();
        int n3 = this.getTableType();
        int n4 = this.getTableInstance();
        boolean bl = false;
        CcnTableDef ccnTableDef = new CcnTableDef((byte)n2, (byte)n, byArray, (short)((byte)n3), (byte)n4, (byte)(bl ? 1 : 0), 0, 0);
        CcnChangeTableNameRequest ccnChangeTableNameRequest = new CcnChangeTableNameRequest(ccnTableDef);
        CcnResponseMessage ccnResponseMessage = this.getCcnDevice().getCcnNetwork().getCcnComm().ccnAsyncRequest().sendAsyncRequest(ccnChangeTableNameRequest);
        if (ccnResponseMessage == null) {
            return false;
        }
        this.ccnTablesLog.trace("rsp.getResponseCommand()=" + ccnResponseMessage.getResponseCommand() + "rsp.getBlockLen()=" + ccnResponseMessage.getBlockLen());
        if ((ccnResponseMessage.getResponseCommand() & 0xFF) == 21) {
            this.ccnTablesLog.trace("\n****  CcnTable: CcnChangeTableNameRequest name change failed... response command: " + ccnResponseMessage.getResponseCommand() + " len: " + ccnResponseMessage.getBlockLen() + " responseBuffer: " + new String(ByteArrayUtil.toHexString((byte[])ccnResponseMessage.getResponseBuffer().getResponseData())));
            return false;
        }
        return true;
    }

    public boolean writeTable(BCcnProxyExt bCcnProxyExt) throws Exception {
        this.ccnTablesLog.trace("Inside write table::" + bCcnProxyExt.getFieldValue());
        while (this.getCcnDevice().getCcnNetwork().isChangingDisplay()) {
        }
        BCcnTable bCcnTable = bCcnProxyExt.getTable();
        int n = 0;
        if (this.getCcnDevice().areYouOutOfService()) {
            n = 1;
        } else {
            if (!CcnRspPicPocUtil.checkRange(bCcnProxyExt.getFieldValue(), bCcnProxyExt)) {
                n = 3;
                if (bCcnProxyExt.getPointDataType() == 12 || bCcnProxyExt.getPointDataType() == 51) {
                    throw new Exception("User value " + bCcnProxyExt.getFieldValue() + " out of limits, write aborted.\nThe limits for hour are 00 to 23; The limits for minute are 00 to 59.");
                }
                throw new Exception("User value " + bCcnProxyExt.getFieldValue() + " out of limits, write aborted.\nThe limits are " + bCcnProxyExt.getLoLimit() + " to " + bCcnProxyExt.getHiLimit());
            }
            bCcnProxyExt.setDisplayType(this.getCurMetricDisplay());
            byte by = (byte)bCcnProxyExt.getValueBlock();
            int n2 = 0;
            BCcnByteList bCcnByteList = !this.getCcnDevice().isDeviceFID() ? (BCcnByteList)this.getCcnDevice().getTableAccessRights().get(SlotPath.escape((String)bCcnTable.getTableName()) + bCcnTable.getTableNum()) : (BCcnByteList)this.getCcnDevice().getTableAccessRights().get(SlotPath.escape((String)bCcnTable.getTableName()) + bCcnTable.getTableType());
            BCcnByteEntry[] bCcnByteEntryArray = null;
            if (bCcnByteList != null) {
                Class clazz = class$com$tridium$ccn$components$BCcnByteEntry;
                if (clazz == null) {
                    clazz = class$com$tridium$ccn$components$BCcnByteEntry = BCcnTable.class("[Lcom.tridium.ccn.components.BCcnByteEntry;", false);
                }
                bCcnByteEntryArray = (BCcnByteEntry[])bCcnByteList.getChildren(clazz);
            }
            if (bCcnByteEntryArray == null) {
                return false;
            }
            int n3 = 0;
            while (n3 < this.getTableBlockCount()) {
                if (bCcnByteEntryArray[n3].getIndex() == by) {
                    n2 = (byte)bCcnByteEntryArray[n3].getValue();
                    break;
                }
                ++n3;
            }
            if ((n2 & 2) != 2) {
                n = 3;
                throw new LocalizableRuntimeException("ccn", "CcnTable.Write");
            }
            String string = CcnRspPicPocUtil.convertToImperial(bCcnProxyExt);
            String string2 = null;
            int n4 = bCcnProxyExt.getPointDataType();
            byte by2 = (byte)bCcnProxyExt.getValueBlock();
            this.ccnTablesLog.trace(this.getSummaryString() + "CcnTable:writeTable... \nthe setValue we want to write ptName|block|newValue " + bCcnProxyExt.getFieldName() + '|' + by2 + '|' + string);
            CcnResponseMessage ccnResponseMessage = this.getReadTableResponse(by2);
            if (ccnResponseMessage != null) {
                this.ccnTablesLog.trace(this.getSummaryString() + "CcnTable:writeTable... \nfirst read the current block rspCmd|blockLen " + ccnResponseMessage.getResponseCommand() + '|' + ccnResponseMessage.getBlockLen());
            }
            if (ccnResponseMessage == null) {
                string2 = "Unknown error. Read table block " + by2 + " is unsuccessful. The read response is null or Ack code is not 0x06.";
                n = 2;
            } else if (ccnResponseMessage.getResponseCommand() != 6) {
                string2 = "Unknown error. Read table block " + by2 + " is unsuccessful. The read response is null or Ack code is not 0x06.";
                n = 3;
            } else {
                byte[] byArray = ccnResponseMessage.getData();
                if (this instanceof BCcnPicTable || this instanceof BCcnDataTable) {
                    byArray = CcnRspPicPocUtil.mergeNewValue(byArray, bCcnProxyExt.getValueBlockOffset(), bCcnProxyExt.getPointDataType(), bCcnProxyExt.getFieldByteCount(), string, null, bCcnProxyExt);
                } else if (this instanceof BCcnFidTable) {
                    byArray = CcnRspFidUtil.mergeNewValue(byArray, string, bCcnProxyExt, this.getTableType());
                }
                byte[] byArray2 = new byte[byArray.length - 3];
                int n5 = 0;
                while (n5 < byArray2.length) {
                    byArray2[n5] = byArray[n5 + 3];
                    ++n5;
                }
                this.ccnTablesLog.trace(this.getSummaryString() + "CcnTable:writeTable... \nwrite this block ptName|blkNo|newValue " + bCcnProxyExt.getFieldName() + '|' + by2 + '|' + string);
                CcnResponseMessage ccnResponseMessage2 = this.writeTable(byArray2, by2);
                if (ccnResponseMessage2 != null) {
                    this.ccnTablesLog.trace(this.getSummaryString() + "CcnTable:writeTable... \nresponse from the write cmd|len " + ccnResponseMessage2.getResponseCommand() + ':' + ccnResponseMessage2.getBlockLen());
                }
                if (ccnResponseMessage2 != null) {
                    if (ccnResponseMessage2.getResponseCommand() == 6) {
                        if (!this.getCcnDevice().isDeviceFID()) {
                            CcnResponseMessage ccnResponseMessage3 = this.getReadTableResponse(by2);
                            if (ccnResponseMessage3 != null) {
                                this.ccnTablesLog.trace(this.getSummaryString() + "CcnTable:writeTable \nthe confirmation ptName|blkNo|newValue " + bCcnProxyExt.getFieldName() + '|' + by2 + '|' + string);
                            }
                            if (ccnResponseMessage3 == null) {
                                string2 = "Unknown error. Response from write table command is 0x06, but the response from read table to confirm the write command is null or Ack code is not 0x06.";
                                n = 2;
                            } else if (ccnResponseMessage3.getResponseCommand() != 6) {
                                string2 = "Unknown error. Response from write table command is 0x06, but the response from read table to confirm the write command is null or Ack code is not 0x06.";
                                n = 3;
                            } else {
                                String string3 = new String();
                                try {
                                    if (this instanceof BCcnPicTable) {
                                        string3 = CcnRspPicUtil.getValue(ccnResponseMessage3, bCcnProxyExt.getValueBlockOffset(), bCcnProxyExt);
                                    } else if (this instanceof BCcnDataTable) {
                                        string3 = CcnRspDataUtil.getValue(ccnResponseMessage3, bCcnProxyExt.getValueBlockOffset(), bCcnProxyExt);
                                    }
                                    this.ccnTablesLog.trace(this.getSummaryString() + "CcnTable:writeTable... \nthe confirmation ptName|sentValue|newValue " + bCcnProxyExt.getFieldName() + '|' + string + '|' + string3);
                                    if (n4 == 0 || n4 == 1 || n4 == 2 || n4 == 6 || n4 == 7 || n4 == 9 || n4 == 10 || n4 == 17 || n4 == 25 || n4 == 48 || n4 == 49 || n4 == 50) {
                                        this.ccnTablesLog.trace(this.getSummaryString() + "CcnTable:compareFloatValues( latest|sent " + CcnStringNumberConverter.getFloat(string3) + ':' + CcnStringNumberConverter.getFloat(bCcnProxyExt.getFieldValue()));
                                        if (!CcnRspTableUtil.compareFloatValues(CcnStringNumberConverter.getFloat(string3), CcnStringNumberConverter.getFloat(bCcnProxyExt.getFieldValue()))) {
                                            string2 = "Unknown error. Response from write command is 0x06, but the value in controller is not updated.";
                                            n = 3;
                                        }
                                    } else if (!string3.trim().equals(bCcnProxyExt.getFieldValue().trim())) {
                                        string2 = "Unknown error. Response from write command is 0x06, but the value in controller is not updated.";
                                        n = 3;
                                    }
                                    if (string2 == null) {
                                        this.ccnTablesLog.trace("Error message is null...");
                                        ((BCcnInputProxy)bCcnProxyExt).setValue(string3);
                                        if (!(this instanceof BCcnPicTable) && this instanceof BCcnDataTable) {
                                            BCcnPointEntry[] bCcnPointEntryArray = this.getPointList().getPointList();
                                            if (this.getTableType() == 1556 && bCcnPointEntryArray[0].getValueBlock() == 2) {
                                                int n6 = 0;
                                                while (n6 < bCcnPointEntryArray.length) {
                                                    if (bCcnPointEntryArray[n6].getFieldIndex() == bCcnProxyExt.getFieldIndex()) {
                                                        bCcnPointEntryArray[n6].setPointValue(string3);
                                                        break;
                                                    }
                                                    ++n6;
                                                }
                                                BCcnTimeScheduleEntry[] bCcnTimeScheduleEntryArray = CcnRspDataUtil.buildTimeSchedules(bCcnPointEntryArray);
                                                ((BCcnDataTableWithTimeSchedule)this).setTimeScheduleList(new BCcnTimeScheduleList(bCcnTimeScheduleEntryArray));
                                            }
                                        }
                                    }
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                    this.ccnTablesLog.error(this.getSummaryString() + "<CcnTable: Ccn table get No." + bCcnProxyExt.getFieldIndex() + " field from block " + by2 + " ERROR: " + exception);
                                }
                            }
                        } else {
                            CcnResponseMessage ccnResponseMessage4 = this.getReadTableResponse(by2);
                            String string4 = new String();
                            string4 = CcnRspFidUtil.getValue(ccnResponseMessage4, bCcnProxyExt);
                            ((BCcnInputProxy)bCcnProxyExt).setValue(string4);
                            if (this.getTableType() == 1283) {
                                BCcnPointEntry bCcnPointEntry = bCcnProxyExt.makePointEntry();
                                bCcnPointEntry.setPointValue(bCcnProxyExt.getFieldValue());
                                BCcnPointEntry[] bCcnPointEntryArray = ((BCcnFidTable)this).getPointList().getPointList();
                                BCcnTimeScheduleEntry[] bCcnTimeScheduleEntryArray = CcnRspFidUtil.buildTimeSchedules(bCcnPointEntryArray);
                                ((BCcnFidTableWithTimeSchedule)this).setTimeScheduleList(new BCcnTimeScheduleList(bCcnTimeScheduleEntryArray));
                            }
                        }
                    } else if (ccnResponseMessage2.getResponseCommand() == 21) {
                        n = 3;
                        switch (ccnResponseMessage2.getResponseCode()) {
                            case 1: {
                                string2 = "Command not implemented.";
                                break;
                            }
                            case 4: {
                                string2 = "Table not defined.";
                                break;
                            }
                            case 9: {
                                string2 = "POC function does not exist.";
                                break;
                            }
                            case 10: {
                                string2 = "Block not defined.";
                                break;
                            }
                            case 16: {
                                string2 = "Access denied.";
                                break;
                            }
                            case 18: {
                                string2 = "Invalid configuration parameter.";
                                break;
                            }
                            default: {
                                string2 = "Unknown error.";
                                break;
                            }
                        }
                    } else {
                        string2 = "Unknown error. Response from write table command is neither 0x15 nor 0x06.";
                        n = 3;
                    }
                } else {
                    string2 = "Unknown error. Response from write table command is null.";
                    n = 2;
                }
            }
            if (string2 != null) {
                this.ccnTablesLog.trace("Write " + this.getCcnDevice().getDeviceName() + '|' + this.getTableName() + '|' + bCcnProxyExt.getName() + '(' + bCcnProxyExt.getVariableNo() + ") with value " + bCcnProxyExt.getFieldValue() + " is unsuccessful.\n" + string2);
            }
        }
        return n == 0;
    }

    public BCcnTableGroup getGroup() {
        BCcnTableGroup bCcnTableGroup = null;
        BComplex bComplex = this.getParent();
        while (bComplex != null) {
            if (bComplex instanceof BCcnTableGroup) {
                bCcnTableGroup = (BCcnTableGroup)bComplex;
                break;
            }
            bComplex = bComplex.getParent();
        }
        return bCcnTableGroup;
    }

    public void addToPointArrays(BCcnProxyExt bCcnProxyExt, int n) {
        if (bCcnProxyExt != null && bCcnProxyExt.getFieldName().length() > 0) {
            this.points[n] = bCcnProxyExt;
            this.recalcCreatedPointsCount();
        }
    }

    public void removeFromPointArrays(int n) {
        this.points[n] = null;
        this.recalcCreatedPointsCount();
    }

    public void updateObject(BCcnPointEntry bCcnPointEntry, int n, int n2) {
    }

    public void updateObject(BCcnPointEntry bCcnPointEntry, int n, int n2, BCcnProxyExt bCcnProxyExt) {
    }

    public void forcePoint(BCcnDevice bCcnDevice, BCcnNetwork bCcnNetwork, BCcnPointEntry bCcnPointEntry, BCcnProxyExt bCcnProxyExt) throws Exception {
    }

    public void autoPoint(BCcnDevice bCcnDevice, BCcnNetwork bCcnNetwork, BCcnPointEntry bCcnPointEntry) {
    }

    public boolean isConfigurationType() {
        int n = this.getTableType();
        boolean bl = false;
        if (n == 16 || n == 19 || n == 20 || n == 22 || n == 1283 || n == 1284 || n == 1285) {
            bl = true;
        }
        return bl;
    }

    public boolean isSetpointType() {
        int n = this.getTableType();
        boolean bl = false;
        if (n == 23 || n == 24) {
            bl = true;
        }
        return bl;
    }

    public void getExistingObjectArray(BComponent bComponent, Vector vector) {
        BComponent[] bComponentArray = bComponent.getChildComponents();
        int n = 0;
        while (n < bComponentArray.length) {
            if (bComponentArray[n] instanceof BCcnProxyExt && !vector.contains(bComponentArray[n])) {
                vector.addElement(bComponentArray[n]);
            }
            this.getExistingObjectArray(bComponentArray[n], vector);
            ++n;
        }
    }

    public BCcnProxyExt[] getCreatedPoints() {
        return this.points;
    }

    public void updatePointList(BCcnTable bCcnTable, BCcnPointEntry bCcnPointEntry) {
        BCcnTable bCcnTable2;
        int n = bCcnPointEntry.getFieldIndex();
        Vector<BCcnPointEntry> vector = new Vector<BCcnPointEntry>();
        BCcnPointEntry[] bCcnPointEntryArray = null;
        if (bCcnTable instanceof BCcnPicTable) {
            bCcnTable2 = (BCcnPicTable)bCcnTable;
            bCcnPointEntryArray = ((BCcnPicTable)bCcnTable2).getPointList().getPointList();
        } else if (bCcnTable instanceof BCcnDataTable) {
            bCcnTable2 = (BCcnDataTable)bCcnTable;
            bCcnPointEntryArray = ((BCcnDataTable)bCcnTable2).getPointList().getPointList();
        } else if (bCcnTable instanceof BCcnFidTable) {
            bCcnTable2 = (BCcnFidTable)bCcnTable;
            bCcnPointEntryArray = ((BCcnFidTable)bCcnTable2).getPointList().getPointList();
        }
        if (bCcnPointEntryArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < bCcnPointEntryArray.length) {
            if (bCcnPointEntryArray[n2].getFieldIndex() < n) {
                vector.addElement(bCcnPointEntryArray[n2]);
            } else if (bCcnPointEntryArray[n2].getFieldIndex() == n) {
                vector.addElement(bCcnPointEntry);
            } else {
                vector.addElement(bCcnPointEntryArray[n2]);
            }
            ++n2;
        }
        BCcnPointEntry[] bCcnPointEntryArray2 = new BCcnPointEntry[vector.size()];
        vector.copyInto((Object[])bCcnPointEntryArray2);
        this.getPointList().setPointList(bCcnPointEntryArray2);
    }

    public CcnResponseMessage getReadTableResponse(int n) {
        int n2 = this.getCcnDevice().getBusNo();
        int n3 = this.getCcnDevice().getElemNo();
        int n4 = this.getTableType();
        int n5 = this.getTableInstance();
        CcnTableDef ccnTableDef = new CcnTableDef((byte)n3, (byte)n2, null, (short)n4, (byte)n5, (byte)n, 0, 0);
        CcnReadTableRequest ccnReadTableRequest = new CcnReadTableRequest(ccnTableDef);
        CcnResponseMessage ccnResponseMessage = this.getCcnDevice().getCcnNetwork().getCcnComm().ccnAsyncRequest().sendAsyncRequest(ccnReadTableRequest);
        return ccnResponseMessage;
    }

    public CcnResponseMessage writeTable(byte[] byArray, byte by) {
        int n = this.getCcnDevice().getBusNo();
        int n2 = this.getCcnDevice().getElemNo();
        int n3 = this.getTableType();
        int n4 = this.getTableInstance();
        CcnTableDef ccnTableDef = new CcnTableDef((byte)n2, (byte)n, null, (short)n3, (byte)n4, by, (byte)byArray.length, 0);
        CcnWriteTableRequest ccnWriteTableRequest = new CcnWriteTableRequest(ccnTableDef, byArray);
        CcnResponseMessage ccnResponseMessage = this.getCcnDevice().getCcnNetwork().getCcnComm().ccnAsyncRequest().sendAsyncRequest(ccnWriteTableRequest);
        return ccnResponseMessage;
    }

    public boolean isFullAccessPermittedByLicense() {
        if (this.isTableTypeRestricted()) {
            return this.getIsEnhancedVersion();
        }
        return true;
    }

    protected boolean isTableTypeRestricted() {
        int n = this.getTableType();
        boolean bl = false;
        if (n == 16 || n == 18 || n == 19 || n == 21 || n == 22) {
            bl = true;
        }
        return bl;
    }

    public BCcnPointList getPointList() {
        return null;
    }

    public void setPointList(BCcnPointList bCcnPointList) {
    }

    public void setPointLearnCount(int n) {
    }

    public String getSummaryString() {
        return this.getType() + '`' + this.getCcnDevice().getName() + '`' + this.getName() + '`';
    }

    public void changePointsDisplay(BCcnProxyExt[] bCcnProxyExtArray) {
        this.ccnTablesLog.trace(this.getSummaryString() + "changePointsDisplay: pointList[" + bCcnProxyExtArray.length + ']' + this.getCurMetricDisplay());
        int n = 0;
        while (n < bCcnProxyExtArray.length) {
            if (bCcnProxyExtArray[n] != null) {
                bCcnProxyExtArray[n].setDisplayType(this.getCurMetricDisplay());
                int n2 = bCcnProxyExtArray[n].getPointDataType();
                if (!(n2 != 1 && n2 != 2 && n2 != 6 && n2 != 7 && n2 != 9 && n2 != 10 && n2 != 17 && n2 != 48 || bCcnProxyExtArray[n].isDiscrete())) {
                    int n3 = BCcnUnitMappingEnum.parseId(bCcnProxyExtArray[n].getUnits(), this.getCurMetricDisplay());
                    bCcnProxyExtArray[n].setUnitsEnum(CcnEnumsUtil.setProperUnitsMappingEnum(n3));
                    if (this.getCurMetricDisplay()) {
                        bCcnProxyExtArray[n].setFieldValue(CcnRspPicPocUtil.toMetric(bCcnProxyExtArray[n].getDisplayDigits(), bCcnProxyExtArray[n].getUnits(), bCcnProxyExtArray[n].getFieldValue()));
                    } else {
                        bCcnProxyExtArray[n].setFieldValue(CcnRspPicPocUtil.toImperial(bCcnProxyExtArray[n].getDisplayDigits(), bCcnProxyExtArray[n].getUnits(), bCcnProxyExtArray[n].getFieldValue()));
                    }
                    String string = bCcnProxyExtArray[n].getLoLimit();
                    String string2 = bCcnProxyExtArray[n].getHiLimit();
                    switch (n2) {
                        case 1: {
                            if (string != null && !string.trim().equals("") && !string.equals("0")) {
                                string = this.getCurMetricDisplay() ? CcnRspPicPocUtil.toMetric(bCcnProxyExtArray[n].getDisplayDigits(), bCcnProxyExtArray[n].getUnits(), string) : CcnRspPicPocUtil.toImperial(bCcnProxyExtArray[n].getDisplayDigits(), bCcnProxyExtArray[n].getUnits(), string);
                            }
                            if (string2 == null || string2.trim().equals("") || string2.equals("255")) break;
                            if (this.getCurMetricDisplay()) {
                                string2 = CcnRspPicPocUtil.toMetric(bCcnProxyExtArray[n].getDisplayDigits(), bCcnProxyExtArray[n].getUnits(), string2);
                                break;
                            }
                            string2 = CcnRspPicPocUtil.toImperial(bCcnProxyExtArray[n].getDisplayDigits(), bCcnProxyExtArray[n].getUnits(), string2);
                            break;
                        }
                        case 2: {
                            if (string != null && !string.trim().equals("") && !string.equals("0")) {
                                string = this.getCurMetricDisplay() ? CcnRspPicPocUtil.toMetric(bCcnProxyExtArray[n].getDisplayDigits(), bCcnProxyExtArray[n].getUnits(), string) : CcnRspPicPocUtil.toImperial(bCcnProxyExtArray[n].getDisplayDigits(), bCcnProxyExtArray[n].getUnits(), string);
                            }
                            if (string2 == null || string2.trim().equals("") || string2.equals("65535")) break;
                            if (this.getCurMetricDisplay()) {
                                string2 = CcnRspPicPocUtil.toMetric(bCcnProxyExtArray[n].getDisplayDigits(), bCcnProxyExtArray[n].getUnits(), string2);
                                break;
                            }
                            string2 = CcnRspPicPocUtil.toImperial(bCcnProxyExtArray[n].getDisplayDigits(), bCcnProxyExtArray[n].getUnits(), string2);
                            break;
                        }
                        case 6: 
                        case 7: 
                        case 48: {
                            if (string != null && !string.trim().equals("") && !string.equals("0")) {
                                string = this.getCurMetricDisplay() ? CcnRspPicPocUtil.toMetric(bCcnProxyExtArray[n].getDisplayDigits(), bCcnProxyExtArray[n].getUnits(), string) : CcnRspPicPocUtil.toImperial(bCcnProxyExtArray[n].getDisplayDigits(), bCcnProxyExtArray[n].getUnits(), string);
                            }
                            if (string2 == null || string2.trim().equals("") || string2.equals("999999.99")) break;
                            if (this.getCurMetricDisplay()) {
                                string2 = CcnRspPicPocUtil.toMetric(bCcnProxyExtArray[n].getDisplayDigits(), bCcnProxyExtArray[n].getUnits(), string2);
                                break;
                            }
                            string2 = CcnRspPicPocUtil.toImperial(bCcnProxyExtArray[n].getDisplayDigits(), bCcnProxyExtArray[n].getUnits(), string2);
                            break;
                        }
                        case 9: {
                            if (string != null && !string.trim().equals("") && !string.equals("-128")) {
                                string = this.getCurMetricDisplay() ? CcnRspPicPocUtil.toMetric(bCcnProxyExtArray[n].getDisplayDigits(), bCcnProxyExtArray[n].getUnits(), string) : CcnRspPicPocUtil.toImperial(bCcnProxyExtArray[n].getDisplayDigits(), bCcnProxyExtArray[n].getUnits(), string);
                            }
                            if (string2 == null || string2.trim().equals("") || string2.equals("127")) break;
                            if (this.getCurMetricDisplay()) {
                                string2 = CcnRspPicPocUtil.toMetric(bCcnProxyExtArray[n].getDisplayDigits(), bCcnProxyExtArray[n].getUnits(), string2);
                                break;
                            }
                            string2 = CcnRspPicPocUtil.toImperial(bCcnProxyExtArray[n].getDisplayDigits(), bCcnProxyExtArray[n].getUnits(), string2);
                            break;
                        }
                        case 10: {
                            if (string != null && !string.trim().equals("") && !string.equals("-32768")) {
                                string = this.getCurMetricDisplay() ? CcnRspPicPocUtil.toMetric(bCcnProxyExtArray[n].getDisplayDigits(), bCcnProxyExtArray[n].getUnits(), string) : CcnRspPicPocUtil.toImperial(bCcnProxyExtArray[n].getDisplayDigits(), bCcnProxyExtArray[n].getUnits(), string);
                            }
                            if (string2 == null || string2.trim().equals("") || string2.equals("32767")) break;
                            if (this.getCurMetricDisplay()) {
                                string2 = CcnRspPicPocUtil.toMetric(bCcnProxyExtArray[n].getDisplayDigits(), bCcnProxyExtArray[n].getUnits(), string2);
                                break;
                            }
                            string2 = CcnRspPicPocUtil.toImperial(bCcnProxyExtArray[n].getDisplayDigits(), bCcnProxyExtArray[n].getUnits(), string2);
                            break;
                        }
                        case 17: {
                            if (string != null && !string.trim().equals("")) {
                                string = this.getCurMetricDisplay() ? CcnRspPicPocUtil.toMetric(bCcnProxyExtArray[n].getDisplayDigits(), bCcnProxyExtArray[n].getUnits(), string) : CcnRspPicPocUtil.toImperial(bCcnProxyExtArray[n].getDisplayDigits(), bCcnProxyExtArray[n].getUnits(), string);
                            }
                            if (string2 == null || string2.trim().equals("")) break;
                            if (this.getCurMetricDisplay()) {
                                string2 = CcnRspPicPocUtil.toMetric(bCcnProxyExtArray[n].getDisplayDigits(), bCcnProxyExtArray[n].getUnits(), string2);
                                break;
                            }
                            string2 = CcnRspPicPocUtil.toImperial(bCcnProxyExtArray[n].getDisplayDigits(), bCcnProxyExtArray[n].getUnits(), string2);
                            break;
                        }
                    }
                    bCcnProxyExtArray[n].setLoLimit(string);
                    bCcnProxyExtArray[n].setHiLimit(string2);
                    this.updateFacetInfo(bCcnProxyExtArray[n], string, string2);
                }
            }
            ++n;
        }
    }

    public BCcnPointEntry[] changePointsDisplayForFID(BCcnPointEntry[] bCcnPointEntryArray) {
        this.ccnTablesLog.trace(this.getSummaryString() + "changePointsDisplay: pointList[" + bCcnPointEntryArray.length + ']' + this.getCurMetricDisplay());
        int n = 0;
        while (n < bCcnPointEntryArray.length) {
            if (bCcnPointEntryArray[n] != null) {
                bCcnPointEntryArray[n].setDisplayType(this.getCurMetricDisplay());
                int n2 = bCcnPointEntryArray[n].getPointDataType();
                if (!(n2 != 1 && n2 != 2 && n2 != 6 && n2 != 7 && n2 != 9 && n2 != 10 && n2 != 17 && n2 != 48 || bCcnPointEntryArray[n].isDiscrete())) {
                    int n3 = BCcnUnitMappingEnum.parseId(bCcnPointEntryArray[n].getUnits(), this.getCurMetricDisplay());
                    bCcnPointEntryArray[n].setUnitsEnum(CcnEnumsUtil.setProperUnitsMappingEnum(n3));
                    if (this.getCurMetricDisplay()) {
                        bCcnPointEntryArray[n].setPointValue(CcnRspPicPocUtil.toMetric(bCcnPointEntryArray[n].getDisplayDigits(), bCcnPointEntryArray[n].getUnits(), bCcnPointEntryArray[n].getPointValue()));
                    } else {
                        bCcnPointEntryArray[n].setPointValue(CcnRspPicPocUtil.toImperial(bCcnPointEntryArray[n].getDisplayDigits(), bCcnPointEntryArray[n].getUnits(), bCcnPointEntryArray[n].getPointValue()));
                    }
                    String string = bCcnPointEntryArray[n].getLoLimit();
                    String string2 = bCcnPointEntryArray[n].getHiLimit();
                    switch (n2) {
                        case 1: {
                            if (string != null && !string.trim().equals("") && !string.equals("0")) {
                                string = this.getCurMetricDisplay() ? CcnRspPicPocUtil.toMetric(bCcnPointEntryArray[n].getDisplayDigits(), bCcnPointEntryArray[n].getUnits(), string) : CcnRspPicPocUtil.toImperial(bCcnPointEntryArray[n].getDisplayDigits(), bCcnPointEntryArray[n].getUnits(), string);
                            }
                            if (string2 == null || string2.trim().equals("") || string2.equals("255")) break;
                            if (this.getCurMetricDisplay()) {
                                string2 = CcnRspPicPocUtil.toMetric(bCcnPointEntryArray[n].getDisplayDigits(), bCcnPointEntryArray[n].getUnits(), string2);
                                break;
                            }
                            string2 = CcnRspPicPocUtil.toImperial(bCcnPointEntryArray[n].getDisplayDigits(), bCcnPointEntryArray[n].getUnits(), string2);
                            break;
                        }
                        case 2: {
                            if (string != null && !string.trim().equals("") && !string.equals("0")) {
                                string = this.getCurMetricDisplay() ? CcnRspPicPocUtil.toMetric(bCcnPointEntryArray[n].getDisplayDigits(), bCcnPointEntryArray[n].getUnits(), string) : CcnRspPicPocUtil.toImperial(bCcnPointEntryArray[n].getDisplayDigits(), bCcnPointEntryArray[n].getUnits(), string);
                            }
                            if (string2 == null || string2.trim().equals("") || string2.equals("65535")) break;
                            if (this.getCurMetricDisplay()) {
                                string2 = CcnRspPicPocUtil.toMetric(bCcnPointEntryArray[n].getDisplayDigits(), bCcnPointEntryArray[n].getUnits(), string2);
                                break;
                            }
                            string2 = CcnRspPicPocUtil.toImperial(bCcnPointEntryArray[n].getDisplayDigits(), bCcnPointEntryArray[n].getUnits(), string2);
                            break;
                        }
                        case 6: 
                        case 7: 
                        case 48: {
                            if (string != null && !string.trim().equals("") && !string.equals("0")) {
                                string = this.getCurMetricDisplay() ? CcnRspPicPocUtil.toMetric(bCcnPointEntryArray[n].getDisplayDigits(), bCcnPointEntryArray[n].getUnits(), string) : CcnRspPicPocUtil.toImperial(bCcnPointEntryArray[n].getDisplayDigits(), bCcnPointEntryArray[n].getUnits(), string);
                            }
                            if (string2 == null || string2.trim().equals("") || string2.equals("999999.99")) break;
                            if (this.getCurMetricDisplay()) {
                                string2 = CcnRspPicPocUtil.toMetric(bCcnPointEntryArray[n].getDisplayDigits(), bCcnPointEntryArray[n].getUnits(), string2);
                                break;
                            }
                            string2 = CcnRspPicPocUtil.toImperial(bCcnPointEntryArray[n].getDisplayDigits(), bCcnPointEntryArray[n].getUnits(), string2);
                            break;
                        }
                        case 9: {
                            if (string != null && !string.trim().equals("") && !string.equals("-128")) {
                                string = this.getCurMetricDisplay() ? CcnRspPicPocUtil.toMetric(bCcnPointEntryArray[n].getDisplayDigits(), bCcnPointEntryArray[n].getUnits(), string) : CcnRspPicPocUtil.toImperial(bCcnPointEntryArray[n].getDisplayDigits(), bCcnPointEntryArray[n].getUnits(), string);
                            }
                            if (string2 == null || string2.trim().equals("") || string2.equals("127")) break;
                            if (this.getCurMetricDisplay()) {
                                string2 = CcnRspPicPocUtil.toMetric(bCcnPointEntryArray[n].getDisplayDigits(), bCcnPointEntryArray[n].getUnits(), string2);
                                break;
                            }
                            string2 = CcnRspPicPocUtil.toImperial(bCcnPointEntryArray[n].getDisplayDigits(), bCcnPointEntryArray[n].getUnits(), string2);
                            break;
                        }
                        case 10: {
                            if (string != null && !string.trim().equals("") && !string.equals("-32768")) {
                                string = this.getCurMetricDisplay() ? CcnRspPicPocUtil.toMetric(bCcnPointEntryArray[n].getDisplayDigits(), bCcnPointEntryArray[n].getUnits(), string) : CcnRspPicPocUtil.toImperial(bCcnPointEntryArray[n].getDisplayDigits(), bCcnPointEntryArray[n].getUnits(), string);
                            }
                            if (string2 == null || string2.trim().equals("") || string2.equals("32767")) break;
                            if (this.getCurMetricDisplay()) {
                                string2 = CcnRspPicPocUtil.toMetric(bCcnPointEntryArray[n].getDisplayDigits(), bCcnPointEntryArray[n].getUnits(), string2);
                                break;
                            }
                            string2 = CcnRspPicPocUtil.toImperial(bCcnPointEntryArray[n].getDisplayDigits(), bCcnPointEntryArray[n].getUnits(), string2);
                            break;
                        }
                        case 17: {
                            if (string != null && !string.trim().equals("")) {
                                string = this.getCurMetricDisplay() ? CcnRspPicPocUtil.toMetric(bCcnPointEntryArray[n].getDisplayDigits(), bCcnPointEntryArray[n].getUnits(), string) : CcnRspPicPocUtil.toImperial(bCcnPointEntryArray[n].getDisplayDigits(), bCcnPointEntryArray[n].getUnits(), string);
                            }
                            if (string2 == null || string2.trim().equals("")) break;
                            if (this.getCurMetricDisplay()) {
                                string2 = CcnRspPicPocUtil.toMetric(bCcnPointEntryArray[n].getDisplayDigits(), bCcnPointEntryArray[n].getUnits(), string2);
                                break;
                            }
                            string2 = CcnRspPicPocUtil.toImperial(bCcnPointEntryArray[n].getDisplayDigits(), bCcnPointEntryArray[n].getUnits(), string2);
                            break;
                        }
                    }
                    bCcnPointEntryArray[n].setLoLimit(string);
                    bCcnPointEntryArray[n].setHiLimit(string2);
                    this.updateFacetInfo(bCcnPointEntryArray[n], string, string2);
                }
                System.out.println("update points from change display::" + bCcnPointEntryArray[n].getPointValue());
            }
            ++n;
        }
        return bCcnPointEntryArray;
    }

    public void updateFacetInfo(BCcnProxyExt bCcnProxyExt, String string, String string2) {
        if (bCcnProxyExt.getParentPoint() instanceof BNumericWritable) {
            ((BCcnNumericWritable)bCcnProxyExt.getParentPoint()).setFacets(BFacets.makeNumeric(null, (BInteger)BInteger.make((int)2), (BNumber)BDouble.make((String)string), (BNumber)BDouble.make((String)string2)));
        }
    }

    public void updateFacetInfo(BCcnPointEntry bCcnPointEntry, String string, String string2) {
        int n;
        BCcnInputProxy bCcnInputProxy = null;
        BCcnProxyExt[] bCcnProxyExtArray = this.getCreatedPoints();
        if (bCcnProxyExtArray[n = bCcnPointEntry.getFieldIndex()] != null && bCcnProxyExtArray[n] instanceof BCcnInputProxy) {
            bCcnInputProxy = (BCcnInputProxy)bCcnProxyExtArray[n];
            if (bCcnInputProxy.getParentPoint() instanceof BNumericWritable) {
                ((BCcnNumericWritable)bCcnInputProxy.getParentPoint()).setFacets(BFacets.makeNumeric(null, (BInteger)BInteger.make((int)2), (BNumber)BDouble.make((String)string), (BNumber)BDouble.make((String)string2)));
            }
            bCcnInputProxy.setValue(bCcnPointEntry.getPointValue());
            bCcnInputProxy.setUnitsEnum(bCcnPointEntry.getUnitsEnum());
        }
    }

    public BIcon getIcon() {
        return this.icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.tGroup = null;
        this.icon = BIcon.make((BOrd)BOrd.make((String)"local:|module://ccn/com/tridium/ccn/images/CcnTable.gif"));
        this.changingDisplay = false;
        this.points = new BCcnProxyExt[64];
        this.createdPointsCount = 0;
        this.ccnTablesLog = Log.getLog((String)"CCNTablesLog");
        this.ccnTimeLog = Log.getLog((String)"CcnPerformanceLog");
        this.ccnSubscribedPointLog = Log.getLog((String)"CcnSubscribedPointsLog");
        this.vPollAttributeProxyExts = new Vector(0);
    }

    public BCcnTable() {
        this.this();
    }

    public BCcnTable(BCcnTableEntry bCcnTableEntry) {
        this.this();
        this.setDuplicateTableName(bCcnTableEntry.getTableName());
    }

    static {
        Class clazz = class$com$tridium$ccn$tables$BCcnTable;
        if (clazz == null) {
            clazz = class$com$tridium$ccn$tables$BCcnTable = BCcnTable.class("[Lcom.tridium.ccn.tables.BCcnTable;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

