/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.tables;

import com.tridium.ccn.BCcnDevice;
import com.tridium.ccn.components.BCcnPointList;
import com.tridium.ccn.components.BCcnTableEntry;
import com.tridium.ccn.job.BCcnAddDataPointsJob;
import com.tridium.ccn.job.BCcnLearnDataPointsJob;
import com.tridium.ccn.messages.CcnResponseMessage;
import com.tridium.ccn.point.BCcnProxyExt;
import com.tridium.ccn.tables.BCcnPicTable;
import com.tridium.ccn.tables.BCcnPocTable;
import com.tridium.ccn.tables.BCcnTable;
import com.tridium.ccn.util.CcnRspDataUtil;
import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BCcnDataTable
extends BCcnTable {
    public static final Property pocTableType = BCcnDataTable.newProperty((int)1, (int)0, null);
    public static final Property dataBlock = BCcnDataTable.newProperty((int)0, (int)0, null);
    public static final Property pointList = BCcnDataTable.newProperty((int)4, (BValue)new BCcnPointList(), null);
    public static final Property pointLearnCount = BCcnDataTable.newProperty((int)1, (int)0, null);
    public static final Property pointCreateCount = BCcnDataTable.newProperty((int)1, (int)0, null);
    public static final Property learnedTimeSchedules = BCcnDataTable.newProperty((int)4, (BValue)new BFolder(), null);
    public static final Action submitDataPointDiscoveryJob = BCcnDataTable.newAction((int)4, null);
    public static final Action submitAddDataPointsJob = BCcnDataTable.newAction((int)4, (BValue)new BCcnPointList(), null);
    public static final Type TYPE;
    BIcon icon;
    private BCcnPocTable tParent;
    BCcnTableEntry entry;
    static /* synthetic */ Class class$com$tridium$ccn$tables$BCcnDataTable;

    public int getPocTableType() {
        return this.getInt(pocTableType);
    }

    public void setPocTableType(int n) {
        this.setInt(pocTableType, n, null);
    }

    public int getDataBlock() {
        return this.getInt(dataBlock);
    }

    public void setDataBlock(int n) {
        this.setInt(dataBlock, n, null);
    }

    public BCcnPointList getPointList() {
        return (BCcnPointList)this.get(pointList);
    }

    public void setPointList(BCcnPointList bCcnPointList) {
        this.set(pointList, (BValue)bCcnPointList, null);
    }

    public int getPointLearnCount() {
        return this.getInt(pointLearnCount);
    }

    public void setPointLearnCount(int n) {
        this.setInt(pointLearnCount, n, null);
    }

    public int getPointCreateCount() {
        return this.getInt(pointCreateCount);
    }

    public void setPointCreateCount(int n) {
        this.setInt(pointCreateCount, n, null);
    }

    public BFolder getLearnedTimeSchedules() {
        return (BFolder)this.get(learnedTimeSchedules);
    }

    public void setLearnedTimeSchedules(BFolder bFolder) {
        this.set(learnedTimeSchedules, (BValue)bFolder, null);
    }

    public BOrd submitDataPointDiscoveryJob() {
        return (BOrd)this.invoke(submitDataPointDiscoveryJob, null, null);
    }

    public BOrd submitAddDataPointsJob(BCcnPointList bCcnPointList) {
        return (BOrd)this.invoke(submitAddDataPointsJob, (BValue)bCcnPointList, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        this.recordPocTableType();
        super.started();
    }

    public void stopped() throws Exception {
        BCcnPocTable bCcnPocTable = this.getParentPoc();
        bCcnPocTable.setDataTableCreateCount(bCcnPocTable.getDataTableCreateCount() - 1);
        super.stopped();
    }

    public BOrd doSubmitDataPointDiscoveryJob() {
        BCcnLearnDataPointsJob bCcnLearnDataPointsJob = new BCcnLearnDataPointsJob(this);
        return bCcnLearnDataPointsJob.submit(null);
    }

    public BOrd doSubmitAddDataPointsJob(BCcnPointList bCcnPointList) {
        BCcnAddDataPointsJob bCcnAddDataPointsJob = new BCcnAddDataPointsJob(this, bCcnPointList);
        return bCcnAddDataPointsJob.submit(null);
    }

    private final void recordPocTableType() {
        int n = this.getParentPoc().getTableType();
        this.setPocTableType(n);
    }

    public boolean isParentLegal(BComponent bComponent) throws LocalizableRuntimeException {
        if (bComponent instanceof BCcnPocTable) {
            return true;
        }
        throw new LocalizableRuntimeException("ccn", "CcnDataTable.Drop");
    }

    public boolean isChildLegal(BComponent bComponent) throws LocalizableRuntimeException {
        if (bComponent instanceof BCcnPicTable || bComponent instanceof BCcnPocTable) {
            throw new LocalizableRuntimeException("ccn", "CcnPicTable and CcnPocTable nodes may not be under a CcnDataTable node");
        }
        return true;
    }

    public BCcnPocTable getParentPoc() {
        if (this.tParent == null) {
            BComplex bComplex = this.getParent();
            while (bComplex != null) {
                if (bComplex instanceof BCcnPocTable) {
                    this.tParent = (BCcnPocTable)bComplex;
                    break;
                }
                bComplex = bComplex.getParent();
            }
        }
        return this.tParent;
    }

    protected boolean isTableTypeRestricted() {
        int n = this.getPocTableType();
        int n2 = this.getTableType();
        boolean bl = false;
        if (n == 21 || n == 22 || n == 20 && n2 != 1556) {
            bl = true;
        }
        return bl;
    }

    public boolean isConfigurationType() {
        int n = this.getPocTableType();
        boolean bl = false;
        if (n == 16 || n == 19 || n == 20 || n == 22) {
            bl = true;
        }
        return bl;
    }

    public boolean isSetpointType() {
        int n = this.getPocTableType();
        boolean bl = false;
        if (n == 23 || n == 24) {
            bl = true;
        }
        return bl;
    }

    public void pollForData() {
        BCcnDevice bCcnDevice = this.getCcnDevice();
        if (this.getCCNNetwork().isDiscoveryInProgress() || !bCcnDevice.isRunning() || this.getCCNNetwork().isChangingDisplay() || this.getPointCreateCount() == 0) {
            return;
        }
        long l = BAbsTime.now().getTimeOfDayMillis();
        if (this.vPollAttributeProxyExts.size() == 0) {
            return;
        }
        this.ccnSubscribedPointLog.trace("Number of subscribed points-->::Device::" + bCcnDevice.getDeviceName() + "::Table-->" + this.getTableName() + " are::" + this.vPollAttributeProxyExts.size());
        CcnResponseMessage ccnResponseMessage = this.getReadTableResponse(this.getDataBlock());
        this.ccnTablesLog.trace(this.getTableName() + " Poll Resposne for tabletype::" + tableType + "is" + (Object)((Object)ccnResponseMessage));
        if (ccnResponseMessage == null) {
            return;
        }
        this.commSuccess(true);
        int n = 0;
        while (n < this.vPollAttributeProxyExts.size()) {
            BCcnProxyExt bCcnProxyExt = (BCcnProxyExt)this.vPollAttributeProxyExts.get(n);
            if (bCcnProxyExt != null) {
                try {
                    CcnRspDataUtil.setProxyReadValue(ccnResponseMessage, bCcnProxyExt.getValueBlockOffset(), bCcnProxyExt);
                }
                catch (Exception exception) {
                    this.ccnTablesLog.error("CcnDataTable poll for data exception::" + exception.getMessage());
                }
            }
            ++n;
        }
        long l2 = BAbsTime.now().getTimeOfDayMillis();
        this.ccnTimeLog.trace("Data Table PollForData Device->" + bCcnDevice.getName() + ", table->" + this.getTableName() + ", polltime::" + (l2 - l) + "milli seconds");
    }

    public BIcon getIcon() {
        return this.icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.icon = BIcon.make((BOrd)BOrd.make((String)"local:|module://ccn/com/tridium/ccn/images/CcnDataTable.gif"));
    }

    public BCcnDataTable() {
        this.this();
    }

    public BCcnDataTable(BCcnTableEntry bCcnTableEntry) {
        this.this();
        this.entry = bCcnTableEntry;
        this.setTableBlockCount(bCcnTableEntry.getBlockCount());
        this.setTableType(bCcnTableEntry.getTableType());
        this.setTableTypeString(bCcnTableEntry.getTableTypeString());
        this.setTableInstance(bCcnTableEntry.getTableInstance());
        this.setTableNum(bCcnTableEntry.getTableNum());
        this.setTableName(bCcnTableEntry.getTableName());
    }

    static {
        Class clazz = class$com$tridium$ccn$tables$BCcnDataTable;
        if (clazz == null) {
            clazz = class$com$tridium$ccn$tables$BCcnDataTable = BCcnDataTable.class("[Lcom.tridium.ccn.tables.BCcnDataTable;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

