/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.messages;

import com.tridium.ccn.BCcnDevice;
import com.tridium.ccn.BCcnNetwork;
import com.tridium.ccn.components.BCcnByteEntry;
import com.tridium.ccn.components.BCcnByteList;
import com.tridium.ccn.components.BCcnTableEntry;
import com.tridium.ccn.exceptions.CcnException;
import com.tridium.ccn.job.BCcnLearnTablesJob;
import com.tridium.ccn.messages.CcnMessageConst;
import com.tridium.ccn.messages.CcnReadTableRequest;
import com.tridium.ccn.messages.CcnResponseMessage;
import com.tridium.ccn.util.AsynchronousRequest;
import com.tridium.ccn.util.CcnRspPicPocUtil;
import com.tridium.ccn.util.CcnRspPocUtil;
import com.tridium.ccn.util.CcnRspTableUtil;
import com.tridium.platCcn.CcnTableDef;
import java.util.Vector;
import javax.baja.job.BJobState;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BValue;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.util.BFolder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CcnLearnDeviceRequest
implements AsynchronousRequest,
CcnMessageConst {
    private BCcnNetwork ccnNetwork;
    private BCcnDevice ccnDevice;
    private BCcnLearnTablesJob job;
    private int maxTableNum;
    private Vector vt;
    int table_type;
    String table_typeString;
    int table_instance;
    int table_num;
    String table_name;
    int table_blockCnt;
    int table_parentTable;
    byte[] table_blkAR;
    int table_pointCnt;
    Log ccnMessageLog;
    static /* synthetic */ Class class$com$tridium$ccn$components$BCcnTableEntry;
    static /* synthetic */ Class class$com$tridium$ccn$components$BCcnByteEntry;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() {
        if (!this.ccnDevice.isDeviceStatusOk()) {
            throw new LocalizableRuntimeException("ccn", "CcnLearnTable.add");
        }
        this.ccnDevice.setLearnStatus("Learn-> Start discovery process... disable deviceStatus and polling");
        try {
            try {
                int n;
                block43: {
                    int n2;
                    int n3;
                    int n4;
                    int n5;
                    block44: {
                        this.vt = new Vector();
                        this.ccnDevice.setTableLearnCount(0);
                        n5 = this.ccnDevice.getBusNo();
                        n4 = this.ccnDevice.getElemNo();
                        this.ccnMessageLog.trace("\n****  learnDeviceTablesRequest... Interrogate device at busNo=" + n5 + ", elemNo=" + n4);
                        this.maxTableNum = this.ccnDevice.getMaxTableNumber();
                        if (this.maxTableNum == 0) {
                            if (!this.ccnDevice.isDeviceFID()) {
                                CcnResponseMessage ccnResponseMessage = this.getBlockDataFromDeviceTable(n5, n4, (char)-1, 1, 1);
                                if (ccnResponseMessage != null && ccnResponseMessage.getResponseCommand() == 6) {
                                    this.maxTableNum = ccnResponseMessage.getTableNumber();
                                }
                                if (this.maxTableNum == 0 && (ccnResponseMessage = this.getBlockDataFromDeviceTable(n5, n4, 255, 1, 1)) != null && ccnResponseMessage.getResponseCommand() == 6) {
                                    this.maxTableNum = ccnResponseMessage.getTableNumber();
                                }
                            }
                            if (this.maxTableNum == 0) {
                                this.maxTableNum = (char)-1;
                            }
                            this.ccnDevice.setMaxTableNumber(this.maxTableNum);
                            this.ccnMessageLog.trace("\n****  learnDeviceTablesRequest... Before starting learn, find maxTableNum for :" + n5 + ',' + n4 + " | maxTableNum set to " + this.maxTableNum);
                        }
                        if (this.ccnDevice.isDeviceFID()) break block44;
                        n3 = 16;
                        n = 67;
                        String string = this.ccnDevice.getPicType();
                        n2 = n3;
                        while (n2 <= n) {
                            boolean bl = false;
                            if (this.job != null) {
                                this.job.progress(100 * n2 / n);
                            }
                            switch (n2) {
                                case 16: {
                                    bl = this.ccnDevice.getLrnUsrCfgPic10();
                                    break;
                                }
                                case 17: {
                                    bl = this.ccnDevice.getLrnStaDspPic11();
                                    break;
                                }
                                case 18: {
                                    bl = this.ccnDevice.getLrnMaintPic12();
                                    break;
                                }
                                case 19: {
                                    if (string.equalsIgnoreCase("64CC") || string.equalsIgnoreCase("125PM")) break;
                                    bl = this.ccnDevice.getLrnSvcCfgPic13();
                                    break;
                                }
                                case 20: {
                                    boolean bl2 = false;
                                    if (this.ccnDevice.getLrnUsrCfgPoc14() || this.ccnDevice.getLrnTimSchDTT614()) {
                                        bl2 = true;
                                    }
                                    bl = bl2;
                                    break;
                                }
                                case 21: {
                                    bl = this.ccnDevice.getLrnMaintPoc15();
                                    break;
                                }
                                case 22: {
                                    if (string.equalsIgnoreCase("64CC") || string.equalsIgnoreCase("125PM")) break;
                                    bl = this.ccnDevice.getLrnSvcCfgPoc16();
                                    break;
                                }
                                case 23: {
                                    bl = this.ccnDevice.getLrnSetPtsPic17();
                                    break;
                                }
                                case 24: {
                                    bl = this.ccnDevice.getLrnSetPtsPoc18();
                                    break;
                                }
                                case 67: {
                                    bl = this.ccnDevice.getLrnAlmHstPic43();
                                    break;
                                }
                            }
                            if (bl) {
                                this.ccnDevice.setLearnStatus("Learn-> process table type " + Integer.toHexString(n2));
                                this.ccnMessageLog.trace("\n****  learnDeviceTablesRequest... Interrogate device:" + n5 + ',' + n4 + " for table type=" + Integer.toHexString(n2));
                                this.interrogateDeviceForTableType(n5, n4, n2);
                            }
                            if (!(this.job == null || this.job.isAlive() && this.job.getJobState() != BJobState.canceled)) {
                                this.ccnDevice.setLearnStatus("Cancelled-> Cancellation requested by user during device learn ->  tabletype:" + Integer.toHexString(n2));
                                this.ccnDevice.setAbort(false);
                                break block43;
                            }
                            ++n2;
                        }
                        break block43;
                    }
                    n3 = 1281;
                    n = 1285;
                    int n6 = n3;
                    while (n6 <= n) {
                        block45: {
                            n2 = 0;
                            if (this.job != null) {
                                this.job.progress(100 * n6 / n);
                            }
                            switch (n6) {
                                case 1281: {
                                    n2 = this.ccnDevice.getLrnStaDspTT500() ? 1 : 0;
                                    break;
                                }
                                case 1282: {
                                    break block45;
                                }
                                case 1283: {
                                    n2 = this.ccnDevice.getLrnTimSchTT503() ? 1 : 0;
                                    break;
                                }
                                case 1284: {
                                    n2 = this.ccnDevice.getLrnSetPtsTT504() ? 1 : 0;
                                    break;
                                }
                                case 1285: {
                                    n2 = this.ccnDevice.getLrnHolSchTT505() ? 1 : 0;
                                }
                            }
                            if (n2 != 0) {
                                this.ccnDevice.setLearnStatus("Learn-> process table type " + Integer.toHexString(n6));
                                this.ccnMessageLog.trace("\n****  learnDeviceTablesRequest... Interrogate device:" + n5 + ',' + n4 + " for table type=" + Integer.toHexString(n6));
                                this.interrogateDeviceForTableType(n5, n4, n6);
                            }
                            if (!(this.job == null || this.job.isAlive() && this.job.getJobState() != BJobState.canceled)) {
                                this.ccnDevice.setLearnStatus("Cancelled-> Cancellation requested by user during device learn ->  tabletype:" + Integer.toHexString(n6));
                                this.ccnDevice.setAbort(false);
                                break;
                            }
                        }
                        ++n6;
                    }
                }
                this.ccnMessageLog.trace("\n****  learnDeviceTablesRequest... closing out learn: vt= " + this.vt.size());
                if (!(this.job == null || this.job.isAlive() && this.job.getJobState() != BJobState.canceled)) {
                    this.ccnDevice.setLearnStatus("Cancelled-> assembling Table list");
                    this.ccnDevice.setAbort(false);
                }
                if (this.vt.size() == 0) {
                    this.ccnDevice.setLearnStatus("Learn-> Assembling Table list-> No Tables found ");
                    this.ccnDevice.setTableLearnCount(0);
                } else {
                    BCcnTableEntry[] bCcnTableEntryArray = new BCcnTableEntry[this.vt.size()];
                    this.vt.copyInto((Object[])bCcnTableEntryArray);
                    this.ccnDevice.getLearnedTables().removeAll();
                    n = 0;
                    while (n < bCcnTableEntryArray.length) {
                        this.addLearnedTable(bCcnTableEntryArray[n]);
                        ++n;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            Object var2_13 = null;
            this.ccnDevice.setLearnStatus("Learn-> Complete");
            this.ccnDevice.setLearnStatus("Idle");
            throw throwable;
        }
        {
            Object var2_14 = null;
            this.ccnDevice.setLearnStatus("Learn-> Complete");
            this.ccnDevice.setLearnStatus("Idle");
            return;
        }
    }

    void addLearnedTable(BCcnTableEntry bCcnTableEntry) {
        boolean bl = false;
        BFolder bFolder = this.ccnDevice.getLearnedTables();
        Class clazz = class$com$tridium$ccn$components$BCcnTableEntry;
        if (clazz == null) {
            clazz = class$com$tridium$ccn$components$BCcnTableEntry = CcnLearnDeviceRequest.class("[Lcom.tridium.ccn.components.BCcnTableEntry;", false);
        }
        BCcnTableEntry[] bCcnTableEntryArray = (BCcnTableEntry[])bFolder.getChildren(clazz);
        int n = 0;
        while (n < bCcnTableEntryArray.length) {
            if (bCcnTableEntryArray[n].getTableName().equalsIgnoreCase(bCcnTableEntry.getTableName()) && bCcnTableEntryArray[n].getTableNum() == bCcnTableEntry.getTableNum() && bCcnTableEntryArray[n].getTableInstance() == bCcnTableEntry.getTableInstance() && bCcnTableEntryArray[n].getTableType() == bCcnTableEntry.getTableType() && bCcnTableEntryArray[n].getTableTypeString().equalsIgnoreCase(bCcnTableEntry.getTableTypeString())) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            this.ccnDevice.getLearnedTables().add(SlotPath.escape((String)(bCcnTableEntry.getTableName().trim() + '_' + bCcnTableEntry.getTableType() + '_' + bCcnTableEntry.getTableNum() + '_' + bCcnTableEntry.getTableInstance())), (BValue)bCcnTableEntry);
        }
    }

    void addByteArray(String string, BCcnByteEntry bCcnByteEntry) {
        boolean bl = false;
        BFolder bFolder = this.ccnDevice.getLearnedTables();
        Class clazz = class$com$tridium$ccn$components$BCcnByteEntry;
        if (clazz == null) {
            clazz = class$com$tridium$ccn$components$BCcnByteEntry = CcnLearnDeviceRequest.class("[Lcom.tridium.ccn.components.BCcnByteEntry;", false);
        }
        BCcnByteEntry[] bCcnByteEntryArray = (BCcnByteEntry[])bFolder.getChildren(clazz);
        int n = 0;
        while (n < bCcnByteEntryArray.length) {
            if (bCcnByteEntryArray[n].getIndex() == bCcnByteEntry.getIndex()) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            this.ccnDevice.getLearnedTables().add(string + bCcnByteEntry.getIndex(), (BValue)bCcnByteEntry);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void interrogateDeviceForTableType(int var1_1, int var2_2, int var3_3) {
        block28: {
            var5_4 = 1;
            if (this.ccnDevice.isDeviceFID()) break block28;
            var6_5 = false;
            var7_7 = false;
            var8_9 = false;
            block11: while (true) {
                block29: {
                    if (var6_5) {
                        this.ccnDevice.setTableLearnCount(this.vt.size());
                        return;
                    }
                    this.ccnMessageLog.trace("<CcnLearnDeviceRequest: bus:elem:tt:ti:blk " + var1_1 + '|' + var2_2 + '|' + Integer.toHexString(var3_3) + '|' + var5_4 + "|1|");
                    this.ccnDevice.setLearnStatus("Learn-> process table type " + var3_3 + " tableInstance " + var5_4);
                    var4_11 = this.getBlockDataFromDeviceTable(var1_1, var2_2, var3_3, var5_4, 1);
                    if (var4_11 != null) {
                        this.ccnMessageLog.trace("<CcnLearnDeviceRequest: rsp: " + (Object)var4_11 + " | " + var4_11.getResponseCommand());
                    }
                    if (var4_11 == null || var4_11.getResponseCommand() != 6) {
                        this.checkFor0x614DataTable(var1_1, var2_2, var7_7, var8_9);
                        var6_5 = true;
                        continue;
                    }
                    if (var4_11.getResponseCommand() == 6 && this.maxTableNum != 0 && var4_11.getTableNumber() > this.maxTableNum) {
                        this.ccnMessageLog.trace("<CcnLearnDeviceRequest: maxTableNum= " + this.maxTableNum + " exceeded: bus:elem:tt:ti:blk " + var1_1 + '|' + var2_2 + '|' + Integer.toHexString(var3_3) + '|' + var5_4 + '|');
                        this.checkFor0x614DataTable(var1_1, var2_2, var7_7, var8_9);
                        var6_5 = true;
                        continue;
                    }
                    var9_13 = false;
                    if (var3_3 != 20) break block29;
                    var7_7 = true;
                    var10_15 = false;
                    try {
                        try {
                            var13_19 = this.getBlockDataFromDeviceTable(var1_1, var2_2, 20, var5_4, 6);
                            if (var13_19 != null && var13_19.getResponseCommand() == 6 && CcnRspPocUtil.getDataTableType(var13_19) == 1556) {
                                var8_9 = true;
                                var9_13 = true;
                            } else if (!this.ccnDevice.getIsEnhancedVersion()) {
                                var10_15 = true;
                            }
                        }
                        catch (CcnException var13_20) {
                            this.ccnMessageLog.error("<CcnLearnDeviceRequest: ERROR: " + (Object)var13_20);
                            var10_15 = true;
                        }
                    }
                    catch (Throwable var11_17) {
                        v0 = var12_18 = null;
lbl45:
                        // 2 sources

                        while (true) {
                            if (!var9_13 && !this.ccnDevice.getLrnUsrCfgPoc14()) {
                                var10_15 = true;
                            }
                            if (!var10_15) {
                                // JSR Ret
                            }
                            ++var5_4;
                            continue block11;
                            break;
                        }
                    }
                    {
                        v0 = null;
                        ** continue;
                    }
                }
                var10_16 = this.convertBlockDataToTableData(var4_11, var3_3, var5_4);
                if (var9_13) {
                    var10_16.setTableTypeString("Time_Schedules");
                }
                if (var10_16 != null) {
                    this.vt.addElement(new BCcnTableEntry(var10_16));
                }
                ++var5_4;
            }
        }
        var6_6 = 1;
        var7_8 = 1;
        switch (var3_3) {
            case 1281: {
                break;
            }
            case 1283: {
                var6_6 = 16;
                var7_8 = 2;
                break;
            }
            case 1284: {
                var6_6 = 12;
                var7_8 = 2;
                break;
            }
            case 1285: {
                var7_8 = 2;
                break;
            }
            default: {
                return;
            }
        }
        var8_10 = var5_4;
        while (var8_10 <= var6_6) {
            this.ccnMessageLog.trace("<CcnLearnDeviceRequest FID: bus:elem:tt:ti:blk " + var1_1 + '|' + var2_2 + '|' + Integer.toHexString(var3_3) + '|' + var8_10 + '|' + var7_8 + '|');
            this.ccnDevice.setLearnStatus("Learn-> process FID table type " + Integer.toHexString(var3_3) + " tableInstance " + var5_4);
            var4_12 = this.getBlockDataFromDeviceTable(var1_1, var2_2, var3_3, var8_10, var7_8);
            if (var4_12 != null) {
                this.ccnMessageLog.trace("<CcnLearnDeviceRequest FID: rsp: " + (Object)var4_12 + " | " + var4_12.getResponseCommand());
            }
            if (var4_12 == null || var4_12.getResponseCommand() != 6) {
                this.ccnMessageLog.trace("<CcnLearnDeviceRequest FID: responseCommand: " + var4_12.getResponseCommand() + "\nresponseBuffer: " + new String(var4_12.getResponseBuffer().getResponseData()));
                break;
            }
            var9_14 = this.convertBlockDataToTableData(var4_12, var3_3, var8_10);
            this.ccnMessageLog.trace("<CcnLearnDeviceRequest FID: newEntry: " + (Object)var9_14);
            if (var9_14 != null) {
                this.vt.addElement(new BCcnTableEntry(var9_14));
            }
            ++var8_10;
        }
        this.ccnDevice.setTableLearnCount(this.vt.size());
    }

    private final void checkFor0x614DataTable(int n, int n2, boolean bl, boolean bl2) {
        if (bl && !bl2) {
            CcnResponseMessage ccnResponseMessage = this.getBlockDataFromDeviceTable(n, n2, 1556, 1, 1);
            if (ccnResponseMessage == null) {
                this.ccnMessageLog.trace("<CcnLearnDeviceRequest: test for 0x614... dtrsp: " + (Object)((Object)ccnResponseMessage));
            } else {
                this.ccnMessageLog.trace("<CcnLearnDeviceRequest: test for 0x614... responseCommand: " + ccnResponseMessage.getResponseCommand() + "\nresponseBuffer: " + new String(ccnResponseMessage.getResponseBuffer().getResponseData()));
            }
            if (ccnResponseMessage != null && ccnResponseMessage.getResponseCommand() == 6) {
                BCcnTableEntry bCcnTableEntry = new BCcnTableEntry(20, "Time_Schedules", 1, 0, "SPSCHPOC", 2, 0, null, 25);
                this.ccnMessageLog.trace("<CcnLearnDeviceRequest: specialEntry: " + (Object)((Object)bCcnTableEntry));
                this.vt.addElement(new BCcnTableEntry(bCcnTableEntry));
            }
        }
    }

    private final BCcnTableEntry convertBlockDataToTableData(CcnResponseMessage ccnResponseMessage, int n, int n2) {
        if (!this.ccnDevice.isDeviceFID()) {
            BCcnTableEntry bCcnTableEntry = new BCcnTableEntry();
            try {
                bCcnTableEntry.setTableType(CcnRspTableUtil.getTableType(ccnResponseMessage));
                bCcnTableEntry.setTableTypeString(CcnRspPicPocUtil.getTableTypeString(bCcnTableEntry.getTableType()));
                bCcnTableEntry.setTableInstance(n2);
                int n3 = ccnResponseMessage.getTableNumber();
                bCcnTableEntry.setTableNum(n3);
                String string = CcnRspTableUtil.getTableName(ccnResponseMessage).trim();
                bCcnTableEntry.setTableName(CcnRspTableUtil.getTableName(ccnResponseMessage).trim());
                int n4 = CcnRspTableUtil.getBlockCount(ccnResponseMessage);
                bCcnTableEntry.setBlockCount(n4);
                BCcnByteEntry[] bCcnByteEntryArray = new BCcnByteEntry[n4];
                BCcnByteList bCcnByteList = new BCcnByteList();
                int n5 = 0;
                while (n5 < n4) {
                    bCcnByteEntryArray[n5] = new BCcnByteEntry();
                    bCcnByteEntryArray[n5].setIndex(n5 + 1);
                    bCcnByteEntryArray[n5].setValue(CcnRspTableUtil.getBlockAccessRights(ccnResponseMessage, n5 + 1));
                    if (bCcnByteList.get("index" + n3 + bCcnByteEntryArray[n5].getIndex()) == null) {
                        bCcnByteList.add("index" + n3 + bCcnByteEntryArray[n5].getIndex(), (BValue)bCcnByteEntryArray[n5]);
                    }
                    ++n5;
                }
                if (this.ccnDevice.getTableAccessRights().get(SlotPath.escape((String)string) + n3) == null) {
                    this.ccnDevice.getTableAccessRights().add(SlotPath.escape((String)string) + n3, (BValue)bCcnByteList);
                }
                if ((n5 = CcnRspTableUtil.getPointCount(ccnResponseMessage)) == 0) {
                    return null;
                }
                bCcnTableEntry.setPointCount(n5);
            }
            catch (CcnException ccnException) {
                ccnException.printStackTrace();
                this.ccnMessageLog.error("<CcnLearnDeviceRequest: ERROR: " + (Object)((Object)ccnException));
            }
            return bCcnTableEntry;
        }
        BCcnTableEntry bCcnTableEntry = new BCcnTableEntry();
        try {
            bCcnTableEntry.setTableType(n);
            bCcnTableEntry.setTableTypeString(CcnRspTableUtil.getTableTypeString(n));
            bCcnTableEntry.setTableInstance(n2);
            bCcnTableEntry.setTableNum(0);
            switch (n) {
                case 1281: {
                    bCcnTableEntry.setTableName(new String("IO_Points"));
                    bCcnTableEntry.setBlockCount(6);
                    byte[] byArray = new byte[]{1, 1, 2, 3, 3, 1, 4, 1, 5, 1, 6, 3};
                    this.setBlockAccessRightsForFIDTable(byArray, 6, n, bCcnTableEntry.getTableName());
                    bCcnTableEntry.setPointCount(64);
                    break;
                }
                case 1283: {
                    bCcnTableEntry.setTableName("TST" + n2);
                    bCcnTableEntry.setBlockCount(3);
                    byte[] byArray = new byte[6];
                    byArray[0] = 1;
                    byArray[2] = 2;
                    byArray[3] = 3;
                    byArray[4] = 3;
                    byArray[5] = 1;
                    byte[] byArray2 = byArray;
                    this.setBlockAccessRightsForFIDTable(byArray2, 3, n, bCcnTableEntry.getTableName());
                    bCcnTableEntry.setPointCount(21);
                    break;
                }
                case 1284: {
                    bCcnTableEntry.setTableName("SP" + n2);
                    bCcnTableEntry.setBlockCount(2);
                    byte[] byArray = new byte[4];
                    byArray[0] = 1;
                    byArray[2] = 2;
                    byArray[3] = 3;
                    byte[] byArray3 = byArray;
                    this.setBlockAccessRightsForFIDTable(byArray3, 2, n, bCcnTableEntry.getTableName());
                    bCcnTableEntry.setPointCount(4);
                    break;
                }
                case 1285: {
                    bCcnTableEntry.setTableName("HO" + n2);
                    bCcnTableEntry.setBlockCount(2);
                    byte[] byArray = new byte[4];
                    byArray[0] = 1;
                    byArray[2] = 2;
                    byArray[3] = 3;
                    byte[] byArray4 = byArray;
                    this.setBlockAccessRightsForFIDTable(byArray4, 2, n, bCcnTableEntry.getTableName());
                    bCcnTableEntry.setPointCount(60);
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        catch (Exception exception) {
            this.ccnMessageLog.error("<CcnLearnDeviceRequest FID: ERROR: " + exception);
        }
        return bCcnTableEntry;
    }

    private final void setBlockAccessRightsForFIDTable(byte[] byArray, int n, int n2, String string) {
        BCcnByteEntry[] bCcnByteEntryArray = new BCcnByteEntry[n];
        BCcnByteList bCcnByteList = new BCcnByteList();
        int n3 = 0;
        while (n3 < n) {
            bCcnByteEntryArray[n3] = new BCcnByteEntry();
            bCcnByteEntryArray[n3].setIndex(n3 + 1);
            bCcnByteEntryArray[n3].setValue(byArray[(n3 + 1) * 2 - 1]);
            if (bCcnByteList.get("index" + n2 + bCcnByteEntryArray[n3].getIndex()) == null) {
                bCcnByteList.add("index" + n2 + bCcnByteEntryArray[n3].getIndex(), (BValue)bCcnByteEntryArray[n3]);
            }
            ++n3;
        }
        if (this.ccnDevice.getTableAccessRights().get(SlotPath.escape((String)string) + n2) == null) {
            this.ccnDevice.getTableAccessRights().add(SlotPath.escape((String)string) + n2, (BValue)bCcnByteList);
        }
    }

    private final CcnResponseMessage getBlockDataFromDeviceTable(int n, int n2, int n3, int n4, int n5) {
        this.ccnMessageLog.trace("<getBlockDataFromDeviceTable: " + n3 + " | " + (short)n3 + " | " + Integer.toHexString(n3));
        CcnResponseMessage ccnResponseMessage = null;
        int n6 = 0;
        while (n6 < 3) {
            CcnReadTableRequest ccnReadTableRequest = new CcnReadTableRequest(new CcnTableDef((byte)n2, (byte)n, null, (short)n3, (byte)n4, (byte)n5, 0, 0));
            ccnResponseMessage = this.ccnNetwork.getCcnComm().ccnAsyncRequest().sendAsyncRequest(ccnReadTableRequest);
            if (ccnResponseMessage != null) break;
            ++n6;
        }
        if (ccnResponseMessage != null) {
            this.ccnMessageLog.trace("\n****  learnDeviceTablesRequest... return from block read, device:" + n + ',' + n2 + " for table=" + Integer.toHexString(n3) + ',' + n4 + " curBlock=" + n5 + " blockLen=" + ccnResponseMessage.getBlockLen());
        }
        return ccnResponseMessage;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.ccnMessageLog = Log.getLog((String)"CCNMessagesLog");
    }

    public CcnLearnDeviceRequest(BCcnDevice bCcnDevice, BCcnLearnTablesJob bCcnLearnTablesJob) {
        this.this();
        this.ccnDevice = bCcnDevice;
        this.ccnNetwork = bCcnDevice.getCcnNetwork();
        this.job = bCcnLearnTablesJob;
    }

    public CcnLearnDeviceRequest(BCcnDevice bCcnDevice) {
        this.this();
        this.ccnDevice = bCcnDevice;
        this.ccnNetwork = bCcnDevice.getCcnNetwork();
    }
}

