/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.messages;

import com.tridium.ccn.BCcnDevice;
import com.tridium.ccn.BCcnNetwork;
import com.tridium.ccn.enums.BCcnBaudRateEnum;
import com.tridium.ccn.exceptions.CcnException;
import com.tridium.ccn.messages.CcnMessageConst;
import com.tridium.ccn.messages.CcnReadTableRequest;
import com.tridium.ccn.messages.CcnResponseMessage;
import com.tridium.ccn.util.AsynchronousRequest;
import com.tridium.ccn.util.CcnRspDevUtil;
import com.tridium.platCcn.CcnTableDef;
import javax.baja.log.Log;
import javax.baja.sys.LocalizableRuntimeException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CcnFetchDeviceDataRequest
implements CcnMessageConst,
AsynchronousRequest {
    BCcnDevice dev;
    BCcnNetwork network;
    int controllerNum;
    int busNum;
    Log ccnMessageLog;

    public void fetchBlock3() throws CcnException {
        CcnReadTableRequest ccnReadTableRequest = new CcnReadTableRequest(new CcnTableDef((byte)this.controllerNum, (byte)this.busNum, null, 32, 1, 3, 0, 0));
        CcnResponseMessage ccnResponseMessage = this.network.getCcnComm().ccnAsyncRequest().sendAsyncRequest(ccnReadTableRequest);
        if (ccnResponseMessage == null) {
            throw new CcnException(6488177);
        }
        if (ccnResponseMessage.getResponseCommand() == 21) {
            return;
        }
        if (ccnResponseMessage.getResponseCommand() == 6) {
            try {
                this.dev.setPrimaryBaudRate(BCcnBaudRateEnum.make(CcnRspDevUtil.getPrimaryBaudRate(ccnResponseMessage)));
                this.dev.setSecondaryBaudRate(BCcnBaudRateEnum.make(CcnRspDevUtil.getSecondaryBaudRate(ccnResponseMessage)));
            }
            catch (CcnException ccnException) {
                this.ccnMessageLog.error("<CcnFetchDeviceDataRequest, fetchBlock3: ERROR: " + (Object)((Object)ccnException));
            }
        }
    }

    public void fetchBlock4() throws CcnException {
        CcnReadTableRequest ccnReadTableRequest = new CcnReadTableRequest(new CcnTableDef((byte)this.controllerNum, (byte)this.busNum, null, 32, 1, 4, 0, 0));
        CcnResponseMessage ccnResponseMessage = this.network.getCcnComm().ccnAsyncRequest().sendAsyncRequest(ccnReadTableRequest);
        if (ccnResponseMessage == null || ccnResponseMessage.getResponseCommand() != 6) {
            throw new CcnException(6488177);
        }
        try {
            this.dev.setDeviceDescription(CcnRspDevUtil.getDevDesc(ccnResponseMessage).trim());
            this.dev.setLocation(CcnRspDevUtil.getLocDesc(ccnResponseMessage).trim());
            this.dev.setPartNo(CcnRspDevUtil.getSwPartNum(ccnResponseMessage).trim());
            this.dev.setModelNo(CcnRspDevUtil.getModelNum(ccnResponseMessage).trim());
            this.dev.setSerialNo(CcnRspDevUtil.getSerialNum(ccnResponseMessage).trim());
            this.dev.setReferenceNo(CcnRspDevUtil.getReferenceNum(ccnResponseMessage).trim());
        }
        catch (CcnException ccnException) {
            this.ccnMessageLog.error("<CcnFetchDeviceDataRequest, fetchBlock4: ERROR: " + (Object)((Object)ccnException));
        }
    }

    public void fetchBlock6() throws CcnException {
        CcnReadTableRequest ccnReadTableRequest = new CcnReadTableRequest(new CcnTableDef((byte)this.controllerNum, (byte)this.busNum, null, 32, 1, 6, 0, 0));
        CcnResponseMessage ccnResponseMessage = this.network.getCcnComm().ccnAsyncRequest().sendAsyncRequest(ccnReadTableRequest);
        if (ccnResponseMessage == null || ccnResponseMessage.getResponseCommand() != 6) {
            throw new CcnException(6488177);
        }
        try {
            this.dev.setPlatformNo(CcnRspDevUtil.getPlatformId(ccnResponseMessage).trim());
            this.dev.setOsVersion(CcnRspDevUtil.getPICExecSWVerNum(ccnResponseMessage).trim());
            this.dev.setPicType(CcnRspDevUtil.getPICType(ccnResponseMessage).trim());
            if (!CcnRspDevUtil.getPICType(ccnResponseMessage).equalsIgnoreCase("203UC") && !CcnRspDevUtil.getPICType(ccnResponseMessage).equalsIgnoreCase("201X")) {
                this.ccnMessageLog.trace("<CcnFetchDeviceDataRequest: PICApplSwVerNum: " + CcnRspDevUtil.getPICApplSwVerNum(ccnResponseMessage));
                this.dev.setApplicationVersion(CcnRspDevUtil.getPICApplSwVerNum(ccnResponseMessage).trim());
            }
            if (this.dev.isDeviceFID()) {
                this.dev.setFlags(this.dev.getSlot("userConfiguration"), 4);
                this.dev.setFlags(this.dev.getSlot("maintenance"), 4);
                this.dev.setFlags(this.dev.getSlot("serviceConfiguration"), 4);
                this.dev.setFlags(this.dev.getSlot("alarmHistory"), 4);
            }
        }
        catch (CcnException ccnException) {
            this.ccnMessageLog.error("<CcnFetchDeviceDataRequest, fetchBlock6: ERROR: " + (Object)((Object)ccnException));
        }
    }

    public void execute() {
        if (!this.dev.isDeviceStatusOk()) {
            throw new LocalizableRuntimeException("ccn", "CcnDevice.Fetch");
        }
        try {
            this.fetchBlock3();
            this.fetchBlock4();
            this.fetchBlock6();
        }
        catch (Exception exception) {
            this.ccnMessageLog.error("<CcnFetchDeviceDataRequest: ERROR: " + exception);
            exception.printStackTrace();
        }
    }

    private final /* synthetic */ void this() {
        this.ccnMessageLog = Log.getLog((String)"CCNMessagesLog");
    }

    public CcnFetchDeviceDataRequest(BCcnDevice bCcnDevice, BCcnNetwork bCcnNetwork) {
        this(bCcnDevice, bCcnNetwork, bCcnDevice.getElemNo(), bCcnDevice.getBusNo());
    }

    public CcnFetchDeviceDataRequest(BCcnDevice bCcnDevice, BCcnNetwork bCcnNetwork, int n, int n2) {
        this.this();
        this.dev = bCcnDevice;
        this.network = bCcnNetwork;
        this.controllerNum = n;
        this.busNum = n2;
    }
}

