/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.messages;

import com.tridium.ccn.BCcnDevice;
import com.tridium.ccn.components.BCcnAlarmHistoryEntry;
import com.tridium.ccn.components.BCcnAlarmHistoryList;
import com.tridium.ccn.exceptions.CcnException;
import com.tridium.ccn.exceptions.CcnRuntimeException;
import com.tridium.ccn.job.BCcnAlarmHistoryJob;
import com.tridium.ccn.messages.CcnMessageConst;
import com.tridium.ccn.messages.CcnReadTableRequest;
import com.tridium.ccn.messages.CcnResponseMessage;
import com.tridium.ccn.tables.BCcnAHTable;
import com.tridium.ccn.util.AsynchronousRequest;
import com.tridium.ccn.util.CcnAlarmUtil;
import com.tridium.ccn.util.CcnRspTableUtil;
import com.tridium.platCcn.CcnTableDef;
import java.util.Vector;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BValue;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.util.BFolder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CcnAlarmHistoryRequest
implements AsynchronousRequest,
CcnMessageConst {
    private BCcnDevice device;
    private Vector alarmVector;
    private BCcnAHTable ccnAHTable;
    private BCcnAlarmHistoryJob job;
    private int busNo;
    private int elemNo;
    private int tableType;
    private int tableInstance;
    Log ccnMessageLog;
    static /* synthetic */ Class class$com$tridium$ccn$components$BCcnAlarmHistoryEntry;

    public void execute() {
        if (!this.device.isDeviceStatusOk()) {
            throw new LocalizableRuntimeException("ccn", "Device is out of service.Cannot discover the alarms");
        }
        this.ccnAHTable.setLearnStatus("Polling for table header....");
        this.busNo = this.device.getBusNo();
        this.elemNo = this.device.getElemNo();
        this.ccnMessageLog.trace("...Getting alarm count from busNo= " + this.busNo + ", elemNo= " + this.elemNo);
        int n = this.getAlarmHistoryCount();
        int n2 = n - 2;
        if (n == -1) {
            this.ccnAHTable.setLearnStatus("ERROR: Unable to determine number of alarms");
            this.ccnAHTable.setAlarmCount(0);
            BCcnAlarmHistoryList bCcnAlarmHistoryList = new BCcnAlarmHistoryList();
            this.ccnAHTable.setAlarmHistoryList(bCcnAlarmHistoryList);
            return;
        }
        if (n2 == 0) {
            this.ccnAHTable.setLearnStatus("No alarms");
            this.ccnAHTable.setAlarmCount(0);
            BCcnAlarmHistoryList bCcnAlarmHistoryList = new BCcnAlarmHistoryList();
            this.ccnAHTable.setAlarmHistoryList(bCcnAlarmHistoryList);
            return;
        }
        this.ccnAHTable.setAlarmCount(n2);
        this.alarmVector = new Vector();
        int n3 = 0;
        while (n3 < n2) {
            this.job.progress((100 * n3 + 1) / (n2 + 1));
            this.ccnAHTable.setLearnStatus("Learning alarm " + (n3 + 1) + " of " + n2);
            BCcnAlarmHistoryEntry bCcnAlarmHistoryEntry = this.getAlarmHistoryEntry(n3 + 3);
            if (!bCcnAlarmHistoryEntry.getAlarmTextSummary().startsWith("error") && !bCcnAlarmHistoryEntry.getAlarmTextSummary().endsWith("error")) {
                this.alarmVector.addElement(bCcnAlarmHistoryEntry);
            }
            ++n3;
        }
        if (this.alarmVector.size() > 0) {
            BCcnAlarmHistoryEntry[] bCcnAlarmHistoryEntryArray = new BCcnAlarmHistoryEntry[this.alarmVector.size()];
            this.alarmVector.copyInto((Object[])bCcnAlarmHistoryEntryArray);
            BCcnAlarmHistoryList bCcnAlarmHistoryList = new BCcnAlarmHistoryList(bCcnAlarmHistoryEntryArray);
            int n4 = 0;
            while (n4 < bCcnAlarmHistoryEntryArray.length) {
                this.addLearnedAlarm(bCcnAlarmHistoryEntryArray[n4]);
                ++n4;
            }
            this.ccnAHTable.setAlarmCount(this.alarmVector.size());
        } else {
            BCcnAlarmHistoryList bCcnAlarmHistoryList = new BCcnAlarmHistoryList();
            this.ccnAHTable.setAlarmHistoryList(bCcnAlarmHistoryList);
            this.ccnAHTable.setAlarmCount(0);
        }
    }

    private final int getAlarmHistoryCount() {
        CcnResponseMessage ccnResponseMessage = this.getBlockDataFromAlarmTable(1);
        if (ccnResponseMessage == null) {
            this.ccnAHTable.setLearnStatus("ERROR: no response to alarm count request...");
            return -1;
        }
        if ((ccnResponseMessage.getResponseCommand() & 0xFF) == 21) {
            int n = ccnResponseMessage.getResponseCode() & 0xFF;
            if (n == 1) {
                this.ccnAHTable.setLearnStatus("ERROR: command not implemented");
            } else if (n == 4) {
                this.ccnAHTable.setLearnStatus("ERROR: table does not exist");
            } else if (n == 10) {
                this.ccnAHTable.setLearnStatus("ERROR: block not defined");
            } else if (n == 16) {
                this.ccnAHTable.setLearnStatus("ERROR: access denied");
            } else {
                this.ccnAHTable.setLearnStatus("ERROR: unknown error " + n);
            }
            return -1;
        }
        try {
            return CcnRspTableUtil.getBlockCount(ccnResponseMessage) & 0xFF;
        }
        catch (CcnException ccnException) {
            this.ccnMessageLog.error("error parsing alarm history table header");
            this.ccnAHTable.setLearnStatus("ERROR Learn: error in response to alarm count request...");
            return -1;
        }
    }

    private final BCcnAlarmHistoryEntry getAlarmHistoryEntry(int n) throws CcnRuntimeException {
        CcnResponseMessage ccnResponseMessage = this.getBlockDataFromAlarmTable(n);
        if (ccnResponseMessage == null) {
            this.ccnAHTable.setLearnStatus("ERROR Learn: no response to alarm history entry " + n);
            return new BCcnAlarmHistoryEntry("error, block " + n, "no response");
        }
        if ((ccnResponseMessage.getResponseCommand() & 0xFF) == 21) {
            int n2 = ccnResponseMessage.getResponseCode() & 0xFF;
            if (n2 == 1) {
                return new BCcnAlarmHistoryEntry("error, block " + n, "command not implemented");
            }
            if (n2 == 4) {
                return new BCcnAlarmHistoryEntry("error, block " + n, "table does not exist");
            }
            if (n2 == 10) {
                return new BCcnAlarmHistoryEntry("error, block " + n, "block not defined");
            }
            if (n2 == 16) {
                return new BCcnAlarmHistoryEntry("error, block " + n, "access denied");
            }
            return new BCcnAlarmHistoryEntry("error, block " + n, "unknown error");
        }
        if (this.isEmptyAlarmMsgDataArray(ccnResponseMessage)) {
            return new BCcnAlarmHistoryEntry("block " + n + " error", "no data");
        }
        try {
            boolean bl = this.device.getCcnNetwork().getDisplayMetric();
            return new BCcnAlarmHistoryEntry(CcnAlarmUtil.getAlarmTextSummary(ccnResponseMessage, this.elemNo, this.busNo), CcnAlarmUtil.getAlarmTextDetail(ccnResponseMessage, bl));
        }
        catch (CcnException ccnException) {
            this.ccnMessageLog.error("error parsing alarm history table entry");
            String string = "ERROR Learn: error parsing alarm table entry";
            this.ccnAHTable.setLearnStatus(string);
            return new BCcnAlarmHistoryEntry("block " + n + " error", string);
        }
    }

    private final CcnResponseMessage getBlockDataFromAlarmTable(int n) {
        CcnTableDef ccnTableDef = new CcnTableDef((byte)this.elemNo, (byte)this.busNo, null, (short)this.tableType, (byte)this.tableInstance, (byte)n, 0, 0);
        CcnReadTableRequest ccnReadTableRequest = new CcnReadTableRequest(ccnTableDef);
        CcnResponseMessage ccnResponseMessage = this.device.getCcnNetwork().getCcnComm().ccnAsyncRequest().sendAsyncRequest(ccnReadTableRequest);
        return ccnResponseMessage;
    }

    private final boolean isEmptyAlarmMsgDataArray(CcnResponseMessage ccnResponseMessage) {
        byte[] byArray = ccnResponseMessage.getData();
        int n = byArray.length;
        int n2 = 3;
        while (n2 < n) {
            if (4 <= n2 && n2 <= 11 || 15 <= n2 && n2 <= 22 || 44 <= n2 && n2 <= 51 ? byArray[n2] != 0 && byArray[n2] != 32 : byArray[n2] != 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    void addLearnedAlarm(BCcnAlarmHistoryEntry bCcnAlarmHistoryEntry) {
        boolean bl = false;
        BFolder bFolder = this.ccnAHTable.getLearnedAlarms();
        Class clazz = class$com$tridium$ccn$components$BCcnAlarmHistoryEntry;
        if (clazz == null) {
            clazz = class$com$tridium$ccn$components$BCcnAlarmHistoryEntry = CcnAlarmHistoryRequest.class("[Lcom.tridium.ccn.components.BCcnAlarmHistoryEntry;", false);
        }
        BCcnAlarmHistoryEntry[] bCcnAlarmHistoryEntryArray = (BCcnAlarmHistoryEntry[])bFolder.getChildren(clazz);
        int n = 0;
        while (n < bCcnAlarmHistoryEntryArray.length) {
            if (bCcnAlarmHistoryEntryArray[n].getAlarmTextSummary().trim().equalsIgnoreCase(bCcnAlarmHistoryEntry.getAlarmTextSummary().trim())) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            this.ccnAHTable.getLearnedAlarms().add(SlotPath.escape((String)(bCcnAlarmHistoryEntry.getAlarm().trim() + '_' + bCcnAlarmHistoryEntry.getAlarmTextSummary())), (BValue)bCcnAlarmHistoryEntry);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.tableType = 67;
        this.tableInstance = 1;
        this.ccnMessageLog = Log.getLog((String)"CCNMessagesLog");
    }

    public CcnAlarmHistoryRequest(BCcnDevice bCcnDevice, BCcnAHTable bCcnAHTable, BCcnAlarmHistoryJob bCcnAlarmHistoryJob) {
        this.this();
        this.device = bCcnDevice;
        this.busNo = this.device.getBusNo();
        this.elemNo = this.device.getElemNo();
        this.ccnAHTable = bCcnAHTable;
        this.job = bCcnAlarmHistoryJob;
    }
}

