/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.comm;

import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.basicdriver.util.BBasicUnsolicitedReceive;
import com.tridium.ccn.BCcnDevice;
import com.tridium.ccn.BCcnNetwork;
import com.tridium.ccn.comm.CcnReceivedMessage;
import com.tridium.ccn.exceptions.CcnException;
import com.tridium.ccn.messages.CcnAsyncRequest;
import com.tridium.ccn.messages.CcnBroadcastDateTimeRequest;
import com.tridium.ccn.messages.CcnMessageConst;
import com.tridium.ccn.util.CcnAlarmUtil;
import com.tridium.ccn.util.CcnRspDTUtil;
import com.tridium.ccn.util.CcnUtil;
import com.tridium.platCcn.CcnDataWrapper;
import com.tridium.platCcn.CcnUnsolMsgListener;
import com.tridium.platCcn.CcnUnsolicitedMsg;
import javax.baja.log.Log;
import javax.baja.sys.BString;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BCcnUnsolicitedReceive
extends BBasicUnsolicitedReceive
implements CcnMessageConst,
CcnUnsolMsgListener {
    public static final Type TYPE;
    BCcnNetwork ccnNetwork;
    Log ccnNetworkLog;
    static /* synthetic */ Class class$com$tridium$ccn$comm$BCcnUnsolicitedReceive;
    static /* synthetic */ Class class$com$tridium$ccn$BCcnDevice;

    public Type getType() {
        return TYPE;
    }

    public BCcnNetwork getNetwork() {
        if (this.ccnNetwork == null) {
            this.ccnNetwork = (BCcnNetwork)this.getParent();
        }
        return this.ccnNetwork;
    }

    public void callProcessUnsolicitedMessage(ReceivedMessage receivedMessage) {
        this.processUnsolicitedMessage(receivedMessage);
    }

    protected void processUnsolicitedMessage(ReceivedMessage receivedMessage) {
        try {
            if (!CcnUtil.isNetworkStatusOk(this.getNetwork())) {
                return;
            }
            CcnUnsolicitedMsg ccnUnsolicitedMsg = ((CcnReceivedMessage)receivedMessage).getUnsolicitedMsg();
            if (this.isMessageFromAnotherElementAtMyAddress(ccnUnsolicitedMsg)) {
                this.ccnNetworkLog.error("CCN ADDRESS CONFLICT ADVISORY: Detected another controller at this station's CCN address.");
            }
            if (this.isAlarmMessage(ccnUnsolicitedMsg)) {
                this.processAlarmMessage(ccnUnsolicitedMsg);
            } else if (this.isBroadcastTimeRequest(ccnUnsolicitedMsg)) {
                this.processBroadcastTimeRequest(ccnUnsolicitedMsg);
            } else {
                this.ignoreMessage(ccnUnsolicitedMsg);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void unsolicitedMessageReceived(CcnUnsolicitedMsg ccnUnsolicitedMsg) {
        CcnReceivedMessage ccnReceivedMessage = new CcnReceivedMessage(ccnUnsolicitedMsg);
        this.receiveMessage(ccnReceivedMessage);
    }

    private final boolean isMessageFromAnotherElementAtMyAddress(CcnUnsolicitedMsg ccnUnsolicitedMsg) {
        boolean bl = false;
        if (ccnUnsolicitedMsg.getSrcBus() == this.getNetwork().getBusAddress() && ccnUnsolicitedMsg.getSrcAddr() == this.getNetwork().getElemAddress()) {
            bl = true;
        }
        return bl;
    }

    private final boolean isAlarmMessage(CcnUnsolicitedMsg ccnUnsolicitedMsg) {
        boolean bl = false;
        if (ccnUnsolicitedMsg.getCommand() == 30) {
            bl = true;
        }
        return bl;
    }

    private final boolean isBroadcastTimeRequest(CcnUnsolicitedMsg ccnUnsolicitedMsg) throws CcnException {
        boolean bl = false;
        if (ccnUnsolicitedMsg.getCommand() == 12) {
            bl = true;
        }
        boolean bl2 = bl;
        boolean bl3 = false;
        if (bl2) {
            bl3 = false;
            if (CcnRspDTUtil.isWriteToBroadcastTableByName(ccnUnsolicitedMsg) || CcnRspDTUtil.isWriteToBroadcastTableByType_Inst(ccnUnsolicitedMsg)) {
                bl3 = true;
            }
        }
        boolean bl4 = bl3;
        boolean bl5 = false;
        if (bl2) {
            bl5 = false;
            if (ccnUnsolicitedMsg.getData()[ccnUnsolicitedMsg.getData().length - 1] == 3) {
                bl5 = true;
            }
        }
        boolean bl6 = bl5;
        boolean bl7 = false;
        if (bl2 && bl4 && bl6) {
            bl7 = true;
        }
        return bl7;
    }

    private final void processBroadcastTimeRequest(CcnUnsolicitedMsg ccnUnsolicitedMsg) throws CcnException {
        if (this.getNetwork().getBroadcastAcknowledger()) {
            CcnAsyncRequest ccnAsyncRequest = this.getNetwork().getCcnComm().ccnAsyncRequest();
            ccnAsyncRequest.submitRequest(new CcnBroadcastDateTimeRequest(ccnAsyncRequest, true));
        } else {
            this.ccnNetworkLog.trace("Detected broadcast time request but no action taken because Jace not configured as time broadcaster.");
        }
    }

    private final void processAlarmMessage(CcnUnsolicitedMsg ccnUnsolicitedMsg) throws CcnException {
        try {
            ccnUnsolicitedMsg = this.tweakUnsolAlarmMessage(ccnUnsolicitedMsg);
            BCcnDevice bCcnDevice = this.findDeviceForAlarm(ccnUnsolicitedMsg);
            if (bCcnDevice != null) {
                BCcnUnsolicitedReceive.forwardCcnAlarmToCcnDevice(ccnUnsolicitedMsg, bCcnDevice);
            } else {
                this.forwardCcnAlarmToNiagaraAlarmConsole(ccnUnsolicitedMsg, bCcnDevice);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private final CcnUnsolicitedMsg tweakUnsolAlarmMessage(CcnUnsolicitedMsg ccnUnsolicitedMsg) {
        byte[] byArray = ccnUnsolicitedMsg.getData();
        byte[] byArray2 = new byte[byArray.length + 3];
        int n = 0;
        int n2 = 3;
        while (n < byArray.length) {
            byArray2[n2] = byArray[n];
            ++n;
            ++n2;
        }
        CcnUnsolicitedMsg ccnUnsolicitedMsg2 = new CcnUnsolicitedMsg((byte)ccnUnsolicitedMsg.getDestAddr(), (byte)ccnUnsolicitedMsg.getDestBus(), (byte)ccnUnsolicitedMsg.getSrcAddr(), (byte)ccnUnsolicitedMsg.getSrcBus(), 0, 0, (byte)ccnUnsolicitedMsg.getCommand(), byArray2, (short)byArray2.length);
        return ccnUnsolicitedMsg2;
    }

    private final BCcnDevice findDeviceForAlarm(CcnUnsolicitedMsg ccnUnsolicitedMsg) {
        BCcnNetwork bCcnNetwork = this.getNetwork();
        Class clazz = class$com$tridium$ccn$BCcnDevice;
        if (clazz == null) {
            clazz = class$com$tridium$ccn$BCcnDevice = BCcnUnsolicitedReceive.class("[Lcom.tridium.ccn.BCcnDevice;", false);
        }
        BCcnDevice[] bCcnDeviceArray = (BCcnDevice[])bCcnNetwork.getChildren(clazz);
        int n = 0;
        while (n < bCcnDeviceArray.length) {
            BCcnDevice bCcnDevice = bCcnDeviceArray[n];
            if (this.isAlarmForDevice(ccnUnsolicitedMsg, bCcnDevice)) {
                return bCcnDevice;
            }
            ++n;
        }
        return null;
    }

    private final boolean isAlarmForDevice(CcnUnsolicitedMsg ccnUnsolicitedMsg, BCcnDevice bCcnDevice) {
        boolean bl = false;
        if (bCcnDevice != null && bCcnDevice.getElemNo() == ccnUnsolicitedMsg.getSrcAddr() && bCcnDevice.getBusNo() == ccnUnsolicitedMsg.getSrcBus()) {
            bl = true;
        }
        return bl;
    }

    private final void ignoreMessage(CcnUnsolicitedMsg ccnUnsolicitedMsg) {
    }

    private static final void forwardCcnAlarmToCcnDevice(CcnUnsolicitedMsg ccnUnsolicitedMsg, BCcnDevice bCcnDevice) throws CcnException {
        if (bCcnDevice != null) {
            bCcnDevice.unsolicitedAlarmReceived(ccnUnsolicitedMsg);
        }
    }

    private final void forwardCcnAlarmToNiagaraAlarmConsole(CcnUnsolicitedMsg ccnUnsolicitedMsg, BCcnDevice bCcnDevice) throws CcnException {
        boolean bl = this.getNetwork().getDisplayMetric();
        if (bCcnDevice != null) {
            this.getNetwork().addAlarm(BString.make((String)CcnAlarmUtil.getAlarmConsoleSummary(ccnUnsolicitedMsg, bl)), BString.make((String)(CcnAlarmUtil.getTypeDesc((CcnDataWrapper)ccnUnsolicitedMsg) + " - " + CcnAlarmUtil.getSourceDesc((CcnDataWrapper)ccnUnsolicitedMsg))), BString.make((String)CcnAlarmUtil.getFormattedValue((CcnDataWrapper)ccnUnsolicitedMsg, false, bl)));
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.ccnNetworkLog = Log.getLog((String)"CCNNetworkLog");
    }

    public BCcnUnsolicitedReceive() {
        this.this();
    }

    public BCcnUnsolicitedReceive(BCcnNetwork bCcnNetwork) {
        this.this();
        this.ccnNetwork = bCcnNetwork;
    }

    static {
        Class clazz = class$com$tridium$ccn$comm$BCcnUnsolicitedReceive;
        if (clazz == null) {
            clazz = class$com$tridium$ccn$comm$BCcnUnsolicitedReceive = BCcnUnsolicitedReceive.class("[Lcom.tridium.ccn.comm.BCcnUnsolicitedReceive;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

