/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn;

import com.tridium.ccn.BCcnTunnelHelper;
import com.tridium.ccn.CcnTunnelBack;
import com.tridium.ccn.ClientNotInRoutingTableException;
import com.tridium.ccn.ClientSameAddressAsJaceException;
import com.tridium.ccn.TunnelUdp2CcnRequest;
import com.tridium.ccn.UDPAck02Util;
import com.tridium.ccn.UDPAck06Util;
import com.tridium.ccn.UDPMessageProcessor;
import com.tridium.ccn.UDPNack15Util;
import com.tridium.ccn.UDPRoutingTableEntry;
import com.tridium.ccn.UDPTable20Util;
import java.io.StringWriter;
import java.net.DatagramPacket;
import java.net.DatagramSocket;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class UDPUnsolicitedReceiveProcesser
extends UDPMessageProcessor {
    private static final int ALARM_MESSAGE = 1000000;
    private static final int LOCAL_DEFAULT_ADDRESS_MESSAGE = 1000001;
    private static final int LOCAL_ADDRESS_MESSAGE = 1000002;
    private static final int CCN_MESSAGE = 1000003;
    private static final int BROADCAST = 1000004;
    private static final int MULTICAST = 1000005;
    private int messageType;
    private boolean processMsg;
    private boolean respondPlain06;
    private boolean respond02;
    private boolean passThru;
    private boolean messageSupported;

    private final void sendMockTable20Block02() {
        DatagramPacket datagramPacket = UDPTable20Util.createTable20MockBlock02Packet(this);
        this.sendPacket(datagramPacket);
    }

    private final void ifNecessaryThenSendAck02() {
        this.debugf("ifNecessaryThenSendAck02 - entered method - respond02=" + this.respond02);
        if (this.respond02) {
            this.sendPacket(UDPAck02Util.createUdpAck02Packet(this));
        }
    }

    private final void ifNecessaryThenSendPlainAck06() {
        this.debugf("ifNecessaryThenSendPlainAck06 - entered method - respondPlain06=" + this.respondPlain06);
        if (this.respondPlain06) {
            this.sendPacket(UDPAck06Util.createUdpPlainAck06Packet(this));
        }
    }

    private final void sendUnsupportedNack15() {
        this.debugf("entered method sendUnsupportedNack15");
        this.sendPacket(UDPNack15Util.createUnsupportedNack15Packet(this));
    }

    private final void processReceive() {
        this.debugf("Entered method processReceive");
        this.getMessageType();
        if (this.processMsg) {
            if (this.messageSupported) {
                this.debugf("processReceive - message is supported");
                this.furtherProcessReceive();
            } else {
                this.debugf("Received unsupported message via UDP/IP. Summary of Message ID follows.\n" + this.getIdSummary());
                this.sendUnsupportedNack15();
            }
        }
    }

    private final void processLocalAddressMessage() {
        switch (this.iCmd) {
            case 11: {
                this.debugf("processLocalAddressMessage - they want to read a table block");
                break;
            }
            case 12: {
                if (this.isWriteToRoutingTable()) {
                    if (this.iTunnelHelper.ccnNetwork.getElemAddress() == this.iSourceAddr) {
                        throw new ClientSameAddressAsJaceException(this.iSourceAddr);
                    }
                    throw new UDPRoutingTableEntry(this);
                }
                this.debugf("processLocalAddressMessage - they want to write to one of my table's blocks, but not the routing table!");
                StringWriter stringWriter = new StringWriter();
                this.debugf("this is what they told me: " + stringWriter.toString());
                break;
            }
            default: {
                this.debugf("processLocalAddressMessage - they issued command " + this.iCmd + ", but I don't know what that means!");
            }
        }
    }

    private final boolean isWriteToRoutingTable() {
        return new String(this.iPacket.getData(), 12, 8).equals("ROUTETAB");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void furtherProcessReceive() {
        this.debugf("Entered method furtherProcessReceive.");
        this.ifNecessaryThenSendAck02();
        try {
            switch (this.messageType) {
                case 1000001: {
                    this.debugf("furtherProcessReceive - received message type LOCAL_DEFAULT_ADDRESS_MESSAGE");
                    this.sendMockTable20Block02();
                    break;
                }
                case 1000002: {
                    this.debugf("furtherProcessReceive - they want to talk to me!");
                    this.processLocalAddressMessage();
                    break;
                }
                case 1000003: {
                    this.debugf("Routing UPD message to CCN");
                    this.routeUdpToCcn();
                    break;
                }
                default: {
                    this.debugf("Server confused and unable to make any sense of the following message:\n" + this.getIdSummary());
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.ifNecessaryThenSendPlainAck06();
            throw throwable;
        }
        {
            Object var2_3 = null;
            this.ifNecessaryThenSendPlainAck06();
            return;
        }
    }

    private final void getMessageType() {
        if (this.iDestAddr >= 241 && this.iDestAddr <= 254) {
            this.messageType = this.iDestBus == this.iDestAddr ? 1000004 : 1000005;
        } else if (this.iDestAddr == 255 && this.iDestBus == 0) {
            this.messageType = 1000000;
            this.passThru = true;
            this.respondPlain06 = true;
        } else if (this.iDestBus == 0 && this.iDestAddr == 0) {
            if (this.iCmd == 11) {
                this.messageType = 1000001;
                this.processMsg = true;
                this.messageSupported = true;
            }
        } else if (this.iDestBus == this.iMyBus && this.iDestAddr == this.iMyAddr) {
            this.messageType = 1000002;
            this.processMsg = !this.isWriteToRoutingTable() || UDPRoutingTableEntry.getDeviceType(this.iPacket.getData()) == 2;
            this.respondPlain06 = true;
            this.messageSupported = true;
        } else if (this.iCmd != 2) {
            if (this.iTunnelHelper.getRoutingTable().get(this.iSourceAddr) == null) {
                throw new ClientNotInRoutingTableException(this.iSourceAddr);
            }
            this.messageType = 1000003;
            this.respond02 = true;
            this.processMsg = true;
            this.messageSupported = true;
        }
    }

    private final void routeUdpToCcn() {
        this.iTunnelHelper.getCcnAsyncReq().submitRequest(new TunnelUdp2CcnRequest(this, this.iTunnelHelper.getCcnTunnelBack()));
    }

    private final /* synthetic */ void this() {
        this.processMsg = false;
        this.respondPlain06 = false;
        this.respond02 = false;
        this.passThru = false;
        this.messageSupported = false;
    }

    public UDPUnsolicitedReceiveProcesser(DatagramPacket datagramPacket, CcnTunnelBack ccnTunnelBack, BCcnTunnelHelper bCcnTunnelHelper, int n, int n2, boolean bl) {
        super(datagramPacket, ccnTunnelBack, bCcnTunnelHelper, n, n2, false);
        this.this();
        this.processReceive();
    }

    public UDPUnsolicitedReceiveProcesser(DatagramPacket datagramPacket, DatagramSocket datagramSocket, BCcnTunnelHelper bCcnTunnelHelper, int n, int n2, boolean bl) {
        super(datagramPacket, datagramSocket, bCcnTunnelHelper, n, n2, false);
        this.this();
        this.processReceive();
    }
}

