/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn;

import com.tridium.ccn.BCcnTunnelHelper;
import com.tridium.ccn.CcnTunnelBack;
import com.tridium.ccn.exceptions.CcnRuntimeException;
import java.io.ByteArrayInputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import javax.baja.log.Log;
import javax.baja.sys.Clock;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class UDPMessageProcessor {
    private static final int MIN_PACKET_LENGTH = 9;
    protected DatagramPacket iPacket;
    protected DatagramSocket iSocket;
    protected CcnTunnelBack iTunnelBack;
    protected BCcnTunnelHelper iTunnelHelper;
    protected int iUdpPacketId;
    protected int iDestAddr;
    protected int iDestBus;
    protected int iSourceAddr;
    protected int iSourceBus;
    protected int iMsgDataLen;
    protected int iPID;
    protected int iExt;
    protected int iCmd;
    protected int iMyAddr;
    protected int iMyBus;
    protected boolean iDebug;
    private InetAddress iPacketAddress;
    private int iPacketPort;
    Log tunnelLog;

    public InetAddress getPacketAddress() {
        if (this.iPacketAddress == null) {
            this.iPacketAddress = this.iPacket.getAddress();
        }
        return this.iPacketAddress;
    }

    public int getPacketPort() {
        if (this.iPacketPort < 0) {
            this.iPacketPort = this.iPacket.getPort();
        }
        return this.iPacketPort;
    }

    protected String getUdpIdSummary() {
        String string = "";
        string = string + "*** UDP FROM: " + this.getPacketAddress() + "\n]";
        string = string + "    PORT: " + this.getPacketPort() + '\n';
        return string;
    }

    protected String getCcnMsgSummary() {
        String string = "";
        string = string + "*** CCN SRC ADDR: " + this.iSourceAddr + '\n';
        string = string + "            BUS : " + this.iSourceBus + '\n';
        string = string + "        MSG CMD : " + this.iCmd + '\n';
        return string;
    }

    private final byte[] getCcnMessageBytes() {
        int n = this.iPacket.getLength() - 1;
        byte[] byArray = this.iPacket.getData();
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        int n3 = 1;
        while (n2 < n) {
            byArray2[n2] = byArray[n3];
            ++n2;
            ++n3;
        }
        return byArray2;
    }

    protected byte[] getCcnMessageBytesForCcnTransmission() {
        byte[] byArray = this.getCcnMessageBytes();
        byArray[2] = (byte)this.iMyAddr;
        byArray[3] = (byte)this.iMyBus;
        return byArray;
    }

    protected String getIdSummary() {
        return this.getUdpIdSummary() + this.getCcnMsgSummary();
    }

    private final void checkPacketDataLength() {
        if (this.iPacket.getLength() < 9) {
            throw new CcnRuntimeException(6488178, "!!CcnTunnel received UDP/IP message that is too short to possibly be a valid tunnel message.");
        }
    }

    public int yourAddressPlease() {
        return this.iMyAddr;
    }

    public int yourBusPlease() {
        return this.iMyBus;
    }

    public void debugf(String string) {
        if (this.iDebug) {
            String string2 = this.getClass().getName();
            this.tunnelLog.trace(string2 + " : " + string + " : [" + Clock.ticks() + ']');
        }
    }

    public void sendPacket(DatagramPacket datagramPacket) {
        this.debugf("Entered method sendPacket");
        try {
            this.iSocket.send(datagramPacket);
        }
        catch (Exception exception) {
            this.debugf("Unable to send UDP packet because: " + exception);
        }
    }

    private final void parsePacketBasics() {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.iPacket.getData());
        this.iUdpPacketId = byteArrayInputStream.read();
        this.debugf("parsePacketBasics : iUdpPacketId = " + this.iUdpPacketId);
        this.iDestAddr = byteArrayInputStream.read();
        this.debugf("parsePacketBasics : iDestAddr = " + this.iDestAddr);
        this.iDestBus = byteArrayInputStream.read();
        this.debugf("parsePacketBasics : iDestBus = " + this.iDestBus);
        this.iSourceAddr = byteArrayInputStream.read();
        this.debugf("parsePacketBasics : iSourceAddr = " + this.iSourceAddr);
        this.iSourceBus = byteArrayInputStream.read();
        this.debugf("parsePacketBasics : iSourceBus = " + this.iSourceBus);
        this.iMsgDataLen = byteArrayInputStream.read();
        this.debugf("parsePacketBasics : iMsgDataLen = " + this.iMsgDataLen);
        this.iPID = byteArrayInputStream.read();
        this.debugf("parsePacketBasics : iPID = " + this.iPID);
        this.iExt = byteArrayInputStream.read();
        this.debugf("parsePacketBasics : iExt = " + this.iExt);
        this.iCmd = byteArrayInputStream.read();
        this.debugf("parsePacketBasics : iCmd = " + this.iCmd);
    }

    private final /* synthetic */ void this() {
        this.iPacketPort = -1;
        this.tunnelLog = Log.getLog((String)"CCNTunnelLog");
    }

    public UDPMessageProcessor(DatagramPacket datagramPacket, CcnTunnelBack ccnTunnelBack, BCcnTunnelHelper bCcnTunnelHelper, int n, int n2, boolean bl) {
        this.this();
        this.debugf("Entered method UDPMessageProcessor <init>");
        this.iPacket = datagramPacket;
        this.checkPacketDataLength();
        this.iTunnelBack = ccnTunnelBack;
        this.iTunnelHelper = bCcnTunnelHelper;
        this.iSocket = null;
        this.iMyAddr = n;
        this.iMyBus = n2;
        this.iDebug = bl;
        this.parsePacketBasics();
    }

    public UDPMessageProcessor(DatagramPacket datagramPacket, DatagramSocket datagramSocket, BCcnTunnelHelper bCcnTunnelHelper, int n, int n2, boolean bl) {
        this.this();
        this.debugf("Entered method UDPMessageProcessor <init>");
        this.iPacket = datagramPacket;
        this.checkPacketDataLength();
        this.iTunnelBack = null;
        this.iTunnelHelper = bCcnTunnelHelper;
        this.iSocket = datagramSocket;
        this.iMyAddr = n;
        this.iMyBus = n2;
        this.iDebug = bl;
        this.parsePacketBasics();
    }
}

