/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.oncall;

import com.tridium.alarm.BConsoleRecipient;
import com.tridium.alarm.BStationRecipient;
import com.tridium.oncall.BOnCallList;
import com.tridium.oncall.BOnCallRecipient;
import com.tridium.oncall.BOnCallService;
import com.tridium.oncall.util.OnCallToolkit;
import javax.baja.alarm.BAlarmDatabase;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.collection.BICollection;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.schedule.BEnumSchedule;
import javax.baja.schedule.BWeeklySchedule;
import javax.baja.status.BStatusEnum;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BOnCallSchedule
extends BEnumSchedule {
    public static final Action activateCallList = BOnCallSchedule.newAction((int)20, null);
    public static final Action callListRemoved = BOnCallSchedule.newAction((int)20, (BValue)BInteger.DEFAULT, null);
    public static final Action matchClearAndEscalate = BOnCallSchedule.newAction((int)20, (BValue)BString.DEFAULT, null);
    public static final Action clearAndEscalate = BOnCallSchedule.newAction((int)20, (BValue)BString.DEFAULT, null);
    public static final Type TYPE;
    private BStatusEnum lastOut;
    private BOnCallList currentList;
    static /* synthetic */ Class class$com$tridium$oncall$BOnCallSchedule;
    static /* synthetic */ Class class$javax$baja$alarm$BAlarmRecord;

    public final void activateCallList() {
        this.invoke(activateCallList, null, null);
    }

    public final void callListRemoved(BInteger bInteger) {
        this.invoke(callListRemoved, (BValue)bInteger, null);
    }

    public final void matchClearAndEscalate(BString bString) {
        this.invoke(matchClearAndEscalate, (BValue)bString, null);
    }

    public final void clearAndEscalate(BString bString) {
        this.invoke(clearAndEscalate, (BValue)bString, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public final void started() throws Exception {
        super.started();
        BOnCallService bOnCallService = BOnCallService.getInstance();
        if (bOnCallService == null) {
            throw new Exception("Could not find OnCallService");
        }
        this.setFacets(BOnCallService.getInstance().getCallListEnumRangeFacets());
        this.activateCallList();
    }

    public final void changed(Property property, Context context) {
        super.changed(property, context);
        if (this.isRunning()) {
            if (property == BEnumSchedule.out) {
                this.activateCallList();
            } else if (property == BWeeklySchedule.schedule) {
                this.setFacets(BOnCallService.getInstance().getCallListEnumRangeFacets());
            }
        }
    }

    public final IFuture post(Action action, BValue bValue, Context context) {
        if (action == activateCallList || action == callListRemoved || action == matchClearAndEscalate || action == clearAndEscalate) {
            return BOnCallService.getInstance().getWorker().post((Runnable)new Invocation((BComponent)this, action, bValue, context));
        }
        return super.post(action, bValue, context);
    }

    public final boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BOnCallRecipient;
    }

    public final void doActivateCallList() throws Exception {
        BOnCallService bOnCallService;
        if (OnCallToolkit.log.isTraceOn()) {
            OnCallToolkit.log.trace("Activating call list");
        }
        if ((bOnCallService = BOnCallService.getInstance()) == null) {
            throw new Exception("Could not find OnCallService");
        }
        if (this.lastOut != null && !this.lastOut.isNull() && this.currentList != null && this.currentList.isMounted()) {
            if (this.lastOut.getEnum().getOrdinal() == this.getOut().getEnum().getOrdinal()) {
                this.checkEscalation(this.getOnCallRecipient());
                this.getOnCallRecipient().setOnCallList(this.currentList.getName());
                return;
            }
            this.currentList.setActive(bOnCallService.isScheduleActiveElseWhere(this, this.lastOut));
            this.currentList.updateStatus();
            if (OnCallToolkit.log.isTraceOn()) {
                OnCallToolkit.log.trace("Activating call list: Old On Call List: " + this.currentList.getName() + ' ' + this.currentList.getStatus().toString());
            }
        }
        this.lastOut = (BStatusEnum)this.getOut().newCopy();
        if (!this.lastOut.isNull()) {
            this.currentList = bOnCallService.lookupList(this.lastOut.getEnum().getOrdinal());
            if (this.currentList != null) {
                this.currentList.setActive(true);
                this.currentList.updateStatus();
                this.getOnCallRecipient().setOnCallList(this.currentList.getName());
                if (OnCallToolkit.log.isTraceOn()) {
                    OnCallToolkit.log.trace("Activating call list: New On Call List: " + this.currentList.getName() + ' ' + this.currentList.getStatus().toString());
                }
                this.doClearAndEscalate(BString.DEFAULT);
            } else {
                this.lastOut = null;
                this.currentList = null;
                this.getOnCallRecipient().setOnCallList("");
                this.doClearAndEscalate(BString.DEFAULT);
            }
        } else {
            this.lastOut = null;
            this.currentList = null;
            this.getOnCallRecipient().setOnCallList("");
            this.doClearAndEscalate(BString.DEFAULT);
        }
    }

    public final void doCallListRemoved(BInteger bInteger) throws Exception {
        if (OnCallToolkit.log.isTraceOn()) {
            OnCallToolkit.log.trace("On Call List Removed: " + this.getOnCallRecipient().getName() + ": " + bInteger);
        }
        BICollection bICollection = (BICollection)BOrd.make((String)("bql:select from schedule:AbstractSchedule where effectiveValue.value.ordinal=" + bInteger.encodeToString())).get((BObject)this);
        BObject[] bObjectArray = bICollection.toList().list();
        BComponent bComponent = null;
        int n = 0;
        while (n < bObjectArray.length) {
            bComponent = (BComponent)bObjectArray[n];
            bComponent.getParent().asComponent().remove((BComplex)bComponent);
            ++n;
        }
        BOnCallService bOnCallService = BOnCallService.getInstance();
        if (bOnCallService == null) {
            throw new Exception("Could not find OnCallService");
        }
        this.setFacets(BOnCallService.getInstance().getCallListEnumRangeFacets());
        this.activateCallList();
    }

    public final void doMatchClearAndEscalate(BString bString) throws Exception {
        if (bString.getString().length() > 0 && this.currentList != null && this.currentList.isMounted() && !this.currentList.getName().equals(bString.getString())) {
            return;
        }
        if (OnCallToolkit.log.isTraceOn()) {
            OnCallToolkit.log.trace("Match, clear and escalate alarm: " + bString);
        }
        this.doClearAndEscalate(BString.DEFAULT);
    }

    public final void doClearAndEscalate(BString bString) throws Exception {
        String string = this.getOnCallRecipient().buildAlarmClassPredicate(bString.getString());
        if (string.length() <= 0) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("alarm:|bql:select from openAlarms where not isAcknowledged");
        stringBuffer.append(string);
        BICollection bICollection = (BICollection)BOrd.make((String)stringBuffer.toString()).get((BObject)this);
        Cursor cursor = bICollection.cursor();
        BAlarmService bAlarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        BAlarmDatabase bAlarmDatabase = bAlarmService.getAlarmDb();
        Class clazz = class$javax$baja$alarm$BAlarmRecord;
        if (clazz == null) {
            clazz = class$javax$baja$alarm$BAlarmRecord = BOnCallSchedule.class("[Ljavax.baja.alarm.BAlarmRecord;", false);
        }
        Array array = new Array(clazz);
        while (cursor.next()) {
            array.add((Object)cursor.get().asValue().newCopy());
        }
        BConsoleRecipient[] bConsoleRecipientArray = null;
        BStationRecipient[] bStationRecipientArray = null;
        BAlarmRecord[] bAlarmRecordArray = (BAlarmRecord[])array.trim();
        int n = 0;
        while (n < bAlarmRecordArray.length) {
            String[] stringArray = new String[]{"OnCallRecipient", "OnCallList", "OnCallStartTime", "OnCallUser", "OnCallContact", "OnCallListPriority"};
            BIDataValue[] bIDataValueArray = new BIDataValue[]{BString.DEFAULT, BString.DEFAULT, BAbsTime.NULL, BString.DEFAULT, BString.DEFAULT, BInteger.make((int)-1)};
            BFacets bFacets = BFacets.make((String[])stringArray, (BIDataValue[])bIDataValueArray);
            bAlarmRecordArray[n].setAlarmData(BFacets.make((BFacets)bAlarmRecordArray[n].getAlarmData(), (BFacets)bFacets));
            bAlarmRecordArray[n].setLastUpdate(BAbsTime.now());
            bAlarmDatabase.update(bAlarmRecordArray[n]);
            if (OnCallToolkit.log.isTraceOn()) {
                OnCallToolkit.log.trace("Clear and escalate alarm: " + bAlarmRecordArray[n].getUuid().encodeToString());
            }
            if (bConsoleRecipientArray == null) {
                bConsoleRecipientArray = this.getOnCallRecipient().getLinkedConsoleRecipients();
            }
            int n2 = 0;
            while (n2 < bConsoleRecipientArray.length) {
                bConsoleRecipientArray[n2].routeAlarm(bAlarmRecordArray[n]);
                ++n2;
            }
            if (bStationRecipientArray == null) {
                bStationRecipientArray = this.getOnCallRecipient().getLinkedStationRecipients();
            }
            n2 = 0;
            while (n2 < bStationRecipientArray.length) {
                bStationRecipientArray[n2].routeAlarm(bAlarmRecordArray[n]);
                ++n2;
            }
            ++n;
        }
        this.checkEscalation(this.getOnCallRecipient());
    }

    final void routeAlarm(BAlarmRecord bAlarmRecord, BOnCallRecipient bOnCallRecipient) {
        if (this.currentList != null && this.currentList.isMounted()) {
            this.currentList.routeAlarm(bAlarmRecord, bOnCallRecipient);
        }
    }

    final void checkEscalation(BOnCallRecipient bOnCallRecipient) {
        if (this.currentList != null && this.currentList.isMounted()) {
            this.currentList.checkEscalation(bOnCallRecipient);
        }
    }

    public final BOnCallRecipient getOnCallRecipient() {
        return (BOnCallRecipient)this.getParent();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.lastOut = null;
        this.currentList = null;
    }

    public BOnCallSchedule() {
        this.this();
        this.setFlags((Slot)BEnumSchedule.facets, this.getFlags((Slot)BEnumSchedule.facets) | 4);
    }

    static {
        Class clazz = class$com$tridium$oncall$BOnCallSchedule;
        if (clazz == null) {
            clazz = class$com$tridium$oncall$BOnCallSchedule = BOnCallSchedule.class("[Lcom.tridium.oncall.BOnCallSchedule;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

