/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.oncall;

import com.tridium.alarm.user.BIUserAlarmRecipient;
import com.tridium.oncall.BOnCallList;
import com.tridium.oncall.BOnCallService;
import com.tridium.oncall.util.OnCallToolkit;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BOnCallContact
extends BComponent
implements BIStatus,
BOnCallService.UserListener {
    public static final Property status = BOnCallContact.newProperty((int)67, (BValue)BStatus.ok, null);
    public static final Property lastFaultCause = BOnCallContact.newProperty((int)67, (String)"", null);
    public static final Property enabled = BOnCallContact.newProperty((int)0, (boolean)true, null);
    public static final Property priority = BOnCallContact.newProperty((int)0, (int)1, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)1)));
    public static final Property rotationMarker = BOnCallContact.newProperty((int)69, (int)-1, null);
    public static final Property user = BOnCallContact.newProperty((int)0, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"wbutil:OrdSelectFE"), (String)"queryOrd", (BIDataValue)BString.make((String)"service:baja:UserService|bql:select icon.encodeToString, displayName, handleOrd, status.encodeToString from baja:User stop")));
    public static final Property userAlarmRecipient = BOnCallContact.newProperty((int)0, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"wbutil:OrdSelectFE"), (String)"queryOrd", (BIDataValue)BString.make((String)"station:|slot:|bql:select icon.encodeToString, displayName, handleOrd from alarm:IUserAlarmRecipient stop")));
    public static final Type TYPE;
    private static final BIcon icon;
    private static final String NULL_TEXT = "null";
    static final Context ROTATE_CONTEXT;
    private BUser currentUser;
    private String currentUserName;
    private BIUserAlarmRecipient currentRec;
    static /* synthetic */ Class class$com$tridium$oncall$BOnCallContact;

    public final BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public final void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public final String getLastFaultCause() {
        return this.getString(lastFaultCause);
    }

    public final void setLastFaultCause(String string) {
        this.setString(lastFaultCause, string, null);
    }

    public final boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public final void setEnabled(boolean bl) {
        this.setBoolean(enabled, bl, null);
    }

    public final int getPriority() {
        return this.getInt(priority);
    }

    public final void setPriority(int n) {
        this.setInt(priority, n, null);
    }

    public final int getRotationMarker() {
        return this.getInt(rotationMarker);
    }

    public final void setRotationMarker(int n) {
        this.setInt(rotationMarker, n, null);
    }

    public final BOrd getUser() {
        return (BOrd)this.get(user);
    }

    public final void setUser(BOrd bOrd) {
        this.set(user, (BValue)bOrd, null);
    }

    public final BOrd getUserAlarmRecipient() {
        return (BOrd)this.get(userAlarmRecipient);
    }

    public final void setUserAlarmRecipient(BOrd bOrd) {
        this.set(userAlarmRecipient, (BValue)bOrd, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public final void started() throws Exception {
        BOnCallService.getInstance().addUserListener(this);
        this.updateName();
    }

    public final void stopped() throws Exception {
        BOnCallService.getInstance().removeUserListener(this);
    }

    public final void changed(Property property, Context context) {
        if (this.isRunning()) {
            if (property == user || property == userAlarmRecipient) {
                this.updateName();
            } else if (property == priority && context != ROTATE_CONTEXT) {
                this.updateRotationMarker(true);
                ((BOnCallList)this.getParent()).startReorderTimer();
            } else if (property == enabled) {
                this.updateDisabledStatus();
            }
        }
    }

    public final boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BOnCallList;
    }

    public final BIcon getIcon() {
        return icon;
    }

    private final void updateName() {
        this.currentUser = null;
        this.currentUserName = NULL_TEXT;
        boolean bl = false;
        try {
            if (!this.getUser().isNull()) {
                this.currentUser = (BUser)this.getUser().get((BObject)this);
                this.currentUserName = this.currentUser.getName();
                bl = true;
            } else {
                this.setStatus(BStatus.fault);
                this.setLastFaultCause("User is set to null");
                OnCallToolkit.log.error(this.getName() + ": " + this.getLastFaultCause());
            }
        }
        catch (UnresolvedException unresolvedException) {
            this.setStatus(BStatus.fault);
            this.setLastFaultCause("Could not find User");
            OnCallToolkit.log.error(this.getName() + ": " + this.getLastFaultCause());
        }
        String string = NULL_TEXT;
        this.currentRec = null;
        try {
            if (!this.getUserAlarmRecipient().isNull()) {
                this.currentRec = (BIUserAlarmRecipient)this.getUserAlarmRecipient().get((BObject)this);
                string = ((BComponent)this.currentRec).getName();
                if (bl) {
                    this.setStatus(BStatus.ok);
                }
            } else {
                this.setStatus(BStatus.fault);
                this.setLastFaultCause("Alarm Recipient is set to null");
                OnCallToolkit.log.error(this.getName() + ": " + this.getLastFaultCause());
            }
        }
        catch (UnresolvedException unresolvedException) {
            this.setStatus(BStatus.fault);
            this.setLastFaultCause("Could not find Alarm Recipient");
            OnCallToolkit.log.error(this.getName() + ": " + this.getLastFaultCause());
        }
        String string2 = SlotPath.escape((String)(this.currentUserName + '_' + string));
        if (!string2.equals(this.getName())) {
            int n = 0;
            String string3 = string2;
            while (true) {
                if (n > 0) {
                    string3 = string2 + String.valueOf(n);
                }
                if (this.getParent().getSlot(string3) == null) {
                    this.getParent().asComponent().rename(this.getPropertyInParent(), string3);
                    break;
                }
                ++n;
            }
        }
        this.getOnCallList().updateStatus();
    }

    final String getCurrentUserName() {
        return this.currentUserName;
    }

    final BUser getCurrentUser() {
        return this.currentUser;
    }

    final BIUserAlarmRecipient getCurrentUserAlarmRecipient() {
        return this.currentRec;
    }

    private final BOnCallList getOnCallList() {
        return (BOnCallList)this.getParent();
    }

    final void updateDisabledStatus() {
        boolean bl = false;
        if (this.currentUser != null && this.currentUser.isMounted()) {
            bl = this.currentUser.getStatus().isDisabled();
        }
        BStatus bStatus = this.getStatus();
        boolean bl2 = false;
        if (this.getOnCallList().getStatus().isDisabled() || !this.getEnabled() || bl) {
            bl2 = true;
        }
        this.setStatus(BStatus.makeDisabled((BStatus)bStatus, (boolean)bl2));
    }

    public final void userRemoved(String string) {
        if (this.currentUser == null) {
            return;
        }
        if (string.equals(this.currentUserName)) {
            this.updateName();
        }
    }

    public final void userEnabledChanged(String string) {
        if (this.currentUser == null) {
            return;
        }
        if (!this.currentUser.isMounted()) {
            return;
        }
        if (string.equals(this.currentUserName)) {
            this.updateDisabledStatus();
        }
    }

    final void updateRotationMarker(boolean bl) {
        if (this.getRotationMarker() == -1 || bl) {
            BOnCallList bOnCallList = this.getOnCallList();
            Class clazz = class$com$tridium$oncall$BOnCallContact;
            if (clazz == null) {
                clazz = class$com$tridium$oncall$BOnCallContact = BOnCallContact.class("[Lcom.tridium.oncall.BOnCallContact;", false);
            }
            BOnCallContact[] bOnCallContactArray = (BOnCallContact[])bOnCallList.getChildren(clazz);
            int n = 0;
            int n2 = 0;
            while (n2 < bOnCallContactArray.length) {
                if (bOnCallContactArray[n2] != this && bOnCallContactArray[n2].getPriority() == this.getPriority() && bOnCallContactArray[n2].getRotationMarker() > n) {
                    n = bOnCallContactArray[n2].getRotationMarker();
                }
                ++n2;
            }
            if (n <= -1) {
                n = 0;
            }
            this.setRotationMarker(++n);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.currentUser = null;
        this.currentUserName = NULL_TEXT;
        this.currentRec = null;
    }

    public BOnCallContact() {
        this.this();
    }

    public BOnCallContact(int n) {
        this.this();
        this.setPriority(n);
    }

    static {
        Class clazz = class$com$tridium$oncall$BOnCallContact;
        if (clazz == null) {
            clazz = class$com$tridium$oncall$BOnCallContact = BOnCallContact.class("[Lcom.tridium.oncall.BOnCallContact;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((String)"module://onCall/res/onCallContact.png");
        ROTATE_CONTEXT = new BasicContext();
    }
}

