/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platSysmonNxt;

import com.tridium.platform.BPlatformService;
import com.tridium.platform.alarm.BIAlarmablePlatformService;
import com.tridium.platform.alarm.BPlatformAlarmProxy;
import com.tridium.platform.alarm.BPlatformAlarmSupport;
import com.tridium.platform.alarm.BPlatformServiceAlarmRecord;
import com.tridium.platform.alarm.PlatformServiceAlarmListener;
import java.util.HashMap;
import java.util.Vector;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BStation;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;
import javax.baja.util.BFormat;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BHardwareMonitorNxtPlatformService
extends BPlatformService
implements BIAlarmablePlatformService {
    public static final Property sysmonPollRate = BHardwareMonitorNxtPlatformService.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)15), (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE, (String)"min", (BIDataValue)BRelTime.makeMinutes((int)0), (String)"max", (BIDataValue)BRelTime.makeMinutes((int)15)));
    public static final Property cpuTemp = BHardwareMonitorNxtPlatformService.newProperty((int)1, (float)0.0f, (BFacets)BFacets.make((String)"units", (BIDataValue)UnitDatabase.getUnit((String)"celsius")));
    public static final Property cpuTempHi = BHardwareMonitorNxtPlatformService.newProperty((int)0, (float)75.0f, (BFacets)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"celsius"), (int)1, (int)120));
    public static final Property boardTemp = BHardwareMonitorNxtPlatformService.newProperty((int)1, (float)0.0f, (BFacets)BFacets.make((String)"units", (BIDataValue)UnitDatabase.getUnit((String)"celsius")));
    public static final Property boardTempHi = BHardwareMonitorNxtPlatformService.newProperty((int)0, (float)70.0f, (BFacets)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"celsius"), (int)1, (int)120));
    public static final Property ramTemp = BHardwareMonitorNxtPlatformService.newProperty((int)1, (float)0.0f, (BFacets)BFacets.make((String)"units", (BIDataValue)UnitDatabase.getUnit((String)"celsius")));
    public static final Property ramTempHi = BHardwareMonitorNxtPlatformService.newProperty((int)0, (float)70.0f, (BFacets)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"celsius"), (int)1, (int)120));
    public static final Property cpuTemperatureAlarmSupport = BHardwareMonitorNxtPlatformService.newProperty((int)0, (BValue)BHardwareMonitorNxtPlatformService.initCpuTemperatureAlarmSupport(), null);
    public static final Property cpuTemperatureAlarmProxy = BHardwareMonitorNxtPlatformService.newProperty((int)6, (BValue)new BPlatformAlarmProxy(), null);
    public static final Property boardTemperatureAlarmSupport = BHardwareMonitorNxtPlatformService.newProperty((int)0, (BValue)BHardwareMonitorNxtPlatformService.initBoardTemperatureAlarmSupport(), null);
    public static final Property boardTemperatureAlarmProxy = BHardwareMonitorNxtPlatformService.newProperty((int)6, (BValue)new BPlatformAlarmProxy(), null);
    public static final Property ramTemperatureAlarmSupport = BHardwareMonitorNxtPlatformService.newProperty((int)0, (BValue)BHardwareMonitorNxtPlatformService.initRamTemperatureAlarmSupport(), null);
    public static final Property ramTemperatureAlarmProxy = BHardwareMonitorNxtPlatformService.newProperty((int)6, (BValue)new BPlatformAlarmProxy(), null);
    public static final Type TYPE;
    private static final BIcon icon;
    public static Log log;
    private static final String ALARM_TYPE_CPU_TEMPERATURE = "cpu temperature";
    private static final String ALARM_TYPE_BOARD_TEMPERATURE = "board temperature";
    private static final String ALARM_TYPE_RAM_TEMPERATURE = "ram temperature";
    int errorCode;
    private Clock.Ticket sysmonTicket;
    private boolean lastCpuTempOk;
    private boolean nowCpuTempOk;
    private boolean lastBoardTempOk;
    private boolean nowBoardTempOk;
    private boolean lastRamTempOk;
    private boolean nowRamTempOk;
    private int cpuTemperature;
    private int boardTemperature;
    private int ramTemperature;
    private int[] temperatures;
    Vector alarmListeners;
    protected boolean open;
    static /* synthetic */ Class class$com$tridium$platSysmonNxt$BHardwareMonitorNxtPlatformService;

    public BRelTime getSysmonPollRate() {
        return (BRelTime)this.get(sysmonPollRate);
    }

    public void setSysmonPollRate(BRelTime bRelTime) {
        this.set(sysmonPollRate, (BValue)bRelTime, null);
    }

    public float getCpuTemp() {
        return this.getFloat(cpuTemp);
    }

    public void setCpuTemp(float f) {
        this.setFloat(cpuTemp, f, null);
    }

    public float getCpuTempHi() {
        return this.getFloat(cpuTempHi);
    }

    public void setCpuTempHi(float f) {
        this.setFloat(cpuTempHi, f, null);
    }

    public float getBoardTemp() {
        return this.getFloat(boardTemp);
    }

    public void setBoardTemp(float f) {
        this.setFloat(boardTemp, f, null);
    }

    public float getBoardTempHi() {
        return this.getFloat(boardTempHi);
    }

    public void setBoardTempHi(float f) {
        this.setFloat(boardTempHi, f, null);
    }

    public float getRamTemp() {
        return this.getFloat(ramTemp);
    }

    public void setRamTemp(float f) {
        this.setFloat(ramTemp, f, null);
    }

    public float getRamTempHi() {
        return this.getFloat(ramTempHi);
    }

    public void setRamTempHi(float f) {
        this.setFloat(ramTempHi, f, null);
    }

    public BPlatformAlarmSupport getCpuTemperatureAlarmSupport() {
        return (BPlatformAlarmSupport)this.get(cpuTemperatureAlarmSupport);
    }

    public void setCpuTemperatureAlarmSupport(BPlatformAlarmSupport bPlatformAlarmSupport) {
        this.set(cpuTemperatureAlarmSupport, (BValue)bPlatformAlarmSupport, null);
    }

    public BPlatformAlarmProxy getCpuTemperatureAlarmProxy() {
        return (BPlatformAlarmProxy)this.get(cpuTemperatureAlarmProxy);
    }

    public void setCpuTemperatureAlarmProxy(BPlatformAlarmProxy bPlatformAlarmProxy) {
        this.set(cpuTemperatureAlarmProxy, (BValue)bPlatformAlarmProxy, null);
    }

    public BPlatformAlarmSupport getBoardTemperatureAlarmSupport() {
        return (BPlatformAlarmSupport)this.get(boardTemperatureAlarmSupport);
    }

    public void setBoardTemperatureAlarmSupport(BPlatformAlarmSupport bPlatformAlarmSupport) {
        this.set(boardTemperatureAlarmSupport, (BValue)bPlatformAlarmSupport, null);
    }

    public BPlatformAlarmProxy getBoardTemperatureAlarmProxy() {
        return (BPlatformAlarmProxy)this.get(boardTemperatureAlarmProxy);
    }

    public void setBoardTemperatureAlarmProxy(BPlatformAlarmProxy bPlatformAlarmProxy) {
        this.set(boardTemperatureAlarmProxy, (BValue)bPlatformAlarmProxy, null);
    }

    public BPlatformAlarmSupport getRamTemperatureAlarmSupport() {
        return (BPlatformAlarmSupport)this.get(ramTemperatureAlarmSupport);
    }

    public void setRamTemperatureAlarmSupport(BPlatformAlarmSupport bPlatformAlarmSupport) {
        this.set(ramTemperatureAlarmSupport, (BValue)bPlatformAlarmSupport, null);
    }

    public BPlatformAlarmProxy getRamTemperatureAlarmProxy() {
        return (BPlatformAlarmProxy)this.get(ramTemperatureAlarmProxy);
    }

    public void setRamTemperatureAlarmProxy(BPlatformAlarmProxy bPlatformAlarmProxy) {
        this.set(ramTemperatureAlarmProxy, (BValue)bPlatformAlarmProxy, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doStationStarted(BStation bStation) {
        super.doStationStarted(bStation);
        log.trace("......loading sysmon libraries");
        this.loadLibraries();
        log.trace("......symon libraries loaded");
        if (this.sysmonTicket != null) {
            this.sysmonTicket.cancel();
        }
        log.trace("......sysmon poll rate " + this.getSysmonPollRate());
        this.sysmonTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getSysmonPollRate(), (Action)poll, null);
        this.getCpuTemperatureAlarmProxy().setAlarmSupport(this.getCpuTemperatureAlarmSupport());
        this.getBoardTemperatureAlarmProxy().setAlarmSupport(this.getBoardTemperatureAlarmSupport());
        this.getRamTemperatureAlarmProxy().setAlarmSupport(this.getRamTemperatureAlarmSupport());
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        super.changed(property, context);
        if (property == sysmonPollRate) {
            if (this.sysmonTicket != null) {
                this.sysmonTicket.cancel();
            }
            this.sysmonTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getSysmonPollRate(), (Action)poll, null);
        }
    }

    public void doPoll(Context context) {
        log.trace("sysmonNxt poll");
        if (!this.open) {
            this.errorCode = this.open();
            if (!this.open) {
                System.out.println("diagbase driver error " + this.errorCode);
                return;
            }
        }
        try {
            BPlatformServiceAlarmRecord bPlatformServiceAlarmRecord;
            if (this.readTemperatures(this.temperatures) != 0) {
                System.out.println("unable to read temperatures");
                this.close();
                return;
            }
            this.cpuTemperature = this.temperatures[0];
            this.setCpuTemp(this.cpuTemperature);
            this.ramTemperature = this.temperatures[3];
            this.setRamTemp(this.ramTemperature);
            this.boardTemperature = this.temperatures[6];
            this.setBoardTemp(this.boardTemperature);
            log.trace("cpuBoardTemp --> " + this.cpuTemperature);
            log.trace("mainBoardTemp --> " + this.boardTemperature);
            log.trace("ramBoardTemp --> " + this.ramTemperature);
            boolean bl = false;
            if ((float)this.cpuTemperature < this.getCpuTempHi()) {
                bl = true;
            }
            this.nowCpuTempOk = bl;
            boolean bl2 = false;
            if (this.getCpuTemp() < this.getCpuTempHi()) {
                bl2 = true;
            }
            this.lastCpuTempOk = bl2;
            boolean bl3 = false;
            if ((float)this.boardTemperature < this.getBoardTempHi()) {
                bl3 = true;
            }
            this.nowBoardTempOk = bl3;
            boolean bl4 = false;
            if (this.getBoardTemp() < this.getBoardTempHi()) {
                bl4 = true;
            }
            this.lastBoardTempOk = bl4;
            boolean bl5 = false;
            if ((float)this.ramTemperature < this.getRamTempHi()) {
                bl5 = true;
            }
            this.nowRamTempOk = bl5;
            boolean bl6 = false;
            if (this.getRamTemp() < this.getRamTempHi()) {
                bl6 = this.lastRamTempOk = true;
            }
            if (this.nowCpuTempOk != this.lastCpuTempOk) {
                if (this.nowCpuTempOk) {
                    System.out.println("cpuTemp --> OK");
                    bPlatformServiceAlarmRecord = this.getCpuTemperatureAlarmSupport().makeToNormal();
                    this.getCpuTemperatureAlarmProxy().firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord);
                } else {
                    System.out.println("cpuTemp --> FAILED");
                    bPlatformServiceAlarmRecord = this.getCpuTemperatureAlarmSupport().makeNewFaultAlarm();
                    this.getCpuTemperatureAlarmProxy().firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord);
                }
            }
            if (this.nowBoardTempOk != this.lastBoardTempOk) {
                if (this.nowBoardTempOk) {
                    System.out.println("boardTemp --> OK");
                    bPlatformServiceAlarmRecord = this.getBoardTemperatureAlarmSupport().makeToNormal();
                    this.getBoardTemperatureAlarmProxy().firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord);
                } else {
                    System.out.println("boardTemp --> FAILED");
                    bPlatformServiceAlarmRecord = this.getBoardTemperatureAlarmSupport().makeNewFaultAlarm();
                    this.getBoardTemperatureAlarmProxy().firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord);
                }
            }
            if (this.nowRamTempOk != this.lastRamTempOk) {
                if (this.nowRamTempOk) {
                    System.out.println("ramTemp --> OK");
                    bPlatformServiceAlarmRecord = this.getRamTemperatureAlarmSupport().makeToNormal();
                    this.getRamTemperatureAlarmProxy().firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord);
                } else {
                    System.out.println("ramTemp --> FAILED");
                    bPlatformServiceAlarmRecord = this.getRamTemperatureAlarmSupport().makeNewFaultAlarm();
                    this.getRamTemperatureAlarmProxy().firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord);
                }
            }
        }
        catch (Exception exception) {
            System.out.println("exception in sysmonNxt doPoll()");
        }
    }

    protected abstract void loadLibraries();

    protected abstract int open();

    protected abstract int close();

    protected abstract int readTemperatures(int[] var1);

    public BIcon getIcon() {
        return icon;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public void addPlatformServiceAlarmListener(PlatformServiceAlarmListener platformServiceAlarmListener) {
        this.getCpuTemperatureAlarmProxy().addPlatformServiceAlarmListener(platformServiceAlarmListener);
        this.getBoardTemperatureAlarmProxy().addPlatformServiceAlarmListener(platformServiceAlarmListener);
        this.getRamTemperatureAlarmProxy().addPlatformServiceAlarmListener(platformServiceAlarmListener);
    }

    public void removePlatformServiceAlarmListener(PlatformServiceAlarmListener platformServiceAlarmListener) {
        this.getCpuTemperatureAlarmProxy().removePlatformServiceAlarmListener(platformServiceAlarmListener);
        this.getBoardTemperatureAlarmProxy().removePlatformServiceAlarmListener(platformServiceAlarmListener);
        this.getRamTemperatureAlarmProxy().removePlatformServiceAlarmListener(platformServiceAlarmListener);
    }

    public void firePlatformServiceAlarmEvent(BPlatformServiceAlarmRecord bPlatformServiceAlarmRecord) {
        throw new IllegalStateException();
    }

    public BBoolean ackAlarm(BPlatformServiceAlarmRecord bPlatformServiceAlarmRecord) {
        throw new IllegalStateException();
    }

    static BPlatformAlarmSupport initCpuTemperatureAlarmSupport() {
        BPlatformAlarmSupport bPlatformAlarmSupport = new BPlatformAlarmSupport();
        bPlatformAlarmSupport.setToFaultText(BFormat.make((String)"%lexicon(platSysmonNxt:cpuTemperatureFail)%"));
        bPlatformAlarmSupport.setToNormalText(BFormat.make((String)"%lexicon(platSysmonNxt:cpuTemperaturePassed)%"));
        HashMap<String, BString> hashMap = new HashMap<String, BString>();
        hashMap.put("alarmType", BString.make((String)ALARM_TYPE_CPU_TEMPERATURE));
        bPlatformAlarmSupport.setMetaData(BFacets.make(hashMap));
        return bPlatformAlarmSupport;
    }

    static BPlatformAlarmSupport initBoardTemperatureAlarmSupport() {
        BPlatformAlarmSupport bPlatformAlarmSupport = new BPlatformAlarmSupport();
        bPlatformAlarmSupport.setToFaultText(BFormat.make((String)"%lexicon(platSysmonNxt:boardTemperatureFail)%"));
        bPlatformAlarmSupport.setToNormalText(BFormat.make((String)"%lexicon(platSysmonNxt:boardTemperaturePassed)%"));
        HashMap<String, BString> hashMap = new HashMap<String, BString>();
        hashMap.put("alarmType", BString.make((String)ALARM_TYPE_BOARD_TEMPERATURE));
        bPlatformAlarmSupport.setMetaData(BFacets.make(hashMap));
        return bPlatformAlarmSupport;
    }

    static BPlatformAlarmSupport initRamTemperatureAlarmSupport() {
        BPlatformAlarmSupport bPlatformAlarmSupport = new BPlatformAlarmSupport();
        bPlatformAlarmSupport.setToFaultText(BFormat.make((String)"%lexicon(platSysmonNxt:ramTemperatureFail)%"));
        bPlatformAlarmSupport.setToNormalText(BFormat.make((String)"%lexicon(platSysmonNxt:ramTemperaturePassed)%"));
        HashMap<String, BString> hashMap = new HashMap<String, BString>();
        hashMap.put("alarmType", BString.make((String)ALARM_TYPE_RAM_TEMPERATURE));
        bPlatformAlarmSupport.setMetaData(BFacets.make(hashMap));
        return bPlatformAlarmSupport;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.errorCode = 0;
        this.temperatures = new int[9];
        this.alarmListeners = new Vector(1);
        this.open = false;
    }

    public BHardwareMonitorNxtPlatformService() {
        this.this();
        this.setPlatformServiceDescription(this.getLexicon().getText("HardwareMonitorNxtPlatformService.description"));
    }

    static {
        Class clazz = class$com$tridium$platSysmonNxt$BHardwareMonitorNxtPlatformService;
        if (clazz == null) {
            clazz = class$com$tridium$platSysmonNxt$BHardwareMonitorNxtPlatformService = BHardwareMonitorNxtPlatformService.class("[Lcom.tridium.platSysmonNxt.BHardwareMonitorNxtPlatformService;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"connection.png");
        log = Log.getLog((String)"sysmon");
    }
}

