/*
 * Decompiled with CFR 0.152.
 */
package com.viconics.wireless.comm;

import com.tridium.basicdriver.BBasicNetwork;
import com.tridium.basicdriver.comm.Comm;
import com.tridium.basicdriver.comm.CommReceiver;
import com.tridium.basicdriver.comm.CommTransactionManager;
import com.tridium.basicdriver.comm.CommTransmitter;
import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.basicdriver.serial.BSerialNetwork;
import com.tridium.basicdriver.util.BasicException;
import com.viconics.wireless.BWirelessStatNetwork;
import com.viconics.wireless.messages.WirelessStatMessage;
import java.io.InputStream;
import java.io.OutputStream;
import javax.baja.log.Log;
import javax.baja.serial.BISerialPort;
import javax.baja.serial.BISerialService;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class WirelessStatComm
extends Comm {
    public static final Log log = Log.getLog((String)"wireless.serial");
    private static final long MIN_SLEEP_TIME = 1L;
    private BISerialPort serialPort;
    private InputStream in;
    private OutputStream out;
    private Thread rxThread;
    private long lastRecvMessageTicks;
    private long lastSentMessageTicks;
    private long retryOnceMessages;
    private long retryMoreThanOnceMessages;
    private long messageFailed;
    private long noRetryMessages;

    protected boolean started() throws Exception {
        try {
            BISerialService bISerialService = (BISerialService)Sys.getService((Type)BISerialService.TYPE);
            this.serialPort = ((BSerialNetwork)this.getNetwork()).getSerialPortConfig().open(this.getNetwork().getName());
            this.serialPort.enableReceiveTimeout(bISerialService.getMinTimeout());
            this.in = this.serialPort.getInputStream();
            this.out = this.serialPort.getOutputStream();
        }
        catch (Exception exception) {
            String string = "Error opening and configuring the serial port";
            this.getNetwork().getLog().error(string, (Throwable)exception);
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (Exception exception2) {
                    this.getNetwork().getLog().error("Unable to close serial input stream.", (Throwable)exception2);
                }
            }
            if (this.out != null) {
                try {
                    this.out.close();
                }
                catch (Exception exception3) {
                    this.getNetwork().getLog().error("Unable to close serial output stream.", (Throwable)exception3);
                }
            }
            if (this.serialPort != null) {
                this.serialPort.close();
            }
            throw exception;
        }
        this.getCommReceiver().setInputStream(this.in);
        this.getCommTransmitter().setOutputStream(this.out);
        this.rxThread = new Thread((Runnable)this.getCommReceiver(), "SerialRcv:" + this.getNetwork().getName());
        this.getCommReceiver().setAlive(true);
        this.rxThread.start();
        this.rxThread.setPriority(5);
        return true;
    }

    protected void stopped() throws Exception {
        this.getCommReceiver().setAlive(false);
        if (this.getCommReceiver() != null && this.rxThread != null) {
            this.rxThread.interrupt();
        }
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (Exception exception) {
                this.getNetwork().getLog().error("Unable to close serial input stream.", (Throwable)exception);
            }
        }
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (Exception exception) {
                this.getNetwork().getLog().error("Unable to close serial output stream.", (Throwable)exception);
            }
        }
        if (this.serialPort != null) {
            this.serialPort.disableReceiveTimeout();
            this.serialPort.close();
        }
        this.in = null;
        this.out = null;
    }

    public Message transmit(Message message, BRelTime bRelTime, int n) throws BasicException {
        if (message == null) {
            return null;
        }
        if (!this.isCommStarted()) {
            throw new BasicException("Communication handler service not started.");
        }
        this.performSendMessageDelay();
        if (!message.getResponseExpected()) {
            this.transmitNoResponse(message);
            return null;
        }
        this.performInterMessageDelay();
        if (message == null) {
            return null;
        }
        if (!message.getResponseExpected()) {
            this.transmitNoResponse(message);
            return null;
        }
        BasicException basicException = null;
        Message message2 = null;
        try {
            int n2 = 0;
            while (n2 < n + 1) {
                if (n2 > 0) {
                    log.warning("Retries: [" + n2 + ']' + ((Object)((Object)((WirelessStatMessage)message))).toString());
                }
                if ((message2 = this.processTransmit(message, bRelTime)) != null && message2.getSuccessfulResponse()) {
                    if (n2 == 0) {
                        ++this.noRetryMessages;
                    }
                    if (n2 == 1) {
                        ++this.retryOnceMessages;
                    }
                    if (n2 <= 1) break;
                    ++this.retryMoreThanOnceMessages;
                    break;
                }
                ++n2;
            }
            if (message2 != null && !message2.getSuccessfulResponse()) {
                ++this.messageFailed;
                String string = "Unsuccessful response for request message sent.";
                log.error("Retries: " + string + ' ' + ((Object)((Object)((WirelessStatMessage)message))).toString());
                basicException = new BasicException(string);
            } else if (message2 == null) {
                ++this.messageFailed;
                log.error("Retries: timeout: " + ((Object)((Object)((WirelessStatMessage)message))).toString());
            }
        }
        catch (BasicException basicException2) {
            basicException = basicException2;
        }
        if (basicException != null) {
            if (basicException instanceof BasicException) {
                if (log.isTraceOn()) {
                    log.trace("Comm sendRequest exception: ", (Throwable)basicException);
                }
            } else {
                throw basicException;
            }
        }
        return message2;
    }

    public synchronized void transmitNoResponse(Message message) throws BasicException {
        if (message == null) {
            return;
        }
        if (!this.isCommStarted()) {
            throw new BasicException("Communication handler service not started.");
        }
        this.performSendMessageDelay();
        this.performInterMessageDelay();
        this.setSentMessageTicks(Clock.ticks());
        super.transmitNoResponse(message);
    }

    public void receive(ReceivedMessage receivedMessage) {
        if (receivedMessage == null) {
            return;
        }
        this.setReceivedMessageTicks(Clock.ticks());
        super.receive(receivedMessage);
    }

    protected void performInterMessageDelay() {
        int n = 0;
        long l = ((BSerialNetwork)this.getNetwork()).getInterMessageDelay().getMillis();
        if (l <= 0L) {
            return;
        }
        long l2 = Clock.ticks() - this.lastRecvMessageTicks;
        if (l2 >= l) {
            return;
        }
        ++n;
        long l3 = Math.max(l - l2, 1L);
        try {
            Thread.sleep(l3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void performSendMessageDelay() {
        int n = 0;
        long l = ((BWirelessStatNetwork)this.getNetwork()).getSendMessageDelay().getMillis();
        if (l <= 0L) {
            return;
        }
        long l2 = Clock.ticks() - this.lastSentMessageTicks;
        if (l2 >= l) {
            return;
        }
        ++n;
        long l3 = Math.max(l - l2, 1L);
        try {
            Thread.sleep(l3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void setReceivedMessageTicks(long l) {
        this.lastRecvMessageTicks = l;
    }

    protected void setSentMessageTicks(long l) {
        this.lastSentMessageTicks = l;
    }

    public BISerialPort getSerialPort() {
        return this.serialPort;
    }

    public long getRetryOnceMessages() {
        return this.retryOnceMessages;
    }

    public void setRetryOnceMessages(long l) {
        this.retryOnceMessages = l;
    }

    public long getRetryMoreThanOnceMessages() {
        return this.retryMoreThanOnceMessages;
    }

    public void setRetryMoreThanOnceMessages(long l) {
        this.retryMoreThanOnceMessages = l;
    }

    public long getMessageFailed() {
        return this.messageFailed;
    }

    public void setMessageFailed(long l) {
        this.messageFailed = l;
    }

    public long getNoRetryMessages() {
        return this.noRetryMessages;
    }

    public void setNoRetryMessages(long l) {
        this.noRetryMessages = l;
    }

    private final /* synthetic */ void this() {
        this.lastRecvMessageTicks = 0L;
        this.lastSentMessageTicks = 0L;
        this.retryOnceMessages = 0L;
        this.retryMoreThanOnceMessages = 0L;
        this.messageFailed = 0L;
        this.noRetryMessages = 0L;
    }

    public WirelessStatComm(BSerialNetwork bSerialNetwork, CommReceiver commReceiver) {
        super((BBasicNetwork)bSerialNetwork, commReceiver);
        this.this();
    }

    public WirelessStatComm(BSerialNetwork bSerialNetwork, CommReceiver commReceiver, CommTransmitter commTransmitter) {
        super((BBasicNetwork)bSerialNetwork, commReceiver, commTransmitter);
        this.this();
    }

    public WirelessStatComm(BSerialNetwork bSerialNetwork, CommReceiver commReceiver, CommTransmitter commTransmitter, CommTransactionManager commTransactionManager) {
        super((BBasicNetwork)bSerialNetwork, commReceiver, commTransmitter, commTransactionManager);
        this.this();
    }
}

