/*
 * Decompiled with CFR 0.152.
 */
package com.viconics.wireless.comm;

import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.basicdriver.util.BBasicUnsolicitedReceive;
import com.viconics.wireless.BWirelessStatDevice;
import com.viconics.wireless.BWirelessStatNetwork;
import com.viconics.wireless.BWirelessStatPointBuilder;
import com.viconics.wireless.comm.BWirelessStatReplyParser;
import com.viconics.wireless.comm.ResponseThread;
import com.viconics.wireless.comm.TagObject;
import com.viconics.wireless.messages.WirelessStatMessageConst;
import com.viconics.wireless.messages.WirelessStatReceivedMessage;
import com.viconics.wireless.misc.BUtils;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BEnumWritable;
import javax.baja.control.BNumericPoint;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BWirelessStatUnsolicitedReceive
extends BBasicUnsolicitedReceive
implements WirelessStatMessageConst {
    public static final Type TYPE;
    private int sigStr;
    static /* synthetic */ Class class$com$viconics$wireless$comm$BWirelessStatUnsolicitedReceive;

    public Type getType() {
        return TYPE;
    }

    BWirelessStatNetwork getNetwork() {
        return (BWirelessStatNetwork)this.getParent();
    }

    protected void processUnsolicitedMessage(ReceivedMessage receivedMessage) {
        WirelessStatReceivedMessage wirelessStatReceivedMessage = (WirelessStatReceivedMessage)receivedMessage;
        if (wirelessStatReceivedMessage.getCRCValid()) {
            TagObject tagObject = new TagObject(wirelessStatReceivedMessage.getCommAddress(), Integer.parseInt(wirelessStatReceivedMessage.getMsgType(), 16), Integer.parseInt(wirelessStatReceivedMessage.getCommandType(), 16), Integer.parseInt(wirelessStatReceivedMessage.getTransactionSequence(), 16));
            if (this.getNetwork().getHash().get(tagObject) != null) {
                ((ResponseThread)this.getNetwork().getHash().get(tagObject)).requestedStop();
            } else if (wirelessStatReceivedMessage.getCommandType().equalsIgnoreCase("01") || wirelessStatReceivedMessage.getCommandType().equalsIgnoreCase("03")) {
                BUtils.trace("Message not found in hash table: (tag: " + tagObject + ')' + ((WirelessStatReceivedMessage)receivedMessage).toString());
            }
        } else {
            System.out.println("Rejecting message with invalid CRC: " + ((WirelessStatReceivedMessage)receivedMessage).toString());
        }
        this.processResponse(wirelessStatReceivedMessage);
    }

    public void processResponse(WirelessStatReceivedMessage wirelessStatReceivedMessage) {
        if (wirelessStatReceivedMessage.getCRCValid()) {
            int n = wirelessStatReceivedMessage.getCommAddress();
            this.setSigStr(wirelessStatReceivedMessage.getSigStr());
            if (wirelessStatReceivedMessage.getCommAddress() != 0 && BWirelessStatNetwork.devArray[wirelessStatReceivedMessage.getCommAddress()] == null && !wirelessStatReceivedMessage.getMsgType().equalsIgnoreCase("0000")) {
                if (!Sys.atSteadyState()) {
                    return;
                }
                BWirelessStatReplyParser.dataOutReplyReq(this.getNetwork(), "0000", "00", wirelessStatReceivedMessage.getCommAddress(), BWirelessStatNetwork.makeTransString(), "01", null);
                return;
            }
            if (wirelessStatReceivedMessage.getMsgType().equalsIgnoreCase("0001")) {
                if (wirelessStatReceivedMessage.getCommandType().equalsIgnoreCase("02")) {
                    BWirelessStatReplyParser.dataOutNoReply(this.getNetwork(), wirelessStatReceivedMessage.getMsgType(), "03", wirelessStatReceivedMessage.getCommAddress(), wirelessStatReceivedMessage.getTransactionSequence(), "");
                    if (BWirelessStatNetwork.devArray[n] != null) {
                        BWirelessStatDevice bWirelessStatDevice = (BWirelessStatDevice)BWirelessStatNetwork.devArray[n];
                        bWirelessStatDevice.setLastHeartbeat(System.currentTimeMillis());
                        int n2 = wirelessStatReceivedMessage.getData().length();
                        if (n2 > 0) {
                            int n3 = this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(0, 2));
                            if (bWirelessStatDevice.getAdded() && n3 == 0) {
                                BWirelessStatReplyParser.dataOutReplyReq(this.getNetwork(), "0003", "02", n, BWirelessStatNetwork.makeTransString(), "01", bWirelessStatDevice);
                            } else if (!bWirelessStatDevice.getAdded() && n3 == 1) {
                                BWirelessStatReplyParser.dataOutReplyReq(this.getNetwork(), "0003", "02", n, BWirelessStatNetwork.makeTransString(), "00", bWirelessStatDevice);
                            }
                        }
                    } else {
                        BWirelessStatReplyParser.dataOutReplyReq(this.getNetwork(), "0000", "00", n, BWirelessStatNetwork.makeTransString(), "01", null);
                    }
                }
            } else if (wirelessStatReceivedMessage.getMsgType().equalsIgnoreCase("0000")) {
                if (wirelessStatReceivedMessage.getCommandType().equalsIgnoreCase("02")) {
                    int n4 = 0;
                    int n5 = 0;
                    int n6 = 0;
                    int n7 = 0;
                    String string = "";
                    String string2 = "";
                    int n8 = this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(0, 2));
                    n4 = this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(2, 4));
                    n5 = this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(4, 6));
                    n6 = this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(6, 8));
                    string = wirelessStatReceivedMessage.getData().substring(8, 12);
                    string2 = wirelessStatReceivedMessage.getData().substring(12, 28);
                    n7 = this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(28, 30));
                    try {
                        if (BWirelessStatNetwork.devArray[n] == null) {
                            if (!Sys.atSteadyState()) {
                                return;
                            }
                            BWirelessStatPointBuilder.createDisabledDevice(n8, n, this.getSigStr(), this.getNetwork());
                        }
                        this.getNetwork().setZigbeeInfo(n, this.getSigStr(), n4, n8, n5, n6, string, string2, n7);
                        BWirelessStatReplyParser.dataOutNoReply(this.getNetwork(), wirelessStatReceivedMessage.getMsgType(), "03", wirelessStatReceivedMessage.getCommAddress(), wirelessStatReceivedMessage.getTransactionSequence(), "");
                    }
                    catch (Exception exception) {
                        BUtils.error(exception.getMessage());
                    }
                } else if (wirelessStatReceivedMessage.getCommandType().equalsIgnoreCase("01")) {
                    int n9 = 0;
                    int n10 = 0;
                    int n11 = 0;
                    String string = "";
                    String string3 = "";
                    int n12 = 0;
                    int n13 = this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(2, 4));
                    if (wirelessStatReceivedMessage.getData().length() >= 12) {
                        n9 = this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(4, 6));
                        n10 = this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(6, 8));
                        n11 = this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(8, 10));
                        string = wirelessStatReceivedMessage.getData().substring(10, 14);
                        string3 = wirelessStatReceivedMessage.getData().length() >= 30 ? wirelessStatReceivedMessage.getData().substring(14, 30) : "";
                        n12 = wirelessStatReceivedMessage.getData().length() >= 32 ? this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(30, 32)) : 0;
                        try {
                            if (BWirelessStatNetwork.devArray[n] == null) {
                                if (!Sys.atSteadyState()) {
                                    return;
                                }
                                BWirelessStatPointBuilder.createDisabledDevice(n13, n, this.getSigStr(), this.getNetwork());
                            }
                            this.getNetwork().setZigbeeInfo(n, this.getSigStr(), n9, n13, n10, n11, string, string3, n12);
                        }
                        catch (Exception exception) {
                            BUtils.error(exception.getMessage());
                        }
                    }
                }
            } else if (wirelessStatReceivedMessage.getMsgType().equalsIgnoreCase("0100")) {
                if (wirelessStatReceivedMessage.getCommandType().equalsIgnoreCase("02")) {
                    this.getNetwork().setTemps(n, this.getSigStr(), this.HexStringToFloat(wirelessStatReceivedMessage.getData().substring(0, 4)), this.HexStringToFloat(wirelessStatReceivedMessage.getData().substring(4, 8)), this.HexStringToFloat(wirelessStatReceivedMessage.getData().substring(8, 12)), this.HexStringToFloat(wirelessStatReceivedMessage.getData().substring(12, 16)) * 10.0f, this.HexStringToFloat(wirelessStatReceivedMessage.getData().substring(16, 20)) * 10.0f, this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(20, 21)));
                    BWirelessStatReplyParser.dataOutNoReply(this.getNetwork(), wirelessStatReceivedMessage.getMsgType(), "03", wirelessStatReceivedMessage.getCommAddress(), wirelessStatReceivedMessage.getTransactionSequence(), "");
                } else if (wirelessStatReceivedMessage.getCommandType().equalsIgnoreCase("00")) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(BWirelessStatUnsolicitedReceive.wordToHex((int)(((BNumericPoint)this.getPoint(wirelessStatReceivedMessage.getCommAddress(), "RoomTemp")).getOut().getValue() * 10.0)));
                    stringBuffer.append(BWirelessStatUnsolicitedReceive.wordToHex((int)(((BNumericPoint)this.getPoint(wirelessStatReceivedMessage.getCommAddress(), "OutdoorTemp")).getOut().getValue() * 10.0)));
                    stringBuffer.append(BWirelessStatUnsolicitedReceive.wordToHex((int)(((BNumericPoint)this.getPoint(wirelessStatReceivedMessage.getCommAddress(), "OutdoorTemp")).getOut().getValue() * 10.0)));
                    stringBuffer.append(BWirelessStatUnsolicitedReceive.wordToHex((int)(((BNumericPoint)this.getPoint(wirelessStatReceivedMessage.getCommAddress(), "SupplyTemp")).getOut().getValue() * 10.0)));
                    stringBuffer.append(BWirelessStatUnsolicitedReceive.wordToHex((int)((BNumericPoint)this.getPoint(wirelessStatReceivedMessage.getCommAddress(), "PIHeatingDemand")).getOut().getValue()));
                    stringBuffer.append(BWirelessStatUnsolicitedReceive.wordToHex((int)((BNumericPoint)this.getPoint(wirelessStatReceivedMessage.getCommAddress(), "PICoolingDemand")).getOut().getValue()));
                    BWirelessStatReplyParser.dataOutNoReply(this.getNetwork(), wirelessStatReceivedMessage.getMsgType(), "01", wirelessStatReceivedMessage.getCommAddress(), wirelessStatReceivedMessage.getTransactionSequence(), stringBuffer.toString());
                    stringBuffer = null;
                }
            } else if (wirelessStatReceivedMessage.getMsgType().equalsIgnoreCase("0101")) {
                if (wirelessStatReceivedMessage.getCommandType().equalsIgnoreCase("02")) {
                    this.getNetwork().setTSetpoints(n, this.getSigStr(), this.HexStringToFloat(wirelessStatReceivedMessage.getData().substring(0, 4)), this.HexStringToFloat(wirelessStatReceivedMessage.getData().substring(4, 8)), this.HexStringToFloat(wirelessStatReceivedMessage.getData().substring(8, 12)), this.HexStringToFloat(wirelessStatReceivedMessage.getData().substring(12, 16)), this.HexStringToFloat(wirelessStatReceivedMessage.getData().substring(16, 20)), this.HexStringToFloat(wirelessStatReceivedMessage.getData().substring(20, 24)));
                    BWirelessStatReplyParser.dataOutNoReply(this.getNetwork(), wirelessStatReceivedMessage.getMsgType(), "03", wirelessStatReceivedMessage.getCommAddress(), wirelessStatReceivedMessage.getTransactionSequence(), "");
                } else if (wirelessStatReceivedMessage.getCommandType().equalsIgnoreCase("00")) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(BWirelessStatUnsolicitedReceive.wordToHex((int)(((BNumericPoint)this.getPoint(wirelessStatReceivedMessage.getCommAddress(), "OccCoolSetpoint")).getOut().getValue() * 10.0)));
                    stringBuffer.append(BWirelessStatUnsolicitedReceive.wordToHex((int)(((BNumericPoint)this.getPoint(wirelessStatReceivedMessage.getCommAddress(), "OccHeatSetpoint")).getOut().getValue() * 10.0)));
                    stringBuffer.append(BWirelessStatUnsolicitedReceive.wordToHex((int)(((BNumericPoint)this.getPoint(wirelessStatReceivedMessage.getCommAddress(), "UnOccCoolSetpoint")).getOut().getValue() * 10.0)));
                    stringBuffer.append(BWirelessStatUnsolicitedReceive.wordToHex((int)(((BNumericPoint)this.getPoint(wirelessStatReceivedMessage.getCommAddress(), "UnOccHeatSetpoint")).getOut().getValue() * 10.0)));
                    if (this.getPoint(wirelessStatReceivedMessage.getCommAddress(), "StandByCoolSetpoint") != null) {
                        stringBuffer.append(BWirelessStatUnsolicitedReceive.wordToHex((int)(((BNumericPoint)this.getPoint(wirelessStatReceivedMessage.getCommAddress(), "StandByCoolSetpoint")).getOut().getValue() * 10.0)));
                    } else {
                        stringBuffer.append("7FFF");
                    }
                    if (this.getPoint(wirelessStatReceivedMessage.getCommAddress(), "StandByHeatSetpoint") != null) {
                        stringBuffer.append(BWirelessStatUnsolicitedReceive.wordToHex((int)(((BNumericPoint)this.getPoint(wirelessStatReceivedMessage.getCommAddress(), "StandByHeatSetpoint")).getOut().getValue() * 10.0)));
                    } else {
                        stringBuffer.append("7FFF");
                    }
                    BWirelessStatReplyParser.dataOutNoReply(this.getNetwork(), wirelessStatReceivedMessage.getMsgType(), "01", wirelessStatReceivedMessage.getCommAddress(), wirelessStatReceivedMessage.getTransactionSequence(), stringBuffer.toString());
                    stringBuffer = null;
                }
            } else if (wirelessStatReceivedMessage.getMsgType().equalsIgnoreCase("0102")) {
                if (wirelessStatReceivedMessage.getCommandType().equalsIgnoreCase("02")) {
                    this.getNetwork().setTStatValues(n, this.getSigStr(), this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(0, 2)), this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(2, 4)), this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(4, 6)), this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(6, 8)));
                    BWirelessStatReplyParser.dataOutNoReply(this.getNetwork(), wirelessStatReceivedMessage.getMsgType(), "03", wirelessStatReceivedMessage.getCommAddress(), wirelessStatReceivedMessage.getTransactionSequence(), "");
                } else if (wirelessStatReceivedMessage.getCommandType().equalsIgnoreCase("00")) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(BWirelessStatUnsolicitedReceive.byteToHex(((BEnumWritable)this.getPoint(wirelessStatReceivedMessage.getCommAddress(), "EffectiveOccupancy")).getOut().getEnum().getOrdinal() - 1));
                    stringBuffer.append(BWirelessStatUnsolicitedReceive.byteToHex(((BEnumWritable)this.getPoint(wirelessStatReceivedMessage.getCommAddress(), "KeypadLockout")).getOut().getEnum().getOrdinal() - 1));
                    int n14 = ((BEnumPoint)this.getPoint(wirelessStatReceivedMessage.getCommAddress(), "Alarms")).getOut().getEnum().getOrdinal() - 1;
                    BWirelessStatDevice bWirelessStatDevice = (BWirelessStatDevice)BWirelessStatNetwork.devArray[n];
                    if (!bWirelessStatDevice.isVT76Device()) {
                        switch (((BEnumPoint)this.getPoint(wirelessStatReceivedMessage.getCommAddress(), "Alarms")).getOut().getEnum().getOrdinal()) {
                            case 1: {
                                n14 = 0;
                                break;
                            }
                            case 2: {
                                n14 = 128;
                                break;
                            }
                            case 3: {
                                n14 = 4;
                                break;
                            }
                            case 4: {
                                n14 = 8;
                                break;
                            }
                            case 5: {
                                n14 = 132;
                                break;
                            }
                            case 6: {
                                n14 = 136;
                                break;
                            }
                            case 7: {
                                n14 = 12;
                                break;
                            }
                        }
                    }
                    stringBuffer.append(BWirelessStatUnsolicitedReceive.byteToHex(n14));
                    stringBuffer.append(BWirelessStatUnsolicitedReceive.byteToHex(((BEnumWritable)this.getPoint(wirelessStatReceivedMessage.getCommAddress(), "OccupancyCommand")).getOut().getEnum().getOrdinal() - 1));
                    BWirelessStatReplyParser.dataOutNoReply(this.getNetwork(), wirelessStatReceivedMessage.getMsgType(), "01", wirelessStatReceivedMessage.getCommAddress(), wirelessStatReceivedMessage.getTransactionSequence(), stringBuffer.toString());
                    stringBuffer = null;
                }
            } else if (wirelessStatReceivedMessage.getMsgType().equalsIgnoreCase("0104")) {
                if (wirelessStatReceivedMessage.getCommandType().equalsIgnoreCase("02")) {
                    this.getNetwork().setCommonThermostatPIRStatus(n, this.getSigStr(), this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(0, 2)));
                    BWirelessStatReplyParser.dataOutNoReply(this.getNetwork(), wirelessStatReceivedMessage.getMsgType(), "03", wirelessStatReceivedMessage.getCommAddress(), wirelessStatReceivedMessage.getTransactionSequence(), "");
                }
            } else if (wirelessStatReceivedMessage.getMsgType().equalsIgnoreCase("0200")) {
                if (wirelessStatReceivedMessage.getCommandType().equalsIgnoreCase("02")) {
                    int n15 = wirelessStatReceivedMessage.getData().length();
                    if (n15 > 8) {
                        this.getNetwork().setTStatHumidity(n, this.getSigStr(), this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(0, 4)), this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(4, 6)), this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(6, 8)), this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(8, 9)));
                    } else {
                        this.getNetwork().setTStatHumidity(n, this.getSigStr(), this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(0, 4)), this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(4, 6)), this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(6, 8)));
                    }
                    BWirelessStatReplyParser.dataOutNoReply(this.getNetwork(), wirelessStatReceivedMessage.getMsgType(), "03", wirelessStatReceivedMessage.getCommAddress(), wirelessStatReceivedMessage.getTransactionSequence(), "");
                } else if (wirelessStatReceivedMessage.getCommandType().equalsIgnoreCase("00")) {
                    StringBuffer stringBuffer = new StringBuffer();
                    BWirelessStatDevice bWirelessStatDevice = (BWirelessStatDevice)BWirelessStatNetwork.devArray[n];
                    if (bWirelessStatDevice.isVT76Device()) {
                        stringBuffer.append(BWirelessStatUnsolicitedReceive.wordToHex((int)(((BNumericPoint)this.getPoint(wirelessStatReceivedMessage.getCommAddress(), "RoomHumidity")).getOut().getValue() / 10.0)));
                    } else {
                        stringBuffer.append(BWirelessStatUnsolicitedReceive.wordToHex((int)((BNumericPoint)this.getPoint(wirelessStatReceivedMessage.getCommAddress(), "RoomHumidity")).getOut().getValue()));
                    }
                    int n16 = 0;
                    if (((BBooleanPoint)this.getPoint(wirelessStatReceivedMessage.getCommAddress(), "DehumidStatus")).getOut().getValue()) {
                        n16 = 1;
                    }
                    stringBuffer.append(BWirelessStatUnsolicitedReceive.byteToHex(n16));
                    int n17 = 0;
                    if (((BBooleanWritable)this.getPoint(wirelessStatReceivedMessage.getCommAddress(), "DehumidLockout")).getOut().getValue()) {
                        n17 = 1;
                    }
                    stringBuffer.append(BWirelessStatUnsolicitedReceive.byteToHex(n17));
                    BWirelessStatReplyParser.dataOutNoReply(this.getNetwork(), wirelessStatReceivedMessage.getMsgType(), "01", wirelessStatReceivedMessage.getCommAddress(), wirelessStatReceivedMessage.getTransactionSequence(), stringBuffer.toString());
                    stringBuffer = null;
                }
            } else if (wirelessStatReceivedMessage.getMsgType().equalsIgnoreCase("0201")) {
                if (wirelessStatReceivedMessage.getCommandType().equalsIgnoreCase("02")) {
                    this.getNetwork().setTStatFanControl(n, this.getSigStr(), this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(0, 2)), this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(2, 4)), this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(4, 6)));
                    BWirelessStatReplyParser.dataOutNoReply(this.getNetwork(), wirelessStatReceivedMessage.getMsgType(), "03", wirelessStatReceivedMessage.getCommAddress(), wirelessStatReceivedMessage.getTransactionSequence(), "");
                } else {
                    wirelessStatReceivedMessage.getCommandType().equalsIgnoreCase("00");
                }
            } else if (wirelessStatReceivedMessage.getMsgType().equalsIgnoreCase("0202")) {
                if (wirelessStatReceivedMessage.getCommandType().equalsIgnoreCase("02")) {
                    this.getNetwork().setTSValveStatus(n, this.getSigStr(), this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(0, 2)), this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(2, 4)));
                    BWirelessStatReplyParser.dataOutNoReply(this.getNetwork(), wirelessStatReceivedMessage.getMsgType(), "03", wirelessStatReceivedMessage.getCommAddress(), wirelessStatReceivedMessage.getTransactionSequence(), "");
                } else if (wirelessStatReceivedMessage.getCommandType().equalsIgnoreCase("00")) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(BWirelessStatUnsolicitedReceive.byteToHex(((BEnumWritable)this.getPoint(wirelessStatReceivedMessage.getCommAddress(), "HeatValveStatus")).getOut().getEnum().getOrdinal() - 1));
                    stringBuffer.append(BWirelessStatUnsolicitedReceive.byteToHex(((BEnumWritable)this.getPoint(wirelessStatReceivedMessage.getCommAddress(), "CoolValveStatus")).getOut().getEnum().getOrdinal() - 1));
                    BWirelessStatReplyParser.dataOutNoReply(this.getNetwork(), wirelessStatReceivedMessage.getMsgType(), "01", wirelessStatReceivedMessage.getCommAddress(), wirelessStatReceivedMessage.getTransactionSequence(), stringBuffer.toString());
                    stringBuffer = null;
                }
            } else if (wirelessStatReceivedMessage.getMsgType().equalsIgnoreCase("0203")) {
                if (wirelessStatReceivedMessage.getCommandType().equalsIgnoreCase("02")) {
                    this.getNetwork().setTSOutputStatus(n, this.getSigStr(), this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(0, 2)), this.HexStringToFloat(wirelessStatReceivedMessage.getData().substring(2, 6)), this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(6, 8)), this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(8, 10)));
                    BWirelessStatReplyParser.dataOutNoReply(this.getNetwork(), wirelessStatReceivedMessage.getMsgType(), "03", wirelessStatReceivedMessage.getCommAddress(), wirelessStatReceivedMessage.getTransactionSequence(), "");
                } else if (wirelessStatReceivedMessage.getCommandType().equalsIgnoreCase("00")) {
                    StringBuffer stringBuffer = new StringBuffer();
                    BWirelessStatDevice bWirelessStatDevice = (BWirelessStatDevice)BWirelessStatNetwork.devArray[n];
                    stringBuffer.append(BWirelessStatUnsolicitedReceive.byteToHex(bWirelessStatDevice.getStatusBit()));
                    stringBuffer.append(BWirelessStatUnsolicitedReceive.wordToHex((int)(((BNumericPoint)this.getPoint(wirelessStatReceivedMessage.getCommAddress(), "UI3Status")).getOut().getValue() * 10.0)));
                    stringBuffer.append(BWirelessStatUnsolicitedReceive.byteToHex(((BEnumWritable)this.getPoint(wirelessStatReceivedMessage.getCommAddress(), "SystemMode")).getOut().getValue().getOrdinal() - 1));
                    stringBuffer.append(BWirelessStatUnsolicitedReceive.byteToHex(((BEnumWritable)this.getPoint(wirelessStatReceivedMessage.getCommAddress(), "SequenceOfOperation")).getOut().getValue().getOrdinal() - 1));
                    BWirelessStatReplyParser.dataOutNoReply(this.getNetwork(), wirelessStatReceivedMessage.getMsgType(), "01", wirelessStatReceivedMessage.getCommAddress(), wirelessStatReceivedMessage.getTransactionSequence(), stringBuffer.toString());
                    stringBuffer = null;
                }
            } else if (wirelessStatReceivedMessage.getMsgType().equalsIgnoreCase("0204")) {
                if (wirelessStatReceivedMessage.getCommandType().equalsIgnoreCase("02")) {
                    this.getNetwork().setTSHPU(n, this.getSigStr(), this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(0, 2)), this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(2, 4)));
                    BWirelessStatReplyParser.dataOutNoReply(this.getNetwork(), wirelessStatReceivedMessage.getMsgType(), "03", wirelessStatReceivedMessage.getCommAddress(), wirelessStatReceivedMessage.getTransactionSequence(), "");
                } else if (wirelessStatReceivedMessage.getCommandType().equalsIgnoreCase("00")) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(BWirelessStatUnsolicitedReceive.byteToHex(((BEnumWritable)this.getPoint(wirelessStatReceivedMessage.getCommAddress(), "SystemModeHPU")).getOut().getValue().getOrdinal() - 1));
                    int n18 = 0;
                    if (((BBooleanWritable)this.getPoint(wirelessStatReceivedMessage.getCommAddress(), "ReversingValveStatus")).getOut().getValue()) {
                        n18 = 1;
                    }
                    stringBuffer.append(BWirelessStatUnsolicitedReceive.byteToHex(n18));
                    BWirelessStatReplyParser.dataOutNoReply(this.getNetwork(), wirelessStatReceivedMessage.getMsgType(), "01", wirelessStatReceivedMessage.getCommAddress(), wirelessStatReceivedMessage.getTransactionSequence(), stringBuffer.toString());
                    stringBuffer = null;
                }
            } else if (wirelessStatReceivedMessage.getMsgType().equalsIgnoreCase("0205")) {
                if (wirelessStatReceivedMessage.getCommandType().equalsIgnoreCase("02")) {
                    this.getNetwork().setTSOutputStatusVT7600(n, this.getSigStr(), this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(0, 2)), this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(2, 4)));
                    BWirelessStatReplyParser.dataOutNoReply(this.getNetwork(), wirelessStatReceivedMessage.getMsgType(), "03", wirelessStatReceivedMessage.getCommAddress(), wirelessStatReceivedMessage.getTransactionSequence(), "");
                } else if (wirelessStatReceivedMessage.getCommandType().equalsIgnoreCase("00")) {
                    StringBuffer stringBuffer = new StringBuffer();
                    BWirelessStatDevice bWirelessStatDevice = (BWirelessStatDevice)BWirelessStatNetwork.devArray[n];
                    stringBuffer.append(BWirelessStatUnsolicitedReceive.byteToHex(bWirelessStatDevice.getStatusBit()));
                    stringBuffer.append(BWirelessStatUnsolicitedReceive.byteToHex(((BEnumWritable)this.getPoint(wirelessStatReceivedMessage.getCommAddress(), "FanMode")).getOut().getEnum().getOrdinal() - 1));
                    BWirelessStatReplyParser.dataOutNoReply(this.getNetwork(), wirelessStatReceivedMessage.getMsgType(), "01", wirelessStatReceivedMessage.getCommAddress(), wirelessStatReceivedMessage.getTransactionSequence(), stringBuffer.toString());
                    stringBuffer = null;
                }
            } else if (wirelessStatReceivedMessage.getMsgType().equalsIgnoreCase("0206")) {
                if (wirelessStatReceivedMessage.getCommandType().equalsIgnoreCase("02")) {
                    this.getNetwork().setTSRTU(n, this.getSigStr(), this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(0, 2)));
                    BWirelessStatReplyParser.dataOutNoReply(this.getNetwork(), wirelessStatReceivedMessage.getMsgType(), "03", wirelessStatReceivedMessage.getCommAddress(), wirelessStatReceivedMessage.getTransactionSequence(), "");
                } else if (wirelessStatReceivedMessage.getCommandType().equalsIgnoreCase("00")) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(BWirelessStatUnsolicitedReceive.byteToHex(((BEnumWritable)this.getPoint(wirelessStatReceivedMessage.getCommAddress(), "SystemModeRTU")).getOut().getValue().getOrdinal() - 1));
                    BWirelessStatReplyParser.dataOutNoReply(this.getNetwork(), wirelessStatReceivedMessage.getMsgType(), "01", wirelessStatReceivedMessage.getCommAddress(), wirelessStatReceivedMessage.getTransactionSequence(), stringBuffer.toString());
                    stringBuffer = null;
                }
            } else if (wirelessStatReceivedMessage.getMsgType().equalsIgnoreCase("0207")) {
                if (wirelessStatReceivedMessage.getCommandType().equalsIgnoreCase("02")) {
                    this.getNetwork().setTSEconimizer(n, this.getSigStr(), this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(0, 4)));
                    BWirelessStatReplyParser.dataOutNoReply(this.getNetwork(), wirelessStatReceivedMessage.getMsgType(), "03", wirelessStatReceivedMessage.getCommAddress(), wirelessStatReceivedMessage.getTransactionSequence(), "");
                } else if (wirelessStatReceivedMessage.getCommandType().equalsIgnoreCase("00")) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(BWirelessStatUnsolicitedReceive.byteToHex((int)((BNumericPoint)this.getPoint(wirelessStatReceivedMessage.getCommAddress(), "EconomizerOutput")).getOut().getValue()));
                    BWirelessStatReplyParser.dataOutNoReply(this.getNetwork(), wirelessStatReceivedMessage.getMsgType(), "01", wirelessStatReceivedMessage.getCommAddress(), wirelessStatReceivedMessage.getTransactionSequence(), stringBuffer.toString());
                    stringBuffer = null;
                }
            } else if (wirelessStatReceivedMessage.getMsgType().equalsIgnoreCase("0208")) {
                if (wirelessStatReceivedMessage.getCommandType().equalsIgnoreCase("02")) {
                    this.getNetwork().setTSTwoStageHeating(n, this.getSigStr(), this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(0, 2)));
                    BWirelessStatReplyParser.dataOutNoReply(this.getNetwork(), wirelessStatReceivedMessage.getMsgType(), "03", wirelessStatReceivedMessage.getCommAddress(), wirelessStatReceivedMessage.getTransactionSequence(), "");
                } else if (wirelessStatReceivedMessage.getCommandType().equalsIgnoreCase("00")) {
                    StringBuffer stringBuffer = new StringBuffer();
                    int n19 = 0;
                    if (((BBooleanPoint)this.getPoint(n, "W2Status")).getOut().getValue()) {
                        n19 = 1;
                    }
                    stringBuffer.append(BWirelessStatUnsolicitedReceive.byteToHex(n19));
                    BWirelessStatReplyParser.dataOutNoReply(this.getNetwork(), wirelessStatReceivedMessage.getMsgType(), "03", wirelessStatReceivedMessage.getCommAddress(), wirelessStatReceivedMessage.getTransactionSequence(), stringBuffer.toString());
                    stringBuffer = null;
                }
            } else if (wirelessStatReceivedMessage.getMsgType().equalsIgnoreCase("0209")) {
                if (wirelessStatReceivedMessage.getCommandType().equalsIgnoreCase("02")) {
                    this.getNetwork().setTSTwoStageCooling(n, this.getSigStr(), this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(0, 2)));
                    BWirelessStatReplyParser.dataOutNoReply(this.getNetwork(), wirelessStatReceivedMessage.getMsgType(), "03", wirelessStatReceivedMessage.getCommAddress(), wirelessStatReceivedMessage.getTransactionSequence(), "");
                } else if (wirelessStatReceivedMessage.getCommandType().equalsIgnoreCase("00")) {
                    StringBuffer stringBuffer = new StringBuffer();
                    int n20 = 0;
                    if (((BBooleanPoint)this.getPoint(n, "Y2Status")).getOut().getValue()) {
                        n20 = 1;
                    }
                    stringBuffer.append(BWirelessStatUnsolicitedReceive.byteToHex(n20));
                    BWirelessStatReplyParser.dataOutNoReply(this.getNetwork(), wirelessStatReceivedMessage.getMsgType(), "01", wirelessStatReceivedMessage.getCommAddress(), wirelessStatReceivedMessage.getTransactionSequence(), stringBuffer.toString());
                    stringBuffer = null;
                }
            } else if (wirelessStatReceivedMessage.getMsgType().equalsIgnoreCase("020A")) {
                if (wirelessStatReceivedMessage.getCommandType().equalsIgnoreCase("02")) {
                    this.getNetwork().setTSSchedule(n, this.getSigStr(), this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(0, 2)), this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(2, 6)), this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(6, 10)), this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(10, 14)), this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(14, 18)));
                    BWirelessStatReplyParser.dataOutNoReply(this.getNetwork(), wirelessStatReceivedMessage.getMsgType(), "03", wirelessStatReceivedMessage.getCommAddress(), wirelessStatReceivedMessage.getTransactionSequence(), "");
                } else if (wirelessStatReceivedMessage.getCommandType().equalsIgnoreCase("00")) {
                    String string = "";
                    BWirelessStatReplyParser.dataOutReplyReq(this.getNetwork(), "020A", "02", n, BWirelessStatNetwork.makeTransString(), string, null);
                }
            } else if (wirelessStatReceivedMessage.getMsgType().equalsIgnoreCase("020B")) {
                if (wirelessStatReceivedMessage.getCommandType().equalsIgnoreCase("02")) {
                    int n21 = wirelessStatReceivedMessage.getData().length();
                    if (n21 > 6) {
                        this.getNetwork().setFloatingValve(n, this.getSigStr(), this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(0, 2)), this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(2, 4)), this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(4, 6)), this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(6, 8)));
                    } else {
                        this.getNetwork().setFloatingValve(n, this.getSigStr(), this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(0, 2)), this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(2, 4)), this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(4, 6)));
                    }
                    BWirelessStatReplyParser.dataOutNoReply(this.getNetwork(), wirelessStatReceivedMessage.getMsgType(), "03", wirelessStatReceivedMessage.getCommAddress(), wirelessStatReceivedMessage.getTransactionSequence(), "");
                } else if (wirelessStatReceivedMessage.getCommandType().equalsIgnoreCase("00")) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("00");
                    stringBuffer.append(BWirelessStatUnsolicitedReceive.byteToHex(((BEnumPoint)this.getPoint(wirelessStatReceivedMessage.getCommAddress(), "HeatValveStatus")).getOut().getValue().getOrdinal() - 1));
                    stringBuffer.append(BWirelessStatUnsolicitedReceive.byteToHex(((BEnumPoint)this.getPoint(wirelessStatReceivedMessage.getCommAddress(), "CoolValveStatus")).getOut().getValue().getOrdinal() - 1));
                    BWirelessStatReplyParser.dataOutNoReply(this.getNetwork(), wirelessStatReceivedMessage.getMsgType(), "01", wirelessStatReceivedMessage.getCommAddress(), wirelessStatReceivedMessage.getTransactionSequence(), stringBuffer.toString());
                    stringBuffer = null;
                }
            } else if (wirelessStatReceivedMessage.getMsgType().equalsIgnoreCase("020C")) {
                if (wirelessStatReceivedMessage.getCommandType().equalsIgnoreCase("02")) {
                    this.getNetwork().setVT76RHStatus(n, this.getSigStr(), this.HexStringToFloat(wirelessStatReceivedMessage.getData().substring(0, 4)), this.HexStringToFloat(wirelessStatReceivedMessage.getData().substring(4, 8)), this.HexStringToFloat(wirelessStatReceivedMessage.getData().substring(8, 12)));
                }
                BWirelessStatReplyParser.dataOutNoReply(this.getNetwork(), wirelessStatReceivedMessage.getMsgType(), "03", wirelessStatReceivedMessage.getCommAddress(), wirelessStatReceivedMessage.getTransactionSequence(), "");
            } else if (wirelessStatReceivedMessage.getMsgType().equalsIgnoreCase("020D")) {
                if (wirelessStatReceivedMessage.getCommandType().equalsIgnoreCase("02")) {
                    this.getNetwork().setVT76RHSetpoints(n, this.getSigStr(), this.HexStringToFloat(wirelessStatReceivedMessage.getData().substring(0, 4)), this.HexStringToFloat(wirelessStatReceivedMessage.getData().substring(4, 8)), this.HexStringToFloat(wirelessStatReceivedMessage.getData().substring(8, 12)));
                }
                BWirelessStatReplyParser.dataOutNoReply(this.getNetwork(), wirelessStatReceivedMessage.getMsgType(), "03", wirelessStatReceivedMessage.getCommAddress(), wirelessStatReceivedMessage.getTransactionSequence(), "");
            } else if (wirelessStatReceivedMessage.getMsgType().equalsIgnoreCase("0F02")) {
                if (wirelessStatReceivedMessage.getCommandType().equalsIgnoreCase("02")) {
                    int n22 = this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(0, 2));
                    this.getNetwork().setConflict(n22, true);
                    BWirelessStatReplyParser.dataOutNoReply(this.getNetwork(), wirelessStatReceivedMessage.getMsgType(), "03", wirelessStatReceivedMessage.getCommAddress(), wirelessStatReceivedMessage.getTransactionSequence(), BWirelessStatUnsolicitedReceive.byteToHex(n22));
                }
            } else if (wirelessStatReceivedMessage.getMsgType().equalsIgnoreCase("0F03")) {
                if (wirelessStatReceivedMessage.getCommandType().equalsIgnoreCase("01")) {
                    if (wirelessStatReceivedMessage.getData().substring(0, 2).equalsIgnoreCase("00")) {
                        this.getNetwork().setZigbeeModMajorVersion(this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(2, 4)));
                        this.getNetwork().setZigbeeModMinorVersion(this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(4, 6)));
                        this.getNetwork().setZigbeeAddress(wirelessStatReceivedMessage.getData().substring(6, 10));
                        this.getNetwork().setIEEEAddress(wirelessStatReceivedMessage.getData().substring(10, 26));
                        this.getNetwork().setHardwareRevision(this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(26, 28)));
                    } else {
                        System.out.println("0x0F03 is unsupported by this revision of gateway module!");
                    }
                }
            } else if (!wirelessStatReceivedMessage.getMsgType().equalsIgnoreCase("0F00")) {
                if (wirelessStatReceivedMessage.getMsgType().equalsIgnoreCase("0F01")) {
                    if (wirelessStatReceivedMessage.getCommandType().equalsIgnoreCase("01")) {
                        if (wirelessStatReceivedMessage.getData().substring(0, 2).equalsIgnoreCase("00")) {
                            this.getNetwork().setZigbeePanId(this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(2, 6)));
                            this.getNetwork().setzigbeeChannel(this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(6, 8)));
                        } else {
                            System.out.println("Error readig command 0x0F03 from zigbee module");
                        }
                    }
                } else if (!wirelessStatReceivedMessage.getMsgType().equalsIgnoreCase("0002") && !wirelessStatReceivedMessage.getMsgType().equalsIgnoreCase("0003") && wirelessStatReceivedMessage.getMsgType().equalsIgnoreCase("0004")) {
                    if (wirelessStatReceivedMessage.getCommandType().equalsIgnoreCase("02")) {
                        this.getNetwork().setRSSI(n, this.getSigStr(), this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(0, 2)));
                        BWirelessStatReplyParser.dataOutNoReply(this.getNetwork(), wirelessStatReceivedMessage.getMsgType(), "03", wirelessStatReceivedMessage.getCommAddress(), wirelessStatReceivedMessage.getTransactionSequence(), "");
                    } else if (wirelessStatReceivedMessage.getCommandType().equalsIgnoreCase("01")) {
                        this.getNetwork().setRSSI(n, this.getSigStr(), this.HexStringToInt(wirelessStatReceivedMessage.getData().substring(2, 4)));
                    }
                }
            }
        } else {
            System.out.println("CRC ERROR: " + (Object)((Object)wirelessStatReceivedMessage));
        }
    }

    private final float HexStringToFloat(String string) {
        return (float)this.HexStringToInt(string) / 10.0f;
    }

    private final int HexStringToInt(String string) {
        int n = Integer.valueOf(string, 16);
        if (n > 65135) {
            n -= 65536;
        }
        return n;
    }

    public BControlPoint getPoint(int n, String string) {
        if (BWirelessStatNetwork.devArray[n] != null) {
            BWirelessStatDevice bWirelessStatDevice = (BWirelessStatDevice)BWirelessStatNetwork.devArray[n];
            return (BControlPoint)bWirelessStatDevice.getPoints().get(string);
        }
        System.out.println("Error: Device not found by BControlPoint getPoint() method");
        int n2 = 0;
        while (n2 < BWirelessStatNetwork.devArray.length) {
            if (BWirelessStatNetwork.devArray[n2] != null) {
                System.out.println("Device at:" + n2 + " found.  ");
            }
            ++n2;
        }
        System.out.println("Requested Comm at:" + n);
        return null;
    }

    public static String wordToHex(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n < 0) {
            String string = Integer.toHexString(n);
            stringBuffer.append(string.substring(string.length() - 4, string.length()));
        } else if (n < 4096) {
            if (n < 255) {
                if (n < 16) {
                    stringBuffer.append("000" + Integer.toHexString(n));
                } else {
                    stringBuffer.append("00" + Integer.toHexString(n));
                }
            } else {
                stringBuffer.append("0" + Integer.toHexString(n));
            }
        } else {
            stringBuffer.append(Integer.toHexString(n));
        }
        return stringBuffer.toString();
    }

    public static String byteToHex(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n < 0) {
            String string = Integer.toHexString(n);
            stringBuffer.append(string.substring(string.length() - 2, string.length()));
        } else if (n < 16) {
            stringBuffer.append("0" + Integer.toHexString(n));
        } else {
            stringBuffer.append(Integer.toHexString(n));
        }
        return stringBuffer.toString();
    }

    public int binaryToInt(StringBuffer stringBuffer) {
        int n = 0;
        if (stringBuffer.charAt(stringBuffer.length() - 1) == '1') {
            ++n;
        }
        if (stringBuffer.charAt(stringBuffer.length() - 2) == '1') {
            n += 2;
        }
        if (stringBuffer.charAt(stringBuffer.length() - 3) == '1') {
            n += 4;
        }
        if (stringBuffer.charAt(stringBuffer.length() - 4) == '1') {
            n += 8;
        }
        if (stringBuffer.charAt(stringBuffer.length() - 5) == '1') {
            n += 16;
        }
        if (stringBuffer.charAt(stringBuffer.length() - 6) == '1') {
            n += 32;
        }
        if (stringBuffer.charAt(stringBuffer.length() - 7) == '1') {
            n += 64;
        }
        if (stringBuffer.charAt(stringBuffer.length() - 8) == '1') {
            n += 128;
        }
        return n;
    }

    public void setSigStr(int n) {
        this.sigStr = n;
    }

    public int getSigStr() {
        return this.sigStr;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.sigStr = 0;
    }

    public BWirelessStatUnsolicitedReceive() {
        this.this();
    }

    static {
        Class clazz = class$com$viconics$wireless$comm$BWirelessStatUnsolicitedReceive;
        if (clazz == null) {
            clazz = class$com$viconics$wireless$comm$BWirelessStatUnsolicitedReceive = BWirelessStatUnsolicitedReceive.class("[Lcom.viconics.wireless.comm.BWirelessStatUnsolicitedReceive;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

