/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.websockets.router;

import com.tridium.websockets.ByteUtil;
import com.tridium.websockets.WebSocket;
import com.tridium.websockets.WebSocketState;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.baja.log.Log;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class SocketRegistration {
    private static Log LOG = Log.getLog((String)"websockets.router");
    private String path;
    private Set sockets;

    public abstract boolean matches(String var1);

    public void register(WebSocket webSocket) {
        if (webSocket == null) {
            throw new IllegalArgumentException("socket required");
        }
        if (LOG.isTraceOn()) {
            LOG.trace("SocketRegistration: registering socket: " + webSocket.getKey() + " from host: " + webSocket.getContext().getRemoteHost() + " on path: " + this.path);
        }
        this.sockets.add(webSocket);
    }

    public void unregister(WebSocket webSocket) {
        if (webSocket == null) {
            throw new IllegalArgumentException("socket required");
        }
        if (LOG.isTraceOn()) {
            LOG.trace("SocketRegistration: unregistering socket " + webSocket.getKey() + " from path " + this.path);
        }
        this.sockets.remove(webSocket);
    }

    public void fire(JSONObject jSONObject) throws JSONException {
        byte[] byArray = this.toPayload(jSONObject);
        Iterator iterator = this.sockets.iterator();
        while (iterator.hasNext()) {
            WebSocket webSocket = (WebSocket)iterator.next();
            if (webSocket.getState() != WebSocketState.OPEN) continue;
            try {
                webSocket.send(byArray);
            }
            catch (IOException iOException) {
                LOG.error("SocketRegistration: Could not write to registered socket", (Throwable)iOException);
            }
        }
    }

    public byte[] toPayload(JSONObject jSONObject) throws JSONException {
        JSONObject jSONObject2 = new JSONObject();
        jSONObject2.put("path", (Object)this.path);
        jSONObject2.put("data", (Object)jSONObject);
        return ByteUtil.getUTF8Bytes(jSONObject2.toString());
    }

    public String getPath() {
        return this.path;
    }

    public Set getRegisteredSockets() {
        return new HashSet(this.sockets);
    }

    public boolean equals(Object object) {
        if (object instanceof SocketRegistration) {
            return ((SocketRegistration)object).getPath().equals(this.path);
        }
        return false;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    private final /* synthetic */ void this() {
        this.sockets = new HashSet();
    }

    public SocketRegistration(String string) {
        this.this();
        this.path = string;
    }
}

