/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.websockets.router;

import com.tridium.websockets.ByteUtil;
import com.tridium.websockets.WebSocket;
import com.tridium.websockets.WebSocketCloseReason;
import com.tridium.websockets.WebSocketEventHandler;
import com.tridium.websockets.router.EventRouter;
import java.util.StringTokenizer;
import javax.baja.log.Log;
import javax.baja.sys.Context;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class EventReceiver
extends WebSocketEventHandler {
    private EventRouter router;
    private Log LOG;

    public void onOpen(Context context) {
        if (this.LOG.isTraceOn()) {
            this.LOG.trace("EventReceiver: opened socket: " + this.getSocket().getKey());
        }
    }

    public void onClose(WebSocketCloseReason webSocketCloseReason, Context context) {
        if (this.LOG.isTraceOn()) {
            this.LOG.trace("EventReceiver: closing socket: " + this.getSocket().getKey());
        }
        this.router.unregisterAll(this.getSocket());
    }

    public void onMessage(byte[] byArray, Context context) {
        String string = ByteUtil.toUTF8String(byArray);
        try {
            JSONObject jSONObject = new JSONObject(string);
            String string2 = jSONObject.getString("action");
            if ("subscribe".equals(string2)) {
                String string3 = jSONObject.getString("path");
                StringTokenizer stringTokenizer = new StringTokenizer(string3);
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken();
                    this.router.register(string4, this.getSocket());
                }
            }
        }
        catch (JSONException jSONException) {
            this.LOG.error("invalid JSON data received: " + string, (Throwable)jSONException);
        }
    }

    private final /* synthetic */ void this() {
        this.LOG = Log.getLog((String)"websockets.router");
    }

    public EventReceiver(WebSocket webSocket, EventRouter eventRouter) {
        super(webSocket);
        this.this();
        if (eventRouter == null) {
            throw new IllegalArgumentException("EventRouter is required");
        }
        this.router = eventRouter;
    }
}

